/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.ActionHandlerListener;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModel;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public class ResultView
extends ViewPart {
    private final String RESULT_TITLE = AcadEditorPlugin.getPlugin().getString("RESULT_VIEW");
    TextViewer resultViewer;

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        this.init(iViewSite);
        this.enableEditActions();
    }

    public void createPartControl(Composite composite) {
        this.resultViewer = new TextViewer(composite, 2882);
        this.resultViewer.setEditable(false);
        this.createActions();
        this.createMenu();
        this.createToolbar();
        this.createContextMenu();
        this.set_Title();
        WorkbenchHelp.setHelp((Control)composite, (String)ContextIds.ACAD_EDITOR_RESULT_VIEW);
    }

    public void setFocus() {
        if (this.resultViewer != null && this.resultViewer.getControl().isDisposed()) {
            this.resultViewer.getControl().setFocus();
        }
    }

    public void createActions() {
    }

    private ImageDescriptor getImageDescriptor(String string) {
        String string2 = "icons/full/elcl16/";
        try {
            URL uRL = AcadEditorPlugin.getPlugin().getBaseURL();
            URL uRL2 = new URL(uRL, string2 + string);
            return ImageDescriptor.createFromURL((URL)uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private void createMenu() {
        IMenuManager iMenuManager = this.getViewSite().getActionBars().getMenuManager();
    }

    private void createToolbar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ResultView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.resultViewer.getControl());
        this.resultViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.resultViewer);
    }

    private void hookGlobalActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void updateActionEnablement() {
    }

    public void set_Title() {
        AcadGuiModel acadGuiModel = AcadGuiModelManager.getCurrentModel();
        StringBuffer stringBuffer = new StringBuffer(this.RESULT_TITLE).append(" ");
        if (acadGuiModel != null) {
            long l = acadGuiModel.getCurrentCount();
            l = l >= 0L ? ++l : 0L;
            if (acadGuiModel.getContextInstance() == null || acadGuiModel.getContextInstance().eContainer() == null) {
                stringBuffer.append(AcadEditorPlugin.getPlugin().getString("STR_NO_EXTRACTOR"));
            } else {
                SensorConfigType sensorConfigType = AcadGuiModelManager.getLogForConfiguration(acadGuiModel);
                if (sensorConfigType != null) {
                    stringBuffer.append(" ").append(AcadEditorPlugin.getPlugin().getString("STR_RESULT_TITLE", new Object[]{String.valueOf(l)}));
                } else {
                    stringBuffer.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
                }
            }
        }
        super.setTitle(stringBuffer.toString());
    }

    public void dispose() {
        super.dispose();
    }

    public String getText() {
        return ((StyledText)this.resultViewer.getControl()).getText();
    }

    public static final ResultView getResultView(boolean bl) {
        try {
            IWorkbenchPage iWorkbenchPage = AcadEditorPlugin.getDefault().getActivePage();
            if (iWorkbenchPage == null) {
                return null;
            }
            IViewPart iViewPart = iWorkbenchPage.findView("org.eclipse.hyades.logging.adapter.ui.views.resultview");
            if (iViewPart != null && iViewPart instanceof ResultView) {
                return (ResultView)iViewPart;
            }
            if (bl && (iViewPart = iWorkbenchPage.showView("org.eclipse.hyades.logging.adapter.ui.views.resultview")) != null && iViewPart instanceof ResultView) {
                return (ResultView)iViewPart;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return null;
    }

    public void reset() {
        this.setResult("");
    }

    public void setResult(String string) {
        if (this.resultViewer != null && string != null) {
            this.resultViewer.setDocument((IDocument)new Document(string));
        }
    }

    public void enableActions() {
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }
}

