/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.uml2sd.ui.load.BackgroundLoader;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SDViewerPlugin
extends AbstractUIPlugin {
    public static final String LOADER_TAG = "uml2SDLoader";
    private static SDViewerPlugin plugin;
    private ResourceBundle resourceBundle;
    private static URL BASIC_URL;

    public SDViewerPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
        try {
            this.resourceBundle = iPluginDescriptor.getResourceBundle();
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.createLastLoaderIfAny(iPluginDescriptor);
    }

    private void createLastLoaderIfAny(IPluginDescriptor iPluginDescriptor) {
        IExtensionPoint iExtensionPoint = iPluginDescriptor.getExtensionPoint(LOADER_TAG);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        Preferences preferences = this.getPluginPreferences();
        String string = preferences.getString(LOADER_TAG);
        if (iExtensionArray == null || string == null || string.length() == 0) {
            return;
        }
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                String string2;
                if (iConfigurationElementArray[n2].getName().equals(LOADER_TAG) && string.equals(string2 = iConfigurationElementArray[n2].getAttribute("class"))) {
                    try {
                        Object object = iConfigurationElementArray[n2].createExecutableExtension("class");
                        IUml2SDLoader iUml2SDLoader = (IUml2SDLoader)object;
                        LoadersManager.getLoadersManager().setCurrentLoader(iUml2SDLoader);
                    }
                    catch (CoreException coreException) {
                        System.err.println("Error 'uml2SDLoader' Extension point :" + (Object)((Object)coreException));
                    }
                    catch (Exception exception) {
                        System.err.println("Error 'uml2SDLoader' Extension point :" + exception);
                    }
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void setLastLoader(String string) {
        Preferences preferences = this.getPluginPreferences();
        preferences.setValue(LOADER_TAG, string);
    }

    public void shutdown() throws CoreException {
        BackgroundLoader.shutdown();
        super.shutdown();
    }

    public static SDViewerPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = SDViewerPlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static ImageDescriptor getResourceImage(String string) {
        try {
            URL uRL = new URL(BASIC_URL, "plugin/org.eclipse.hyades.uml2sd.ui/icons/" + string);
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
            return imageDescriptor;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public static String getId() {
        return SDViewerPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    static {
        BASIC_URL = null;
        try {
            BASIC_URL = new URL("platform", "localhost", "plugin");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

