/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDGraphNodeSupporter;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.TabContents;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchFilterDialog
extends Dialog {
    private SDView viewer = null;
    private TabFolder tab = null;
    private Criteria criteria = null;
    private ISDGraphNodeSupporter provider = null;
    private String okText;
    private String title;

    public Control createDialogArea(Composite composite) {
        if (this.provider instanceof ISDFindProvider) {
            WorkbenchHelp.setHelp((Control)composite, (String)(SDViewerPlugin.getId() + ".UML2SDFIND"));
        } else if (this.provider instanceof ISDFilterProvider) {
            WorkbenchHelp.setHelp((Control)composite, (String)(SDViewerPlugin.getId() + ".UML2SDFILTER"));
        }
        return new TabContents(composite, this.provider);
    }

    public SearchFilterDialog(SDView sDView, ISDGraphNodeSupporter iSDGraphNodeSupporter) {
        super(sDView.getSDWidget().getShell());
        this.provider = iSDGraphNodeSupporter;
        this.viewer = sDView;
        this.setShellStyle(67680);
    }

    public int open() {
        this.create();
        if (this.criteria != null) {
            this.copyFromCriteria(this.criteria);
            this.criteria = null;
        }
        if (this.okText != null) {
            this.getButton(0).setText(this.okText);
        } else {
            this.getButton(0).setText(SDViewerPlugin.getResourceString("SEARCH_DIALOG_SEARCH_BUTTON"));
        }
        if (this.title != null) {
            this.getShell().setText(this.title);
        } else {
            this.getShell().setText(SDViewerPlugin.getResourceString("SEARCH_DIALOG_TITLE"));
        }
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        return super.open();
    }

    public void okPressed() {
        this.criteria = new Criteria();
        TabContents tabContents = null;
        tabContents = this.tab == null ? (TabContents)this.getDialogArea() : (TabContents)this.tab.getSelection()[0].getControl();
        this.copyToCriteria(tabContents);
        super.close();
        if (this.provider != null && this.provider instanceof ISDFindProvider) {
            ((ISDFindProvider)this.provider).find(this.criteria);
        }
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public void copyToCriteria(TabContents tabContents) {
        this.criteria.setLifeLineSelected(tabContents.getLifelineButtonSelection());
        this.criteria.setSyncMessageSelected(tabContents.getSynMessageButtonSelection());
        this.criteria.setSyncMessageReturnSelected(tabContents.getSynMessageReturnButtonSelection());
        this.criteria.setAsyncMessageSelected(tabContents.getAsynMessageButtonSelection());
        this.criteria.setAsyncMessageReturnSelected(tabContents.getAsynMessageReturnButtonSelection());
        this.criteria.setStopSelected(tabContents.getStopButtonSelection());
        this.criteria.setCaseSenstiveSelected(tabContents.getCaseSensitiveSelection());
        this.criteria.setExpression(tabContents.getSearchText());
    }

    public void copyFromCriteria(Criteria criteria) {
        TabContents tabContents = (TabContents)this.getDialogArea();
        tabContents.setLifelineButtonSelection(criteria.isLifeLineSelected());
        tabContents.setSynMessageButtonSelection(criteria.isSyncMessageSelected());
        tabContents.setSynMessageReturnButtonSelection(criteria.isSyncMessageReturnSelected());
        tabContents.setAsynMessageButtonSelection(criteria.isAsyncMessageSelected());
        tabContents.setAsynMessageReturnButtonSelection(criteria.isSyncMessageReturnSelected());
        tabContents.setStopButtonSelection(criteria.isStopSelected());
        tabContents.setCaseSensitiveSelection(criteria.isCaseSenstiveSelected());
        if (criteria.getExpression() != null) {
            tabContents.setSearchText(criteria.getExpression());
        }
    }

    public void setOkText(String string) {
        this.okText = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

