/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.TimeEvent;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.ISDPreferences;
import org.eclipse.hyades.uml2sd.util.SortAsyncMessageComparator;
import org.eclipse.hyades.uml2sd.util.SortSyncMessageComparator;
import org.eclipse.hyades.uml2sd.util.TimeEventComparator;

public class Frame
extends GraphNode {
    protected double maxTime = -50.0;
    protected double minTime = -50.0;
    private boolean computeMinMax = true;
    protected List lifeLines = new ArrayList();
    protected List syncMessages = new ArrayList();
    protected List syncMessagesReturn = new ArrayList();
    protected List asyncMessages = new ArrayList();
    protected List asyncMessagesReturn = new ArrayList();
    protected int verticalIndex = 0;
    protected int horizontalIndex = 0;
    private int lifeLineDrawIndex = 0;
    private int messageDrawIndex = 0;
    private int messageReturnDrawIndex = 0;
    private int asyncMessageDrawIndex = 0;
    private int asyncMessageReturnDrawIndex = 0;
    protected LifelineCategories[] lifelineCategories = null;
    protected boolean sortSyncMessage = false;
    protected boolean sortSyncMessageReturn = false;
    protected boolean sortAsyncMessage = false;
    protected boolean sortAsyncMessageReturn = false;
    protected Lifeline highlightLifeline = null;
    protected int startEvent = 0;
    protected int nbEvent = 0;
    protected IColor highlightColor = null;
    protected boolean timeInfo = false;
    private int visibleAreaX;
    private int visibleAreaY;
    private int visibleAreaWidth;
    private int visibleAreaHeight;
    protected static ISDPreferences userPref = null;
    protected GraphNode focusNode = null;
    protected String unitName = null;

    protected List getLifelines() {
        return this.lifeLines;
    }

    public Object[] getLifelinesArray() {
        return this.lifeLines.toArray();
    }

    public int lifeLinesCount() {
        if (this.lifeLines != null) {
            return this.lifeLines.size();
        }
        return 0;
    }

    public Lifeline getLifeline(int n) {
        if (this.lifeLines != null && n >= 0 && n < this.lifeLines.size()) {
            return (Lifeline)this.lifeLines.get(n);
        }
        return null;
    }

    protected List getSyncMessages() {
        return this.syncMessages;
    }

    public Object[] getSyncMessagesArray() {
        return this.syncMessages.toArray();
    }

    public int syncMessageCount() {
        if (this.syncMessages != null) {
            return this.syncMessages.size();
        }
        return 0;
    }

    public SyncMessage getSyncMessage(int n) {
        if (this.syncMessages != null && n >= 0 && n < this.syncMessages.size()) {
            return (SyncMessage)this.syncMessages.get(n);
        }
        return null;
    }

    public int asyncMessageCount() {
        if (this.asyncMessages != null) {
            return this.asyncMessages.size();
        }
        return 0;
    }

    public AsyncMessage getAsyncMessage(int n) {
        if (this.asyncMessages != null && n >= 0 && n < this.asyncMessages.size()) {
            return (AsyncMessage)this.asyncMessages.get(n);
        }
        return null;
    }

    public void resetIndex() {
        this.lifeLineDrawIndex = 0;
        this.messageDrawIndex = 0;
        this.messageReturnDrawIndex = 0;
    }

    public void setLifelineCategories(LifelineCategories[] lifelineCategoriesArray) {
        this.lifelineCategories = lifelineCategoriesArray;
    }

    public LifelineCategories[] getLifelineCategories() {
        return this.lifelineCategories;
    }

    protected List getSyncMessagesReturn() {
        return this.syncMessagesReturn;
    }

    public Object[] getSyncMessagesReturnArray() {
        return this.syncMessagesReturn.toArray();
    }

    public int syncMessageReturnCount() {
        if (this.syncMessagesReturn != null) {
            return this.syncMessagesReturn.size();
        }
        return 0;
    }

    public SyncMessageReturn getSyncMessageReturn(int n) {
        if (this.syncMessagesReturn != null && n >= 0 && n < this.syncMessagesReturn.size()) {
            return (SyncMessageReturn)this.syncMessagesReturn.get(n);
        }
        return null;
    }

    public int asyncMessageReturnCount() {
        if (this.asyncMessagesReturn != null) {
            return this.asyncMessagesReturn.size();
        }
        return 0;
    }

    public AsyncMessageReturn getAsyncMessageReturn(int n) {
        if (this.asyncMessagesReturn != null && n >= 0 && n < this.asyncMessagesReturn.size()) {
            return (AsyncMessageReturn)this.asyncMessagesReturn.get(n);
        }
        return null;
    }

    protected int getMaxEventOccurrence() {
        return this.verticalIndex;
    }

    protected void setMaxEventOccurrence(int n) {
        this.verticalIndex = n;
    }

    protected int getNewHorizontalIndex() {
        return ++this.horizontalIndex;
    }

    protected int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public void addLifeLine(Lifeline lifeline) {
        this.computeMinMax = true;
        if (lifeline == null) {
            return;
        }
        lifeline.setFrame(this);
        lifeline.setIndex(this.getNewHorizontalIndex());
        this.lifeLines.add(lifeline);
    }

    public void addMessage(BaseMessage baseMessage) {
        this.computeMinMax = true;
        if (baseMessage == null) {
            return;
        }
        if (baseMessage instanceof SyncMessageReturn) {
            BaseMessage baseMessage2;
            this.syncMessagesReturn.add(baseMessage);
            if (this.syncMessages.size() > 0 && (baseMessage2 = (BaseMessage)this.syncMessagesReturn.get(this.syncMessagesReturn.size() - 1)).getEventOccurrence() > baseMessage.getEventOccurrence()) {
                this.sortSyncMessageReturn = true;
            }
        } else if (baseMessage instanceof SyncMessage) {
            BaseMessage baseMessage3;
            this.syncMessages.add(baseMessage);
            if (this.syncMessages.size() > 0 && (baseMessage3 = (BaseMessage)this.syncMessages.get(this.syncMessages.size() - 1)).getEventOccurrence() > baseMessage.getEventOccurrence()) {
                this.sortSyncMessage = true;
            }
        } else if (baseMessage instanceof AsyncMessageReturn) {
            this.asyncMessagesReturn.add(baseMessage);
            if (this.asyncMessagesReturn.size() > 0) {
                int n;
                AsyncMessage asyncMessage = (AsyncMessage)this.asyncMessagesReturn.get(this.asyncMessagesReturn.size() - 1);
                AsyncMessage asyncMessage2 = (AsyncMessage)baseMessage;
                int n2 = asyncMessage.getStartOccurrence() > asyncMessage.getEndOccurrence() ? asyncMessage.getEndOccurrence() : asyncMessage.getStartOccurrence();
                if (n2 > (n = asyncMessage2.getStartOccurrence() > asyncMessage2.getEndOccurrence() ? asyncMessage2.getEndOccurrence() : asyncMessage2.getStartOccurrence())) {
                    this.sortAsyncMessageReturn = true;
                }
            }
        } else if (baseMessage instanceof AsyncMessage) {
            this.asyncMessages.add(baseMessage);
            if (this.asyncMessages.size() > 0) {
                int n;
                AsyncMessage asyncMessage = (AsyncMessage)this.asyncMessages.get(this.asyncMessages.size() - 1);
                AsyncMessage asyncMessage3 = (AsyncMessage)baseMessage;
                int n3 = asyncMessage.getStartOccurrence() > asyncMessage.getEndOccurrence() ? asyncMessage.getEndOccurrence() : asyncMessage.getStartOccurrence();
                if (n3 > (n = asyncMessage3.getStartOccurrence() > asyncMessage3.getEndOccurrence() ? asyncMessage3.getEndOccurrence() : asyncMessage3.getStartOccurrence())) {
                    this.sortAsyncMessageReturn = true;
                }
            }
        }
    }

    public void updateIndex(int n, int n2, int n3, int n4) {
        SyncMessage syncMessage;
        SyncMessage syncMessage2;
        int n5;
        SortSyncMessageComparator sortSyncMessageComparator;
        int n6;
        this.visibleAreaX = n;
        this.visibleAreaY = n2;
        this.visibleAreaWidth = n3;
        this.visibleAreaHeight = n4;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 1;
        if (n == 0) {
            this.lifeLineDrawIndex = 0;
        }
        if (n == 2 && n2 == 0) {
            n6 = 0;
            ++n6;
        }
        if (this.lifeLines == null || this.lifeLines.size() < 1) {
            return;
        }
        if (((Lifeline)this.lifeLines.get(this.lifeLineDrawIndex)).getX() > n) {
            n11 = -1;
        }
        n6 = this.lifeLineDrawIndex;
        while (n6 < this.lifeLines.size() && n6 >= 0) {
            ++n7;
            this.lifeLineDrawIndex = n6;
            if (n11 == 1 && ((Lifeline)this.lifeLines.get(n6)).getX() > n - Metrics.swimmingLaneWidth() || n11 == -1 && ((Lifeline)this.lifeLines.get(n6)).getX() < n) break;
            n6 += n11;
        }
        int n12 = 1;
        if (n2 == 0) {
            this.messageDrawIndex = 0;
            this.messageReturnDrawIndex = 0;
            this.asyncMessageDrawIndex = 0;
            this.asyncMessageReturnDrawIndex = 0;
        }
        if (this.syncMessages != null && this.syncMessages.size() > 0) {
            sortSyncMessageComparator = new SortSyncMessageComparator();
            if (((BaseMessage)this.syncMessages.get(this.messageDrawIndex)).getY() > n2) {
                n12 = -1;
            }
            n5 = this.messageDrawIndex;
            while (n5 < this.syncMessages.size() && n5 >= 0) {
                ++n8;
                this.messageDrawIndex = n5;
                syncMessage2 = (SyncMessage)this.syncMessages.get(n5);
                if (n5 < this.syncMessages.size() - 1 && sortSyncMessageComparator.compare(syncMessage2, syncMessage = (SyncMessage)this.syncMessages.get(n5 + 1)) == 1) {
                    this.sortSyncMessage = true;
                }
                if (n12 == 1 && ((BaseMessage)this.syncMessages.get(n5)).getY() > n2 || n12 == -1 && ((BaseMessage)this.syncMessages.get(n5)).getY() < n2) break;
                n5 += n12;
            }
        }
        if (this.syncMessagesReturn != null && this.syncMessagesReturn.size() > 0) {
            sortSyncMessageComparator = new SortSyncMessageComparator();
            if (((BaseMessage)this.syncMessagesReturn.get(this.messageReturnDrawIndex)).getY() > n2) {
                n12 = -1;
            }
            n5 = this.messageReturnDrawIndex;
            while (n5 < this.syncMessagesReturn.size() && n5 >= 0) {
                ++n9;
                this.messageReturnDrawIndex = n5;
                syncMessage2 = (SyncMessage)this.syncMessagesReturn.get(n5);
                if (n5 < this.syncMessagesReturn.size() - 1 && sortSyncMessageComparator.compare(syncMessage2, syncMessage = (SyncMessage)this.syncMessagesReturn.get(n5 + 1)) == 1) {
                    this.sortSyncMessageReturn = true;
                }
                if (n12 == 1 && ((BaseMessage)this.syncMessagesReturn.get(n5)).getY() > n2 || n12 == -1 && ((BaseMessage)this.syncMessagesReturn.get(n5)).getY() < n2) break;
                n5 += n12;
            }
        }
        int n13 = this.lifeLineDrawIndex;
        while (n13 < this.lifeLines.size()) {
            ++n10;
            Lifeline lifeline = (Lifeline)this.lifeLines.get(n13);
            lifeline.updateIndex(n, n2);
            if (lifeline.getX() > n + n3) break;
            ++n13;
        }
    }

    public int getFirstVisibleSyncMessage() {
        return this.messageDrawIndex;
    }

    public int getFirstVisibleSyncMessageReturn() {
        return this.messageReturnDrawIndex;
    }

    public int getFirstVisibleAsyncMessage() {
        return this.asyncMessageDrawIndex;
    }

    public int getFirstVisibleAsyncMessageReturn() {
        return this.asyncMessageReturnDrawIndex;
    }

    public int getX() {
        return 10;
    }

    public int getY() {
        return 10;
    }

    public int getWidth() {
        if (this.horizontalIndex == 0) {
            return Metrics.swimmingLaneWidth() + 46 - 10 - 22;
        }
        return this.horizontalIndex * Metrics.swimmingLaneWidth() + 46 - 45;
    }

    public int getHeight() {
        return this.verticalIndex * (30 + Metrics.getMessageFontHeigth()) + 14 + 4 + Metrics.getLifelineFontHeigth() + 18 + 20 + 14 + 4 + Metrics.getLifelineFontHeigth() * 2;
    }

    protected GraphNode getNodeFromListAt(int n, int n2, List list, int n3) {
        if (list == null) {
            return null;
        }
        int n4 = n3;
        while (n4 < list.size()) {
            GraphNode graphNode = (GraphNode)list.get(n4);
            if (graphNode instanceof Lifeline && graphNode.getX() > this.visibleAreaX + this.visibleAreaWidth || (graphNode.getHeight() >= 0 ? graphNode.getY() > this.visibleAreaY + this.visibleAreaHeight : graphNode.getY() + graphNode.getHeight() > this.visibleAreaY + this.visibleAreaHeight)) break;
            if (graphNode.contains(n, n2)) {
                return graphNode;
            }
            ++n4;
        }
        return null;
    }

    protected GraphNode getCloserLeavingMessage(Lifeline lifeline, BaseMessage baseMessage, List list, boolean bl) {
        if (list == null) {
            return null;
        }
        if (!bl) {
            int n = 0;
            if (baseMessage != null) {
                n = baseMessage.getEventOccurrence();
            }
            int n2 = 0;
            while (n2 < list.size()) {
                GraphNode graphNode = (GraphNode)list.get(n2);
                if (graphNode instanceof SyncMessage ? ((SyncMessage)graphNode).getEventOccurrence() > n && ((SyncMessage)graphNode).getStartLifeline() == lifeline && graphNode != baseMessage : graphNode instanceof AsyncMessage && ((AsyncMessage)graphNode).getStartOccurrence() > n && ((AsyncMessage)graphNode).getStartLifeline() == lifeline && graphNode != baseMessage) {
                    return graphNode;
                }
                ++n2;
            }
        } else {
            int n = this.getMaxEventOccurrence();
            if (baseMessage != null) {
                n = baseMessage.getEventOccurrence();
            }
            int n3 = list.size() - 1;
            while (n3 >= 0) {
                GraphNode graphNode = (GraphNode)list.get(n3);
                if (graphNode instanceof SyncMessage ? ((SyncMessage)graphNode).getEventOccurrence() < n && ((SyncMessage)graphNode).getStartLifeline() == lifeline && graphNode != baseMessage : graphNode instanceof AsyncMessage && ((AsyncMessage)graphNode).getStartOccurrence() < n && ((AsyncMessage)graphNode).getStartLifeline() == lifeline && graphNode != baseMessage) {
                    return graphNode;
                }
                --n3;
            }
        }
        return null;
    }

    protected GraphNode getCloserEnteringMessage(Lifeline lifeline, BaseMessage baseMessage, List list, boolean bl) {
        if (list == null) {
            return null;
        }
        if (!bl) {
            int n = 0;
            if (baseMessage != null) {
                n = baseMessage.getEventOccurrence();
            }
            int n2 = 0;
            while (n2 < list.size()) {
                GraphNode graphNode = (GraphNode)list.get(n2);
                if (graphNode instanceof SyncMessage ? ((SyncMessage)graphNode).getEventOccurrence() < n && ((SyncMessage)graphNode).getEndLifeline() == lifeline && graphNode != baseMessage : graphNode instanceof AsyncMessage && ((AsyncMessage)graphNode).getStartOccurrence() < n && ((AsyncMessage)graphNode).getEndLifeline() == lifeline && graphNode != baseMessage) {
                    return graphNode;
                }
                ++n2;
            }
        } else {
            int n = this.getMaxEventOccurrence();
            if (baseMessage != null) {
                n = baseMessage.getEventOccurrence();
            }
            int n3 = list.size() - 1;
            while (n3 >= 0) {
                GraphNode graphNode = (GraphNode)list.get(n3);
                if (graphNode instanceof SyncMessage ? ((SyncMessage)graphNode).getEventOccurrence() < n && ((SyncMessage)graphNode).getEndLifeline() == lifeline && graphNode != baseMessage : graphNode instanceof AsyncMessage && ((AsyncMessage)graphNode).getStartOccurrence() < n && ((AsyncMessage)graphNode).getEndLifeline() == lifeline && graphNode != baseMessage) {
                    return graphNode;
                }
                --n3;
            }
        }
        return null;
    }

    private int distanceFromEvent(GraphNode graphNode, int n) {
        int n2 = 0;
        if (graphNode instanceof SyncMessage) {
            n2 = ((SyncMessage)graphNode).getEventOccurrence() - n;
        } else if (graphNode instanceof AsyncMessage) {
            int n3;
            int n4 = ((AsyncMessage)graphNode).getStartOccurrence();
            n2 = n4 - n < (n3 = ((AsyncMessage)graphNode).getEndOccurrence()) - n ? n4 - n : n4 - n;
        }
        return Math.abs(n2);
    }

    private GraphNode getCloserToEvent(GraphNode graphNode, GraphNode graphNode2, int n) {
        if (graphNode != null && graphNode2 != null) {
            if (this.distanceFromEvent(graphNode, n) < this.distanceFromEvent(graphNode2, n)) {
                return graphNode;
            }
            return graphNode2;
        }
        if (graphNode != null) {
            return graphNode;
        }
        if (graphNode2 != null) {
            return graphNode2;
        }
        return null;
    }

    public GraphNode getCalledMessage(BaseMessage baseMessage) {
        int n = 0;
        GraphNode graphNode = null;
        Lifeline lifeline = null;
        if (baseMessage != null) {
            n = baseMessage.getEventOccurrence();
            lifeline = baseMessage.getEndLifeline();
            if (lifeline == null) {
                lifeline = baseMessage.getStartLifeline();
            }
        }
        GraphNode graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessages, false);
        GraphNode graphNode3 = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessagesReturn, false);
        graphNode = this.getCloserToEvent(graphNode2, graphNode3, n);
        graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessages, false);
        graphNode = this.getCloserToEvent(graphNode, graphNode2, n);
        graphNode3 = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessagesReturn, false);
        graphNode = this.getCloserToEvent(graphNode, graphNode3, n);
        return graphNode;
    }

    public GraphNode getCallerMessage(BaseMessage baseMessage) {
        int n = this.getMaxEventOccurrence();
        GraphNode graphNode = null;
        Lifeline lifeline = null;
        if (baseMessage != null) {
            n = baseMessage.getEventOccurrence();
            lifeline = baseMessage.getStartLifeline();
            if (lifeline == null) {
                lifeline = baseMessage.getEndLifeline();
            }
        }
        GraphNode graphNode2 = this.getCloserEnteringMessage(lifeline, baseMessage, this.syncMessages, true);
        GraphNode graphNode3 = this.getCloserEnteringMessage(lifeline, baseMessage, this.syncMessagesReturn, true);
        graphNode = this.getCloserToEvent(graphNode2, graphNode3, n);
        graphNode2 = this.getCloserEnteringMessage(lifeline, baseMessage, this.asyncMessages, true);
        graphNode = this.getCloserToEvent(graphNode, graphNode2, n);
        graphNode3 = this.getCloserEnteringMessage(lifeline, baseMessage, this.asyncMessagesReturn, true);
        graphNode = this.getCloserToEvent(graphNode, graphNode3, n);
        return graphNode;
    }

    public GraphNode getNextLifelineMessage(Lifeline lifeline, BaseMessage baseMessage) {
        int n = 0;
        if (baseMessage != null) {
            n = baseMessage.getEventOccurrence();
        }
        GraphNode graphNode = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessages, false);
        GraphNode graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessagesReturn, false);
        GraphNode graphNode3 = this.getCloserToEvent(graphNode, graphNode2, n);
        graphNode = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessages, false);
        graphNode3 = this.getCloserToEvent(graphNode3, graphNode, n);
        graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessagesReturn, false);
        graphNode3 = this.getCloserToEvent(graphNode3, graphNode2, n);
        return graphNode3;
    }

    public GraphNode getPrevLifelineMessage(Lifeline lifeline, BaseMessage baseMessage) {
        int n = this.getMaxEventOccurrence();
        if (baseMessage != null) {
            n = baseMessage.getEventOccurrence();
        }
        GraphNode graphNode = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessages, true);
        GraphNode graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessagesReturn, true);
        GraphNode graphNode3 = this.getCloserToEvent(graphNode, graphNode2, n);
        graphNode = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessages, true);
        graphNode3 = this.getCloserToEvent(graphNode3, graphNode, n);
        graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessagesReturn, true);
        graphNode3 = this.getCloserToEvent(graphNode3, graphNode2, n);
        return graphNode3;
    }

    public GraphNode getNodeAt(int n, int n2) {
        GraphNode graphNode = this.getNodeFromListAt(n, n2, this.lifeLines, this.lifeLineDrawIndex);
        if (graphNode != null) {
            GraphNode graphNode2 = this.getNodeFromListAt(n, n2, ((Lifeline)graphNode).executionOccurrences, 0);
            if (graphNode2 != null) {
                return graphNode2;
            }
            return graphNode;
        }
        graphNode = this.getNodeFromListAt(n, n2, this.syncMessages, this.messageDrawIndex);
        if (graphNode != null) {
            return graphNode;
        }
        graphNode = this.getNodeFromListAt(n, n2, this.syncMessagesReturn, this.messageReturnDrawIndex);
        if (graphNode != null) {
            return graphNode;
        }
        graphNode = this.getNodeFromListAt(n, n2, this.asyncMessages, 0);
        if (graphNode != null) {
            return graphNode;
        }
        graphNode = this.getNodeFromListAt(n, n2, this.asyncMessagesReturn, 0);
        if (graphNode != null) {
            return graphNode;
        }
        return null;
    }

    public void draw(IGC iGC) {
        GraphNode graphNode;
        int n;
        int n2;
        Object[] objectArray;
        if (userPref == null) {
            return;
        }
        if (this.sortSyncMessage) {
            objectArray = this.syncMessages.toArray();
            Arrays.sort(objectArray, new SortSyncMessageComparator());
            this.sortSyncMessage = false;
            this.syncMessages = Arrays.asList(objectArray);
        }
        if (this.sortSyncMessageReturn) {
            objectArray = this.syncMessagesReturn.toArray();
            Arrays.sort(objectArray, new SortSyncMessageComparator());
            this.sortSyncMessageReturn = false;
            this.syncMessagesReturn = Arrays.asList(objectArray);
        }
        if (this.sortAsyncMessage) {
            objectArray = this.asyncMessages.toArray();
            Arrays.sort(objectArray, new SortAsyncMessageComparator());
            this.sortAsyncMessage = false;
            this.asyncMessages = Arrays.asList(objectArray);
        }
        if (this.sortAsyncMessageReturn) {
            objectArray = this.asyncMessagesReturn.toArray();
            Arrays.sort(objectArray, new SortAsyncMessageComparator());
            this.sortAsyncMessageReturn = false;
            this.asyncMessagesReturn = Arrays.asList(objectArray);
        }
        iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
        iGC.fillRectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        iGC.drawRectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int n3 = iGC.textExtent(this.getName()) + 16;
        int n4 = Metrics.getLifelineFontHeigth() + 8;
        iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME_NAME"));
        iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME_NAME"));
        iGC.setFont(Frame.getUserPref().getFont("PREF_FRAME_NAME"));
        int[] nArray = new int[]{this.getX() + 1, this.getY() + 1, this.getX() + 1 + n3, this.getY() + 1, this.getX() + 1 + n3, this.getY() + 1 - 11 + n4, this.getX() + 1 - 11 + n3, this.getY() + 1 + n4, this.getX() + 1, this.getY() + 1 + n4, this.getX() + 1, this.getY() + 1 + n4};
        iGC.fillPolygon(nArray);
        iGC.drawPolygon(nArray);
        iGC.drawLine(this.getX() + 1, this.getY() + 1, this.getX() + 1, this.getY() + 1 + n4);
        iGC.drawTextTruncatedCentred(this.getName(), this.getX(), this.getY(), n3, n4, false);
        iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        if ((float)Metrics.swimmingLaneWidth() * iGC.getZoom() < 10.0f) {
            n6 = Math.round(10.0f / ((float)Metrics.swimmingLaneWidth() * iGC.getZoom()));
        }
        if ((float)(Metrics.getMessageFontHeigth() + 20) * iGC.getZoom() < 1.0f) {
            n7 = Math.round(1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * iGC.getZoom()));
        }
        if (this.lifeLines == null || this.lifeLines.size() < 1) {
            return;
        }
        if (this.highlightLifeline != null) {
            IColor iColor = iGC.getBackground();
            iGC.setBackground(Frame.getUserPref().getTimeCompressionSelectionColor());
            int n8 = this.highlightLifeline.getY() + this.highlightLifeline.getHeight() + (Metrics.getMessageFontHeigth() + 30) * this.startEvent;
            iGC.fillRectangle(11, n8, this.highlightLifeline.getX() + Metrics.getLifelineWidth() / 2 - 10, (Metrics.getMessageFontHeigth() + 30) * this.nbEvent);
            iGC.setBackground(iColor);
        }
        iGC.setFont(Frame.getUserPref().getFont("PREF_LIFELINE"));
        int n9 = this.lifeLineDrawIndex;
        while (n9 < this.lifeLines.size()) {
            Lifeline lifeline = (Lifeline)this.lifeLines.get(n9);
            if (lifeline.getX() > iGC.getContentsX() + iGC.getVisibleWidth()) break;
            lifeline.draw(iGC);
            if (this.highlightLifeline != null) {
                if (lifeline == this.highlightLifeline) {
                    lifeline.highlightExecOccurrenceRegion(iGC, this.startEvent, this.nbEvent, this.highlightColor);
                } else if (lifeline.getIndex() < this.highlightLifeline.getIndex() || lifeline.getIndex() < this.highlightLifeline.getIndex()) {
                    boolean bl = false;
                    n = n2 = lifeline.getExecOccurrenceDrawIndex();
                    while (n < lifeline.getExecutions().size()) {
                        graphNode = (ExecutionOccurrence)lifeline.getExecutions().get(n);
                        int n10 = this.startEvent;
                        int n11 = 0;
                        while (n11 < this.nbEvent) {
                            if (n10 >= ((ExecutionOccurrence)graphNode).startOccurrence && n10 <= ((ExecutionOccurrence)graphNode).endOccurrence && n10 + 1 >= ((ExecutionOccurrence)graphNode).startOccurrence && n10 + 1 <= ((ExecutionOccurrence)graphNode).endOccurrence) {
                                lifeline.highlightExecOccurrenceRegion(iGC, n10, 1, Frame.getUserPref().getTimeCompressionSelectionColor());
                            }
                            ++n10;
                            ++n11;
                        }
                        if (((ExecutionOccurrence)graphNode).getY() > this.getY()) break;
                        ++n;
                    }
                }
            }
            ++n5;
            n9 += n6;
        }
        int n12 = 0;
        if (this.syncMessages != null && this.syncMessages.size() > 0) {
            SortSyncMessageComparator sortSyncMessageComparator = new SortSyncMessageComparator();
            iGC.setFont(Frame.getUserPref().getFont("PREF_SYNC_MESS"));
            n2 = ((BaseMessage)this.syncMessages.get(this.messageDrawIndex)).getY();
            n = this.messageDrawIndex;
            while (n < this.syncMessages.size()) {
                SyncMessage syncMessage;
                graphNode = (SyncMessage)this.syncMessages.get(n);
                if (n < this.syncMessages.size() - 1 && sortSyncMessageComparator.compare(graphNode, syncMessage = (SyncMessage)this.syncMessages.get(n + 1)) == 1) {
                    this.sortSyncMessage = true;
                }
                if (((BaseMessage)graphNode).getY() > iGC.getContentsY() + iGC.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth()) break;
                if (((SyncMessage)graphNode).endLifeline == null && ((SyncMessage)graphNode).startLifeline != null) {
                    if (iGC.getContentsX() + iGC.getVisibleWidth() > ((BaseMessage)graphNode).getX() + ((BaseMessage)graphNode).getWidth() && iGC.getContentsX() < ((BaseMessage)graphNode).getX() + ((BaseMessage)graphNode).getWidth()) {
                        ((BaseMessage)graphNode).draw(iGC);
                        ++n12;
                    }
                } else if (((SyncMessage)graphNode).endLifeline != null && ((SyncMessage)graphNode).startLifeline == null && iGC.getContentsX() + iGC.getVisibleWidth() > ((BaseMessage)graphNode).getX() + ((BaseMessage)graphNode).getWidth() && iGC.getContentsX() < ((BaseMessage)graphNode).getX() + ((BaseMessage)graphNode).getWidth()) {
                    ((BaseMessage)graphNode).draw(iGC);
                    ++n12;
                }
                this.lifelineDependantDrawing(iGC, (BaseMessage)graphNode);
                n += n7;
            }
        }
        n12 = 0;
        if (this.syncMessagesReturn != null && this.syncMessagesReturn.size() > 0) {
            SortSyncMessageComparator sortSyncMessageComparator = new SortSyncMessageComparator();
            iGC.setFont(Frame.getUserPref().getFont("PREF_SYNC_MESS_RET"));
            n2 = ((BaseMessage)this.syncMessagesReturn.get(this.messageReturnDrawIndex)).getY();
            n = this.messageReturnDrawIndex;
            while (n < this.syncMessagesReturn.size()) {
                SyncMessage syncMessage;
                graphNode = (SyncMessage)this.syncMessagesReturn.get(n);
                if (n < this.syncMessagesReturn.size() - 1 && sortSyncMessageComparator.compare(graphNode, syncMessage = (SyncMessage)this.syncMessagesReturn.get(n + 1)) == 1) {
                    this.sortSyncMessageReturn = true;
                }
                if (((BaseMessage)graphNode).getY() > iGC.getContentsY() + iGC.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth()) break;
                this.lifelineDependantDrawing(iGC, (BaseMessage)graphNode);
                n += n7;
            }
        }
        if (this.asyncMessages != null && this.asyncMessages.size() > 0) {
            SortAsyncMessageComparator sortAsyncMessageComparator = new SortAsyncMessageComparator();
            iGC.setFont(Frame.getUserPref().getFont("PREF_ASYNC_MESS"));
            n2 = ((BaseMessage)this.asyncMessages.get(this.asyncMessageDrawIndex)).getY();
            n = this.asyncMessageDrawIndex;
            while (n < this.asyncMessages.size()) {
                AsyncMessage asyncMessage;
                graphNode = (AsyncMessage)this.asyncMessages.get(n);
                if (n < this.asyncMessages.size() - 1 && sortAsyncMessageComparator.compare(graphNode, asyncMessage = (AsyncMessage)this.asyncMessages.get(n + 1)) == 1) {
                    this.sortAsyncMessage = true;
                }
                this.lifelineDependantDrawing(iGC, (BaseMessage)graphNode);
                n += n7;
            }
        }
        if (this.asyncMessagesReturn != null && this.asyncMessagesReturn.size() > 0) {
            SortAsyncMessageComparator sortAsyncMessageComparator = new SortAsyncMessageComparator();
            iGC.setFont(Frame.getUserPref().getFont("PREF_ASYNC_MESS_RET"));
            n2 = this.asyncMessageReturnDrawIndex;
            while (n2 < this.asyncMessagesReturn.size()) {
                AsyncMessage asyncMessage = (AsyncMessage)this.asyncMessagesReturn.get(n2);
                if (n2 < this.asyncMessagesReturn.size() - 1 && sortAsyncMessageComparator.compare(asyncMessage, graphNode = (AsyncMessage)this.asyncMessagesReturn.get(n2 + 1)) == 1) {
                    this.sortAsyncMessageReturn = true;
                }
                this.lifelineDependantDrawing(iGC, asyncMessage);
                n2 += n7;
            }
        }
    }

    public void setFocusNode(GraphNode graphNode) {
        this.focusNode = graphNode;
    }

    public GraphNode getFocusNode() {
        return this.focusNode;
    }

    private boolean lifelineDependantDrawing(IGC iGC, BaseMessage baseMessage) {
        if (baseMessage.endLifeline != null && baseMessage.endLifeline.isVisible(iGC.getContentsX(), 0, iGC.getVisibleWidth(), 0) || baseMessage.startLifeline != null && baseMessage.startLifeline.isVisible(iGC.getContentsX(), 0, iGC.getVisibleWidth(), 0)) {
            baseMessage.draw(iGC);
            return true;
        }
        if (baseMessage.endLifeline != null && !baseMessage.endLifeline.isVisible(iGC.getContentsX(), 0, iGC.getVisibleWidth(), 0) && baseMessage.startLifeline != null && !baseMessage.startLifeline.isVisible(iGC.getContentsX(), 0, iGC.getVisibleWidth(), 0)) {
            if (baseMessage.endLifeline.getX() > iGC.getContentsX() + iGC.getVisibleWidth() && baseMessage.startLifeline.getX() < iGC.getContentsX()) {
                baseMessage.draw(iGC);
                return true;
            }
            if (baseMessage.startLifeline.getX() > iGC.getContentsX() + iGC.getVisibleWidth() && baseMessage.endLifeline.getX() < iGC.getContentsX()) {
                baseMessage.draw(iGC);
                return true;
            }
        }
        return false;
    }

    public void highlightTimeCompression(Lifeline lifeline, int n, int n2, IColor iColor) {
        this.highlightLifeline = lifeline;
        this.startEvent = n;
        this.nbEvent = n2;
        this.highlightColor = iColor;
    }

    public void resetTimeCompression() {
        this.highlightLifeline = null;
        this.startEvent = 0;
        this.nbEvent = 0;
        this.highlightColor = null;
    }

    public double getMinTime() {
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.minTime;
    }

    public double getMaxTime() {
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.maxTime;
    }

    private void computeMinMax() {
        TimeEvent timeEvent;
        TimeEvent timeEvent2;
        Object object;
        int n;
        List<Object> list = new ArrayList<Object[]>();
        int n2 = 0;
        while (n2 < this.syncMessages.size()) {
            if (((ITimeRange)this.syncMessages.get(n2)).hasTimeInfo()) {
                n = ((BaseMessage)this.syncMessages.get(n2)).getEventOccurrence();
                double d = ((ITimeRange)this.syncMessages.get(n2)).getFirstTime();
                object = new TimeEvent(d, n, (ITimeRange)this.syncMessages.get(n2));
                list.add(object);
            }
            ++n2;
        }
        n = 0;
        while (n < this.syncMessagesReturn.size()) {
            if (((ITimeRange)this.syncMessagesReturn.get(n)).hasTimeInfo()) {
                int n3 = ((BaseMessage)this.syncMessagesReturn.get(n)).getEventOccurrence();
                double d = ((ITimeRange)this.syncMessagesReturn.get(n)).getFirstTime();
                TimeEvent timeEvent3 = new TimeEvent(d, n3, (ITimeRange)this.syncMessagesReturn.get(n));
                list.add(timeEvent3);
            }
            ++n;
        }
        int n4 = 0;
        while (n4 < this.asyncMessages.size()) {
            if (((ITimeRange)this.asyncMessages.get(n4)).hasTimeInfo()) {
                int n5 = ((AsyncMessage)this.asyncMessages.get(n4)).getStartOccurrence();
                double d = ((ITimeRange)this.asyncMessages.get(n4)).getFirstTime();
                timeEvent2 = new TimeEvent(d, n5, (ITimeRange)this.asyncMessages.get(n4));
                list.add(timeEvent2);
                n5 = ((AsyncMessage)this.asyncMessages.get(n4)).getEndOccurrence();
                d = ((ITimeRange)this.asyncMessages.get(n4)).getLastTime();
                timeEvent2 = new TimeEvent(d, n5, (ITimeRange)this.asyncMessages.get(n4));
                list.add(timeEvent2);
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 < this.asyncMessagesReturn.size()) {
            if (((ITimeRange)this.asyncMessagesReturn.get(n6)).hasTimeInfo()) {
                int n7 = ((AsyncMessage)this.asyncMessagesReturn.get(n6)).getStartOccurrence();
                double d = ((ITimeRange)this.asyncMessagesReturn.get(n6)).getFirstTime();
                timeEvent = new TimeEvent(d, n7, (ITimeRange)this.asyncMessagesReturn.get(n6));
                list.add(timeEvent);
                n7 = ((AsyncMessage)this.asyncMessagesReturn.get(n6)).getEndOccurrence();
                d = ((ITimeRange)this.asyncMessagesReturn.get(n6)).getLastTime();
                timeEvent = new TimeEvent(d, n7, (ITimeRange)this.asyncMessagesReturn.get(n6));
                list.add(timeEvent);
            }
            ++n6;
        }
        object = list.toArray();
        Arrays.sort(object, new TimeEventComparator());
        list = Arrays.asList(object);
        int n8 = 0;
        while (n8 < list.size() - 1) {
            timeEvent2 = (TimeEvent)list.get(n8);
            timeEvent = (TimeEvent)list.get(n8 + 1);
            if (this.computeMinMax) {
                this.minTime = timeEvent.getTime() - timeEvent2.getTime();
                this.computeMinMax = false;
            }
            if (timeEvent.getTime() - timeEvent2.getTime() < this.minTime) {
                this.minTime = timeEvent.getTime() - timeEvent2.getTime();
            }
            if (timeEvent.getTime() - timeEvent2.getTime() > this.maxTime) {
                this.maxTime = timeEvent.getTime() - timeEvent2.getTime();
            }
            ++n8;
        }
    }

    protected void setHasTimeInfo(boolean bl) {
        this.timeInfo = bl;
    }

    public boolean hasTimeInfo() {
        return this.timeInfo;
    }

    public static boolean contains(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        if (n3 < 0) {
            n7 += n3;
            n9 = -n9;
        }
        if (n4 < 0) {
            n8 += n4;
            n10 = -n10;
        }
        return n5 >= n7 && n6 >= n8 && n5 - n7 < n9 && n6 - n8 < n10;
    }

    public static void setUserPref(ISDPreferences iSDPreferences) {
        userPref = iSDPreferences;
    }

    public static ISDPreferences getUserPref() {
        return userPref;
    }

    public void setTimeUnitName(String string) {
        this.unitName = string;
    }

    public String getTimeUnitName() {
        return this.unitName;
    }
}

