/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IFont;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ColorImpl;
import org.eclipse.hyades.uml2sd.ui.preferences.SDViewPref;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class NGC
implements IGC {
    protected GC context;
    protected SDWidget view;
    private Font tempFont = null;
    private IColor gradientColor = null;
    private IColor backGround = null;
    private IColor foreGround = null;
    private static int motif_bounds = 1000;

    public NGC(SDWidget sDWidget, GC gC) {
        this.context = gC;
        this.view = sDWidget;
    }

    public void setLineStyle(int n) {
        this.context.setLineStyle(n);
    }

    public int getLineStyle() {
        return this.context.getLineStyle();
    }

    public int getContentsX() {
        return Math.round((float)this.view.getContentsX() / this.view.zoomValue);
    }

    public int getContentsY() {
        return Math.round((float)this.view.getContentsY() / this.view.zoomValue);
    }

    public int getVisibleWidth() {
        return Math.round((float)this.view.getVisibleWidth() / this.view.zoomValue);
    }

    public int getVisibleHeight() {
        return Math.round((float)this.view.getVisibleHeight() / this.view.zoomValue);
    }

    public int contentsToViewX(int n) {
        return this.view.contentsToViewX(n);
    }

    public int contentsToViewY(int n) {
        return this.view.contentsToViewY(n);
    }

    public int ensureSWTBounds(int n) {
        if (n < -motif_bounds) {
            n = -motif_bounds;
        } else if (n > this.view.getVisibleWidth() + motif_bounds) {
            n = this.view.getVisibleWidth() + motif_bounds;
        }
        return n;
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        n = this.view.contentsToViewX(n);
        n2 = this.view.contentsToViewY(n2);
        n3 = this.view.contentsToViewX(n3);
        n4 = this.view.contentsToViewY(n4);
        if (n == n3) {
            this.context.drawLine(this.ensureSWTBounds(n), this.ensureSWTBounds(n2), this.ensureSWTBounds(n3), this.ensureSWTBounds(n4));
        } else {
            this.context.drawLine(n, n2, n3, n4);
        }
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        n = this.view.contentsToViewX(n);
        n2 = this.view.contentsToViewY(n2);
        if (n < -motif_bounds) {
            n3 = n3 + n + motif_bounds;
        }
        if (n2 < -motif_bounds) {
            n4 = n4 + n2 + motif_bounds;
        }
        this.context.drawRectangle(this.ensureSWTBounds(n), this.ensureSWTBounds(n2), this.ensureSWTBounds(n3), this.ensureSWTBounds(n4));
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        this.context.drawFocus(this.view.contentsToViewX(n), this.view.contentsToViewY(n2), n3, n4);
    }

    public void fillPolygon(int[] nArray) {
        int n = nArray.length / 2 * 2;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = this.view.contentsToViewX(Math.round((float)nArray[n2] * this.view.zoomValue));
            nArray2[++n2] = this.view.contentsToViewY(Math.round((float)nArray[n2] * this.view.zoomValue));
            ++n2;
        }
        this.context.fillPolygon(nArray2);
    }

    public void drawPolygon(int[] nArray) {
        int n = nArray.length / 2 * 2;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = this.view.contentsToViewX(Math.round((float)nArray[n2] * this.view.zoomValue));
            nArray2[++n2] = this.view.contentsToViewY(Math.round((float)nArray[n2] * this.view.zoomValue));
            ++n2;
        }
        this.context.drawPolygon(nArray2);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue) - 1;
        n4 = Math.round((float)n4 * this.view.zoomValue) - 1;
        n = this.view.contentsToViewX(n) + 1;
        n2 = this.view.contentsToViewY(n2) + 1;
        if (n < -motif_bounds) {
            n3 = n3 + n + motif_bounds;
        }
        if (n2 < -motif_bounds) {
            n4 = n4 + n2 + motif_bounds;
        }
        this.context.fillRectangle(this.ensureSWTBounds(n), this.ensureSWTBounds(n2), this.ensureSWTBounds(n3), this.ensureSWTBounds(n4));
    }

    public void fillGradientRectangle(int n, int n2, int n3, int n4, boolean bl) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        IColor iColor = this.foreGround;
        this.setForeground(this.gradientColor);
        n = this.view.contentsToViewX(n);
        n2 = this.view.contentsToViewY(n2);
        if (n < -motif_bounds) {
            n3 = n3 + n + motif_bounds;
        }
        if (n2 < -motif_bounds) {
            n4 = n4 + n2 + motif_bounds;
        }
        this.context.fillGradientRectangle(this.ensureSWTBounds(n) + this.ensureSWTBounds(n3), this.ensureSWTBounds(n2), -this.ensureSWTBounds(n3), this.ensureSWTBounds(n4), bl);
        this.setForeground(iColor);
    }

    public int textExtent(String string) {
        return this.context.textExtent((String)string).x;
    }

    public void drawText(String string, int n, int n2, boolean bl) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        this.context.drawText(string, this.view.contentsToViewX(n), this.view.contentsToViewY(n2), bl);
    }

    public void drawText(String string, int n, int n2) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        this.context.drawText(string, this.view.contentsToViewX(n), this.view.contentsToViewY(n2), true);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        this.context.fillOval(this.view.contentsToViewX(n), this.view.contentsToViewY(n2), n3, n4);
    }

    public IColor getBackground() {
        if (this.backGround != null && this.backGround.getColor() instanceof Color && !((Color)this.backGround.getColor()).isDisposed()) {
            return this.backGround;
        }
        return ColorImpl.getSystemColor(1);
    }

    public IColor getForeground() {
        if (this.foreGround != null && this.foreGround.getColor() instanceof Color && !((Color)this.foreGround.getColor()).isDisposed()) {
            return this.foreGround;
        }
        return ColorImpl.getSystemColor(1);
    }

    public void setBackground(IColor iColor) {
        if (iColor == null) {
            return;
        }
        if (iColor.getColor() instanceof Color) {
            this.context.setBackground((Color)iColor.getColor());
            this.backGround = iColor;
        }
    }

    public void setForeground(IColor iColor) {
        if (iColor == null) {
            return;
        }
        if (iColor.getColor() instanceof Color) {
            this.context.setForeground((Color)iColor.getColor());
            this.foreGround = iColor;
        }
    }

    public void setGradientColor(IColor iColor) {
        if (iColor == null) {
            return;
        }
        if (iColor.getColor() instanceof Color) {
            this.gradientColor = iColor;
        }
    }

    public void setLineWidth(int n) {
        this.context.setLineWidth(n);
    }

    public int getLineWidth() {
        return this.context.getLineWidth();
    }

    private void localDrawText(String string, int n, int n2, boolean bl) {
        Point point = this.context.textExtent(string);
        if (!bl) {
            this.context.fillRectangle(n, n2, point.x, point.y);
        }
        this.context.drawText(string, n, n2, bl);
    }

    public void drawTextTruncatedCentred(String string, int n, int n2, int n3, int n4, boolean bl) {
        Point point = this.context.textExtent(string);
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        int n5 = this.view.contentsToViewX(n);
        int n6 = this.view.contentsToViewY(n2);
        if (point.y > n4) {
            return;
        }
        if (point.x <= n3) {
            this.localDrawText(string, n5 + 1 + (n3 - point.x) / 2, n6 + 1 + (n4 - point.y) / 2, bl);
        } else {
            String string2 = string;
            int n7 = string.length() - 1;
            while (n7 >= 0 && this.context.textExtent((String)string2).x >= n3) {
                string2 = string.substring(0, n7);
                --n7;
            }
            int n8 = 0;
            int n9 = 1;
            while (n9 <= 3 && string2.length() - n9 > 0) {
                ++n8;
                ++n9;
            }
            string2 = string2.substring(0, string2.length() - n8);
            int n10 = 0;
            while (n10 < n8) {
                string2 = string2 + ".";
                ++n10;
            }
            this.localDrawText(string2, n5 + 1 + (n3 - this.context.textExtent((String)string2).x) / 2, n6 + 1 + (n4 - this.context.textExtent((String)string2).y) / 2, bl);
        }
    }

    public void drawTextTruncated(String string, int n, int n2, int n3, int n4, boolean bl) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        int n5 = this.view.contentsToViewX(n);
        int n6 = this.view.contentsToViewY(n2);
        if (this.context.textExtent((String)string).x <= n3) {
            this.localDrawText(string, n5 + 1, n6 + 1 + n4, bl);
        } else {
            String string2 = string;
            int n7 = string.length() - 1;
            while (n7 >= 0 && this.context.textExtent((String)string2).x >= n3) {
                string2 = string.substring(0, n7);
                --n7;
            }
            int n8 = 0;
            int n9 = 1;
            while (n9 <= 3 && string2.length() - n9 > 0) {
                ++n8;
                ++n9;
            }
            string2 = string2.substring(0, string2.length() - n8);
            int n10 = 0;
            while (n10 < n8) {
                string2 = string2 + ".";
                ++n10;
            }
            this.localDrawText(string2, n5 + 1, n6 + 1 + n4, bl);
        }
    }

    public void drawImage(IImage iImage, int n, int n2, int n3, int n4) {
        if (!(iImage.getImage() instanceof Image)) {
            return;
        }
        Image image = (Image)iImage.getImage();
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        int n5 = this.view.contentsToViewX(n);
        int n6 = this.view.contentsToViewY(n2);
        Rectangle rectangle = ((Image)iImage.getImage()).getBounds();
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        if (n7 > n3) {
            n7 = n3;
        }
        if (n8 > n4) {
            n8 = n4;
        }
        float f = this.view.zoomValue;
        n7 = Math.round((float)n7 * f);
        n8 = Math.round((float)n8 * f);
        this.context.drawImage(image, 0, 0, rectangle.width, rectangle.height, n5, n6, n7, n8);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        n = Math.round((float)n * this.view.zoomValue);
        n2 = Math.round((float)n2 * this.view.zoomValue);
        n3 = Math.round((float)n3 * this.view.zoomValue);
        n4 = Math.round((float)n4 * this.view.zoomValue);
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        this.context.drawArc(this.view.contentsToViewX(n), this.view.contentsToViewY(n2), n3, n4, n5, n6);
    }

    public void setFont(IFont iFont) {
        if (iFont.getFont() != null && ((Font)iFont.getFont()).getFontData().length > 0) {
            FontData fontData = ((Font)iFont.getFont()).getFontData()[0];
            if (SDViewPref.getInstance().fontLinked()) {
                fontData.setHeight(Math.round((float)fontData.getHeight() * this.view.zoomValue));
            }
            if (this.tempFont != null) {
                this.tempFont.dispose();
            }
            this.tempFont = new Font((Device)Display.getCurrent(), fontData);
            this.context.setFont(this.tempFont);
        }
    }

    public int getFontHeight(IFont iFont) {
        if (iFont.getFont() != null && iFont.getFont() instanceof Font && ((Font)iFont.getFont()).getFontData().length > 0) {
            FontData fontData = ((Font)iFont.getFont()).getFontData()[0];
            Font font = this.context.getFont();
            this.context.setFont((Font)iFont.getFont());
            int n = this.context.textExtent((String)"lp").y;
            this.context.setFont(font);
            return n;
        }
        return 0;
    }

    public int getFontWidth(IFont iFont) {
        if (iFont.getFont() != null && iFont.getFont() instanceof Font) {
            Font font = this.context.getFont();
            this.context.setFont((Font)iFont.getFont());
            int n = this.context.getFontMetrics().getAverageCharWidth();
            this.context.setFont(font);
            return n;
        }
        return 0;
    }

    public void dispose() {
        if (this.tempFont != null) {
            this.tempFont.dispose();
        }
        this.tempFont = null;
        if (this.context != null) {
            this.context.dispose();
        }
        this.context = null;
    }

    public float getZoom() {
        if (this.view != null) {
            return this.view.zoomValue;
        }
        return 1.0f;
    }

    public int getLineDotStyle() {
        return 3;
    }

    public int getLineDashStyle() {
        return 2;
    }

    public int getLineSolidStyle() {
        return 1;
    }

    public IColor createColor(int n, int n2, int n3) {
        return new ColorImpl(Display.getDefault(), n, n2, n3);
    }
}

