/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.editor.action;

import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class EditAction
extends Action {
    public Control getFocusControl() {
        return Display.getCurrent().getFocusControl();
    }

    public String getClipboardText() {
        Control control = this.getFocusControl();
        if (control != null) {
            Clipboard clipboard = new Clipboard(this.getFocusControl().getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            String string = (String)clipboard.getContents((Transfer)textTransfer);
            clipboard.dispose();
            return string;
        }
        return null;
    }

    public String getSelectionText() {
        Control control = this.getFocusControl();
        if (control instanceof Text) {
            return ((Text)control).getSelectionText();
        }
        if (control instanceof StyledText) {
            return ((StyledText)control).getSelectionText();
        }
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            Point point = combo.getSelection();
            return combo.getText().substring(point.x, point.y);
        }
        return "";
    }

    public boolean isReadOnlyFocusControl() {
        Control control = this.getFocusControl();
        if (control == null || !control.isEnabled()) {
            return true;
        }
        IWorkbenchPage iWorkbenchPage = UIUtil.getActiveWorkbenchPage();
        if (iWorkbenchPage != null && iWorkbenchPage.getActiveEditor() instanceof IHyadesEditorPart && ((IHyadesEditorPart)iWorkbenchPage.getActiveEditor()).isReadOnly()) {
            return true;
        }
        if (control instanceof Text) {
            return !((Text)control).getEditable();
        }
        if (control instanceof StyledText) {
            return !((StyledText)control).getEditable();
        }
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            return (combo.getStyle() & 8) == 8;
        }
        return false;
    }

    public boolean isValidFocusControl() {
        Control control = this.getFocusControl();
        return control instanceof Text || control instanceof StyledText || control instanceof Combo;
    }
}

