/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.AssociationDescriptor;
import org.eclipse.hyades.ui.internal.extension.AssociationDescriptorEntry;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.jface.resource.ImageRegistry;

public class AssociationMapping
implements IAssociationMapping {
    private AssociationMappingRegistry associationMappingRegistry;
    private String pluginId;
    private List commonAssociationDescriptors;
    private Map entryByType;
    private String extensionPoint;
    private boolean pluginRegistryWasLoaded = false;

    public AssociationMapping(AssociationMappingRegistry associationMappingRegistry, String string, String string2) {
        this.associationMappingRegistry = associationMappingRegistry;
        this.extensionPoint = string;
        this.pluginId = string2;
        this.commonAssociationDescriptors = new ArrayList();
        this.entryByType = new HashMap();
    }

    public void dispose() {
        CoreUtil.dispose(this.commonAssociationDescriptors);
        CoreUtil.dispose(this.entryByType);
        this.associationMappingRegistry = null;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    protected ImageRegistry getImageRegistry() {
        return this.associationMappingRegistry.getImageRegistry();
    }

    public IAssociationMappingRegistry getAssociationMappingRegistry() {
        return this.associationMappingRegistry;
    }

    public String getExtensionPoint() {
        return this.extensionPoint;
    }

    public String[] getTypes() {
        this.loadPluginRegistry();
        return this.entryByType.keySet().toArray(new String[this.entryByType.keySet().size()]);
    }

    protected boolean hasAssociationDescriptors() {
        return !this.commonAssociationDescriptors.isEmpty() || !this.entryByType.isEmpty();
    }

    public IAssociationDescriptor[] associationDescriptors() {
        this.loadPluginRegistry();
        HashSet hashSet = new HashSet(this.commonAssociationDescriptors);
        Iterator iterator = this.entryByType.values().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(((AssociationDescriptorEntry)iterator.next()).getTypedAssociationDescriptor());
        }
        return hashSet.toArray(new IAssociationDescriptor[hashSet.size()]);
    }

    public IAssociationDescriptor[] getAssociationDescriptors() {
        this.loadPluginRegistry();
        return this.commonAssociationDescriptors.toArray(new IAssociationDescriptor[this.commonAssociationDescriptors.size()]);
    }

    public IAssociationDescriptor[] getAssociationDescriptors(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_NULL_TYPE"));
        }
        this.loadPluginRegistry();
        return this.retrieveEntry(string).getAssociationDescriptors();
    }

    public IAssociationDescriptor getAssociationDescriptor(String string) {
        if (string == null) {
            return null;
        }
        IAssociationDescriptor[] iAssociationDescriptorArray = this.getAssociationDescriptors();
        int n = 0;
        int n2 = iAssociationDescriptorArray.length;
        while (n < n2) {
            if (string.equals(iAssociationDescriptorArray[n].getId())) {
                return iAssociationDescriptorArray[n];
            }
            ++n;
        }
        return null;
    }

    public IAssociationDescriptor getAssociationDescriptor(String string, String string2) throws IllegalArgumentException {
        if (string2 == null) {
            return null;
        }
        IAssociationDescriptor[] iAssociationDescriptorArray = this.getAssociationDescriptors(string);
        int n = 0;
        int n2 = iAssociationDescriptorArray.length;
        while (n < n2) {
            if (string2.equals(iAssociationDescriptorArray[n].getId())) {
                return iAssociationDescriptorArray[n];
            }
            ++n;
        }
        return null;
    }

    public IAssociationDescriptor getDefaultAssociationDescriptor() {
        this.loadPluginRegistry();
        if (this.commonAssociationDescriptors.isEmpty()) {
            return null;
        }
        return (IAssociationDescriptor)this.commonAssociationDescriptors.get(0);
    }

    public IAssociationDescriptor getDefaultAssociationDescriptor(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_NULL_TYPE"));
        }
        this.loadPluginRegistry();
        return this.retrieveEntry(string).getDefault();
    }

    public synchronized boolean setDefaultAssociationDescriptor(IAssociationDescriptor iAssociationDescriptor) throws IllegalArgumentException {
        if (iAssociationDescriptor == null) {
            return false;
        }
        if (iAssociationDescriptor.getAssociationMapping() != this) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_INV_ASSOC"));
        }
        int n = this.commonAssociationDescriptors.indexOf(iAssociationDescriptor);
        if (n == 0) {
            return true;
        }
        if (n > 0) {
            this.commonAssociationDescriptors.remove(n);
        }
        this.commonAssociationDescriptors.add(0, iAssociationDescriptor);
        return iAssociationDescriptor == this.commonAssociationDescriptors.get(0);
    }

    public synchronized boolean setDefaultAssociationDescriptor(String string, IAssociationDescriptor iAssociationDescriptor) throws IllegalArgumentException {
        if (iAssociationDescriptor == null) {
            return false;
        }
        if (string == null) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_NULL_TYPE"));
        }
        if (iAssociationDescriptor.getAssociationMapping() != this) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_INV_ASSOC"));
        }
        if (!iAssociationDescriptor.applyTo(string)) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_INV_ASSOC"));
        }
        AssociationDescriptorEntry associationDescriptorEntry = this.retrieveEntry(string);
        associationDescriptorEntry.setDefault(iAssociationDescriptor);
        return associationDescriptorEntry.getDefault() == iAssociationDescriptor;
    }

    public boolean addToAvoidedSet(String string, IAssociationDescriptor iAssociationDescriptor) {
        if (string == null || iAssociationDescriptor == null || !iAssociationDescriptor.applyTo(string)) {
            return false;
        }
        this.retrieveEntry(string).addToAvoidedSet(iAssociationDescriptor);
        return true;
    }

    public IAssociationDescriptor[] getAvoidedAssociationDescriptors(String string) {
        if (string != null) {
            Set set = this.retrieveEntry(string).avoidedAssociationDescriptors();
            return set.toArray(new IAssociationDescriptor[set.size()]);
        }
        return new IAssociationDescriptor[0];
    }

    public boolean removeAllFromAvoidSet(String string) {
        if (string == null) {
            return false;
        }
        this.retrieveEntry(string).removeAllFromAvoidedSet();
        return true;
    }

    public boolean removeFromAvoidedSet(String string, IAssociationDescriptor iAssociationDescriptor) {
        if (string == null) {
            return false;
        }
        return this.retrieveEntry(string).removeFromAvoidedSet(iAssociationDescriptor);
    }

    public IAssociationDescriptor createAssociationDescriptor() {
        AssociationDescriptor associationDescriptor = new AssociationDescriptor(this);
        this.commonAssociationDescriptors.add(associationDescriptor);
        return associationDescriptor;
    }

    protected synchronized void loadPluginRegistry() {
        if (this.pluginRegistryWasLoaded) {
            return;
        }
        if (this.pluginId != null) {
            IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor(this.pluginId, this.getExtensionPoint());
            int n = 0;
            int n2 = iConfigurationElementArray.length;
            while (n < n2) {
                AssociationDescriptor associationDescriptor = new AssociationDescriptor(this);
                associationDescriptor.loadFromConfigurationElement(iConfigurationElementArray[n]);
                ++n;
            }
        }
        this.pluginRegistryWasLoaded = true;
    }

    protected synchronized AssociationDescriptorEntry retrieveEntry(String string) {
        if (string == null) {
            return null;
        }
        AssociationDescriptorEntry associationDescriptorEntry = (AssociationDescriptorEntry)this.entryByType.get(string);
        if (associationDescriptorEntry == null) {
            associationDescriptorEntry = new AssociationDescriptorEntry(this.commonAssociationDescriptors, string);
            this.entryByType.put(string, associationDescriptorEntry);
        }
        return associationDescriptorEntry;
    }

    protected synchronized void register(IAssociationDescriptor iAssociationDescriptor) {
        if (!this.isValid(iAssociationDescriptor)) {
            return;
        }
        if (!this.commonAssociationDescriptors.contains(iAssociationDescriptor)) {
            this.commonAssociationDescriptors.add(iAssociationDescriptor);
        }
    }

    protected boolean register(String string, IAssociationDescriptor iAssociationDescriptor) {
        if (string == null) {
            return false;
        }
        if (!this.isValid(iAssociationDescriptor)) {
            return false;
        }
        this.retrieveEntry(string).addTypedAssociationDescriptor(iAssociationDescriptor);
        return true;
    }

    protected void deregister(IAssociationDescriptor iAssociationDescriptor) {
        this.commonAssociationDescriptors.remove(iAssociationDescriptor);
    }

    protected synchronized void deregister(String string, IAssociationDescriptor iAssociationDescriptor) {
        if (string == null) {
            return;
        }
        AssociationDescriptorEntry associationDescriptorEntry = (AssociationDescriptorEntry)this.entryByType.get(string);
        if (associationDescriptorEntry == null) {
            return;
        }
        associationDescriptorEntry.removeTypedAssociationDescriptor(iAssociationDescriptor);
    }

    protected boolean isValid(IAssociationDescriptor iAssociationDescriptor) {
        IAssociationDescriptorFilter iAssociationDescriptorFilter = this.associationMappingRegistry.getFilter();
        if (iAssociationDescriptorFilter == null) {
            return true;
        }
        return iAssociationDescriptorFilter.isValid(this, iAssociationDescriptor);
    }
}

