/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.TreeViewerFrameSource;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class TreeNavigatorFrameSource
extends TreeViewerFrameSource {
    private ITreeNavigator treeNavigator;

    public TreeNavigatorFrameSource(ITreeNavigator iTreeNavigator) {
        super((AbstractTreeViewer)iTreeNavigator.getTreeViewer());
        this.treeNavigator = iTreeNavigator;
    }

    protected ITreeNavigator getTreeNavigator() {
        return this.treeNavigator;
    }

    protected TreeFrame createFrame(Object object) {
        TreeFrame treeFrame = super.createFrame(object);
        treeFrame.setName(this.treeNavigator.getFrameName(object));
        treeFrame.setToolTipText(this.treeNavigator.getFrameToolTipText(object));
        return treeFrame;
    }

    protected void frameChanged(TreeFrame treeFrame) {
        IProject iProject;
        Object object = treeFrame.getInput();
        if (object instanceof IResource && (iProject = ((IResource)object).getProject()) != null && !iProject.isOpen()) {
            MessageDialog.openInformation((Shell)this.treeNavigator.getViewSite().getShell(), (String)ResourceNavigatorMessages.getString((String)"NavigatorFrameSource.closedProject.title"), (String)ResourceNavigatorMessages.format((String)"NavigatorFrameSource.closedProject.message", (Object[])new Object[]{iProject.getName()}));
            this.treeNavigator.getFrameList().back();
            return;
        }
        super.frameChanged(treeFrame);
        this.treeNavigator.updateTitle();
    }
}

