/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.util.IDisposable;

public class ResourceBundleManager
implements IDisposable {
    private List resourceBundles = this.createResourceBundleList();

    public void dispose() {
        this.resourceBundles.clear();
    }

    protected List createResourceBundleList() {
        return new ArrayList();
    }

    public boolean add(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return false;
        }
        return this.resourceBundles.add(resourceBundle);
    }

    public boolean add(int n, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return false;
        }
        this.resourceBundles.add(n, resourceBundle);
        return true;
    }

    public boolean remove(ResourceBundle resourceBundle) {
        return this.resourceBundles.remove(resourceBundle);
    }

    public ResourceBundle remove(int n) {
        return (ResourceBundle)this.resourceBundles.remove(n);
    }

    public void clear() {
        this.resourceBundles.clear();
    }

    public Iterator iterator() {
        return this.resourceBundles.iterator();
    }

    public int size() {
        return this.resourceBundles.size();
    }

    public String getString(String string) throws NullPointerException, MissingResourceException {
        MissingResourceException missingResourceException = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            try {
                return ((ResourceBundle)iterator.next()).getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                missingResourceException = missingResourceException2;
            }
        }
        throw missingResourceException;
    }

    public String getString(String string, String string2) throws NullPointerException, MissingResourceException {
        return StringUtil.replace(this.getString(string), "%1", string2);
    }

    public String getString(String string, String[] stringArray) throws NullPointerException, MissingResourceException {
        String string2 = this.getString(string);
        int n = stringArray.length;
        while (n > 0) {
            string2 = StringUtil.replace(string2, "%" + n, stringArray[n - 1]);
            --n;
        }
        return string2;
    }
}

