/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class FileSystemStructureProvider
implements IImportStructureProvider {
    private String pathPrefixToRemove;

    public FileSystemStructureProvider(String string) {
        this.pathPrefixToRemove = string;
    }

    public List getChildren(Object object) {
        File file = (File)object;
        String[] stringArray = file.list();
        int n = stringArray == null ? 0 : stringArray.length;
        ArrayList<File> arrayList = new ArrayList<File>(n);
        int n2 = 0;
        while (n2 < n) {
            File file2 = new File(file, stringArray[n2]);
            String string = this.getFullPath(file2);
            if (!"".equals(string)) {
                arrayList.add(new File(file, stringArray[n2]));
            }
            ++n2;
        }
        return arrayList;
    }

    public InputStream getContents(Object object) {
        try {
            return new FileInputStream((File)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public String getFullPath(Object object) {
        File file = (File)object;
        String string = file.getPath();
        if (file.isDirectory() && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return this.removePrefix(string);
    }

    public String getLabel(Object object) {
        File file = (File)object;
        String string = null;
        if (file.isDirectory()) {
            string = this.getFullPath(file);
        }
        if ("".equals(string)) {
            return "";
        }
        string = file.getName();
        if (string.length() == 0) {
            return file.getPath();
        }
        return string;
    }

    public boolean isFolder(Object object) {
        return ((File)object).isDirectory();
    }

    private String removePrefix(String string) {
        int n;
        if (this.pathPrefixToRemove != null && (n = string.indexOf(this.pathPrefixToRemove)) >= 0) {
            string = string.substring(n + this.pathPrefixToRemove.length());
        }
        return string;
    }
}

