/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.TraceMethodBaseLoader;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;

public class XMLmethodExitLoader
extends TraceMethodBaseLoader {
    protected static final String OVERHEAD = "overhead";
    private double overhead;
    private long sequenceCounter;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$trace$CallStackPerThread;

    public void addAttribute(String string, String string2) {
        if (!this.loadToModel) {
            return;
        }
        switch (LoadersUtils.getHashCode((String)string)) {
            case 529694900: {
                this.overhead = Double.parseDouble(string2);
                break;
            }
            case 2011131163: {
                this.stackDepth = Short.parseShort(string2);
                break;
            }
            case -873960692: {
                this.ticket = Long.parseLong(string2);
                break;
            }
            default: {
                super.addAttribute(string, string2);
            }
        }
    }

    public void addYourselfInContext() {
        if (!this.loadToModel) {
            return;
        }
        this.cs = (CallStackPerThread)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$loaders$trace$CallStackPerThread == null ? (class$org$eclipse$hyades$loaders$trace$CallStackPerThread = XMLmethodExitLoader.class$("org.eclipse.hyades.loaders.trace.CallStackPerThread")) : class$org$eclipse$hyades$loaders$trace$CallStackPerThread, LoadersUtils.getLookUpKey((int)this.threadIdRef));
        if (this.cs == null || this.cs.isEmpty()) {
            return;
        }
        this.invocationPool = this.cs.invocationPool;
        this.theProcess = this.getProcess();
        this.dispatchProcessMode(0);
    }

    public void initialize(HierarchyContext hierarchyContext, String string) {
        this.loadToModel = hierarchyContext.isLoadToModel();
        if (!this.loadToModel) {
            return;
        }
        super.initialize(hierarchyContext, string);
        this.overhead = 0.0;
        this.stackDepth = 0;
        this.ticket = 0L;
        this.sequenceCounter = 0L;
    }

    protected void processEF(int n) {
        super.processEF(n);
        this.fullInvocation = ((TraceUtils.InvocationInfo)this.cs.peek()).getMethodInvocation();
        if (this.fullInvocation != null) {
            this.theThread = this.fullInvocation.getThread();
            this.fullInvocation.setExitTime(this.createDeltaTime());
            this.fullInvocation.setOverhead(this.overhead);
            this.updateStatisticalInfo();
            this.invocationPool.release((TraceUtils.InvocationInfo)this.cs.pop());
        }
    }

    protected void processENI(int n) {
        super.processENI(n);
        this.processEF(n);
    }

    protected void processES(int n) {
        super.processES(n);
        this.updateStatisticalInfoOnly();
    }

    private void updateStatisticalInfo() {
        try {
            int n = this.fullInvocation.getInvokes().size();
            if (n > 0) {
                this.lastChildExitTime = ((TRCFullMethodInvocation)this.fullInvocation.getInvokes().get(n - 1)).getExitTime();
                this.deltaBaseTime = this.fullInvocation.getExitTime() - this.lastChildExitTime - this.fullInvocation.getOverhead();
            } else {
                this.deltaBaseTime = this.fullInvocation.getExitTime() - this.fullInvocation.getEntryTime() - this.fullInvocation.getOverhead();
            }
            this.invokerMethod = this.fullInvocation.getMethod();
            this.invokerObject = (TRCFullTraceObject)this.fullInvocation.getOwningObject();
            this.invokerClass = this.fullInvocation.getMethod().getDefiningClass();
            this.invokerObjectClass = this.getExtendedClass(this.invokerObject, this.invokerClass);
            this.updateTimeStatistics();
        }
        catch (Exception exception) {
            LoadersUtils.log((Throwable)exception);
        }
    }

    private void updateStatisticalInfoOnly() {
        try {
            TraceUtils.InvocationInfo invocationInfo;
            TraceUtils.InvocationInfo invocationInfo2 = (TraceUtils.InvocationInfo)this.cs.peek();
            double d = this.createDeltaTime();
            this.lastChildExitTime = invocationInfo2.getLastChildExitTime();
            this.deltaBaseTime = this.lastChildExitTime > 0.0 ? d - this.lastChildExitTime - this.overhead : d - invocationInfo2.getEntryTime() - this.overhead;
            this.invokerObject = invocationInfo2.getObject();
            this.invokerClass = invocationInfo2.getTheClass();
            this.invokerObjectClass = invocationInfo2.getObjectClass();
            this.invokerMethod = invocationInfo2.getMethod();
            this.updateTimeStatistics();
            this.invocationPool.release((TraceUtils.InvocationInfo)this.cs.pop());
            if (!this.cs.isEmpty() && (invocationInfo = (TraceUtils.InvocationInfo)this.cs.peek()) != null) {
                invocationInfo.setLastChildExitTime(d);
            }
            this.theProcess.setLastEventTime(d);
        }
        catch (Exception exception) {
            LoadersUtils.log((Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

