/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.SerializableImpl;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.events.cbe.util.EventValidation;

public class ExtendedDataElementImpl
extends SerializableImpl
implements ExtendedDataElement,
Cloneable {
    private static final long serialVersionUID = -6200886839335499445L;
    private static final String CLASS_NAME = (class$org$eclipse$hyades$logging$events$cbe$impl$ExtendedDataElementImpl == null ? (class$org$eclipse$hyades$logging$events$cbe$impl$ExtendedDataElementImpl = ExtendedDataElementImpl.class$("org.eclipse.hyades.logging.events.cbe.impl.ExtendedDataElementImpl")) : class$org$eclipse$hyades$logging$events$cbe$impl$ExtendedDataElementImpl).getName();
    private static final int MAX_TYPE_LENGTH = 64;
    private static final int MAX_NAME_LENGTH = 64;
    private static final int MAX_VALUE_LENGTH = 1024;
    public static final String[] EDE_TYPES = new String[]{"noValue", "byte", "short", "int", "long", "float", "double", "string", "dateTime", "boolean", "byteArray", "shortArray", "intArray", "longArray", "floatArray", "doubleArray", "stringArray", "dateTimeArray", "booleanArray", "hexBinary"};
    public static final List EDE_TYPES_LIST = Arrays.asList(EDE_TYPES);
    private static final char[] HEX_BASE_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final String HEX_VALUE_EDEFAULT = null;
    protected String hexValue = HEX_VALUE_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    protected EList values = null;
    protected EList children = null;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$events$cbe$impl$ExtendedDataElementImpl;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$events$cbe$ExtendedDataElement;
    static /* synthetic */ Class class$java$lang$String;

    protected ExtendedDataElementImpl() {
    }

    public EList getChildren() {
        if (this.children == null) {
            this.children = new EObjectContainmentEList(class$org$eclipse$hyades$logging$events$cbe$ExtendedDataElement == null ? (class$org$eclipse$hyades$logging$events$cbe$ExtendedDataElement = ExtendedDataElementImpl.class$("org.eclipse.hyades.logging.events.cbe.ExtendedDataElement")) : class$org$eclipse$hyades$logging$events$cbe$ExtendedDataElement, (InternalEObject)this, 4);
        }
        return this.children;
    }

    public EList getChildren(String string) {
        ListIterator listIterator = this.getChildren().listIterator();
        BasicEList basicEList = new BasicEList();
        while (listIterator.hasNext()) {
            ExtendedDataElement extendedDataElement = (ExtendedDataElement)listIterator.next();
            if (!extendedDataElement.getName().equals(string)) continue;
            basicEList.add((Object)extendedDataElement);
        }
        return basicEList;
    }

    public void setHexValue(String string) {
        String string2 = this.hexValue;
        this.hexValue = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)string2, (Object)this.hexValue));
        }
    }

    public String getHexValue() {
        return this.hexValue;
    }

    public void setHexValueAsByteArray(byte[] byArray) {
        this.setHexValue(this.byteArrayToHexBinary(byArray));
        this.setType("hexBinary");
    }

    public void setHexValueAsCharArray(char[] cArray) {
        this.setHexValue(new String(cArray));
        this.setType("hexBinary");
    }

    public byte[] getHexValueAsByteArray() {
        byte[] byArray = null;
        if (this.getType().equals("hexBinary")) {
            String string = this.getHexValue();
            if (string != null) {
                try {
                    byArray = this.hexBinaryToByteArray(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalStateException(string + " is not a valid xsd:hexBinary value");
                }
            }
        } else {
            throw new IllegalStateException("type is not hexBinary");
        }
        return byArray;
    }

    public char[] getHexValueAsCharArray() {
        char[] cArray = null;
        if (this.getType().equals("hexBinary")) {
            String string = this.getHexValue();
            if (string != null) {
                try {
                    cArray = string.toCharArray();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalStateException(string + " is not a valid xsd:hexBinary value");
                }
            }
        } else {
            throw new IllegalStateException("type is not hexBinary");
        }
        return cArray;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)string2, (Object)this.name));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setType(String string) {
        String string2 = this.type;
        this.type = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)string2, (Object)this.type));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setTypeAsInt(int n) {
        switch (n) {
            case 1: {
                this.setType("byte");
                break;
            }
            case 2: {
                this.setType("short");
                break;
            }
            case 3: {
                this.setType("int");
                break;
            }
            case 4: {
                this.setType("long");
                break;
            }
            case 5: {
                this.setType("float");
                break;
            }
            case 6: {
                this.setType("double");
                break;
            }
            case 7: {
                this.setType("string");
                break;
            }
            case 8: {
                this.setType("dateTime");
                break;
            }
            case 9: {
                this.setType("boolean");
                break;
            }
            case 10: {
                this.setType("byteArray");
                break;
            }
            case 11: {
                this.setType("shortArray");
                break;
            }
            case 12: {
                this.setType("intArray");
                break;
            }
            case 13: {
                this.setType("longArray");
                break;
            }
            case 14: {
                this.setType("floatArray");
                break;
            }
            case 15: {
                this.setType("doubleArray");
                break;
            }
            case 16: {
                this.setType("stringArray");
                break;
            }
            case 17: {
                this.setType("dateTimeArray");
                break;
            }
            case 18: {
                this.setType("booleanArray");
                break;
            }
            case 19: {
                this.setType("hexBinary");
                break;
            }
            default: {
                this.setType("noValue");
            }
        }
    }

    public int getTypeAsInt() {
        String string = this.getType();
        if (string != null) {
            if (string.equals("byte")) {
                return 1;
            }
            if (string.equals("short")) {
                return 2;
            }
            if (string.equals("int")) {
                return 3;
            }
            if (string.equals("long")) {
                return 4;
            }
            if (string.equals("float")) {
                return 5;
            }
            if (string.equals("double")) {
                return 6;
            }
            if (string.equals("string")) {
                return 7;
            }
            if (string.equals("dateTime")) {
                return 8;
            }
            if (string.equals("boolean")) {
                return 9;
            }
            if (string.equals("byteArray")) {
                return 10;
            }
            if (string.equals("shortArray")) {
                return 11;
            }
            if (string.equals("intArray")) {
                return 12;
            }
            if (string.equals("longArray")) {
                return 13;
            }
            if (string.equals("floatArray")) {
                return 14;
            }
            if (string.equals("doubleArray")) {
                return 15;
            }
            if (string.equals("stringArray")) {
                return 16;
            }
            if (string.equals("dateTimeArray")) {
                return 17;
            }
            if (string.equals("booleanArray")) {
                return 18;
            }
            if (string.equals("hexBinary")) {
                return 19;
            }
        }
        return 0;
    }

    public EList getValues() {
        if (this.values == null) {
            this.values = new EDataTypeEList(class$java$lang$String == null ? (class$java$lang$String = ExtendedDataElementImpl.class$("java.lang.String")) : class$java$lang$String, (InternalEObject)this, 3);
        }
        return this.values;
    }

    public void setValues(String[] stringArray) {
        this.setValuesAsStringArray(stringArray);
    }

    public void setValuesAsBoolean(boolean bl) {
        this.setValuesAsString(String.valueOf(bl));
        this.setType("boolean");
    }

    public boolean getValuesAsBoolean() {
        if (this.getType().equals("boolean") && this.getValues().size() == 1) {
            return new Boolean((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsBooleanArray(boolean[] blArray) {
        EList eList = this.resetValues();
        int n = 0;
        while (n < blArray.length) {
            eList.add((Object)String.valueOf(blArray[n]));
            ++n;
        }
        this.setType("booleanArray");
    }

    public boolean[] getValuesAsBooleanArray() {
        if (this.getType().equals("booleanArray")) {
            EList eList = this.getValues();
            boolean[] blArray = new boolean[eList.size()];
            int n = 0;
            while (n < eList.size()) {
                blArray[n] = new Boolean((String)eList.get(n));
                ++n;
            }
            return blArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsByte(byte by) {
        this.setValues(String.valueOf(by));
        this.setType("byte");
    }

    public byte getValuesAsByte() {
        if (this.getType().equals("byte") && this.getValues().size() == 1) {
            return new Byte((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsByteArray(byte[] byArray) {
        EList eList = this.resetValues();
        int n = 0;
        while (n < byArray.length) {
            eList.add((Object)String.valueOf(byArray[n]));
            ++n;
        }
        this.setType("byteArray");
    }

    public byte[] getValuesAsByteArray() {
        if (this.getType().equals("byteArray")) {
            EList eList = this.getValues();
            byte[] byArray = new byte[eList.size()];
            int n = 0;
            while (n < eList.size()) {
                byArray[n] = new Byte((String)eList.get(n));
                ++n;
            }
            return byArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsDate(String string) {
        this.setValues(string);
        this.setType("dateTime");
    }

    public String getValuesAsDate() {
        if (this.getType().equals("dateTime") && this.getValues().size() != 0) {
            return (String)this.getValues().get(0);
        }
        throw new IllegalStateException();
    }

    public void setValuesAsDateArray(String[] stringArray) {
        this.setValuesArray(stringArray);
        this.setType("dateTimeArray");
    }

    public String[] getValuesAsDateArray() {
        if (this.getType().equals("dateTimeArray")) {
            ArrayList arrayList = new ArrayList(this.getValues());
            String[] stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }
        throw new IllegalStateException();
    }

    public void setValuesAsDateAsLong(long l) {
        this.setValuesAsDate(EventHelpers.longToDate(l));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getValuesAsDateAsLong() {
        long l = 0L;
        if (!this.getType().equals("dateTime")) throw new IllegalStateException("Invalid type " + this.getType());
        if (this.getValues().size() == 0) throw new IllegalStateException("There are " + this.getValues().size() + " elements in the values array");
        try {
            return EventHelpers.dateToLong(this.getValuesAsDate());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(this.getValuesAsDate() + " is not a valid xsd:dateTime");
        }
    }

    public void setValuesAsDateAsLongArray(long[] lArray) {
        String[] stringArray = new String[lArray.length];
        int n = 0;
        while (n < lArray.length) {
            stringArray[n] = EventHelpers.longToDate(lArray[n]);
            ++n;
        }
        this.setValuesAsDateArray(stringArray);
    }

    public long[] getValuesAsDateAsLongArray() {
        String[] stringArray = this.getValuesAsDateArray();
        long[] lArray = new long[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            try {
                lArray[n] = EventHelpers.dateToLong(stringArray[n]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(stringArray[n] + " is not a valid xsd:dateTime value");
            }
            ++n;
        }
        return lArray;
    }

    public void setValuesAsDouble(double d) {
        this.setValues(String.valueOf(d));
        this.setType("double");
    }

    public double getValuesAsDouble() {
        if (this.getType().equals("double") && this.getValues().size() == 1) {
            return new Double((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsDoubleArray(double[] dArray) {
        EList eList = this.resetValues();
        int n = 0;
        while (n < dArray.length) {
            eList.add((Object)String.valueOf(dArray[n]));
            ++n;
        }
        this.setType("doubleArray");
    }

    public double[] getValuesAsDoubleArray() {
        if (this.getType().equals("doubleArray")) {
            EList eList = this.getValues();
            double[] dArray = new double[eList.size()];
            int n = 0;
            while (n < eList.size()) {
                dArray[n] = new Double((String)eList.get(n));
                ++n;
            }
            return dArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsFloat(float f) {
        this.setValues(String.valueOf(f));
        this.setType("float");
    }

    public float getValuesAsFloat() {
        if (this.getType().equals("float") && this.getValues().size() == 1) {
            return new Float((String)this.getValues().get(0)).floatValue();
        }
        throw new IllegalStateException();
    }

    public void setValuesAsFloatArray(float[] fArray) {
        EList eList = this.resetValues();
        int n = 0;
        while (n < fArray.length) {
            eList.add((Object)String.valueOf(fArray[n]));
            ++n;
        }
        this.setType("floatArray");
    }

    public float[] getValuesAsFloatArray() {
        if (this.getType().equals("floatArray")) {
            EList eList = this.getValues();
            float[] fArray = new float[eList.size()];
            int n = 0;
            while (n < eList.size()) {
                fArray[n] = new Float((String)eList.get(n)).floatValue();
                ++n;
            }
            return fArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsInt(int n) {
        this.setValues(Integer.toString(n));
        this.setType("int");
    }

    public int getValuesAsInt() {
        if (this.getType().equals("int") && this.getValues().size() == 1) {
            return Integer.parseInt((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsIntArray(int[] nArray) {
        EList eList = this.resetValues();
        int n = 0;
        while (n < nArray.length) {
            eList.add((Object)Integer.toString(nArray[n]));
            ++n;
        }
        this.setType("intArray");
    }

    public int[] getValuesAsIntArray() {
        if (this.getType().equals("intArray")) {
            EList eList = this.getValues();
            int[] nArray = new int[eList.size()];
            int n = 0;
            while (n < eList.size()) {
                nArray[n] = new Integer((String)eList.get(n));
                ++n;
            }
            return nArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsLong(long l) {
        this.setValues(String.valueOf(l));
        this.setType("long");
    }

    public long getValuesAsLong() {
        if (this.getType().equals("long") && this.getValues().size() == 1) {
            return new Long((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsLongArray(long[] lArray) {
        EList eList = this.resetValues();
        int n = 0;
        while (n < lArray.length) {
            eList.add((Object)String.valueOf(lArray[n]));
            ++n;
        }
        this.setType("longArray");
    }

    public long[] getValuesAsLongArray() {
        if (this.getType().equals("longArray")) {
            EList eList = this.getValues();
            long[] lArray = new long[eList.size()];
            int n = 0;
            while (n < eList.size()) {
                lArray[n] = new Long((String)eList.get(n));
                ++n;
            }
            return lArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsShort(short s) {
        this.setValues(String.valueOf(s));
        this.setType("short");
    }

    public short getValuesAsShort() {
        if (this.getType().equals("short") && this.getValues().size() == 1) {
            return new Short((String)this.getValues().get(0));
        }
        throw new IllegalStateException();
    }

    public void setValuesAsShortArray(short[] sArray) {
        EList eList = this.resetValues();
        int n = 0;
        while (n < sArray.length) {
            eList.add((Object)String.valueOf(sArray[n]));
            ++n;
        }
        this.setType("shortArray");
    }

    public short[] getValuesAsShortArray() {
        if (this.getType().equals("shortArray")) {
            EList eList = this.getValues();
            short[] sArray = new short[eList.size()];
            int n = 0;
            while (n < eList.size()) {
                sArray[n] = new Short((String)eList.get(n));
                ++n;
            }
            return sArray;
        }
        throw new IllegalStateException();
    }

    public void setValuesAsString(String string) {
        this.setValues(string);
        this.setType("string");
    }

    public String getValuesAsString() {
        if (this.getType().equals("string") && this.getValues().size() == 1) {
            return (String)this.getValues().get(0);
        }
        throw new IllegalStateException();
    }

    public void setValuesAsStringArray(String[] stringArray) {
        this.setValuesArray(stringArray);
        this.setType("stringArray");
    }

    public String[] getValuesAsStringArray() {
        if (this.getType().equals("stringArray")) {
            ArrayList arrayList = new ArrayList(this.getValues());
            String[] stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }
        throw new IllegalStateException();
    }

    public ExtendedDataElement addChild(ExtendedDataElement extendedDataElement) {
        this.getChildren().add((Object)extendedDataElement);
        return extendedDataElement;
    }

    public void clearChildren() {
        this.getChildren().clear();
    }

    public void removeChildren(String string) {
        if (this.getChildren() != null) {
            int n = 0;
            while (n < this.getChildren().size()) {
                if (((ExtendedDataElement)this.getChildren().get(n)).getName().equals(string)) {
                    this.getChildren().remove(n--);
                }
                ++n;
            }
        }
    }

    public ExtendedDataElement addChild(String string) {
        ExtendedDataElement extendedDataElement = EventFactory.eINSTANCE.createExtendedDataElement();
        extendedDataElement.setName(string);
        this.getChildren().add((Object)extendedDataElement);
        return extendedDataElement;
    }

    public ExtendedDataElement addChild(String string, int n, String string2) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setTypeAsInt(n);
        if (19 == n) {
            extendedDataElement.setHexValue(string2);
        } else {
            extendedDataElement.getValues().add((Object)string2);
        }
        return extendedDataElement;
    }

    public ExtendedDataElement addChild(String string, int n, String[] stringArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setTypeAsInt(n);
        extendedDataElement.getValues().addAll(Arrays.asList(stringArray));
        return extendedDataElement;
    }

    public ExtendedDataElement addChild(String string, String string2) {
        return this.addChild(string, 7, string2);
    }

    public ExtendedDataElement addChild(String string, String[] stringArray) {
        return this.addChild(string, 16, stringArray);
    }

    public ExtendedDataElement addChildWithBooleanArrayValue(String string, boolean[] blArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsBooleanArray(blArray);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithBooleanValue(String string, boolean bl) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsBoolean(bl);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithByteArrayValue(String string, byte[] byArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsByteArray(byArray);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithByteValue(String string, byte by) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsByte(by);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithDateArrayValue(String string, String[] stringArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsDateArray(stringArray);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithDateAsLongValue(String string, long l) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsDateAsLong(l);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithDateValue(String string, String string2) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsDate(string2);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithDatesAsLongValue(String string, long[] lArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsDateAsLongArray(lArray);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithDoubleArrayValue(String string, double[] dArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsDoubleArray(dArray);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithDoubleValue(String string, double d) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsDouble(d);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithFloatArrayValue(String string, float[] fArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsFloatArray(fArray);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithFloatValue(String string, float f) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsFloat(f);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithHexValue(String string, String string2) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setType("hexBinary");
        extendedDataElement.setHexValue(string2);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithHexValueAsByteArray(String string, byte[] byArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setType("hexBinary");
        extendedDataElement.setHexValueAsByteArray(byArray);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithIntArrayValue(String string, int[] nArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsIntArray(nArray);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithIntValue(String string, int n) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsInt(n);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithLongArrayValue(String string, long[] lArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsLongArray(lArray);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithLongValue(String string, long l) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsLong(l);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithShortArrayValue(String string, short[] sArray) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsShortArray(sArray);
        return extendedDataElement;
    }

    public ExtendedDataElement addChildWithShortValue(String string, short s) {
        ExtendedDataElement extendedDataElement = this.addChild(string);
        extendedDataElement.setValuesAsShort(s);
        return extendedDataElement;
    }

    public Object eGet(EStructuralFeature eStructuralFeature, boolean bl) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return this.getHexValue();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getType();
            }
            case 3: {
                return this.getValues();
            }
            case 4: {
                return this.getChildren();
            }
        }
        return this.eDynamicGet(eStructuralFeature, bl);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, Class clazz, NotificationChain notificationChain) {
        if (n >= 0) {
            switch (this.eDerivedStructuralFeatureID(n, clazz)) {
                case 4: {
                    return ((InternalEList)this.getChildren()).basicRemove((Object)internalEObject, notificationChain);
                }
            }
            return this.eDynamicInverseRemove(internalEObject, n, clazz, notificationChain);
        }
        return this.eBasicSetContainer(null, n, notificationChain);
    }

    public boolean eIsSet(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                return HEX_VALUE_EDEFAULT == null ? this.hexValue != null : !HEX_VALUE_EDEFAULT.equals(this.hexValue);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
            case 3: {
                return this.values != null && !this.values.isEmpty();
            }
            case 4: {
                return this.children != null && !this.children.isEmpty();
            }
        }
        return this.eDynamicIsSet(eStructuralFeature);
    }

    public void eSet(EStructuralFeature eStructuralFeature, Object object) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setHexValue((String)object);
                return;
            }
            case 1: {
                this.setName((String)object);
                return;
            }
            case 2: {
                this.setType((String)object);
                return;
            }
            case 3: {
                this.getValues().clear();
                this.getValues().addAll((Collection)object);
                return;
            }
            case 4: {
                this.getChildren().clear();
                this.getChildren().addAll((Collection)object);
                return;
            }
        }
        this.eDynamicSet(eStructuralFeature, object);
    }

    public void eUnset(EStructuralFeature eStructuralFeature) {
        switch (this.eDerivedStructuralFeatureID(eStructuralFeature)) {
            case 0: {
                this.setHexValue(HEX_VALUE_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 3: {
                this.getValues().clear();
                return;
            }
            case 4: {
                this.getChildren().clear();
                return;
            }
        }
        this.eDynamicUnset(eStructuralFeature);
    }

    public boolean equals(Object object) {
        return EventHelpers.compareEObject(this, object);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (hexValue: ");
        stringBuffer.append(this.hexValue);
        stringBuffer.append(", name: ");
        stringBuffer.append(this.name);
        stringBuffer.append(", type: ");
        stringBuffer.append(this.type);
        stringBuffer.append(", values: ");
        stringBuffer.append(this.values);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static boolean isValid(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public static boolean isValid(String string) {
        return EDE_TYPES_LIST.contains(string);
    }

    public static String typeToString(int n) {
        try {
            return (String)EDE_TYPES_LIST.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static int typeToInt(String string) {
        return EDE_TYPES_LIST.indexOf(string);
    }

    public void validate() throws ValidationException {
        int n;
        Object object;
        EAttribute eAttribute;
        EAttribute eAttribute2;
        EAttribute eAttribute3;
        Object[] objectArray;
        EventPackage eventPackage = EventPackage.eINSTANCE;
        EventValidation.validateRequiredProperties(CLASS_NAME, this);
        String string = this.getType();
        if (!EDE_TYPES_LIST.contains(string)) {
            objectArray = new Object[]{this.getName(), this.getType()};
            EventValidation.throwValidationException(CLASS_NAME, "LOG_EXTENDED_DATA_INVALID_TYPE_EXC_", objectArray);
        }
        if (this.getTypeAsInt() == 0) {
            if (this.getValues().size() > 0 || this.getHexValue() != null) {
                objectArray = eventPackage.getExtendedDataElement_Type();
                eAttribute3 = eventPackage.getExtendedDataElement_Values();
                eAttribute2 = eventPackage.getExtendedDataElement_HexValue();
                String[] stringArray = new String[]{EventValidation.getComponentName(this, eAttribute3.getName()), EventValidation.getComponentName(this, eAttribute2.getName())};
                EventValidation.throwValidationException(CLASS_NAME, "LOG_INCONSISTENT_ATTRIBUTES_EXC_", new Object[]{EventValidation.getComponentName(this, objectArray.getName()), this.getType(), Arrays.asList(stringArray)});
            }
        } else if (this.getTypeAsInt() == 19) {
            if (this.getHexValue() == null) {
                eAttribute = eventPackage.getExtendedDataElement_HexValue();
                EventValidation.throwMissingPropertyException(CLASS_NAME, "LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", new Object[]{EventValidation.getComponentName(this, eAttribute.getName()), this.getClass()});
            }
        } else if (this.getValues().size() == 0) {
            eAttribute = eventPackage.getExtendedDataElement_Values();
            EventValidation.throwMissingPropertyException(CLASS_NAME, "LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", new Object[]{EventValidation.getComponentName(this, eAttribute.getName()), this.getClass()});
        }
        if (this.getValues().size() > 0 && this.getHexValue() != null) {
            objectArray = eventPackage.getExtendedDataElement_Values();
            eAttribute3 = eventPackage.getExtendedDataElement_HexValue();
            EventValidation.throwValidationException(CLASS_NAME, "LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_", new Object[]{EventValidation.getComponentName(this, objectArray.getName()), EventValidation.getComponentName(this, eAttribute3.getName())});
        }
        objectArray = eventPackage.getExtendedDataElement_Name();
        eAttribute3 = eventPackage.getExtendedDataElement_Type();
        EventValidation.validateLength(CLASS_NAME, this, (EStructuralFeature)objectArray, 64);
        EventValidation.validateLength(CLASS_NAME, this, (EStructuralFeature)eAttribute3, 64);
        eAttribute2 = eventPackage.getExtendedDataElement_Values();
        this.validateEListAsStringLength((EStructuralFeature)eAttribute2, 1024);
        int n2 = this.getTypeAsInt();
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                EList eList = this.getValues();
                if (eList.size() != 0) {
                    int n3 = 0;
                    while (n3 < eList.size()) {
                        if (eList.get(n3) == null) {
                            object = new Object[]{this.getName(), this.getType()};
                            EventValidation.throwValidationException(CLASS_NAME, "LOG_EXTENDED_DATA_VALUE_NULL_EXC_", object);
                        }
                        ++n3;
                    }
                    break;
                }
                eAttribute = eventPackage.getExtendedDataElement_HexValue();
                EventValidation.throwMissingPropertyException(CLASS_NAME, "LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", new Object[]{EventValidation.getComponentName(this, eAttribute.getName()), this.getClass()});
                break;
            }
        }
        String string2 = null;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (this.getValues().size() == 1) {
                    string2 = (String)this.getValues().get(0);
                    break;
                }
                object = new Object[]{new Integer(this.getValues().size()), this.getName(), this.getType()};
                EventValidation.throwValidationException(CLASS_NAME, "LOG_VALUE_ARRAY_SIZE_MISMATCH_EXC_", object);
                break;
            }
        }
        try {
            switch (n2) {
                case 1: {
                    Byte.parseByte(string2);
                    break;
                }
                case 6: {
                    Double.parseDouble(string2);
                    break;
                }
                case 5: {
                    Float.parseFloat(string2);
                    break;
                }
                case 3: {
                    Integer.parseInt(string2);
                    break;
                }
                case 4: {
                    Long.parseLong(string2);
                    break;
                }
                case 2: {
                    Short.parseShort(string2);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray2 = new Object[]{string2, this.getType(), this.getName()};
            EventValidation.throwValidationException(CLASS_NAME, "LOG_INVALID_TYPE_CONVERSION_EXC_", objectArray2);
        }
        object = null;
        try {
            switch (n2) {
                case 10: {
                    int n4 = 0;
                    while (n4 < this.values.size()) {
                        object = (Object[])this.values.get(n4);
                        Byte.parseByte((String)object);
                        ++n4;
                    }
                    break;
                }
                case 15: {
                    int n5 = 0;
                    while (n5 < this.values.size()) {
                        object = (String)this.values.get(n5);
                        Double.parseDouble((String)object);
                        ++n5;
                    }
                    break;
                }
                case 14: {
                    int n6 = 0;
                    while (n6 < this.values.size()) {
                        object = (String)this.values.get(n6);
                        Float.parseFloat((String)object);
                        ++n6;
                    }
                    break;
                }
                case 12: {
                    int n7 = 0;
                    while (n7 < this.values.size()) {
                        object = (String)this.values.get(n7);
                        Integer.parseInt((String)object);
                        ++n7;
                    }
                    break;
                }
                case 13: {
                    int n8 = 0;
                    while (n8 < this.values.size()) {
                        object = (String)this.values.get(n8);
                        Long.parseLong((String)object);
                        ++n8;
                    }
                    break;
                }
                case 11: {
                    n = 0;
                    while (n < this.values.size()) {
                        object = (String)this.values.get(n);
                        Short.parseShort((String)object);
                        ++n;
                    }
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray3 = new Object[]{object, this.getType(), this.getName()};
            EventValidation.throwValidationException(CLASS_NAME, "LOG_INVALID_TYPE_CONVERSION_EXC_", objectArray3);
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                if (this.isXsdDateTime(string2)) break;
                Object[] objectArray4 = new Object[]{this.getName(), this.getType(), string2};
                EventValidation.throwValidationException(CLASS_NAME, "LOG_EXTENDED_DATA_INVALID_DATE_EXC_", objectArray4);
                break;
            }
            case 9: {
                if (this.isXsdBoolean(string2)) break;
                Object[] objectArray5 = new Object[]{this.getName(), this.getType(), string2};
                EventValidation.throwValidationException(CLASS_NAME, "LOG_EXTENDED_DATA_INVALID_BOOLEAN_EXC_", objectArray5);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                this.values = this.getValues();
                int n9 = 0;
                while (n9 < this.values.size()) {
                    object = (String)this.values.get(n9);
                    if (!this.isXsdDateTime((String)object)) {
                        Object[] objectArray6 = new Object[]{this.getName(), this.getType(), object};
                        EventValidation.throwValidationException(CLASS_NAME, "LOG_EXTENDED_DATA_INVALID_DATE_EXC_", objectArray6);
                    }
                    ++n9;
                }
                break;
            }
            case 18: {
                this.values = this.getValues();
                int n10 = 0;
                while (n10 < this.values.size()) {
                    String string3 = (String)this.values.get(n10);
                    if (!this.isXsdBoolean(string3)) {
                        Object[] objectArray7 = new Object[]{this.getName(), this.getType(), string3};
                        EventValidation.throwValidationException(CLASS_NAME, "LOG_EXTENDED_DATA_INVALID_BOOLEAN_EXC_", objectArray7);
                    }
                    ++n10;
                }
                break;
            }
            case 19: {
                String string4 = this.getHexValue();
                if (string4 == null) break;
                this.validateHexBinary(string4);
                break;
            }
        }
        EList eList = this.getChildren();
        n = 0;
        while (n < eList.size()) {
            ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(n);
            extendedDataElement.validate();
            ++n;
        }
    }

    protected void setValues(String string) {
        EList eList = this.resetValues();
        eList.add((Object)string);
    }

    protected void setValuesArray(String[] stringArray) {
        EList eList = this.resetValues();
        eList.addAll(Arrays.asList(stringArray));
    }

    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getExtendedDataElement();
    }

    protected EList resetValues() {
        this.clearValues();
        return this.getValues();
    }

    public void clearValues() {
        this.getValues().clear();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        EventHelpers.serializableRead(this, objectInputStream);
    }

    private boolean isXsdBoolean(String string) {
        return string.equals("true") || string.equals("false") || string.equals("1") || string.equals("0");
    }

    private boolean isXsdDateTime(String string) {
        boolean bl = true;
        long l = 0L;
        try {
            l = EventHelpers.dateToLong(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    private void validateEListAsStringLength(EStructuralFeature eStructuralFeature, int n) throws ValidationException {
        EList eList = (EList)this.eGet(eStructuralFeature);
        if (eList != null) {
            ListIterator listIterator = eList.listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                int n2 = 0;
                if (string == null || (n2 = string.length()) <= n) continue;
                Object[] objectArray = new Object[]{string, EventValidation.getComponentName(this, eStructuralFeature.getName()), new Integer(n)};
                EventValidation.throwValidationException(CLASS_NAME, "LOG_INVALID_LIST_ELEMENT_LENGTH_EXC_", objectArray);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        EventHelpers.serializableWrite(this, objectOutputStream);
    }

    private String byteArrayToHexBinary(byte[] byArray) {
        String string = null;
        if (byArray != null) {
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
            int n = 0;
            while (n < byArray.length) {
                stringBuffer.append(HEX_BASE_CHARS[(byArray[n] & 0xF0) >> 4]);
                stringBuffer.append(HEX_BASE_CHARS[byArray[n] & 0xF]);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private byte[] hexBinaryToByteArray(String string) throws IllegalStateException {
        byte[] byArray = null;
        if (string != null) {
            int n = string.length();
            if (n % 2 == 1) {
                throw new IllegalArgumentException("inHexData must have an even length");
            }
            byArray = new byte[n / 2];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3 / 2;
                int n5 = 0;
                while (n5 < 2) {
                    char c = string.charAt(n3 + n5);
                    switch (Character.toUpperCase(c)) {
                        case '0': {
                            n2 = 0;
                            break;
                        }
                        case '1': {
                            n2 = 1;
                            break;
                        }
                        case '2': {
                            n2 = 2;
                            break;
                        }
                        case '3': {
                            n2 = 3;
                            break;
                        }
                        case '4': {
                            n2 = 4;
                            break;
                        }
                        case '5': {
                            n2 = 5;
                            break;
                        }
                        case '6': {
                            n2 = 6;
                            break;
                        }
                        case '7': {
                            n2 = 7;
                            break;
                        }
                        case '8': {
                            n2 = 8;
                            break;
                        }
                        case '9': {
                            n2 = 9;
                            break;
                        }
                        case 'A': {
                            n2 = 10;
                            break;
                        }
                        case 'B': {
                            n2 = 11;
                            break;
                        }
                        case 'C': {
                            n2 = 12;
                            break;
                        }
                        case 'D': {
                            n2 = 13;
                            break;
                        }
                        case 'E': {
                            n2 = 14;
                            break;
                        }
                        case 'F': {
                            n2 = 15;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("string is not a valid hexBinary");
                        }
                    }
                    if (n5 == 0) {
                        byArray[n4] = (byte)(n2 << 4);
                    } else {
                        int n6 = n4;
                        byArray[n6] = (byte)(byArray[n6] + n2);
                    }
                    ++n5;
                }
                n3 += 2;
            }
        }
        return byArray;
    }

    private void validateHexBinary(String string) throws ValidationException {
        if (string.length() % 2 != 0) {
            Object[] objectArray = new Object[]{this.getName(), this.getType(), string};
            EventValidation.throwValidationException(CLASS_NAME, "LOG_EXTENDED_DATA_INVALID_HEX_BINARY_1_EXC_", objectArray);
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            c = Character.toUpperCase(c);
            boolean bl = false;
            int n2 = 0;
            while (n2 < HEX_BASE_CHARS.length) {
                if (c == HEX_BASE_CHARS[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                Object[] objectArray = new Object[]{this.getName(), this.getType(), string, new Character(c)};
                EventValidation.throwValidationException(CLASS_NAME, "LOG_EXTENDED_DATA_INVALID_HEX_BINARY_2_EXC_", objectArray);
            }
            ++n;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return EcoreUtil.copy((EObject)this);
    }

    public void init() {
        this.setHexValue(HEX_VALUE_EDEFAULT);
        this.setName(NAME_EDEFAULT);
        this.setType(TYPE_EDEFAULT);
        this.clearValues();
        this.clearChildren();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

