package httpRecorder.proxy;

/*
 * Disclaimer:
 * The following source code is sample code created by IBM Corporation. 
 * This sample code is not part of any standard IBM product and is provided 
 * to you solely for the purpose of assisting you in the development of your 
 * applications. The code is provided 'AS IS', without warranty or condition 
 * of any kind. IBM shall not be liable for any damages arising out of your 
 * use of the sample code, even if IBM has been advised of the possibility of 
 * such damages.
 */

/**
 * Implementors of this interface may be registered to the HttpProxy in order to 
 * receive event notifications such as the start of the proxy and the process of a HTTP
 * request.
 */
public interface IHttpProxyMonitor
{
	/**
	 * This method id invoked when the proxy is up to start monitoring the communication
	 * between the client and the server
	 */
	public void started(HttpProxy proxy);
	
	/**
	 * This method id invoked when the proxy is not listening to the communication
	 * between the client and the server
	 */	
	public void stopped(HttpProxy proxy);
	
	/**
	 * This method is invoked when an exception is thrown during the proxy activity.
	 */
	public void handle(Exception e);
	
	/**
	 * This method is invoked immeadialy after a request from the client is 
	 * processed and before it is written to the server.
	 * 
	 * <br>If the return is false, the request won't be written to the server.
	 */
	public boolean handle(HttpRequest request);

	/**
	 * This method is invoked immeadialy after a response from the server is
	 * processed and before it is written to the client.
	 * 
	 * <br>If the return is false, the response won't be written to the client.
	 */
	public boolean handle(HttpResponse response);
}
