/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.List;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraphSource;

public class SDTextObservationGraphSource
implements EnumerationGraphSource {
    SDTextObservation sdc;
    List times;
    List values;

    public SDTextObservationGraphSource(SDTextObservation sDTextObservation) {
        this.sdc = sDTextObservation;
        this.times = sDTextObservation.getCreationTime();
        this.values = sDTextObservation.getTextValue();
    }

    public int bchopGetIndex(double d) {
        int n = 0;
        int n2 = this.times.size() - 1;
        double d2 = ((Number)this.times.get(n)).doubleValue();
        double d3 = ((Number)this.times.get(n2)).doubleValue();
        if (d >= d3) {
            return this.times.size() - 1;
        }
        if (d <= d2) {
            return 0;
        }
        return this.bchopGetIndex(n, n2, d);
    }

    private int bchopGetIndex(int n, int n2, double d) {
        while (true) {
            if (n2 - n < 10) {
                int n3 = n;
                while (n3 <= n2) {
                    Number number = (Number)this.times.get(n3);
                    if (number.doubleValue() > d) {
                        if (--n3 < 0) {
                            return 0;
                        }
                        if (n3 >= this.times.size()) {
                            return this.times.size() - 1;
                        }
                        return n3;
                    }
                    ++n3;
                }
                return n2;
            }
            double d2 = ((Number)this.times.get(n)).doubleValue();
            double d3 = ((Number)this.times.get(n2)).doubleValue();
            double d4 = (d - d2) / (d3 - d2);
            d4 *= (double)(n2 - n - 2);
            double d5 = ((Number)this.times.get((int)(d4 = d4 + (double)n + 1.0))).doubleValue();
            if (d5 == d) {
                return (int)d4;
            }
            if (d5 > d) {
                n2 = (int)d4;
                continue;
            }
            n = (int)d4;
        }
    }

    public Object getValueAt(double d) {
        if (this.times == null) {
            return null;
        }
        if (this.times.size() == 0) {
            return null;
        }
        int n = this.bchopGetIndex(d);
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Text Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        String string = (String)this.values.get(n);
        return string;
    }

    public double getMin() {
        if (this.times == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.times.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        Number number = (Number)this.times.get(0);
        return number.doubleValue();
    }

    public double getMax() {
        if (this.times == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.times.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        Number number = (Number)this.times.get(this.times.size() - 1);
        return number.doubleValue();
    }
}

