/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.variableloader.internal;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDGenericVariable;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableModifierProxy;
import org.eclipse.swt.graphics.Image;

public class SDModifiableVariable
extends SDGenericVariable
implements SDModifiableVariableRepresentation {
    public static final int NONE = -1;
    public static final int INTEGER = 0;
    public static final int LONG = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int STRING = 4;
    Object value = null;
    int measured_type = -1;
    int modifier_type = -1;
    StatisticalFactory factory = StatisticalFactory.eINSTANCE;
    SDMemberDescriptor descriptor;
    SDVariableModifierProxy modifier;
    SDCounterDescriptor measured_desc;
    SDCounterDescriptor requested_desc;
    SDSnapshotObservation measured;
    SDSnapshotObservation requested;
    double min_bound = Double.MIN_VALUE;
    double max_bound = Double.MAX_VALUE;
    Object last_requested;
    long last_req_time;
    Object last_measured;
    long last_mes_time;
    String[] possibles;

    public int getMeasuredType() {
        return this.measured_type;
    }

    public int getModifierType() {
        return this.modifier_type;
    }

    public String[] getEnumerationValues() {
        return this.possibles;
    }

    public void setEnumerationValues(String[] stringArray) {
        this.possibles = stringArray;
    }

    SDModifiableVariable(String string, String string2, String string3, Image image, boolean bl, int n, int n2, SDMemberDescriptor sDMemberDescriptor, SDVariableModifierProxy sDVariableModifierProxy, double d, double d2, SDSampleWindow sDSampleWindow) {
        super(string, string2, string3, image, bl);
        this.measured_type = n;
        this.modifier_type = n2;
        this.descriptor = sDMemberDescriptor;
        this.modifier = sDVariableModifierProxy;
        this.min_bound = d;
        this.max_bound = d2;
        if (n == 4) {
            this.measured = this.factory.createSDTextObservation();
            this.last_measured = null;
        } else {
            this.measured = this.factory.createSDContiguousObservation();
            this.last_measured = null;
        }
        this.measured.setWindow(sDSampleWindow);
        if (n2 == 4) {
            this.requested = this.factory.createSDTextObservation();
            this.last_requested = null;
        } else {
            this.requested = this.factory.createSDContiguousObservation();
            this.last_requested = new Double(0.0);
        }
        this.requested.setWindow(sDSampleWindow);
        this.requested_desc = this.factory.createSDCounterDescriptor();
        this.requested_desc.setParent((SDDescriptor)sDMemberDescriptor);
        this.requested_desc.setName(string2 + " - Requested");
        this.requested_desc.setDescription(string3);
        this.measured_desc = this.factory.createSDCounterDescriptor();
        this.measured_desc.setParent((SDDescriptor)sDMemberDescriptor);
        this.measured_desc.setName(string2 + " - Measured");
        this.measured_desc.setDescription(string3);
        this.requested_desc.setRepresentation((SDRepresentation)this);
        this.requested.setMemberDescriptor((SDMemberDescriptor)this.requested_desc);
        this.measured.setMemberDescriptor((SDMemberDescriptor)this.measured_desc);
    }

    public Object getLastMeasuredValue() {
        return this.last_measured;
    }

    public long getLastMeasuredTime() {
        return this.last_mes_time;
    }

    public Object getLastRequestedValue() {
        return this.last_requested;
    }

    public long getLastRequestedTime() {
        return this.last_req_time;
    }

    public double getMaxBound() {
        return this.max_bound;
    }

    public double getMinBound() {
        return this.min_bound;
    }

    private void addRequestedValue(long l, Double d) throws ClassCastException {
        SDContiguousObservation sDContiguousObservation = (SDContiguousObservation)this.requested;
        BasicEList basicEList = (BasicEList)sDContiguousObservation.getCreationTime();
        BasicEList basicEList2 = (BasicEList)sDContiguousObservation.getValue();
        if (this.modifier_type == 0) {
            d = new Double(d.intValue());
        } else if (this.modifier_type == 1) {
            d = new Double(d.longValue());
        } else if (this.modifier_type == 2) {
            d = new Double(d.floatValue());
        }
        this.last_requested = d;
        this.last_req_time = l;
        this.addValue(basicEList, basicEList2, l, d);
    }

    private void addRequestedValue(long l, String string) throws ClassCastException {
        SDTextObservation sDTextObservation = (SDTextObservation)this.requested;
        BasicEList basicEList = (BasicEList)sDTextObservation.getCreationTime();
        BasicEList basicEList2 = (BasicEList)sDTextObservation.getTextValue();
        this.addValue(basicEList, basicEList2, l, string);
        this.last_requested = string;
        this.last_req_time = l;
    }

    private void addMeasuredValue(long l, Double d) throws ClassCastException {
        SDContiguousObservation sDContiguousObservation = (SDContiguousObservation)this.measured;
        BasicEList basicEList = (BasicEList)sDContiguousObservation.getCreationTime();
        BasicEList basicEList2 = (BasicEList)sDContiguousObservation.getValue();
        if (this.measured_type == 0) {
            d = new Double(d.intValue());
        } else if (this.measured_type == 1) {
            d = new Double(d.longValue());
        } else if (this.measured_type == 2) {
            d = new Double(d.floatValue());
        }
        this.addValue(basicEList, basicEList2, l, d);
        this.last_measured = d;
        this.last_mes_time = l;
    }

    private void addMeasuredValue(long l, String string) throws ClassCastException {
        SDTextObservation sDTextObservation = (SDTextObservation)this.measured;
        BasicEList basicEList = (BasicEList)sDTextObservation.getCreationTime();
        BasicEList basicEList2 = (BasicEList)sDTextObservation.getTextValue();
        this.addValue(basicEList, basicEList2, l, string);
        this.last_measured = string;
        this.last_mes_time = l;
    }

    public void padRequestedValue(long l) throws ClassCastException {
        if (this.last_requested != null) {
            if (this.last_requested instanceof Double) {
                this.addRequestedValue(l, (Double)this.last_requested);
            } else {
                this.addRequestedValue(l, (String)this.last_requested);
            }
        }
    }

    public void padRequestedValue(long l, Object object) throws ClassCastException {
        if (object != null) {
            if (object instanceof Number) {
                this.addRequestedValue(l, new Double(((Number)this.last_requested).doubleValue()));
            } else {
                this.addRequestedValue(l, (String)object);
            }
        }
    }

    public void setRequestedValue(long l, int n) throws ClassCastException {
        this.addRequestedValue(l, new Double(n));
        this.modifier.requestValue(this.uid, n);
    }

    public void setRequestedValue(long l, long l2) throws ClassCastException {
        this.addRequestedValue(l, new Double(l2));
        this.modifier.requestValue(this.uid, l2);
    }

    public void setRequestedValue(long l, float f) throws ClassCastException {
        this.addRequestedValue(l, new Double(f));
        this.modifier.requestValue(this.uid, f);
    }

    public void setRequestedValue(long l, double d) throws ClassCastException {
        this.addRequestedValue(l, new Double(d));
        this.modifier.requestValue(this.uid, d);
    }

    public void setRequestedValue(long l, Object object) throws ClassCastException {
        if (this.modifier_type == 4) {
            this.addRequestedValue(l, (String)object);
        } else {
            this.addRequestedValue(l, new Double(((Number)object).doubleValue()));
        }
        this.modifier.requestValue(this.uid, object);
    }

    public void setMeasuredValue(long l, int n) throws ClassCastException {
        this.addMeasuredValue(l, new Double(n));
    }

    public void setMeasuredValue(long l, long l2) throws ClassCastException {
        this.addMeasuredValue(l, new Double(l2));
    }

    public void setMeasuredValue(long l, float f) throws ClassCastException {
        this.addMeasuredValue(l, new Double(f));
    }

    public void setMeasuredValue(long l, double d) throws ClassCastException {
        this.addMeasuredValue(l, new Double(d));
    }

    public void setMeasuredValue(long l, Object object) throws ClassCastException {
        if (this.measured_type == 4) {
            this.addMeasuredValue(l, (String)object);
        } else {
            this.addMeasuredValue(l, new Double(((Number)object).doubleValue()));
        }
    }
}

