/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.variableloader.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDMeasuredVariable;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDMeasuredVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariable;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableModifierProxy;
import org.eclipse.swt.graphics.Image;

public class SDVariableLoader {
    StatisticalFactory factory = StatisticalFactory.eINSTANCE;
    SDDescriptor root;
    SDSampleWindow window;

    public SDVariableLoader(SDDescriptor sDDescriptor) {
        this.root = sDDescriptor;
        this.window = this.getOrCreateView(this.root.getAgent());
    }

    public SDVariableLoader(TRCAgent tRCAgent, String string) {
        this.root = this.factory.createSDDescriptor();
        this.root.setName(string);
        this.root.setAgent(tRCAgent);
        this.window = this.getOrCreateView(this.root.getAgent());
    }

    public SDDescriptor getModelRoot() {
        return this.root;
    }

    private SDSampleWindow getOrCreateView(TRCAgent tRCAgent) {
        SDView sDView = (SDView)tRCAgent.getView();
        if (sDView == null) {
            sDView = this.factory.createSDView();
            sDView.setAgent(tRCAgent);
            sDView.setName("view");
        }
        if (sDView.eContents().size() == 0) {
            SDSampleWindow sDSampleWindow = this.factory.createSDSampleWindow();
            sDSampleWindow.setView(sDView);
            return sDSampleWindow;
        }
        return (SDSampleWindow)sDView.eContents().get(0);
    }

    public SDMeasuredVariableRepresentation createSDMeasuredVariable(String string, String string2, String string3, Image image, boolean bl, int n, String string4, String string5) {
        SDMemberDescriptor sDMemberDescriptor = (SDMemberDescriptor)this.getDescriptor(string4, string5);
        if (sDMemberDescriptor == null) {
            sDMemberDescriptor = this.createMemberDescriptor(string4, string5);
        }
        SDMeasuredVariable sDMeasuredVariable = new SDMeasuredVariable(string, string2, string3, image, bl, n, sDMemberDescriptor, this.window);
        return sDMeasuredVariable;
    }

    public SDModifiableVariableRepresentation createSDModifiableVariable(String string, String string2, String string3, Image image, boolean bl, int n, int n2, String string4, String string5, SDVariableModifierProxy sDVariableModifierProxy, double d, double d2) {
        SDMemberDescriptor sDMemberDescriptor = (SDMemberDescriptor)this.getDescriptor(string4, string5);
        if (sDMemberDescriptor == null) {
            sDMemberDescriptor = this.createMemberDescriptor(string4, string5);
        }
        SDModifiableVariable sDModifiableVariable = new SDModifiableVariable(string, string2, string3, image, bl, n, n2, sDMemberDescriptor, sDVariableModifierProxy, d, d2, this.window);
        return sDModifiableVariable;
    }

    private SDDescriptor getDescriptor(String string, String string2) {
        return this.getDescriptor(this.root, string, string2, this.root.getName().equals(string2));
    }

    private SDDescriptor getDescriptor(SDDescriptor sDDescriptor, String string, String string2, boolean bl) {
        EList eList = sDDescriptor.getChildren();
        int n = 0;
        while (n < eList.size()) {
            SDDescriptor sDDescriptor2 = (SDDescriptor)eList.get(n);
            String string3 = sDDescriptor2.getName();
            if (bl && sDDescriptor2.getName().equals(string)) {
                return sDDescriptor2;
            }
            if ((sDDescriptor2 = this.getDescriptor(sDDescriptor2, string, string2, sDDescriptor2.getName().equals(string2))) != null) {
                return sDDescriptor2;
            }
            ++n;
        }
        return null;
    }

    private SDMemberDescriptor createMemberDescriptor(String string, String string2) {
        SDMemberDescriptor sDMemberDescriptor = this.createMemberDescriptor(this.root, string, string2);
        if (sDMemberDescriptor == null) {
            SDCounterDescriptor sDCounterDescriptor = this.factory.createSDCounterDescriptor();
            sDCounterDescriptor.setParent(this.root);
            sDCounterDescriptor.setName(string2);
            SDCounterDescriptor sDCounterDescriptor2 = this.factory.createSDCounterDescriptor();
            sDCounterDescriptor2.setParent((SDDescriptor)sDCounterDescriptor);
            sDCounterDescriptor2.setName(string);
            return sDCounterDescriptor2;
        }
        return sDMemberDescriptor;
    }

    private SDMemberDescriptor createMemberDescriptor(SDDescriptor sDDescriptor, String string, String string2) {
        if (sDDescriptor.getName().equals(string2)) {
            SDCounterDescriptor sDCounterDescriptor = this.factory.createSDCounterDescriptor();
            sDCounterDescriptor.setParent(sDDescriptor);
            sDCounterDescriptor.setName(string);
            return sDCounterDescriptor;
        }
        EList eList = sDDescriptor.getChildren();
        int n = 0;
        while (n < eList.size()) {
            SDDescriptor sDDescriptor2 = (SDDescriptor)eList.get(n);
            SDMemberDescriptor sDMemberDescriptor = this.createMemberDescriptor(sDDescriptor2, string, string2);
            if (sDMemberDescriptor != null) {
                return sDMemberDescriptor;
            }
            ++n;
        }
        return null;
    }
}

