/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorSource;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class HistogramGraph
implements Graph {
    GraphSource source;
    ZoomSlider yslider;
    TimeZoomSlider xslider;
    Color fg_col;
    int line_width = 1;
    int line_style = 1;
    double scaling = 1.0;

    public HistogramGraph(GraphSource graphSource, TimeZoomSlider timeZoomSlider, ZoomSlider zoomSlider, Color color) {
        this.source = graphSource;
        this.fg_col = color;
        this.xslider = timeZoomSlider;
        this.yslider = zoomSlider;
    }

    public BasicGraphSource getGraphSource() {
        return this.source;
    }

    public void setIndicatorSource(IndicatorSource indicatorSource) {
    }

    public double getXMin() {
        return this.source.getMin();
    }

    public double getXMax() {
        return this.source.getMax();
    }

    public double getYMin() {
        return this.source.getValueMin();
    }

    public double getYMax() {
        return this.source.getValueMax();
    }

    public void setForeground(Color color) {
        this.fg_col = color;
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int n) {
        this.line_width = n;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int n) {
        this.line_style = n;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void setUseIndicator(boolean bl) {
    }

    public void paintGraph(GC gC, int n, int n2, int n3, int n4) {
        gC.setForeground(this.fg_col);
        gC.setLineWidth(this.line_width);
        gC.setLineStyle(this.line_style);
        double d = this.xslider.getMinVisible();
        double d2 = this.xslider.getMaxVisible();
        double d3 = this.xslider.getIncrement();
        int n5 = (int)this.yslider.value2Pixel(0.0);
        double d4 = d;
        while (d4 <= d2) {
            double d5 = d4;
            double d6 = this.source.getValueAt(d5);
            if (Double.isNaN(d6) || Double.isInfinite(d6)) {
                d6 = 0.0;
            }
            double d7 = this.xslider.value2Pixel(d5);
            double d8 = this.yslider.value2Pixel(d6 *= this.scaling);
            gC.drawLine((int)d7, n5, (int)d7, (int)d8);
            d4 += d3;
        }
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider timeZoomSlider) {
        this.xslider = timeZoomSlider;
    }

    public void setYSlider(ZoomSlider zoomSlider) {
        this.yslider = zoomSlider;
    }

    public void setStaticScaling(double d) {
        this.scaling = d;
    }

    public double getStaticScaling() {
        return this.scaling;
    }
}

