/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class MessagePanel
extends Composite
implements SelectionListener {
    Object msg_lock = new Object();
    StringBuffer buffer = new StringBuffer();
    boolean cleared = false;
    boolean locked = false;
    Button lock;
    Button save;
    Button clear;
    Text msg_text;

    public MessagePanel(Composite composite, int n) {
        super(composite, n);
        this.init();
        this.initEventHandling();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData gridData = new GridData();
        this.setLayout((Layout)gridLayout);
        this.lock = new Button((Composite)this, 0x1000002);
        this.lock.setImage(EditorPlugin.img.getImage("lock.gif"));
        this.msg_text = new Text((Composite)this, 2634);
        this.save = new Button((Composite)this, 0x1000008);
        this.save.setImage(EditorPlugin.img.getImage("save.gif"));
        this.lock.setLayoutData((Object)this.getButtonLayout());
        this.lock.setToolTipText(EditorPlugin.getString("LOCK_TOOLTIP"));
        this.save.setLayoutData((Object)this.getButtonLayout());
        this.save.setToolTipText(EditorPlugin.getString("SAVE_TOOLTIP"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 4;
        this.msg_text.setLayoutData((Object)gridData);
    }

    private void initEventHandling() {
        this.lock.addSelectionListener((SelectionListener)this);
        this.save.addSelectionListener((SelectionListener)this);
    }

    private GridData getButtonLayout() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 21;
        gridData.heightHint = 21;
        return gridData;
    }

    public String getMsgText() {
        return this.msg_text.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMsgText(String string) {
        Object object = this.msg_lock;
        synchronized (object) {
            if (this.locked) {
                this.buffer.setLength(0);
                this.buffer.append(string);
                this.cleared = true;
            } else {
                this.msg_text.setText(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMsgText(String string) {
        Object object = this.msg_lock;
        synchronized (object) {
            if (this.locked) {
                this.buffer.append(string);
            } else {
                this.msg_text.append(string);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetSelected(SelectionEvent selectionEvent) {
        block12: {
            if (selectionEvent.getSource() == this.lock) {
                Object object = this.msg_lock;
                synchronized (object) {
                    this.locked = this.lock.getSelection();
                    if (!this.locked) {
                        if (this.cleared) {
                            this.msg_text.setText(this.buffer.toString());
                        } else {
                            this.msg_text.append(this.buffer.toString());
                        }
                        this.cleared = false;
                    }
                    this.buffer.setLength(0);
                }
            }
            if (selectionEvent.getSource() != this.save) break block12;
            SaveAsDialog saveAsDialog = new SaveAsDialog(this.getShell());
            saveAsDialog.setTitle(EditorPlugin.getString("SAVE_LOG_TITLE"));
            saveAsDialog.open();
            IPath iPath = saveAsDialog.getResult();
            if (iPath != null) {
                try {
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile iFile = iWorkspaceRoot.getFile(iPath);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.msg_text.getText().getBytes());
                    try {
                        iFile.setContents((InputStream)byteArrayInputStream, true, false, null);
                    }
                    catch (Exception exception) {
                        iFile.create((InputStream)byteArrayInputStream, true, null);
                    }
                }
                catch (Throwable throwable) {
                    MessageBox messageBox = new MessageBox(this.getShell(), 32);
                    messageBox.setText(EditorPlugin.getString("SAVE_LOG_FAILED_TITLE"));
                    messageBox.setMessage(EditorPlugin.getString("SAVE_LOG_FAILED_MSG"));
                    messageBox.open();
                    EditorPlugin.DBG.logVisibleError(throwable, EditorPlugin.getString("ERROR_SAVE_MESSAGE_LOG"), false);
                    EditorPlugin.DBG.error("error saving message log", throwable);
                }
            }
        }
    }
}

