/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class BaseImageManager {
    private URL iconBaseURL;
    private ImageRegistry imageRegistry;
    private boolean loaded = false;

    protected void addImages() {
    }

    public void initialize(URL uRL, ImageRegistry imageRegistry) {
        this.iconBaseURL = uRL;
        this.imageRegistry = imageRegistry;
    }

    private void loadImages() {
        if (!this.loaded) {
            this.addImages();
            this.loaded = true;
        }
    }

    protected void add(String string, String string2) {
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = ImageDescriptor.createFromURL((URL)this.makeIconFileURL(string, string2));
        }
        catch (MalformedURLException malformedURLException) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if (imageDescriptor != null) {
            if (this.imageRegistry == null) {
                EditorPlugin.DBG.error("IMAGE REGISTRY IS NULL!", new Throwable("null image registry"));
            }
            this.imageRegistry.put(string2, imageDescriptor);
        } else {
            EditorPlugin.DBG.error("Image " + string + " " + string2 + " NOT FOUND!");
        }
    }

    private URL makeIconFileURL(String string, String string2) throws MalformedURLException {
        if (this.iconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('/');
        stringBuffer.append(string2);
        return new URL(this.iconBaseURL, stringBuffer.toString());
    }

    public ImageDescriptor getImageDescriptor(String string) {
        this.loadImages();
        return this.imageRegistry.getDescriptor(string);
    }

    public Image getImage(String string) {
        this.loadImages();
        return this.imageRegistry.get(string);
    }
}

