/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.spinner.internal;

import java.text.DecimalFormat;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class Spinner
extends Composite
implements FocusListener,
SelectionListener {
    Text text;
    Composite buttons;
    Button up;
    Button down;
    double last_good_value = 0.0;
    double min = 0.0;
    double max = 100.0;
    double increment = 1.0;
    double decimals = 0.0;
    DecimalFormat dformat;

    public Spinner(Composite composite, int n) {
        super(composite, n);
        this.init();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.validateText();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.validateText();
    }

    public void configure(int n, double d, double d2, double d3) {
        this.min = d;
        this.max = d2;
        this.increment = d3;
        this.last_good_value = d;
        StringBuffer stringBuffer = new StringBuffer("#");
        if (n > 0) {
            stringBuffer.append(".");
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("0");
            ++n2;
        }
        this.dformat = new DecimalFormat(stringBuffer.toString());
    }

    public double getValue() {
        try {
            double d = Double.parseDouble(this.text.getText());
            return this.validate(d);
        }
        catch (Exception exception) {
            return this.last_good_value;
        }
    }

    private void validateText() {
        try {
            double d = Double.parseDouble(this.text.getText());
            this.setValue(this.validate(d));
        }
        catch (Exception exception) {
            this.setValue(this.last_good_value);
        }
    }

    private double validate(double d) {
        if (d < this.min) {
            d = this.min;
        }
        if (d > this.max) {
            d = this.max;
        }
        double d2 = d % this.increment;
        d -= d2;
        if (d2 > this.increment / 2.0) {
            d += this.increment;
        }
        return d;
    }

    public void setValue(double d) {
        this.last_good_value = this.validate(d);
        this.text.setText(this.dformat.format(this.last_good_value));
    }

    private void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.text = new Text((Composite)this, 2052);
        this.text.setLayoutData((Object)GData.getGridData(true, true, -1, 16, 1, 1, 4, 4));
        this.buttons = new Composite((Composite)this, 0);
        this.buttons.setLayoutData((Object)GData.getGridData(false, true, -1, 16, 1, 1, 4, 4));
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        this.buttons.setLayout((Layout)fillLayout);
        this.up = new Button(this.buttons, 8);
        this.up.setImage(EditorPlugin.img.getImage("up.gif"));
        this.down = new Button(this.buttons, 8);
        this.down.setImage(EditorPlugin.img.getImage("down.gif"));
        this.text.setText("0");
        this.text.addFocusListener((FocusListener)this);
        this.up.addSelectionListener((SelectionListener)this);
        this.down.addSelectionListener((SelectionListener)this);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource() == this.up) {
            double d = this.getValue();
            if ((d += this.increment) > this.max) {
                d = this.min;
            }
            this.setValue(d);
        } else if (selectionEvent.getSource() == this.down) {
            double d = this.getValue();
            if ((d -= this.increment) < this.min) {
                d = this.max;
            }
            this.setValue(d);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }
}

