/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class ZoomIndicator {
    ZoomSlider slider = null;
    double value;
    double oldValue;
    Color color;
    Color xorColor;

    public ZoomIndicator(ZoomSlider zoomSlider) {
        this.slider = zoomSlider;
        this.setColor(zoomSlider.getDisplay().getSystemColor(22));
        this.setValue(zoomSlider.getMinLimit());
        zoomSlider.addZoomIndicator(this);
    }

    public ZoomIndicator(ZoomSlider zoomSlider, double d) {
        this(zoomSlider);
        this.setValue(d);
        zoomSlider.redraw();
    }

    public ZoomIndicator(ZoomSlider zoomSlider, Color color) {
        this(zoomSlider);
        this.setColor(color);
        zoomSlider.redraw();
    }

    public ZoomIndicator(ZoomSlider zoomSlider, double d, Color color) {
        this(zoomSlider, d);
        this.setColor(color);
        zoomSlider.redraw();
    }

    public void setZoomSlider(ZoomSlider zoomSlider) {
        this.slider = zoomSlider;
    }

    public ZoomSlider getZoomSlider() {
        return this.slider;
    }

    public void setValue(double d) {
        this.oldValue = this.value;
        if (d > this.slider.getMaxLimit()) {
            d = this.slider.getMaxLimit();
        }
        if (d < this.slider.getMinLimit()) {
            d = this.slider.getMinLimit();
        }
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    public void setColor(Color color) {
        this.color = color;
        this.setXORColor();
    }

    public Color getColor() {
        return this.color;
    }

    public void paint(GC gC, Image image, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        n3 = (int)this.slider.value2Pixel(this.value);
        n4 = (int)this.slider.value2Pixel(0.0);
        int n5 = this.slider.getOrientation();
        int n6 = this.slider.getDirection();
        int n7 = this.slider.getBounds().height;
        int n8 = this.slider.getBounds().width;
        if (image == null) {
            if (gC == null) {
                EditorPlugin.DBG.warning("indicator - graphics null");
            }
            gC.setBackground(this.xorColor);
            gC.setXORMode(true);
            if (n5 == 0) {
                if (n6 == 1) {
                    gC.fillRectangle(n, n3, n2, Math.abs(n3 - n4));
                } else {
                    gC.fillRectangle(n, n4, n2, Math.abs(n3 - n4));
                }
            } else if (n6 == 1) {
                gC.fillRectangle(n3, n, Math.abs(n3 - n4), n2);
            } else {
                gC.fillRectangle(n4, n, Math.abs(n3 - n4), n2);
            }
            gC.setXORMode(false);
        } else if (this.value != this.oldValue) {
            if (n5 == 0) {
                gC.setClipping(n, 0, n2, n7);
            } else {
                gC.setClipping(0, n, n8, n2);
            }
            gC.drawImage(image, 0, 0);
            gC.setClipping(0, 0, n8, n7);
            gC.setBackground(this.xorColor);
            gC.setXORMode(true);
            if (n5 == 0) {
                if (n6 == 1) {
                    gC.fillRectangle(n, n3, n2, Math.abs(n3 - n4));
                } else {
                    gC.fillRectangle(n, n4, n2, Math.abs(n3 - n4));
                }
            } else if (n6 == 1) {
                gC.fillRectangle(n3, n, Math.abs(n3 - n4), n2);
            } else {
                gC.fillRectangle(n4, n, Math.abs(n3 - n4), n2);
            }
            gC.setXORMode(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setXORColor() {
        var1_1 = this.color.getRGB();
        var2_2 = this.slider.getBackground().getRGB();
        var3_3 = new String[]{Integer.toBinaryString(var1_1.red), Integer.toBinaryString(var1_1.green), Integer.toBinaryString(var1_1.blue)};
        var4_4 = new String[]{Integer.toBinaryString(var2_2.red), Integer.toBinaryString(var2_2.green), Integer.toBinaryString(var2_2.blue)};
        var5_5 = 0;
        ** GOTO lbl11
        {
            var3_3[var5_5] = "0" + var3_3[var5_5];
            do {
                if (var3_3[var5_5].length() < 8) continue block0;
                ++var5_5;
lbl11:
                // 2 sources

            } while (var5_5 < 3);
        }
        var6_6 = 0;
        ** GOTO lbl18
        {
            var4_4[var6_6] = "0" + var4_4[var6_6];
            do {
                if (var4_4[var6_6].length() < 8) continue block2;
                ++var6_6;
lbl18:
                // 2 sources

            } while (var6_6 < 3);
        }
        var7_7 = new StringBuffer[3];
        var8_8 = 0;
        while (var8_8 < 3) {
            var7_7[var8_8] = new StringBuffer();
            var9_9 = var3_3[var8_8].toCharArray();
            var10_10 = var4_4[var8_8].toCharArray();
            var11_11 = 0;
            while (var11_11 < var3_3[var8_8].length()) {
                var12_12 = 0;
                if (var9_9[var11_11] != var10_10[var11_11]) {
                    var12_12 = 1;
                }
                var7_7[var8_8].append(String.valueOf(var12_12));
                ++var11_11;
            }
            ++var8_8;
        }
        this.xorColor = new Color((Device)this.slider.getDisplay(), new RGB(Integer.parseInt(var7_7[0].toString(), 2), Integer.parseInt(var7_7[1].toString(), 2), Integer.parseInt(var7_7[2].toString(), 2)));
    }

    public void dispose() {
        if (this.xorColor != null) {
            this.xorColor.dispose();
        }
    }
}

