/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.ClassStatisticPage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ClassStatistic
extends StatisticView {
    private final TRCClassImpl.TRCClassSnapshot cdelta1 = new TRCClassImpl.TRCClassSnapshot();
    private final TRCClassImpl.TRCClassSnapshot cdelta2 = new TRCClassImpl.TRCClassSnapshot();
    private final TRCMethodImpl.TRCMethodSnapshot mdelta1 = new TRCMethodImpl.TRCMethodSnapshot();
    private final TRCMethodImpl.TRCMethodSnapshot mdelta2 = new TRCMethodImpl.TRCMethodSnapshot();

    protected Composite createTable(Composite composite, int n) {
        return new TableTree(composite, n);
    }

    public ClassStatistic(Composite composite, TraceViewerPage traceViewerPage) {
        super(composite, traceViewerPage);
        this._viewerFilter = new ClassStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return "Class60";
    }

    public String getDefaultColumnsTemplate() {
        String string = TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":0:" + String.valueOf(7) + ":200," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":1:" + String.valueOf(1) + ":left:100," + TraceUIPlugin.getString("STR_ST_INSTANCES") + ":2:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_INSTANCES") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_COLLECTED") + ":4:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_SIZE") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_STORAGE") + ":6:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":7:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_INHTIME") + ":8:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":9:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_INHTIME") + ":10:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":11:" + String.valueOf(16) + ":right:50," + TraceUIPlugin.getString("STR_ST_INHCALLS") + ":12:" + String.valueOf(16) + ":right:100";
        return string;
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite composite) {
        ClassTreeViewer classTreeViewer = new ClassTreeViewer((TableTree)composite);
        return classTreeViewer;
    }

    protected void handleSelectionEvent() {
        ((ClassStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(false);
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (iTraceSelection.size() > 0) {
            ((ClassStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(true);
            Object object = iTraceSelection.getFirstElement();
            if (object instanceof TRCObject) {
                object = PerftraceUtil.getClass((TRCObject)object);
            } else if (object instanceof TRCClass) {
                this.select((TRCClass)object);
            } else if (object instanceof TRCMethod) {
                this.select((TRCMethod)object);
            } else if (object instanceof TRCMethodInvocation) {
                this.select(((TRCMethodInvocation)object).getMethod());
            }
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getUpdateAction());
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    private void select(TRCMethod tRCMethod) {
        TRCClass tRCClass = tRCMethod.getDefiningClass();
        TableTree tableTree = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] tableTreeItemArray = tableTree.getItems();
        int n = 0;
        while (n < tableTreeItemArray.length) {
            TableTreeItem tableTreeItem = tableTreeItemArray[n];
            if (tableTreeItem.getData() == tRCClass) {
                ((ClassTreeViewer)this.getTableViewer()).expandItem(tableTreeItem);
                TableTreeItem[] tableTreeItemArray2 = tableTreeItem.getItems();
                int n2 = 0;
                while (n2 < tableTreeItemArray2.length) {
                    TableTreeItem tableTreeItem2 = tableTreeItemArray2[n2];
                    if (tRCMethod == tableTreeItem2.getData()) {
                        ((ClassTreeViewer)this.getTableViewer()).expandItem(tableTreeItem);
                        tableTree.setSelection(new TableTreeItem[]{tableTreeItem2});
                        return;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        tableTree.deselectAll();
    }

    private void select(TRCClass tRCClass) {
        TableTree tableTree = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] tableTreeItemArray = tableTree.getItems();
        int n = 0;
        while (n < tableTreeItemArray.length) {
            Object object = tableTreeItemArray[n].getData();
            if (object != null && object == tRCClass) {
                tableTree.setSelection(new TableTreeItem[]{tableTreeItemArray[n]});
                return;
            }
            ++n;
        }
        tableTree.deselectAll();
    }

    public void updateButtons() {
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        ((ClassStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(iTraceSelection.size() > 0);
        ((ClassStatisticPage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
        ((ClassStatisticPage)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
    }

    protected void updateDetailsPane() {
        int n = this.getTable().getSelectionIndex();
        if (n < 0) {
            return;
        }
        TableItem tableItem = this.getTable().getItem(n);
        Object object = tableItem.getData();
        if (object == null) {
            return;
        }
        if (object != null && object instanceof TableTreeItem) {
            object = ((TableTreeItem)object).getData();
        }
    }

    public void updateModelSelection() {
        ISelection iSelection = this.getTableViewer().getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            this.notifyViewSelectionChanged(this, object);
        }
    }

    public IContentProvider getContentProvider() {
        return new ClassStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ClassStatisticLabelProvider(this);
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn tableColumn = table.getColumn(0);
            this._viewerSorter = new ClassStatisticSorter();
            this.getViewerSorter().setSortedColumn(tableColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            this._totalInst = PerftraceUtil.getTotalInstances(this._page.getMOFObject());
            this._activeInst = PerftraceUtil.getActiveInstances(this._page.getMOFObject());
            this._totalSize = PerftraceUtil.getTotalSize(this._page.getMOFObject());
            this._activeSize = PerftraceUtil.getActiveSize(this._page.getMOFObject());
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
        this.handleSelectionEvent();
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        Object object = viewSelectionChangedEvent.getSource();
        if (object != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllClasses(this._page.getMOFObject()).length <= 0;
    }

    class ClassTreeViewer
    extends TableTreeViewer {
        public ClassTreeViewer(Composite composite) {
            super(composite);
        }

        public ClassTreeViewer(TableTree tableTree) {
            super(tableTree);
        }

        public void expandItem(TableTreeItem tableTreeItem) {
            tableTreeItem.setExpanded(true);
            this.createChildren((Widget)tableTreeItem);
        }
    }

    public class ClassStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ClassStatisticLabelProvider(StatisticView statisticView) {
            this._viewer = statisticView;
        }

        public Image getColumnImage(Object object, int n) {
            StatisticTableColumnInfo statisticTableColumnInfo = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n));
            int n2 = statisticTableColumnInfo.getColumnData().getInitalPos();
            if (statisticTableColumnInfo.isDeltaColumn()) {
                return null;
            }
            int n3 = 0;
            double d = 0.0;
            if (object instanceof TRCClass) {
                TRCClass tRCClass = (TRCClass)object;
                if (((TRCClass)object).computeDelta((IDelta)ClassStatistic.this.cdelta1, 14) < 0) {
                    if (n == 1) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                switch (n2) {
                    case 2: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        n3 = ClassStatistic.this.cdelta1.getTotalInstances();
                        break;
                    }
                    case 3: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        n3 = ClassStatistic.this.cdelta1.getTotalInstances() - ClassStatistic.this.cdelta1.getCollectedInstances();
                        break;
                    }
                    case 4: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        n3 = ClassStatistic.this.cdelta1.getCollectedInstances();
                        break;
                    }
                    case 5: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        n3 = ClassStatistic.this.cdelta1.getTotalSize();
                        break;
                    }
                    case 6: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 15);
                        n3 = ClassStatistic.this.cdelta1.getTotalSize() - ClassStatistic.this.cdelta1.getCollectedSize();
                        break;
                    }
                    case 7: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 7);
                        d = ClassStatistic.this.cdelta1.getBaseTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 8: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 11);
                        d = ClassStatistic.this.cdelta1.getInheritedBaseTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 9: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 8);
                        d = ClassStatistic.this.cdelta1.getCumulativeTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 10: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 12);
                        d = ClassStatistic.this.cdelta1.getInheritedCumulativeTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 11: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 9);
                        n3 = ClassStatistic.this.cdelta1.getCalls();
                        break;
                    }
                    case 12: {
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 10);
                        n3 = ClassStatistic.this.cdelta1.getInheritedCalls();
                    }
                }
            } else {
                TRCMethod tRCMethod = (TRCMethod)object;
                if (tRCMethod.computeDelta((IDelta)ClassStatistic.this.mdelta1, 6) < 0) {
                    if (n == 1) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                switch (n2) {
                    case 7: {
                        tRCMethod.computeDelta((IDelta)ClassStatistic.this.mdelta1, 6);
                        d = ClassStatistic.this.mdelta1.getBaseTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 9: {
                        tRCMethod.computeDelta((IDelta)ClassStatistic.this.mdelta1, 7);
                        d = ClassStatistic.this.mdelta1.getCumulativeTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 11: {
                        tRCMethod.computeDelta((IDelta)ClassStatistic.this.mdelta1, 8);
                        n3 = ClassStatistic.this.mdelta1.getCalls();
                    }
                }
            }
            if (n3 < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (n3 > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            StatisticTableColumnInfo statisticTableColumnInfo = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n));
            int n2 = statisticTableColumnInfo.getColumnData().getInitalPos();
            if (object instanceof TRCClass) {
                TRCClass tRCClass = (TRCClass)object;
                TRCClassImpl.TRCClassSnapshot tRCClassSnapshot = (TRCClassImpl.TRCClassSnapshot)tRCClass.retrieveSnapshot();
                switch (n2) {
                    case 0: {
                        return ((TRCClass)object).getName();
                    }
                    case 1: {
                        return PerftraceUtil.getPackageName(tRCClass.getPackage(), ClassStatistic.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return PerftraceUtil.formatAsPercentage((double)tRCClassSnapshot.getTotalInstances() / (double)ClassStatistic.this._totalInst);
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        return String.valueOf(ClassStatistic.this.cdelta1.getTotalInstances());
                    }
                    case 3: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot.getCollectedInstances()) / (double)ClassStatistic.this._totalInst));
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        return String.valueOf(ClassStatistic.this.cdelta1.getTotalInstances() - ClassStatistic.this.cdelta1.getCollectedInstances());
                    }
                    case 4: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                int n3 = tRCClassSnapshot.getTotalInstances();
                                if (n3 == 0) {
                                    n3 = 1;
                                }
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getCollectedInstances() / (double)n3));
                            }
                            return String.valueOf(tRCClassSnapshot.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        return String.valueOf(ClassStatistic.this.cdelta1.getCollectedInstances());
                    }
                    case 5: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getTotalSize() / (double)ClassStatistic.this._totalSize));
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalSize());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        return String.valueOf(ClassStatistic.this.cdelta1.getTotalSize());
                    }
                    case 6: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            long l = tRCClassSnapshot.getTotalSize() - tRCClassSnapshot.getCollectedSize();
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)l / (double)ClassStatistic.this._activeSize));
                            }
                            return String.valueOf(l);
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 15);
                        return String.valueOf(ClassStatistic.this.cdelta1.getTotalSize() - ClassStatistic.this.cdelta1.getCollectedSize());
                    }
                    case 7: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getBaseTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getBaseTime());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 7);
                        return TString.formatTimeValue((double)ClassStatistic.this.cdelta1.getBaseTime());
                    }
                    case 8: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getInheritedBaseTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getInheritedBaseTime());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 11);
                        return TString.formatTimeValue((double)ClassStatistic.this.cdelta1.getInheritedBaseTime());
                    }
                    case 9: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getCumulativeTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getCumulativeTime());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 8);
                        return TString.formatTimeValue((double)ClassStatistic.this.cdelta1.getCumulativeTime());
                    }
                    case 10: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getInheritedCumulativeTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getInheritedCumulativeTime());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 12);
                        return TString.formatTimeValue((double)ClassStatistic.this.cdelta1.getInheritedCumulativeTime());
                    }
                    case 11: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getCalls() / (double)ClassStatistic.this._totalCalls));
                            }
                            return String.valueOf(tRCClassSnapshot.getCalls());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 9);
                        return String.valueOf(ClassStatistic.this.cdelta1.getCalls());
                    }
                    case 12: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getInheritedCalls() / (double)ClassStatistic.this._totalCalls));
                            }
                            return String.valueOf(tRCClassSnapshot.getInheritedCalls());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 10);
                        return String.valueOf(ClassStatistic.this.cdelta1.getInheritedCalls());
                    }
                }
            } else {
                TRCMethod tRCMethod = (TRCMethod)object;
                TRCMethodImpl.TRCMethodSnapshot tRCMethodSnapshot = (TRCMethodImpl.TRCMethodSnapshot)tRCMethod.retrieveSnapshot();
                switch (n2) {
                    case 0: {
                        StringBuffer stringBuffer = new StringBuffer();
                        return stringBuffer.append(tRCMethod.getName()).append(tRCMethod.getSignature()).toString();
                    }
                    case 7: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCMethodSnapshot.getBaseTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCMethodSnapshot.getBaseTime());
                        }
                        tRCMethod.computeDelta((IDelta)ClassStatistic.this.mdelta1, 6);
                        return TString.formatTimeValue((double)ClassStatistic.this.mdelta1.getBaseTime());
                    }
                    case 9: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCMethodSnapshot.getCumulativeTime() / ClassStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCMethodSnapshot.getCumulativeTime());
                        }
                        tRCMethod.computeDelta((IDelta)ClassStatistic.this.mdelta1, 7);
                        return TString.formatTimeValue((double)ClassStatistic.this.mdelta1.getCumulativeTime());
                    }
                    case 11: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCMethodSnapshot.getCalls() / (double)ClassStatistic.this._totalCalls));
                            }
                            return String.valueOf(tRCMethodSnapshot.getCalls());
                        }
                        tRCMethod.computeDelta((IDelta)ClassStatistic.this.mdelta1, 8);
                        return String.valueOf(ClassStatistic.this.mdelta1.getCalls());
                    }
                }
            }
            return "";
        }
    }

    public class ClassStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object object) {
            if (object instanceof TRCMethod) {
                return ((TRCMethod)object).getDefiningClass();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            return PerftraceUtil.getAllClasses(ClassStatistic.this._page.getMOFObject());
        }

        public Object[] getChildren(Object object) {
            ClassStatistic.this.tmpList.clear();
            if (object instanceof TRCClass) {
                return ((TRCClass)object).getMethods().toArray();
            }
            return ClassStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object object) {
            if (object instanceof TRCClass) {
                return ((TRCClass)object).getMethods().size() > 0;
            }
            return false;
        }
    }

    public class ClassStatisticSorter
    extends StatisticView.StatisticSorter {
        public ClassStatisticSorter() {
            super(ClassStatistic.this);
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            double d = 0.0;
            if (object instanceof TRCClass) {
                TRCClass tRCClass = (TRCClass)object;
                TRCClass tRCClass2 = (TRCClass)object2;
                TRCClassImpl.TRCClassSnapshot tRCClassSnapshot = (TRCClassImpl.TRCClassSnapshot)tRCClass.retrieveSnapshot();
                TRCClassImpl.TRCClassSnapshot tRCClassSnapshot2 = (TRCClassImpl.TRCClassSnapshot)tRCClass2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * tRCClass.getName().compareToIgnoreCase(tRCClass2.getName());
                    }
                    case 1: {
                        return this._sortSequence * tRCClass.getPackage().getName().compareToIgnoreCase(tRCClass2.getPackage().getName());
                    }
                    case 2: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot2.getTotalInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 14);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getTotalInstances() - ClassStatistic.this.cdelta2.getTotalInstances());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot.getCollectedInstances() - tRCClassSnapshot2.getTotalInstances() + tRCClassSnapshot2.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 14);
                        tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 14);
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 16);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getTotalInstances() - ClassStatistic.this.cdelta1.getCollectedInstances() - (ClassStatistic.this.cdelta2.getTotalInstances() - ClassStatistic.this.cdelta2.getCollectedInstances()));
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            if (ClassStatistic.this.isShowPercent()) {
                                int n = tRCClassSnapshot.getTotalInstances();
                                if (n == 0) {
                                    n = 1;
                                }
                                double d2 = (double)tRCClassSnapshot.getCollectedInstances() / (double)n;
                                n = tRCClassSnapshot2.getTotalInstances();
                                if (n == 0) {
                                    n = 1;
                                }
                                return this._sortSequence * (int)((d2 -= (double)tRCClassSnapshot2.getCollectedInstances() / (double)n) * 10000.0);
                            }
                            return this._sortSequence * (tRCClassSnapshot.getCollectedInstances() - tRCClassSnapshot2.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 16);
                        tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 16);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getCollectedInstances() - ClassStatistic.this.cdelta2.getCollectedInstances());
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalSize() - tRCClassSnapshot2.getTotalSize());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 13);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getTotalSize() - ClassStatistic.this.cdelta2.getTotalSize());
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalSize() - tRCClassSnapshot.getCollectedSize() - tRCClassSnapshot2.getTotalSize() + tRCClassSnapshot2.getCollectedSize());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 13);
                        tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 13);
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 15);
                        tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 15);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getTotalSize() - ClassStatistic.this.cdelta1.getCollectedSize() - (ClassStatistic.this.cdelta2.getTotalSize() - ClassStatistic.this.cdelta2.getCollectedSize()));
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getBaseTime() - tRCClassSnapshot2.getBaseTime();
                        } else {
                            tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 7);
                            tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 7);
                            d = ClassStatistic.this.cdelta1.getBaseTime() - ClassStatistic.this.cdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getInheritedBaseTime() - tRCClassSnapshot2.getInheritedBaseTime();
                        } else {
                            tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 11);
                            tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 11);
                            d = ClassStatistic.this.cdelta1.getInheritedBaseTime() - ClassStatistic.this.cdelta2.getInheritedBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getCumulativeTime() - tRCClassSnapshot2.getCumulativeTime();
                        } else {
                            tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 8);
                            tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 8);
                            d = ClassStatistic.this.cdelta1.getCumulativeTime() - ClassStatistic.this.cdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 10: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getInheritedCumulativeTime() - tRCClassSnapshot2.getInheritedCumulativeTime();
                        } else {
                            tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 12);
                            tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 12);
                            d = ClassStatistic.this.cdelta1.getInheritedCumulativeTime() - ClassStatistic.this.cdelta2.getInheritedCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 11: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getCalls() - tRCClassSnapshot2.getCalls());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 9);
                        tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 9);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getCalls() - ClassStatistic.this.cdelta2.getCalls());
                    }
                    case 12: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getInheritedCalls() - tRCClassSnapshot2.getInheritedCalls());
                        }
                        tRCClass.computeDelta((IDelta)ClassStatistic.this.cdelta1, 10);
                        tRCClass2.computeDelta((IDelta)ClassStatistic.this.cdelta2, 10);
                        return this._sortSequence * (ClassStatistic.this.cdelta1.getInheritedCalls() - ClassStatistic.this.cdelta2.getInheritedCalls());
                    }
                }
            } else {
                TRCMethod tRCMethod = (TRCMethod)object;
                TRCMethod tRCMethod2 = (TRCMethod)object2;
                TRCMethodImpl.TRCMethodSnapshot tRCMethodSnapshot = (TRCMethodImpl.TRCMethodSnapshot)tRCMethod.retrieveSnapshot();
                TRCMethodImpl.TRCMethodSnapshot tRCMethodSnapshot2 = (TRCMethodImpl.TRCMethodSnapshot)tRCMethod2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        return this._sortSequence * stringBuffer.append(tRCMethod.getName()).append(tRCMethod.getSignature()).toString().compareToIgnoreCase(stringBuffer2.append(tRCMethod2.getName()).append(tRCMethod2.getSignature()).toString());
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCMethodSnapshot.getBaseTime() - tRCMethodSnapshot2.getBaseTime();
                        } else {
                            tRCMethod.computeDelta((IDelta)ClassStatistic.this.mdelta1, 6);
                            tRCMethod2.computeDelta((IDelta)ClassStatistic.this.mdelta2, 6);
                            d = ClassStatistic.this.mdelta1.getBaseTime() - ClassStatistic.this.mdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCMethodSnapshot.getCumulativeTime() - tRCMethodSnapshot2.getCumulativeTime();
                        } else {
                            tRCMethod.computeDelta((IDelta)ClassStatistic.this.mdelta1, 7);
                            tRCMethod2.computeDelta((IDelta)ClassStatistic.this.mdelta2, 7);
                            d = ClassStatistic.this.mdelta1.getCumulativeTime() - ClassStatistic.this.mdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 11: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCMethodSnapshot.getCalls() - tRCMethodSnapshot2.getCalls());
                        }
                        tRCMethod.computeDelta((IDelta)ClassStatistic.this.mdelta1, 8);
                        tRCMethod2.computeDelta((IDelta)ClassStatistic.this.mdelta2, 8);
                        return this._sortSequence * (ClassStatistic.this.mdelta1.getCalls() - ClassStatistic.this.mdelta2.getCalls());
                    }
                }
            }
            return 0;
        }
    }

    public class ClassStatisticFilter
    extends StatisticView.StatisticFilter {
        public ClassStatisticFilter() {
            super(ClassStatistic.this);
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = true;
            if (!(object2 instanceof TRCClass)) {
                return true;
            }
            String string = "";
            if (this._noPattern) {
                return true;
            }
            if (object2 instanceof TRCClass) {
                string = ((TRCClass)object2).getName();
            }
            if (!this._caseSensitive) {
                string = string.toLowerCase();
            }
            if (this._exactMatch) {
                return string.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                bl = string.startsWith(this._prefix);
            }
            if (bl && this._suffix != "") {
                bl = string.endsWith(this._suffix);
            }
            if (bl) {
                int n = 0;
                while (n < this._textList.size()) {
                    String string2 = (String)this._textList.get(n);
                    int n2 = string.lastIndexOf(string2);
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    string = string.substring(n2 + string2.length());
                    ++n;
                }
            }
            return bl;
        }
    }
}

