/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.MethodStatisticPage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MethodStatistic
extends StatisticView {
    private final TRCMethodImpl.TRCMethodSnapshot delta1 = new TRCMethodImpl.TRCMethodSnapshot();
    private final TRCMethodImpl.TRCMethodSnapshot delta2 = new TRCMethodImpl.TRCMethodSnapshot();

    public MethodStatistic(Composite composite, TraceViewerPage traceViewerPage) {
        super(composite, traceViewerPage);
        this._viewerFilter = new StatisticView.StatisticFilter(this);
    }

    public String getColumnsPreferencesKey() {
        return "M60";
    }

    public String getDefaultColumnsTemplate() {
        String string = TraceUIPlugin.getString("STR_ST_METHOD_NAME") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":1:" + String.valueOf(1) + ":left:200," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":2:0:left:200," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME_AVERAGE") + ":4:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":6:" + String.valueOf(17) + ":right:55";
        return string;
    }

    protected Composite createTable(Composite composite, int n) {
        return new Table(composite, n);
    }

    protected StructuredViewer createTableViewer(Composite composite) {
        return new TableViewer((Table)composite);
    }

    protected IContentProvider getContentProvider() {
        return new MethodStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new MethodStatisticLabelProvider(this);
    }

    public Table getTable() {
        return (Table)this.getTableViewer().getControl();
    }

    protected void handleSelectionEvent() {
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (iTraceSelection.size() > 0) {
            Object object = iTraceSelection.getFirstElement();
            if (object instanceof TRCMethodInvocation) {
                this.select(((TRCMethodInvocation)object).getMethod());
            }
            if (object instanceof TRCMethod) {
                this.select((TRCMethod)object);
            }
        }
    }

    private void select(TRCMethod tRCMethod) {
        Table table = this.getTable();
        int n = 0;
        while (n < table.getItemCount()) {
            Object object = table.getItem(n).getData();
            if (object == tRCMethod) {
                table.setSelection(n);
                this.setNewSelection();
                return;
            }
            ++n;
        }
        table.deselectAll();
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.getUpdateAction());
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    public void updateButtons() {
        ((MethodStatisticPage)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
        ((MethodStatisticPage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
    }

    public void updateModelSelection() {
        ISelection iSelection = this.getTableViewer().getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            this.notifyViewSelectionChanged(this, object);
        }
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn tableColumn = table.getColumn(0);
            this._viewerSorter = new MethodStatisticSorter();
            this.getViewerSorter().setSortedColumn(tableColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
        this.handleSelectionEvent();
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        Object object = viewSelectionChangedEvent.getSource();
        if (object != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        Object[] objectArray = PerftraceUtil.getAllClasses(this._page.getMOFObject());
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            n += ((TRCClass)objectArray[n2]).getMethods().size();
            ++n2;
        }
        return n <= 0;
    }

    public class MethodStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public MethodStatisticLabelProvider(StatisticView statisticView) {
            this._viewer = statisticView;
        }

        public Image getColumnImage(Object object, int n) {
            StatisticTableColumnInfo statisticTableColumnInfo = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n));
            int n2 = statisticTableColumnInfo.getColumnData().getInitalPos();
            if (statisticTableColumnInfo.isDeltaColumn()) {
                return null;
            }
            int n3 = 0;
            double d = 0.0;
            TRCMethod tRCMethod = (TRCMethod)object;
            if (tRCMethod.computeDelta((IDelta)MethodStatistic.this.delta1, 6) < 0) {
                if (n == 1) {
                    return TracePluginImages.getImage("newentry_obj.gif");
                }
                return null;
            }
            switch (n2) {
                case 3: {
                    tRCMethod.computeDelta((IDelta)MethodStatistic.this.delta1, 6);
                    d = MethodStatistic.this.delta1.getBaseTime();
                    if (d < 0.0) {
                        n3 = -1;
                        break;
                    }
                    if (!(d > 0.0)) break;
                    n3 = 1;
                    break;
                }
                case 4: {
                    n3 = 0;
                    break;
                }
                case 5: {
                    tRCMethod.computeDelta((IDelta)MethodStatistic.this.delta1, 7);
                    d = MethodStatistic.this.delta1.getCumulativeTime();
                    if (d < 0.0) {
                        n3 = -1;
                        break;
                    }
                    if (!(d > 0.0)) break;
                    n3 = 1;
                    break;
                }
                case 6: {
                    tRCMethod.computeDelta((IDelta)MethodStatistic.this.delta1, 8);
                    n3 = MethodStatistic.this.delta1.getCalls();
                }
            }
            if (n3 < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (n3 > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            StatisticTableColumnInfo statisticTableColumnInfo = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n));
            int n2 = statisticTableColumnInfo.getColumnData().getInitalPos();
            TRCMethod tRCMethod = (TRCMethod)object;
            TRCMethodImpl.TRCMethodSnapshot tRCMethodSnapshot = (TRCMethodImpl.TRCMethodSnapshot)tRCMethod.retrieveSnapshot();
            switch (n2) {
                case 0: {
                    StringBuffer stringBuffer = new StringBuffer();
                    return stringBuffer.append(tRCMethod.getName()).append(tRCMethod.getSignature()).toString();
                }
                case 1: {
                    return tRCMethod.getDefiningClass().getName();
                }
                case 2: {
                    return PerftraceUtil.getPackageName(tRCMethod.getDefiningClass().getPackage(), MethodStatistic.this._page.getMOFObject()).toString();
                }
                case 3: {
                    if (!statisticTableColumnInfo.isDeltaColumn()) {
                        if (MethodStatistic.this.isShowPercent()) {
                            return PerftraceUtil.formatAsPercentage(tRCMethodSnapshot.getBaseTime() / MethodStatistic.this._maxTime);
                        }
                        return TString.formatTimeValue((double)tRCMethodSnapshot.getBaseTime());
                    }
                    tRCMethod.computeDelta((IDelta)MethodStatistic.this.delta1, 6);
                    return TString.formatTimeValue((double)MethodStatistic.this.delta1.getBaseTime());
                }
                case 4: {
                    int n3 = tRCMethodSnapshot.getCalls();
                    if (n3 == 0) {
                        n3 = 1;
                    }
                    if (MethodStatistic.this.isShowPercent()) {
                        return TString.formatAsPercentage((double)(tRCMethodSnapshot.getBaseTime() / ((double)n3 * MethodStatistic.this._maxTime)));
                    }
                    return TString.formatTimeValue((double)(tRCMethodSnapshot.getBaseTime() / (double)n3));
                }
                case 5: {
                    if (!statisticTableColumnInfo.isDeltaColumn()) {
                        if (MethodStatistic.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)(tRCMethodSnapshot.getCumulativeTime() / MethodStatistic.this._maxTime));
                        }
                        return TString.formatTimeValue((double)tRCMethodSnapshot.getCumulativeTime());
                    }
                    tRCMethod.computeDelta((IDelta)MethodStatistic.this.delta1, 7);
                    return TString.formatTimeValue((double)MethodStatistic.this.delta1.getCumulativeTime());
                }
                case 6: {
                    if (!statisticTableColumnInfo.isDeltaColumn()) {
                        if (MethodStatistic.this.isShowPercent()) {
                            return TString.formatAsPercentage((double)((double)tRCMethodSnapshot.getCalls() / (double)MethodStatistic.this._totalCalls));
                        }
                        return String.valueOf(tRCMethodSnapshot.getCalls());
                    }
                    tRCMethod.computeDelta((IDelta)MethodStatistic.this.delta1, 8);
                    return String.valueOf(MethodStatistic.this.delta1.getCalls());
                }
            }
            return "";
        }
    }

    public class MethodStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object object) {
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = PerftraceUtil.getAllClasses(MethodStatistic.this._page.getMOFObject());
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < objectArray.length) {
                arrayList.addAll(((TRCClass)objectArray[n]).getMethods());
                ++n;
            }
            return arrayList.toArray();
        }

        public Object[] getChildren(Object object) {
            MethodStatistic.this.tmpList.clear();
            return MethodStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object object) {
            return false;
        }
    }

    public class MethodStatisticSorter
    extends StatisticView.StatisticSorter {
        public MethodStatisticSorter() {
            super(MethodStatistic.this);
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            double d = 0.0;
            if (object instanceof TRCMethod) {
                TRCMethod tRCMethod = (TRCMethod)object;
                TRCMethod tRCMethod2 = (TRCMethod)object2;
                TRCMethodImpl.TRCMethodSnapshot tRCMethodSnapshot = (TRCMethodImpl.TRCMethodSnapshot)tRCMethod.retrieveSnapshot();
                TRCMethodImpl.TRCMethodSnapshot tRCMethodSnapshot2 = (TRCMethodImpl.TRCMethodSnapshot)tRCMethod2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        StringBuffer stringBuffer = new StringBuffer();
                        StringBuffer stringBuffer2 = new StringBuffer();
                        return this._sortSequence * stringBuffer.append(tRCMethod.getName()).append(tRCMethod.getSignature()).toString().compareToIgnoreCase(stringBuffer2.append(tRCMethod2.getName()).append(tRCMethod2.getSignature()).toString());
                    }
                    case 1: {
                        return this._sortSequence * tRCMethod.getDefiningClass().getName().compareToIgnoreCase(tRCMethod2.getDefiningClass().getName());
                    }
                    case 2: {
                        return this._sortSequence * tRCMethod.getDefiningClass().getPackage().getName().compareToIgnoreCase(tRCMethod2.getDefiningClass().getPackage().getName());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCMethodSnapshot.getBaseTime() - tRCMethodSnapshot2.getBaseTime();
                        } else {
                            tRCMethod.computeDelta((IDelta)MethodStatistic.this.delta1, 6);
                            tRCMethod2.computeDelta((IDelta)MethodStatistic.this.delta2, 6);
                            d = MethodStatistic.this.delta1.getBaseTime() - MethodStatistic.this.delta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 4: {
                        int n;
                        int n2 = tRCMethodSnapshot.getCalls();
                        if (n2 == 0) {
                            n2 = 1;
                        }
                        if ((n = tRCMethodSnapshot2.getCalls()) == 0) {
                            n = 1;
                        }
                        if ((d = tRCMethodSnapshot.getBaseTime() / (double)n2 - tRCMethodSnapshot2.getBaseTime() / (double)n) < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCMethodSnapshot.getCumulativeTime() - tRCMethodSnapshot2.getCumulativeTime();
                        } else {
                            tRCMethod.computeDelta((IDelta)MethodStatistic.this.delta1, 7);
                            tRCMethod2.computeDelta((IDelta)MethodStatistic.this.delta2, 7);
                            d = MethodStatistic.this.delta1.getCumulativeTime() - MethodStatistic.this.delta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCMethodSnapshot.getCalls() - tRCMethodSnapshot2.getCalls());
                        }
                        tRCMethod.computeDelta((IDelta)MethodStatistic.this.delta1, 8);
                        tRCMethod2.computeDelta((IDelta)MethodStatistic.this.delta2, 8);
                        return this._sortSequence * (MethodStatistic.this.delta1.getCalls() - MethodStatistic.this.delta2.getCalls());
                    }
                }
            }
            return 0;
        }
    }
}

