/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.PackageStatisticPage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class PackageStatistic
extends StatisticView {
    private final TRCPackageImpl.TRCPackageSnapshot pdelta1 = new TRCPackageImpl.TRCPackageSnapshot();
    private final TRCPackageImpl.TRCPackageSnapshot pdelta2 = new TRCPackageImpl.TRCPackageSnapshot();
    private final TRCClassImpl.TRCClassSnapshot cdelta1 = new TRCClassImpl.TRCClassSnapshot();
    private final TRCClassImpl.TRCClassSnapshot cdelta2 = new TRCClassImpl.TRCClassSnapshot();

    protected Composite createTable(Composite composite, int n) {
        return new TableTree(composite, n);
    }

    public PackageStatistic(Composite composite, TraceViewerPage traceViewerPage) {
        super(composite, traceViewerPage);
        this._viewerFilter = new PackageStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return "Pack60";
    }

    public String getDefaultColumnsTemplate() {
        String string = TraceUIPlugin.getString("STR_ST_PACKAGE") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_INSTANCES") + ":1:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_INSTANCES") + ":2:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_COLLECTED") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_SIZE") + ":4:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_STORAGE") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":6:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_INHTIME") + ":7:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":8:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_INHTIME") + ":9:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":10:" + String.valueOf(16) + ":right:50," + TraceUIPlugin.getString("STR_ST_INHCALLS") + ":11:" + String.valueOf(16) + ":right:100";
        return string;
    }

    protected IContentProvider getContentProvider() {
        return new PackageStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new PackageStatisticLabelProvider(this);
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite composite) {
        PackageTreeViewer packageTreeViewer = new PackageTreeViewer((TableTree)composite);
        return packageTreeViewer;
    }

    protected void handleSelectionEvent() {
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (iTraceSelection.size() > 0) {
            Object object = iTraceSelection.getFirstElement();
            if (object instanceof TRCMethod) {
                object = ((TRCMethod)object).getDefiningClass();
            } else if (object instanceof TRCMethodInvocation) {
                object = ((TRCMethodInvocation)object).getMethod().getDefiningClass();
            }
            if (object instanceof TRCObject) {
                this.select(PerftraceUtil.getClass((TRCObject)object));
            }
            if (object instanceof TRCClass) {
                this.select((TRCClass)object);
            }
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.getUpdateAction());
        iMenuManager.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    private void select(Object object) {
        TableTree tableTree = (TableTree)this.getTableViewer().getControl();
        TRCClass tRCClass = null;
        TRCPackage tRCPackage = null;
        if (object instanceof TRCPackage) {
            tRCPackage = (TRCPackage)object;
        } else if (object instanceof TRCClass) {
            tRCClass = (TRCClass)object;
            tRCPackage = tRCClass.getPackage();
        }
        TableTreeItem[] tableTreeItemArray = tableTree.getItems();
        int n = 0;
        while (n < tableTreeItemArray.length) {
            TableTreeItem tableTreeItem = tableTreeItemArray[n];
            if (((TRCPackage)tableTreeItem.getData()).getName().equals(tRCPackage.getName())) {
                if (tRCClass == null) {
                    tableTree.setSelection(new TableTreeItem[]{tableTreeItem});
                    return;
                }
                ((PackageTreeViewer)this.getTableViewer()).expandItem(tableTreeItem);
                TableTreeItem[] tableTreeItemArray2 = tableTreeItem.getItems();
                int n2 = 0;
                while (n2 < tableTreeItemArray2.length) {
                    TableTreeItem tableTreeItem2 = tableTreeItemArray2[n2];
                    if (((TRCClass)tableTreeItem2.getData()).getName().equals(tRCClass.getName())) {
                        ((PackageTreeViewer)this.getTableViewer()).expandItem(tableTreeItem);
                        tableTree.setSelection(new TableTreeItem[]{tableTreeItem2});
                        return;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        tableTree.deselectAll();
    }

    public void updateButtons() {
        ((PackageStatisticPage)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
        ((PackageStatisticPage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
    }

    protected void updateDetailsPane() {
        int n = this.getTable().getSelectionIndex();
        if (n < 0) {
            return;
        }
        TableItem tableItem = this.getTable().getItem(n);
        Object object = tableItem.getData();
        if (object == null) {
            return;
        }
        if (object != null && object instanceof TableTreeItem) {
            object = ((TableTreeItem)object).getData();
        }
    }

    public void updateModelSelection() {
        ISelection iSelection = this.getTableViewer().getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            this.notifyViewSelectionChanged(this, object);
        }
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn tableColumn = table.getColumn(0);
            this._viewerSorter = new PackageStatisticSorter();
            this.getViewerSorter().setSortedColumn(tableColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            this._totalInst = PerftraceUtil.getTotalInstances(this._page.getMOFObject());
            this._activeInst = PerftraceUtil.getActiveInstances(this._page.getMOFObject());
            this._totalSize = PerftraceUtil.getTotalSize(this._page.getMOFObject());
            this._activeSize = PerftraceUtil.getActiveSize(this._page.getMOFObject());
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
        this.handleSelectionEvent();
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        Object object = viewSelectionChangedEvent.getSource();
        if (object != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        Object[] objectArray = PerftraceUtil.getAllPackages(this._page.getMOFObject());
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            TRCPackage tRCPackage = (TRCPackage)objectArray[n2];
            n += tRCPackage.getClasses().size();
            ++n2;
        }
        return n <= 0;
    }

    class PackageTreeViewer
    extends TableTreeViewer {
        public PackageTreeViewer(Composite composite) {
            super(composite);
        }

        public PackageTreeViewer(TableTree tableTree) {
            super(tableTree);
        }

        public void expandItem(TableTreeItem tableTreeItem) {
            tableTreeItem.setExpanded(true);
            this.createChildren((Widget)tableTreeItem);
        }
    }

    public class PackageStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public PackageStatisticLabelProvider(StatisticView statisticView) {
            this._viewer = statisticView;
        }

        public Image getColumnImage(Object object, int n) {
            StatisticTableColumnInfo statisticTableColumnInfo = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n));
            int n2 = statisticTableColumnInfo.getColumnData().getInitalPos();
            if (statisticTableColumnInfo.isDeltaColumn()) {
                return null;
            }
            int n3 = 0;
            double d = 0.0;
            if (object instanceof TRCPackage) {
                TRCPackage tRCPackage = (TRCPackage)object;
                if (tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8) < 0) {
                    if (n == 1) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                switch (n2) {
                    case 1: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        n3 = PackageStatistic.this.pdelta1.getTotalInstances();
                        break;
                    }
                    case 2: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        n3 = PackageStatistic.this.pdelta1.getTotalInstances() - PackageStatistic.this.pdelta1.getCollectedInstances();
                        break;
                    }
                    case 3: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        n3 = PackageStatistic.this.pdelta1.getCollectedInstances();
                        break;
                    }
                    case 4: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        n3 = PackageStatistic.this.pdelta1.getTotalSize();
                        break;
                    }
                    case 5: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 9);
                        n3 = PackageStatistic.this.pdelta1.getTotalSize() - PackageStatistic.this.pdelta1.getCollectedSize();
                        break;
                    }
                    case 6: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 1);
                        d = PackageStatistic.this.pdelta1.getBaseTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 7: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 5);
                        d = PackageStatistic.this.pdelta1.getInheritedBaseTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 8: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 2);
                        d = PackageStatistic.this.pdelta1.getCumulativeTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 9: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 6);
                        d = PackageStatistic.this.pdelta1.getInheritedCumulativeTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 10: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 3);
                        n3 = PackageStatistic.this.pdelta1.getCalls();
                        break;
                    }
                    case 11: {
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 4);
                        n3 = PackageStatistic.this.pdelta1.getInheritedCalls();
                    }
                }
            } else {
                TRCClass tRCClass = (TRCClass)object;
                if (((TRCClass)object).computeDelta((IDelta)PackageStatistic.this.cdelta1, 14) < 0) {
                    if (n == 1) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                switch (n2) {
                    case 1: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        n3 = PackageStatistic.this.cdelta1.getTotalInstances();
                        break;
                    }
                    case 2: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        n3 = PackageStatistic.this.cdelta1.getTotalInstances() - PackageStatistic.this.cdelta1.getCollectedInstances();
                        break;
                    }
                    case 3: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        n3 = PackageStatistic.this.cdelta1.getCollectedInstances();
                        break;
                    }
                    case 4: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        n3 = PackageStatistic.this.cdelta1.getTotalSize();
                        break;
                    }
                    case 5: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 15);
                        n3 = PackageStatistic.this.cdelta1.getTotalSize() - PackageStatistic.this.cdelta1.getCollectedSize();
                        break;
                    }
                    case 6: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 7);
                        d = PackageStatistic.this.cdelta1.getBaseTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 7: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 11);
                        d = PackageStatistic.this.cdelta1.getInheritedBaseTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 8: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 8);
                        d = PackageStatistic.this.cdelta1.getCumulativeTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 9: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 12);
                        d = PackageStatistic.this.cdelta1.getInheritedCumulativeTime();
                        if (d < 0.0) {
                            n3 = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        n3 = 1;
                        break;
                    }
                    case 10: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 9);
                        n3 = PackageStatistic.this.cdelta1.getCalls();
                        break;
                    }
                    case 11: {
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 10);
                        n3 = PackageStatistic.this.cdelta1.getInheritedCalls();
                    }
                }
            }
            if (n3 < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (n3 > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            StatisticTableColumnInfo statisticTableColumnInfo = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n));
            int n2 = statisticTableColumnInfo.getColumnData().getInitalPos();
            if (object instanceof TRCPackage) {
                TRCPackage tRCPackage = (TRCPackage)object;
                TRCPackageImpl.TRCPackageSnapshot tRCPackageSnapshot = (TRCPackageImpl.TRCPackageSnapshot)tRCPackage.retrieveSnapshot();
                switch (n2) {
                    case 0: {
                        return PerftraceUtil.getPackageName(tRCPackage, PackageStatistic.this._page.getMOFObject()).toString();
                    }
                    case 1: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCPackageSnapshot.getTotalInstances() / (double)PackageStatistic.this._totalInst));
                            }
                            return String.valueOf(tRCPackageSnapshot.getTotalInstances());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        return String.valueOf(PackageStatistic.this.pdelta1.getTotalInstances());
                    }
                    case 2: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(tRCPackageSnapshot.getTotalInstances() - tRCPackageSnapshot.getCollectedInstances()) / (double)PackageStatistic.this._activeInst));
                            }
                            return String.valueOf(tRCPackageSnapshot.getTotalInstances() - tRCPackageSnapshot.getCollectedInstances());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        return String.valueOf(PackageStatistic.this.pdelta1.getTotalInstances() - PackageStatistic.this.pdelta1.getCollectedInstances());
                    }
                    case 3: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                int n3 = tRCPackageSnapshot.getTotalInstances();
                                if (n3 == 0) {
                                    n3 = 1;
                                }
                                return TString.formatAsPercentage((double)((double)tRCPackageSnapshot.getCollectedInstances() / (double)n3));
                            }
                            return String.valueOf(tRCPackageSnapshot.getCollectedInstances());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        return String.valueOf(PackageStatistic.this.pdelta1.getCollectedInstances());
                    }
                    case 4: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCPackageSnapshot.getTotalSize() / (double)PackageStatistic.this._totalSize));
                            }
                            return String.valueOf(tRCPackageSnapshot.getTotalSize());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        return String.valueOf(PackageStatistic.this.pdelta1.getTotalSize());
                    }
                    case 5: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(tRCPackageSnapshot.getTotalSize() - tRCPackageSnapshot.getCollectedSize()) / (double)PackageStatistic.this._activeSize));
                            }
                            return String.valueOf(tRCPackageSnapshot.getTotalSize() - tRCPackageSnapshot.getCollectedSize());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 9);
                        return String.valueOf(PackageStatistic.this.pdelta1.getTotalSize() - PackageStatistic.this.pdelta1.getCollectedSize());
                    }
                    case 6: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCPackageSnapshot.getBaseTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCPackageSnapshot.getBaseTime());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 1);
                        return TString.formatTimeValue((double)PackageStatistic.this.pdelta1.getBaseTime());
                    }
                    case 7: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCPackageSnapshot.getInheritedBaseTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCPackageSnapshot.getInheritedBaseTime());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 5);
                        return TString.formatTimeValue((double)PackageStatistic.this.pdelta1.getInheritedBaseTime());
                    }
                    case 8: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCPackageSnapshot.getCumulativeTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCPackageSnapshot.getCumulativeTime());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 2);
                        return TString.formatTimeValue((double)PackageStatistic.this.pdelta1.getCumulativeTime());
                    }
                    case 9: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCPackageSnapshot.getInheritedCumulativeTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCPackageSnapshot.getInheritedCumulativeTime());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 6);
                        return TString.formatTimeValue((double)PackageStatistic.this.pdelta1.getInheritedCumulativeTime());
                    }
                    case 10: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCPackageSnapshot.getCalls() / (double)PackageStatistic.this._totalCalls));
                            }
                            return String.valueOf(tRCPackageSnapshot.getCalls());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 3);
                        return String.valueOf(PackageStatistic.this.pdelta1.getCalls());
                    }
                    case 11: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCPackageSnapshot.getInheritedCalls() / (double)PackageStatistic.this._totalCalls));
                            }
                            return String.valueOf(tRCPackageSnapshot.getInheritedCalls());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 4);
                        return String.valueOf(PackageStatistic.this.pdelta1.getInheritedCalls());
                    }
                }
            } else {
                TRCClass tRCClass = (TRCClass)object;
                TRCClassImpl.TRCClassSnapshot tRCClassSnapshot = (TRCClassImpl.TRCClassSnapshot)tRCClass.retrieveSnapshot();
                switch (n2) {
                    case 0: {
                        return tRCClass.getName();
                    }
                    case 1: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getTotalInstances() / (double)PackageStatistic.this._totalInst));
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalInstances());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        return String.valueOf(PackageStatistic.this.cdelta1.getTotalInstances());
                    }
                    case 2: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot.getCollectedInstances()) / (double)PackageStatistic.this._totalInst));
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        return String.valueOf(PackageStatistic.this.cdelta1.getTotalInstances() - PackageStatistic.this.cdelta1.getCollectedInstances());
                    }
                    case 3: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                int n4 = tRCClassSnapshot.getTotalInstances();
                                if (n4 == 0) {
                                    n4 = 1;
                                }
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getCollectedInstances() / (double)n4));
                            }
                            return String.valueOf(tRCClassSnapshot.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        return String.valueOf(PackageStatistic.this.cdelta1.getCollectedInstances());
                    }
                    case 4: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getTotalSize() / (double)PackageStatistic.this._totalSize));
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalSize());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        return String.valueOf(PackageStatistic.this.cdelta1.getTotalSize());
                    }
                    case 5: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(tRCClassSnapshot.getTotalSize() - tRCClassSnapshot.getCollectedSize()) / (double)PackageStatistic.this._activeSize));
                            }
                            return String.valueOf(tRCClassSnapshot.getTotalSize() - tRCClassSnapshot.getCollectedSize());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 15);
                        return String.valueOf(PackageStatistic.this.cdelta1.getTotalSize() - PackageStatistic.this.cdelta1.getCollectedSize());
                    }
                    case 6: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getBaseTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getBaseTime());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 7);
                        return TString.formatTimeValue((double)PackageStatistic.this.cdelta1.getBaseTime());
                    }
                    case 7: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getInheritedBaseTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getInheritedBaseTime());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 11);
                        return TString.formatTimeValue((double)PackageStatistic.this.cdelta1.getInheritedBaseTime());
                    }
                    case 8: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getCumulativeTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getCumulativeTime());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 8);
                        return TString.formatTimeValue((double)PackageStatistic.this.cdelta1.getCumulativeTime());
                    }
                    case 9: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(tRCClassSnapshot.getInheritedCumulativeTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)tRCClassSnapshot.getInheritedCumulativeTime());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 12);
                        return TString.formatTimeValue((double)PackageStatistic.this.cdelta1.getInheritedCumulativeTime());
                    }
                    case 10: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getCalls() / (double)PackageStatistic.this._totalCalls));
                            }
                            return String.valueOf(tRCClassSnapshot.getCalls());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 9);
                        return String.valueOf(PackageStatistic.this.cdelta1.getCalls());
                    }
                    case 11: {
                        if (!statisticTableColumnInfo.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)tRCClassSnapshot.getInheritedCalls() / (double)PackageStatistic.this._totalCalls));
                            }
                            return String.valueOf(tRCClassSnapshot.getInheritedCalls());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 10);
                        return String.valueOf(PackageStatistic.this.cdelta1.getInheritedCalls());
                    }
                }
            }
            return "";
        }
    }

    public class PackageStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object object) {
            if (object instanceof TRCClass) {
                return ((TRCClass)object).getPackage();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = PerftraceUtil.getAllPackages(PackageStatistic.this._page.getMOFObject());
            ArrayList<TRCPackage> arrayList = new ArrayList<TRCPackage>();
            int n = 0;
            while (n < objectArray.length) {
                TRCPackage tRCPackage = (TRCPackage)objectArray[n];
                if (tRCPackage.getClasses().size() > 0) {
                    arrayList.add(tRCPackage);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        public Object[] getChildren(Object object) {
            PackageStatistic.this.tmpList.clear();
            if (object instanceof TRCPackage) {
                return ((TRCPackage)object).getClasses().toArray();
            }
            return PackageStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object object) {
            return object instanceof TRCPackage;
        }
    }

    public class PackageStatisticSorter
    extends StatisticView.StatisticSorter {
        public PackageStatisticSorter() {
            super(PackageStatistic.this);
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            double d = 0.0;
            if (object instanceof TRCPackage) {
                TRCPackage tRCPackage = (TRCPackage)object;
                TRCPackage tRCPackage2 = (TRCPackage)object2;
                TRCPackageImpl.TRCPackageSnapshot tRCPackageSnapshot = (TRCPackageImpl.TRCPackageSnapshot)tRCPackage.retrieveSnapshot();
                TRCPackageImpl.TRCPackageSnapshot tRCPackageSnapshot2 = (TRCPackageImpl.TRCPackageSnapshot)tRCPackage2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * tRCPackage.getName().compareToIgnoreCase(tRCPackage2.getName());
                    }
                    case 1: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCPackageSnapshot.getTotalInstances() - tRCPackageSnapshot2.getTotalInstances());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 8);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getTotalInstances() - PackageStatistic.this.pdelta2.getTotalInstances());
                    }
                    case 2: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCPackageSnapshot.getTotalInstances() - tRCPackageSnapshot.getCollectedInstances() - tRCPackage2.getTotalInstances() + tRCPackage2.getCollectedInstances());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 8);
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 10);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getTotalInstances() - PackageStatistic.this.pdelta1.getCollectedInstances() - PackageStatistic.this.pdelta2.getTotalInstances() + PackageStatistic.this.pdelta2.getCollectedInstances());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                int n = tRCPackageSnapshot.getTotalInstances();
                                if (n == 0) {
                                    n = 1;
                                }
                                double d2 = (double)tRCPackageSnapshot.getCollectedInstances() / (double)n;
                                n = tRCPackageSnapshot2.getTotalInstances();
                                if (n == 0) {
                                    n = 1;
                                }
                                return this._sortSequence * (int)((d2 -= (double)tRCPackageSnapshot2.getCollectedInstances() / (double)n) * 10000.0);
                            }
                            return this._sortSequence * (tRCPackageSnapshot.getCollectedInstances() - tRCPackageSnapshot2.getCollectedInstances());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 10);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getCollectedInstances() - PackageStatistic.this.pdelta2.getCollectedInstances());
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCPackageSnapshot.getTotalSize() - tRCPackageSnapshot2.getTotalSize());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 7);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getTotalSize() - PackageStatistic.this.pdelta2.getTotalSize());
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCPackageSnapshot.getTotalSize() - tRCPackageSnapshot.getCollectedSize() - tRCPackage2.getTotalSize() + tRCPackage2.getCollectedSize());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 7);
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 9);
                        tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 9);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getTotalSize() - PackageStatistic.this.pdelta1.getCollectedSize() - PackageStatistic.this.pdelta2.getTotalSize() + PackageStatistic.this.pdelta2.getCollectedSize());
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCPackageSnapshot.getBaseTime() - tRCPackageSnapshot2.getBaseTime();
                        } else {
                            tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 1);
                            tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 1);
                            d = PackageStatistic.this.pdelta1.getBaseTime() - PackageStatistic.this.pdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCPackageSnapshot.getInheritedBaseTime() - tRCPackageSnapshot2.getInheritedBaseTime();
                        } else {
                            tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 5);
                            tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 5);
                            d = PackageStatistic.this.pdelta1.getInheritedBaseTime() - PackageStatistic.this.pdelta2.getInheritedBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCPackageSnapshot.getCumulativeTime() - tRCPackageSnapshot2.getCumulativeTime();
                        } else {
                            tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 2);
                            tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 2);
                            d = PackageStatistic.this.pdelta1.getCumulativeTime() - PackageStatistic.this.pdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCPackageSnapshot.getInheritedCumulativeTime() - tRCPackageSnapshot2.getInheritedCumulativeTime();
                        } else {
                            tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 6);
                            tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 6);
                            d = PackageStatistic.this.pdelta1.getInheritedCumulativeTime() - PackageStatistic.this.pdelta2.getInheritedCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 10: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCPackageSnapshot.getCalls() - tRCPackageSnapshot2.getCalls());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 3);
                        tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 3);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getCalls() - PackageStatistic.this.pdelta2.getCalls());
                    }
                    case 11: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCPackageSnapshot.getInheritedCalls() - tRCPackageSnapshot2.getInheritedCalls());
                        }
                        tRCPackage.computeDelta((IDelta)PackageStatistic.this.pdelta1, 4);
                        tRCPackage2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 4);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getInheritedCalls() - PackageStatistic.this.pdelta2.getInheritedCalls());
                    }
                }
            } else {
                TRCClass tRCClass = (TRCClass)object;
                TRCClass tRCClass2 = (TRCClass)object2;
                TRCClassImpl.TRCClassSnapshot tRCClassSnapshot = (TRCClassImpl.TRCClassSnapshot)tRCClass.retrieveSnapshot();
                TRCClassImpl.TRCClassSnapshot tRCClassSnapshot2 = (TRCClassImpl.TRCClassSnapshot)tRCClass2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * tRCClass.getName().compareToIgnoreCase(tRCClass2.getName());
                    }
                    case 1: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot2.getTotalInstances());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 14);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getTotalInstances() - PackageStatistic.this.cdelta2.getTotalInstances());
                    }
                    case 2: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalInstances() - tRCClassSnapshot.getCollectedInstances() - tRCClass2.getTotalInstances() + tRCClass2.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 14);
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 16);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getTotalInstances() - PackageStatistic.this.cdelta1.getCollectedInstances() - (PackageStatistic.this.cdelta2.getTotalInstances() - PackageStatistic.this.cdelta2.getCollectedInstances()));
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                int n = tRCClassSnapshot.getTotalInstances();
                                if (n == 0) {
                                    n = 1;
                                }
                                double d3 = (double)tRCClassSnapshot.getCollectedInstances() / (double)n;
                                n = tRCClassSnapshot2.getTotalInstances();
                                if (n == 0) {
                                    n = 1;
                                }
                                return this._sortSequence * (int)((d3 -= (double)tRCClassSnapshot2.getCollectedInstances() / (double)n) * 10000.0);
                            }
                            return this._sortSequence * (tRCClassSnapshot.getCollectedInstances() - tRCClassSnapshot2.getCollectedInstances());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 16);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getCollectedInstances() - PackageStatistic.this.cdelta2.getCollectedInstances());
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalSize() - tRCClassSnapshot2.getTotalSize());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 13);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getTotalSize() - PackageStatistic.this.cdelta2.getTotalSize());
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getTotalSize() - tRCClassSnapshot2.getCollectedSize() - ((TRCClass)object2).getTotalSize() + ((TRCClass)object2).getCollectedSize());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 13);
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 15);
                        tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 15);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getTotalSize() - PackageStatistic.this.cdelta1.getCollectedSize() - (PackageStatistic.this.cdelta2.getTotalSize() - PackageStatistic.this.cdelta2.getCollectedSize()));
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getBaseTime() - tRCClassSnapshot2.getBaseTime();
                        } else {
                            tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 7);
                            tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 7);
                            d = PackageStatistic.this.cdelta1.getBaseTime() - PackageStatistic.this.cdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getInheritedBaseTime() - tRCClassSnapshot2.getInheritedBaseTime();
                        } else {
                            tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 11);
                            tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 11);
                            d = PackageStatistic.this.cdelta1.getInheritedBaseTime() - PackageStatistic.this.cdelta2.getInheritedBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getCumulativeTime() - tRCClassSnapshot2.getCumulativeTime();
                        } else {
                            tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 8);
                            tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 8);
                            d = PackageStatistic.this.cdelta1.getCumulativeTime() - PackageStatistic.this.cdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = tRCClassSnapshot.getInheritedCumulativeTime() - tRCClassSnapshot2.getInheritedCumulativeTime();
                        } else {
                            tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 12);
                            tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 12);
                            d = PackageStatistic.this.cdelta1.getInheritedCumulativeTime() - PackageStatistic.this.cdelta2.getInheritedCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 10: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getCalls() - tRCClassSnapshot2.getCalls());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 9);
                        tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 9);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getCalls() - PackageStatistic.this.cdelta2.getCalls());
                    }
                    case 11: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (tRCClassSnapshot.getInheritedCalls() - tRCClassSnapshot2.getInheritedCalls());
                        }
                        tRCClass.computeDelta((IDelta)PackageStatistic.this.cdelta1, 10);
                        tRCClass2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 10);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getInheritedCalls() - PackageStatistic.this.cdelta2.getInheritedCalls());
                    }
                }
            }
            return 0;
        }
    }

    public class PackageStatisticFilter
    extends StatisticView.StatisticFilter {
        public PackageStatisticFilter() {
            super(PackageStatistic.this);
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = true;
            if (!(object2 instanceof TRCPackage)) {
                return true;
            }
            String string = "";
            string = ((TRCPackage)object2).getName();
            if (string.equals("")) {
                string = TraceUIPlugin.getString("DEFAULT_PACKAGE");
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                string = string.toLowerCase();
            }
            if (this._exactMatch) {
                return string.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                bl = string.startsWith(this._prefix);
            }
            if (bl && this._suffix != "") {
                bl = string.endsWith(this._suffix);
            }
            if (bl) {
                int n = 0;
                while (n < this._textList.size()) {
                    String string2 = (String)this._textList.get(n);
                    int n2 = string.lastIndexOf(string2);
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    string = string.substring(n2 + string2.length());
                    ++n;
                }
            }
            return bl;
        }
    }
}

