/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.ReferenceTablePage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.IRefChangedListener;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ReferenceTable
extends StatisticView
implements IRefChangedListener {
    protected int _drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");

    protected Composite createTable(Composite composite, int n) {
        return new TableTree(composite, n);
    }

    public ReferenceTable(Composite composite, TraceViewerPage traceViewerPage) {
        super(composite, traceViewerPage);
        this._viewerFilter = new ClassStatisticFilter();
        TraceUIPlugin.getDefault().addRefChangedEventListener(this);
    }

    public String getColumnsPreferencesKey() {
        return "Ref63";
    }

    public String getDefaultColumnsTemplate() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        String string = TraceUIPlugin.getString("STR_REFEREE");
        if (this.showReferTo()) {
            string = TraceUIPlugin.getString("STR_REFERANDS");
        }
        String string2 = string + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":1:" + String.valueOf(1) + ":left:150," + TraceUIPlugin.getString("STR_REF_SIZE") + ":2:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_NB_REF") + ":3:" + String.valueOf(1) + ":left:170," + TraceUIPlugin.getString("STR_OBJ_REF_DETAIL") + ":4:" + String.valueOf(1) + ":left:350";
        return string2;
    }

    protected IContentProvider getContentProvider() {
        return new ObjReferenceContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ObjReferenceLabelProvider(this);
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite composite) {
        ReferenceTreeViewer referenceTreeViewer = new ReferenceTreeViewer((TableTree)composite);
        return referenceTreeViewer;
    }

    protected void handleSelectionEvent() {
        ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(false);
        ITraceSelection iTraceSelection = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (iTraceSelection.size() > 0) {
            Object object = iTraceSelection.getFirstElement();
            if (!(object instanceof TRCPackage)) {
                ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(true);
            }
            this.select(object);
            if (object instanceof TRCObject) {
                object = ((TRCObject)object).getIsA();
            } else if (object instanceof TRCClass) {
                this.select((TRCClass)object);
            }
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getUpdateAction());
        iMenuManager.add((IContributionItem)this.fSeparator);
        iMenuManager.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    private void select(Object object) {
        TRCClass tRCClass = null;
        TRCObject tRCObject = null;
        if (object instanceof TRCClass) {
            tRCClass = (TRCClass)object;
        } else if (object instanceof TRCObject) {
            tRCObject = (TRCObject)object;
            tRCClass = tRCObject.getIsA();
        }
        if (tRCClass == null) {
            return;
        }
        TableTree tableTree = (TableTree)this.getTableViewer().getControl();
        TableTreeItem[] tableTreeItemArray = tableTree.getItems();
        int n = 0;
        while (n < tableTreeItemArray.length) {
            TableTreeItem tableTreeItem = tableTreeItemArray[n];
            if (tableTreeItem.getData().equals(tRCClass)) {
                ((ReferenceTreeViewer)this.getTableViewer()).expandItem(tableTreeItem);
                if (tRCObject == null) {
                    tableTree.setSelection(new TableTreeItem[]{tableTreeItem});
                    this.setNewSelection();
                    return;
                }
                TableTreeItem[] tableTreeItemArray2 = tableTreeItem.getItems();
                int n2 = 0;
                while (n2 < tableTreeItemArray2.length) {
                    TableTreeItem tableTreeItem2 = tableTreeItemArray2[n2];
                    if (tableTreeItem2.getData().equals(tRCObject)) {
                        tableTree.setSelection(new TableTreeItem[]{tableTreeItem2});
                        this.setNewSelection();
                        return;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void updateButtons() {
    }

    protected void updateDetailsPane() {
        int n = this.getTable().getSelectionIndex();
        if (n < 0) {
            return;
        }
        TableItem tableItem = this.getTable().getItem(n);
        Object object = tableItem.getData();
        if (object == null) {
            return;
        }
        if (object != null && object instanceof TableTreeItem) {
            object = ((TableTreeItem)object).getData();
        }
    }

    public void updateModelSelection() {
        ISelection iSelection = this.getTableViewer().getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (object instanceof TRCObjectReference) {
                object = this.showReferTo() ? ((TRCObjectReference)object).getOwner() : ((TRCObjectReference)object).getTarget();
            }
            this.notifyViewSelectionChanged(this, object);
        }
    }

    public void update() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            table.setLinesVisible(false);
            TableColumn tableColumn = table.getColumn(0);
            this._viewerSorter = new ObjReferenceSorter();
            this.getViewerSorter().setSortedColumn(tableColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTableViewer().refresh();
        this.handleSelectionEvent();
    }

    public void dispose() {
        TraceUIPlugin.getDefault().removeRefChangedEventListener(this);
        super.dispose();
    }

    public void handleRefChangedEvent() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        Table table = this.getTable();
        TableColumn tableColumn = table.getColumn(0);
        String string = tableColumn.getText();
        String string2 = TraceUIPlugin.getString("STR_REFEREE");
        if (this.showReferTo()) {
            string2 = TraceUIPlugin.getString("STR_REFERANDS");
        }
        if (string.startsWith(">") || string.startsWith("<")) {
            tableColumn.setText(string.substring(0, 1) + string2);
        } else {
            tableColumn.setText(string2);
        }
        Action action = ((ReferenceTablePage)this.getTraceViewerPage()).referands();
        Action action2 = ((ReferenceTablePage)this.getTraceViewerPage()).referee();
        int n = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        if (action != null) {
            action.setChecked(n == 0);
        }
        if (action2 != null) {
            action2.setChecked(n == 1);
        }
        this.update();
    }

    private boolean showReferTo() {
        return this._drawmode == 0;
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent viewSelectionChangedEvent) {
        Object object = viewSelectionChangedEvent.getSource();
        if (object != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllClasses(this._page.getMOFObject()).length <= 0;
    }

    class ReferenceTreeViewer
    extends TableTreeViewer {
        public ReferenceTreeViewer(Composite composite) {
            super(composite);
        }

        public ReferenceTreeViewer(TableTree tableTree) {
            super(tableTree);
        }

        public void expandItem(TableTreeItem tableTreeItem) {
            tableTreeItem.setExpanded(true);
            this.createChildren((Widget)tableTreeItem);
        }
    }

    public class ObjReferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ObjReferenceLabelProvider(StatisticView statisticView) {
            this._viewer = statisticView;
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            int n2 = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(n)).getColumnData().getInitalPos();
            if (object instanceof TRCClass) {
                switch (n2) {
                    case 0: {
                        return ((TRCClass)object).getName();
                    }
                    case 1: {
                        return PerftraceUtil.getPackageName(((TRCClass)object).getPackage(), ReferenceTable.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        return String.valueOf(((TRCClass)object).getTotalSize() - ((TRCClass)object).getCollectedSize());
                    }
                    case 3: {
                        return "";
                    }
                }
            } else if (object instanceof TRCHeapObject) {
                TRCHeapObject tRCHeapObject = (TRCHeapObject)object;
                switch (n2) {
                    case 0: {
                        TRCClass tRCClass = PerftraceUtil.getClass((TRCObject)tRCHeapObject);
                        if (tRCClass == tRCHeapObject.getIsA()) {
                            return tRCClass.getName() + "." + tRCHeapObject.getId();
                        }
                        return tRCClass.getName();
                    }
                    case 1: {
                        return PerftraceUtil.getPackageName(PerftraceUtil.getClass((TRCObject)tRCHeapObject).getPackage(), ReferenceTable.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        int n3 = tRCHeapObject.getSize();
                        if (n3 != 0) {
                            return String.valueOf(n3);
                        }
                        if (ReferenceTable.this.showReferTo()) {
                            if (tRCHeapObject.getRefTarget().size() > 0 && tRCHeapObject.getRefTarget().get(0) instanceof TRCAggregatedObjectReference) {
                                return String.valueOf(((TRCAggregatedObjectReference)tRCHeapObject.getRefTarget().get(0)).getTargetSize());
                            }
                            TRCClass tRCClass = PerftraceUtil.getClass((TRCObject)tRCHeapObject);
                            int n4 = tRCClass.getTotalInstances();
                            if (n4 == 0) {
                                n4 = 1;
                            }
                            return String.valueOf(tRCClass.getTotalSize() / n4);
                        }
                        if (tRCHeapObject.getRefOwner().size() > 0 && tRCHeapObject.getRefOwner().get(0) instanceof TRCAggregatedObjectReference) {
                            return String.valueOf(((TRCAggregatedObjectReference)tRCHeapObject.getRefOwner().get(0)).getOwnerSize());
                        }
                        TRCClass tRCClass = PerftraceUtil.getClass((TRCObject)tRCHeapObject);
                        int n5 = tRCClass.getTotalInstances();
                        if (n5 == 0) {
                            n5 = 1;
                        }
                        return String.valueOf(tRCClass.getTotalSize() / n5);
                    }
                    case 3: {
                        if (ReferenceTable.this.showReferTo()) {
                            int n6 = 0;
                            int n7 = ((TRCHeapObject)object).getRefTarget().size();
                            int n8 = 0;
                            while (n8 < n7) {
                                n6 = tRCHeapObject.getRefTarget().get(n8) instanceof TRCAggregatedObjectReference ? (n6 += ((TRCAggregatedObjectReference)tRCHeapObject.getRefTarget().get(n8)).getCount()) : ++n6;
                                ++n8;
                            }
                            if (n6 > 0) {
                                return TString.change((String)TraceUIPlugin.getString("REF_BY_DETAIL"), (String)"%1", (String)String.valueOf(n6));
                            }
                            return "";
                        }
                        int n9 = 0;
                        int n10 = ((TRCHeapObject)object).getRefOwner().size();
                        int n11 = 0;
                        while (n11 < n10) {
                            n9 = tRCHeapObject.getRefOwner().get(n11) instanceof TRCAggregatedObjectReference ? (n9 += ((TRCAggregatedObjectReference)tRCHeapObject.getRefOwner().get(n11)).getCount()) : ++n9;
                            ++n11;
                        }
                        if (n9 > 0) {
                            return TString.change((String)TraceUIPlugin.getString("REF_TO_DETAIL"), (String)"%1", (String)String.valueOf(n9));
                        }
                        return "";
                    }
                }
            } else {
                TRCObjectReference tRCObjectReference = (TRCObjectReference)object;
                switch (n2) {
                    case 0: {
                        TRCHeapObject tRCHeapObject = null;
                        tRCHeapObject = ReferenceTable.this.showReferTo() ? tRCObjectReference.getOwner() : tRCObjectReference.getTarget();
                        TRCClass tRCClass = PerftraceUtil.getClass((TRCObject)tRCHeapObject);
                        if (tRCClass == tRCHeapObject.getIsA()) {
                            return tRCClass.getName() + "." + tRCHeapObject.getId();
                        }
                        return tRCClass.getName();
                    }
                    case 1: {
                        TRCHeapObject tRCHeapObject = null;
                        tRCHeapObject = ReferenceTable.this.showReferTo() ? tRCObjectReference.getOwner() : tRCObjectReference.getTarget();
                        return PerftraceUtil.getPackageName(PerftraceUtil.getClass((TRCObject)tRCHeapObject).getPackage(), ReferenceTable.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        int n12 = 0;
                        n12 = tRCObjectReference instanceof TRCAggregatedObjectReference ? (ReferenceTable.this.showReferTo() ? ((TRCAggregatedObjectReference)tRCObjectReference).getOwnerSize() : ((TRCAggregatedObjectReference)tRCObjectReference).getTargetSize()) : (ReferenceTable.this.showReferTo() ? tRCObjectReference.getOwner().getSize() : tRCObjectReference.getTarget().getSize());
                        return String.valueOf(n12);
                    }
                    case 3: {
                        if (ReferenceTable.this.showReferTo()) {
                            int n13 = 0;
                            Object[] objectArray = tRCObjectReference.getOwner().getRefTarget().toArray();
                            int n14 = objectArray.length;
                            int n15 = 0;
                            while (n15 < n14) {
                                n13 = objectArray[n15] instanceof TRCAggregatedObjectReference ? (n13 += ((TRCAggregatedObjectReference)objectArray[n15]).getCount()) : ++n13;
                                ++n15;
                            }
                            if (n13 > 0) {
                                return TString.change((String)TraceUIPlugin.getString("REF_BY_DETAIL"), (String)"%1", (String)String.valueOf(n13));
                            }
                            return "";
                        }
                        int n16 = 0;
                        Object[] objectArray = tRCObjectReference.getTarget().getRefOwner().toArray();
                        int n17 = objectArray.length;
                        int n18 = 0;
                        while (n18 < n17) {
                            n16 = objectArray[n18] instanceof TRCAggregatedObjectReference ? (n16 += ((TRCAggregatedObjectReference)objectArray[n18]).getCount()) : ++n16;
                            ++n18;
                        }
                        if (n16 > 0) {
                            return TString.change((String)TraceUIPlugin.getString("REF_TO_DETAIL"), (String)"%1", (String)String.valueOf(n16));
                        }
                        return "";
                    }
                    case 4: {
                        int n19;
                        if (ReferenceTable.this.showReferTo()) {
                            int n20;
                            if (tRCObjectReference instanceof TRCAggregatedObjectReference && (n20 = ((TRCAggregatedObjectReference)tRCObjectReference).getCount()) > 1) {
                                return TString.change((String)TString.change((String)TraceUIPlugin.getString("REF_BY_DET1"), (String)"%1", (String)String.valueOf(n20)), (String)"%2", (String)PerftraceUtil.getClass((TRCObject)tRCObjectReference.getTarget()).getName());
                            }
                            return "";
                        }
                        if (tRCObjectReference instanceof TRCAggregatedObjectReference && (n19 = ((TRCAggregatedObjectReference)tRCObjectReference).getCount()) > 1) {
                            return TString.change((String)TString.change((String)TraceUIPlugin.getString("REF_TO_DET1"), (String)"%1", (String)PerftraceUtil.getClass((TRCObject)((TRCAggregatedObjectReference)object).getOwner()).getName()), (String)"%2", (String)String.valueOf(n19));
                        }
                        return "";
                    }
                }
            }
            return "";
        }
    }

    public class ObjReferenceContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object object) {
            if (object instanceof TRCClass) {
                return null;
            }
            if (object instanceof TRCHeapObject) {
                return ((TRCHeapObject)object).getIsA();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            return PerftraceUtil.getAllClasses(ReferenceTable.this._page.getMOFObject());
        }

        public Object[] getChildren(Object object) {
            ReferenceTable.this.tmpList.clear();
            if (ReferenceTable.this.showReferTo()) {
                if (object instanceof TRCClass) {
                    Object[] objectArray;
                    TRCHeapObject tRCHeapObject = null;
                    Object[] objectArray2 = ((TRCClass)object).getClassObjects().toArray();
                    int n = 0;
                    while (n < objectArray2.length) {
                        objectArray = (Object[])objectArray2[n];
                        if (objectArray instanceof TRCHeapObject) {
                            tRCHeapObject = (TRCHeapObject)objectArray;
                            break;
                        }
                        ++n;
                    }
                    if (tRCHeapObject != null && tRCHeapObject.getRefTarget().size() > 0) {
                        ReferenceTable.this.tmpList.add(tRCHeapObject);
                    }
                    objectArray = ((TRCClass)object).getObjects().toArray();
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        TRCObject tRCObject = (TRCObject)objectArray[n2];
                        if (tRCObject instanceof TRCHeapObject && ((TRCHeapObject)tRCObject).getRefTarget().size() > 0) {
                            ReferenceTable.this.tmpList.add(tRCObject);
                        }
                        ++n2;
                    }
                } else if (object instanceof TRCHeapObject) {
                    ReferenceTable.this.tmpList.addAll(((TRCHeapObject)object).getRefTarget());
                } else {
                    ReferenceTable.this.tmpList.addAll(((TRCObjectReference)object).getOwner().getRefTarget());
                }
            } else if (object instanceof TRCClass) {
                Object[] objectArray;
                TRCHeapObject tRCHeapObject = null;
                Object[] objectArray3 = ((TRCClass)object).getClassObjects().toArray();
                int n = 0;
                while (n < objectArray3.length) {
                    objectArray = (Object[])objectArray3[n];
                    if (objectArray instanceof TRCHeapObject) {
                        tRCHeapObject = (TRCHeapObject)objectArray;
                        break;
                    }
                    ++n;
                }
                if (tRCHeapObject != null && tRCHeapObject.getRefOwner().size() > 0) {
                    ReferenceTable.this.tmpList.add(tRCHeapObject);
                }
                objectArray = ((TRCClass)object).getObjects().toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    TRCObject tRCObject = (TRCObject)objectArray[n3];
                    if (tRCObject instanceof TRCHeapObject && tRCObject.getIsA() == object && ((TRCHeapObject)tRCObject).getRefOwner().size() > 0) {
                        ReferenceTable.this.tmpList.add(objectArray[n3]);
                    }
                    ++n3;
                }
            } else if (object instanceof TRCHeapObject) {
                ReferenceTable.this.tmpList.addAll(((TRCHeapObject)object).getRefOwner());
            } else {
                ReferenceTable.this.tmpList.addAll(((TRCObjectReference)object).getTarget().getRefOwner());
            }
            return ReferenceTable.this.tmpList.toArray();
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }
    }

    public class ObjReferenceSorter
    extends StatisticView.StatisticSorter {
        public ObjReferenceSorter() {
            super(ReferenceTable.this);
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            if (object instanceof TRCClass) {
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * ((TRCClass)object).getName().compareToIgnoreCase(((TRCClass)object2).getName());
                    }
                    case 1: {
                        return this._sortSequence * ((TRCClass)object).getPackage().getName().compareToIgnoreCase(((TRCClass)object2).getPackage().getName());
                    }
                    case 2: {
                        TRCClass tRCClass = (TRCClass)object;
                        TRCClass tRCClass2 = (TRCClass)object2;
                        return this._sortSequence * (tRCClass.getTotalSize() - tRCClass.getCollectedSize() - (tRCClass2.getTotalSize() - tRCClass2.getCollectedSize()));
                    }
                    case 3: {
                        return 0;
                    }
                }
            } else if (object instanceof TRCHeapObject) {
                TRCHeapObject tRCHeapObject = (TRCHeapObject)object;
                TRCHeapObject tRCHeapObject2 = (TRCHeapObject)object2;
                switch (this._pos) {
                    case 0: {
                        TRCClass tRCClass = tRCHeapObject.getIsA();
                        String string = PerftraceUtil.getClass((TRCObject)tRCHeapObject).getName();
                        String string2 = PerftraceUtil.getClass((TRCObject)tRCHeapObject2).getName();
                        return this._sortSequence * string.compareToIgnoreCase(string2);
                    }
                    case 1: {
                        String string = PerftraceUtil.getClass((TRCObject)tRCHeapObject).getPackage().getName();
                        String string3 = PerftraceUtil.getClass((TRCObject)tRCHeapObject2).getPackage().getName();
                        return this._sortSequence * string.compareToIgnoreCase(string3);
                    }
                    case 2: {
                        int n = 0;
                        int n2 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            Object[] objectArray = tRCHeapObject.getRefTarget().toArray();
                            int n3 = 0;
                            while (n3 < objectArray.length) {
                                TRCObjectReference tRCObjectReference = (TRCObjectReference)objectArray[n3];
                                n = tRCObjectReference instanceof TRCAggregatedObjectReference ? (n += ((TRCAggregatedObjectReference)tRCObjectReference).getTargetSize()) : (n += tRCObjectReference.getTarget().getSize());
                                ++n3;
                            }
                            objectArray = tRCHeapObject2.getRefTarget().toArray();
                            int n4 = 0;
                            while (n4 < objectArray.length) {
                                TRCObjectReference tRCObjectReference = (TRCObjectReference)objectArray[n4];
                                n2 = tRCObjectReference instanceof TRCAggregatedObjectReference ? (n2 += ((TRCAggregatedObjectReference)tRCObjectReference).getTargetSize()) : (n2 += tRCObjectReference.getTarget().getSize());
                                ++n4;
                            }
                        } else {
                            Object[] objectArray = tRCHeapObject.getRefOwner().toArray();
                            int n5 = 0;
                            while (n5 < objectArray.length) {
                                if (objectArray[n5] instanceof TRCAggregatedObjectReference) {
                                    n += ((TRCAggregatedObjectReference)objectArray[n5]).getOwnerSize();
                                }
                                ++n5;
                            }
                            objectArray = tRCHeapObject2.getRefOwner().toArray();
                            int n6 = 0;
                            while (n6 < objectArray.length) {
                                if (objectArray[n6] instanceof TRCAggregatedObjectReference) {
                                    n2 += ((TRCAggregatedObjectReference)objectArray[n6]).getOwnerSize();
                                }
                                ++n6;
                            }
                        }
                        return this._sortSequence * (n - n2);
                    }
                    case 3: {
                        int n;
                        int n7;
                        int n8 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            n7 = tRCHeapObject.getRefTarget().size();
                            n = 0;
                            while (n < n7) {
                                n8 = tRCHeapObject.getRefTarget().get(n) instanceof TRCAggregatedObjectReference ? (n8 += ((TRCAggregatedObjectReference)tRCHeapObject.getRefTarget().get(n)).getCount()) : ++n8;
                                ++n;
                            }
                        } else {
                            n7 = tRCHeapObject.getRefOwner().size();
                            n = 0;
                            while (n < n7) {
                                n8 = tRCHeapObject.getRefOwner().get(n) instanceof TRCAggregatedObjectReference ? (n8 += ((TRCAggregatedObjectReference)tRCHeapObject.getRefOwner().get(n)).getCount()) : ++n8;
                                ++n;
                            }
                        }
                        n7 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            n = tRCHeapObject2.getRefTarget().size();
                            int n9 = 0;
                            while (n9 < n) {
                                n7 = tRCHeapObject2.getRefTarget().get(n9) instanceof TRCAggregatedObjectReference ? (n7 += ((TRCAggregatedObjectReference)tRCHeapObject2.getRefTarget().get(n9)).getCount()) : ++n7;
                                ++n9;
                            }
                        } else {
                            n = tRCHeapObject2.getRefOwner().size();
                            int n10 = 0;
                            while (n10 < n) {
                                n7 = tRCHeapObject2.getRefOwner().get(n10) instanceof TRCAggregatedObjectReference ? (n7 += ((TRCAggregatedObjectReference)tRCHeapObject2.getRefOwner().get(n10)).getCount()) : ++n7;
                                ++n10;
                            }
                        }
                        return this._sortSequence * (n8 - n7);
                    }
                }
            } else {
                TRCObjectReference tRCObjectReference = (TRCObjectReference)object;
                TRCObjectReference tRCObjectReference2 = (TRCObjectReference)object2;
                switch (this._pos) {
                    case 0: {
                        TRCHeapObject tRCHeapObject = tRCObjectReference.getTarget();
                        tRCHeapObject = ReferenceTable.this.showReferTo() ? tRCObjectReference.getOwner() : tRCObjectReference.getTarget();
                        TRCClass tRCClass = PerftraceUtil.getClass((TRCObject)tRCHeapObject);
                        String string = tRCClass.getName();
                        string = tRCClass == tRCHeapObject.getProcess().getClassClass() ? tRCClass.getName() : tRCClass.getName() + "." + tRCHeapObject.getId();
                        tRCHeapObject = tRCObjectReference2.getTarget();
                        tRCHeapObject = ReferenceTable.this.showReferTo() ? tRCObjectReference2.getOwner() : tRCObjectReference2.getTarget();
                        tRCClass = PerftraceUtil.getClass((TRCObject)tRCHeapObject);
                        String string4 = tRCClass.getName();
                        string4 = tRCClass == tRCHeapObject.getProcess().getClassClass() ? tRCClass.getName() : tRCClass.getName() + "." + tRCHeapObject.getId();
                        return this._sortSequence * string.compareToIgnoreCase(string4);
                    }
                    case 1: {
                        TRCHeapObject tRCHeapObject = tRCObjectReference.getTarget();
                        tRCHeapObject = ReferenceTable.this.showReferTo() ? tRCObjectReference.getOwner() : tRCObjectReference.getTarget();
                        String string = PerftraceUtil.getClass((TRCObject)tRCHeapObject).getPackage().getName();
                        tRCHeapObject = tRCObjectReference2.getTarget();
                        tRCHeapObject = ReferenceTable.this.showReferTo() ? tRCObjectReference2.getOwner() : tRCObjectReference2.getTarget();
                        String string5 = PerftraceUtil.getClass((TRCObject)tRCHeapObject).getPackage().getName();
                        return this._sortSequence * string.compareToIgnoreCase(string5);
                    }
                    case 2: {
                        int n = 0;
                        int n11 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            Object[] objectArray = tRCObjectReference.getOwner().getRefTarget().toArray();
                            int n12 = 0;
                            while (n12 < objectArray.length) {
                                TRCObjectReference tRCObjectReference3 = (TRCObjectReference)objectArray[n12];
                                n = tRCObjectReference3 instanceof TRCAggregatedObjectReference ? (n += ((TRCAggregatedObjectReference)tRCObjectReference3).getTargetSize()) : (n += tRCObjectReference3.getTarget().getSize());
                                ++n12;
                            }
                            objectArray = tRCObjectReference2.getOwner().getRefTarget().toArray();
                            int n13 = 0;
                            while (n13 < objectArray.length) {
                                TRCObjectReference tRCObjectReference4 = (TRCObjectReference)objectArray[n13];
                                n11 = tRCObjectReference4 instanceof TRCAggregatedObjectReference ? (n11 += ((TRCAggregatedObjectReference)tRCObjectReference4).getTargetSize()) : (n11 += tRCObjectReference4.getTarget().getSize());
                                ++n13;
                            }
                        } else {
                            Object[] objectArray = tRCObjectReference.getTarget().getRefOwner().toArray();
                            int n14 = 0;
                            while (n14 < objectArray.length) {
                                TRCObjectReference tRCObjectReference5 = (TRCObjectReference)objectArray[n14];
                                n = tRCObjectReference5 instanceof TRCAggregatedObjectReference ? (n += ((TRCAggregatedObjectReference)tRCObjectReference5).getOwnerSize()) : (n += tRCObjectReference5.getOwner().getSize());
                                ++n14;
                            }
                            objectArray = tRCObjectReference2.getTarget().getRefOwner().toArray();
                            int n15 = 0;
                            while (n15 < objectArray.length) {
                                TRCObjectReference tRCObjectReference6 = (TRCObjectReference)objectArray[n15];
                                n11 = tRCObjectReference6 instanceof TRCAggregatedObjectReference ? (n11 += ((TRCAggregatedObjectReference)tRCObjectReference6).getOwnerSize()) : (n11 += tRCObjectReference6.getOwner().getSize());
                                ++n15;
                            }
                        }
                        return this._sortSequence * (n - n11);
                    }
                    case 3: {
                        int n;
                        int n16;
                        int n17 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            n16 = tRCObjectReference.getOwner().getRefTarget().size();
                            n = 0;
                            while (n < n16) {
                                n17 = tRCObjectReference.getOwner().getRefTarget().get(n) instanceof TRCAggregatedObjectReference ? (n17 += ((TRCAggregatedObjectReference)tRCObjectReference.getOwner().getRefTarget().get(n)).getCount()) : ++n17;
                                ++n;
                            }
                        } else {
                            n16 = tRCObjectReference.getTarget().getRefOwner().size();
                            n = 0;
                            while (n < n16) {
                                n17 = tRCObjectReference.getTarget().getRefOwner().get(n) instanceof TRCAggregatedObjectReference ? (n17 += ((TRCAggregatedObjectReference)tRCObjectReference.getTarget().getRefOwner().get(n)).getCount()) : ++n17;
                                ++n;
                            }
                        }
                        n16 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            n = tRCObjectReference2.getOwner().getRefTarget().size();
                            int n18 = 0;
                            while (n18 < n) {
                                n16 = tRCObjectReference2.getOwner().getRefTarget().get(n18) instanceof TRCAggregatedObjectReference ? (n16 += ((TRCAggregatedObjectReference)tRCObjectReference2.getOwner().getRefTarget().get(n18)).getCount()) : ++n16;
                                ++n18;
                            }
                        } else {
                            n = tRCObjectReference2.getTarget().getRefOwner().size();
                            int n19 = 0;
                            while (n19 < n) {
                                n16 = tRCObjectReference2.getTarget().getRefOwner().get(n19) instanceof TRCAggregatedObjectReference ? (n16 += ((TRCAggregatedObjectReference)tRCObjectReference2.getTarget().getRefOwner().get(n19)).getCount()) : ++n16;
                                ++n19;
                            }
                        }
                        return this._sortSequence * (n17 - n16);
                    }
                    case 4: {
                        if (!(tRCObjectReference instanceof TRCAggregatedObjectReference) || !(tRCObjectReference2 instanceof TRCAggregatedObjectReference)) break;
                        return this._sortSequence * (((TRCAggregatedObjectReference)tRCObjectReference).getCount() - ((TRCAggregatedObjectReference)tRCObjectReference2).getCount());
                    }
                }
            }
            return 0;
        }
    }

    public class ClassStatisticFilter
    extends StatisticView.StatisticFilter {
        public ClassStatisticFilter() {
            super(ReferenceTable.this);
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = true;
            if (!(object2 instanceof TRCClass)) {
                return true;
            }
            String string = "";
            if (this._noPattern) {
                return true;
            }
            if (object2 instanceof TRCClass) {
                string = ((TRCClass)object2).getName();
            }
            if (!this._caseSensitive) {
                string = string.toLowerCase();
            }
            if (this._exactMatch) {
                return string.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                bl = string.startsWith(this._prefix);
            }
            if (bl && this._suffix != "") {
                bl = string.endsWith(this._suffix);
            }
            if (bl) {
                int n = 0;
                while (n < this._textList.size()) {
                    String string2 = (String)this._textList.get(n);
                    int n2 = string.lastIndexOf(string2);
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    string = string.substring(n2 + string2.length());
                    ++n;
                }
            }
            return bl;
        }
    }
}

