/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.formatters;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.ICBEPropertyConstants;
import org.eclipse.hyades.logging.adapter.IDirectedGraph;
import org.eclipse.hyades.logging.adapter.IFormatter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;

public class CBEFormatter
extends ProcessUnit
implements IFormatter,
ICBEPropertyConstants {
    private static final String BUILTIN = "##BUILTIN";
    private static EventFactory eventFactory = new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.adapter.formatters.CBEFormatter");
    private String localHostId = null;
    private String localHostIdFormat = null;
    private static final String HOST_ID_FORMAT_IPV4 = "IPV4";
    private static final String HOST_ID_FORMAT_IPV6 = "IPV6";
    private static final String NONE = "None";
    private static final String UNKNOWN_HOST = "Unknown Host";

    public Object[] processEventItems(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        return this.processDirectedGraphs(objectArray);
    }

    private CommonBaseEvent[] processDirectedGraphs(Object[] objectArray) {
        CommonBaseEvent[] commonBaseEventArray = new CommonBaseEvent[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            Iterator iterator = ((List)objectArray[n]).iterator();
            CommonBaseEvent commonBaseEvent = eventFactory.createCommonBaseEvent();
            commonBaseEvent.setGlobalInstanceId(Guid.generate());
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                IDirectedGraph iDirectedGraph = (IDirectedGraph)iterator.next();
                List list = iDirectedGraph.getPath();
                try {
                    Object object3;
                    if (((String)list.get(0)).equals("CommonBaseEvent")) {
                        ExtendedDataElement extendedDataElement;
                        String string;
                        Object object4;
                        if (((String)list.get(2)).equals("extensionName")) {
                            commonBaseEvent.setExtensionName((String)iDirectedGraph.getValue());
                            continue;
                        }
                        if (((String)list.get(2)).equals("localInstanceId")) {
                            object3 = (String)iDirectedGraph.getValue();
                            if (((String)object3).equals(BUILTIN)) {
                                object3 = this.getLocalHostId() + System.currentTimeMillis() + Integer.toString(objectArray[n].hashCode());
                            }
                            commonBaseEvent.setLocalInstanceId((String)object3);
                            continue;
                        }
                        if (((String)list.get(2)).equals("globalInstanceId")) {
                            object3 = (String)iDirectedGraph.getValue();
                            if (((String)object3).equals(BUILTIN)) {
                                object3 = new Guid().toString();
                            }
                            commonBaseEvent.setGlobalInstanceId((String)object3);
                            continue;
                        }
                        if (((String)list.get(2)).equals("creationTime")) {
                            try {
                                object3 = (String)iDirectedGraph.getValue();
                                commonBaseEvent.setCreationTime((String)object3);
                                continue;
                            }
                            catch (ClassCastException classCastException) {
                                object2 = (Long)iDirectedGraph.getValue();
                                commonBaseEvent.setCreationTimeAsLong(((Long)object2).longValue());
                                continue;
                            }
                            catch (Exception exception) {
                                throw exception;
                            }
                        }
                        if (((String)list.get(2)).equals("severity")) {
                            commonBaseEvent.setSeverity(Short.parseShort((String)iDirectedGraph.getValue()));
                            continue;
                        }
                        if (((String)list.get(2)).equals("priority")) {
                            commonBaseEvent.setPriority(Short.parseShort((String)iDirectedGraph.getValue()));
                            continue;
                        }
                        if (((String)list.get(2)).equals("msg")) {
                            object3 = (String)iDirectedGraph.getValue();
                            int n2 = ((String)object3).length() / 1024;
                            if (n2 == 0) {
                                commonBaseEvent.setMsg((String)object3);
                                continue;
                            }
                            commonBaseEvent.setMsg(((String)object3).substring(0, 1024));
                            int n3 = 0;
                            while (n3 < n2) {
                                int n4 = 1024 * n3;
                                object4 = ((String)object3).substring(n4, n4 + 1024);
                                string = "message_" + n3;
                                extendedDataElement = (ExtendedDataElement)hashMap.get(string);
                                if (extendedDataElement == null) {
                                    extendedDataElement = eventFactory.createExtendedDataElement();
                                    commonBaseEvent.addExtendedDataElement(extendedDataElement);
                                    hashMap.put(string, extendedDataElement);
                                }
                                extendedDataElement.setName(string);
                                extendedDataElement.setType("string");
                                extendedDataElement.setValues(new String[]{object4});
                                ++n3;
                            }
                            continue;
                        }
                        if (((String)list.get(2)).equals("repeatCount")) {
                            commonBaseEvent.setRepeatCount(Short.parseShort((String)iDirectedGraph.getValue()));
                            continue;
                        }
                        if (((String)list.get(2)).equals("elapsedTime")) {
                            commonBaseEvent.setElapsedTime(Long.parseLong((String)iDirectedGraph.getValue()));
                            continue;
                        }
                        if (((String)list.get(2)).equals("sequenceNumber")) {
                            commonBaseEvent.setSequenceNumber(Long.parseLong((String)iDirectedGraph.getValue()));
                            continue;
                        }
                        if (((String)list.get(2)).equals("version")) {
                            commonBaseEvent.setVersion((String)iDirectedGraph.getValue());
                            continue;
                        }
                        if (((String)list.get(2)).equals("otherData")) {
                            commonBaseEvent.addAny((String)iDirectedGraph.getValue());
                            continue;
                        }
                        if (((String)list.get(2)).equals("msgDataElement")) {
                            object3 = commonBaseEvent.getMsgDataElement();
                            if (object3 == null) {
                                object3 = eventFactory.createMsgDataElement();
                                commonBaseEvent.setMsgDataElement((MsgDataElement)object3);
                            }
                            if (((String)list.get(4)).equals("msgId")) {
                                object3.setMsgId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgIdType")) {
                                object3.setMsgIdType((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgCatalogId")) {
                                object3.setMsgCatalogId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgCatalogTokens")) {
                                object2 = (String)iDirectedGraph.getValue();
                                if (object2 == null || ((String)object2).length() <= 0) continue;
                                object3.addMsgCatalogTokenAsString((String)object2);
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgCatalogType")) {
                                object3.setMsgCatalogType((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgCatalog")) {
                                object3.setMsgCatalog((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgLocale")) {
                                object3.setMsgLocale((String)iDirectedGraph.getValue());
                                continue;
                            }
                            object2 = this.getEventFactory().createCommonBaseEvent();
                            object2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_MsgDataElement_WARN_");
                            object2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(4)});
                            object2.setSeverity((short)30);
                            this.log((CommonBaseEvent)object2);
                            continue;
                        }
                        if (((String)list.get(2)).equals("contextDataElements")) {
                            object3 = (String)list.get(2) + (String)list.get(3);
                            object2 = (ContextDataElement)hashMap.get(object3);
                            if (object2 == null) {
                                object2 = eventFactory.createContextDataElement();
                                commonBaseEvent.addContextDataElement((ContextDataElement)object2);
                                hashMap.put(object3, object2);
                            }
                            if (((String)list.get(4)).equals("contextId")) {
                                if (object2.getContextValue() != null) {
                                    object = this.getEventFactory().createCommonBaseEvent();
                                    object.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ContextDataElement_WARN_");
                                    object.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(4), "contextValue"});
                                    object.setSeverity((short)30);
                                    this.log((CommonBaseEvent)object);
                                    continue;
                                }
                                object2.setContextId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("type")) {
                                object2.setType((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("name")) {
                                object2.setName((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("contextValue")) {
                                if (object2.getContextId() != null) {
                                    object = this.getEventFactory().createCommonBaseEvent();
                                    object.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ContextDataElement_WARN_");
                                    object.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(4), "contextId"});
                                    object.setSeverity((short)30);
                                    this.log((CommonBaseEvent)object);
                                    continue;
                                }
                                object2.setContextValue((String)iDirectedGraph.getValue());
                                continue;
                            }
                            object = this.getEventFactory().createCommonBaseEvent();
                            object.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ContextDataElement_WARN_");
                            object.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(4)});
                            object.setSeverity((short)30);
                            this.log((CommonBaseEvent)object);
                            continue;
                        }
                        if (((String)list.get(2)).equals("reporterComponentId") || ((String)list.get(2)).equals("sourceComponentId")) {
                            if (((String)list.get(2)).equals("reporterComponentId")) {
                                object3 = commonBaseEvent.getReporterComponentId();
                                if (object3 == null) {
                                    object3 = eventFactory.createComponentIdentification();
                                    commonBaseEvent.setReporterComponentId((ComponentIdentification)object3);
                                }
                            } else {
                                object3 = commonBaseEvent.getSourceComponentId();
                                if (object3 == null) {
                                    object3 = eventFactory.createComponentIdentification();
                                    commonBaseEvent.setSourceComponentId((ComponentIdentification)object3);
                                }
                            }
                            if (((String)list.get(4)).equals("location")) {
                                object2 = (String)iDirectedGraph.getValue();
                                if (((String)object2).equals(BUILTIN)) {
                                    object2 = this.getLocalHostId();
                                }
                                object3.setLocation((String)object2);
                                continue;
                            }
                            if (((String)list.get(4)).equals("locationType")) {
                                object2 = (String)iDirectedGraph.getValue();
                                if (((String)object2).equals(BUILTIN)) {
                                    object2 = this.getLocalHostIdFormat();
                                }
                                object3.setLocationType((String)object2);
                                continue;
                            }
                            if (((String)list.get(4)).equals("application")) {
                                object3.setApplication((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("executionEnvironment")) {
                                object3.setExecutionEnvironment((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("component")) {
                                object3.setComponent((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("subComponent")) {
                                object3.setSubComponent((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("componentIdType")) {
                                object3.setComponentIdType((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("componentType")) {
                                object3.setComponentType((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("instanceId")) {
                                object3.setInstanceId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("processId")) {
                                object3.setProcessId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("threadId")) {
                                object3.setThreadId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            object2 = this.getEventFactory().createCommonBaseEvent();
                            object2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ComponentIdentification_WARN_");
                            object2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(4)});
                            object2.setSeverity((short)30);
                            this.log((CommonBaseEvent)object2);
                            continue;
                        }
                        if (((String)list.get(2)).equals("situation")) {
                            object3 = commonBaseEvent.getSituation();
                            if (object3 == null) {
                                object3 = eventFactory.createSituation();
                                commonBaseEvent.setSituation((Situation)object3);
                            }
                            if (((String)list.get(4)).equals("categoryName")) {
                                object3.setCategoryName((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("situationType")) {
                                if (((String)list.get(6)).equals("AvailableSituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createAvailableSituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof AvailableSituation) {
                                        object2 = (AvailableSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("operationDisposition")) {
                                        object2.setOperationDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("processingDisposition")) {
                                        object2.setProcessingDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("availabilityDisposition")) {
                                        object2.setAvailabilityDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent2 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_AvailableSituation_WARN_");
                                    commonBaseEvent2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent2.setSeverity((short)30);
                                    this.log(commonBaseEvent2);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("RequestSituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createRequestSituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof RequestSituation) {
                                        object2 = (RequestSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("situationQualifier")) {
                                        object2.setSituationQualifier((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent3 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_RequestSituation_WARN_");
                                    commonBaseEvent3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent3.setSeverity((short)30);
                                    this.log(commonBaseEvent3);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("StartSituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createStartSituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof StartSituation) {
                                        object2 = (StartSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("situationQualifier")) {
                                        object2.setSituationQualifier((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent4 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent4.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_StartSituation_WARN_");
                                    commonBaseEvent4.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent4.setSeverity((short)30);
                                    this.log(commonBaseEvent4);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("StopSituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createStopSituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof StopSituation) {
                                        object2 = (StopSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("situationQualifier")) {
                                        object2.setSituationQualifier((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent5 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent5.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_StopSituation_WARN_");
                                    commonBaseEvent5.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent5.setSeverity((short)30);
                                    this.log(commonBaseEvent5);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("ConnectSituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createConnectSituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof ConnectSituation) {
                                        object2 = (ConnectSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("situationDisposition")) {
                                        object2.setSituationDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent6 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent6.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ConnectSituation_WARN_");
                                    commonBaseEvent6.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent6.setSeverity((short)30);
                                    this.log(commonBaseEvent6);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("ConfigureSituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createConfigureSituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof ConfigureSituation) {
                                        object2 = (ConfigureSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent7 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent7.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ConfigureSituation_WARN_");
                                    commonBaseEvent7.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent7.setSeverity((short)30);
                                    this.log(commonBaseEvent7);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("CreateSituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createCreateSituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof CreateSituation) {
                                        object2 = (CreateSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent8 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent8.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_CreateSituation_WARN_");
                                    commonBaseEvent8.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent8.setSeverity((short)30);
                                    this.log(commonBaseEvent8);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("DestroySituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createDestroySituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof DestroySituation) {
                                        object2 = (DestroySituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent9 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent9.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_CreateSituation_WARN_");
                                    commonBaseEvent9.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent9.setSeverity((short)30);
                                    this.log(commonBaseEvent9);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("ReportSituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createReportSituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof ReportSituation) {
                                        object2 = (ReportSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("reportCategory")) {
                                        object2.setReportCategory((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent10 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent10.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ReportSituation_WARN_");
                                    commonBaseEvent10.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent10.setSeverity((short)30);
                                    this.log(commonBaseEvent10);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("FeatureSituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createFeatureSituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof FeatureSituation) {
                                        object2 = (FeatureSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("featureDisposition")) {
                                        object2.setFeatureDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent11 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent11.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_FeatureSituation_WARN_");
                                    commonBaseEvent11.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent11.setSeverity((short)30);
                                    this.log(commonBaseEvent11);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("DependencySituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createDependencySituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof DependencySituation) {
                                        object2 = (DependencySituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("dependencyDisposition")) {
                                        object2.setDependencyDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent12 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent12.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_DependencySituation_WARN_");
                                    commonBaseEvent12.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent12.setSeverity((short)30);
                                    this.log(commonBaseEvent12);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("OtherSituation")) {
                                    object2 = null;
                                    object = object3.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createOtherSituation();
                                        object3.setSituationType((SituationType)object2);
                                    } else if (object instanceof OtherSituation) {
                                        object2 = (OtherSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("anyData")) {
                                        object2.setAny((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    CommonBaseEvent commonBaseEvent13 = this.getEventFactory().createCommonBaseEvent();
                                    commonBaseEvent13.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_DependencySituation_WARN_");
                                    commonBaseEvent13.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(8)});
                                    commonBaseEvent13.setSeverity((short)30);
                                    this.log(commonBaseEvent13);
                                    continue;
                                }
                                object2 = this.getEventFactory().createCommonBaseEvent();
                                object2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_SituationType_WARN_");
                                object2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(6)});
                                object2.setSeverity((short)30);
                                this.log((CommonBaseEvent)object2);
                                continue;
                            }
                            object2 = this.getEventFactory().createCommonBaseEvent();
                            object2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Situation_WARN_");
                            object2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(4)});
                            object2.setSeverity((short)30);
                            this.log((CommonBaseEvent)object2);
                            continue;
                        }
                        if (((String)list.get(2)).startsWith("associatedEvents")) {
                            object3 = (String)list.get(2) + (String)list.get(3);
                            object2 = (AssociatedEvent)hashMap.get(object3);
                            if (object2 == null) {
                                object2 = eventFactory.createAssociatedEvent();
                                commonBaseEvent.addAssociatedEvent((AssociatedEvent)object2);
                                hashMap.put(object3, object2);
                            }
                            if (((String)list.get(4)).equals("associationEngine")) {
                                object = this.getEventFactory().createCommonBaseEvent();
                                object.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociatedEvent_WARN_");
                                object.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(4)});
                                object.setSeverity((short)30);
                                this.log((CommonBaseEvent)object);
                                continue;
                            }
                            if (((String)list.get(4)).equals("associationEngineInfo")) {
                                object = object2.getAssociationEngineInfo();
                                if (object == null) {
                                    object = eventFactory.createAssociationEngine();
                                    object.setId(Guid.generate());
                                    object2.setAssociationEngineInfo((AssociationEngine)object);
                                }
                                if (((String)list.get(6)).equals("id")) {
                                    object.setId((String)iDirectedGraph.getValue());
                                    continue;
                                }
                                if (((String)list.get(6)).equals("name")) {
                                    object.setName((String)iDirectedGraph.getValue());
                                    continue;
                                }
                                if (((String)list.get(6)).equals("type")) {
                                    object.setType((String)iDirectedGraph.getValue());
                                    continue;
                                }
                                CommonBaseEvent commonBaseEvent14 = this.getEventFactory().createCommonBaseEvent();
                                commonBaseEvent14.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociationEngine_WARN_");
                                commonBaseEvent14.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(6)});
                                commonBaseEvent14.setSeverity((short)30);
                                this.log(commonBaseEvent14);
                                continue;
                            }
                            if (((String)list.get(4)).equals("resolvedEvent")) {
                                object2.addResolvedEvent((String)iDirectedGraph.getValue());
                                continue;
                            }
                            object = this.getEventFactory().createCommonBaseEvent();
                            object.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociatedEvent_WARN_");
                            object.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(4)});
                            object.setSeverity((short)30);
                            this.log((CommonBaseEvent)object);
                            continue;
                        }
                        if (((String)list.get(2)).startsWith("extendedDataElements")) {
                            object3 = (String)list.get(2) + (String)list.get(3);
                            object2 = (ExtendedDataElement)hashMap.get(object3);
                            if (object2 == null) {
                                object2 = eventFactory.createExtendedDataElement();
                                commonBaseEvent.addExtendedDataElement((ExtendedDataElement)object2);
                                hashMap.put(object3, object2);
                            }
                            object = (String)list.get(4);
                            int n5 = 4;
                            while (object != null) {
                                if (((String)object).equals("name")) {
                                    object2.setName((String)iDirectedGraph.getValue());
                                    object = null;
                                    continue;
                                }
                                if (((String)object).equals("type")) {
                                    object2.setType((String)iDirectedGraph.getValue());
                                    object = null;
                                    continue;
                                }
                                if (((String)object).equals("values")) {
                                    object4 = new CommonBaseEvent[]{(String)iDirectedGraph.getValue()};
                                    object2.setValues((String[])object4);
                                    object = null;
                                    continue;
                                }
                                if (((String)object).equals("hexValue")) {
                                    if (object2.getValues() != null) {
                                        object4 = this.getEventFactory().createCommonBaseEvent();
                                        object4.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ExtendedDataElement_WARN_");
                                        object4.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), object, "values"});
                                        object4.setSeverity((short)30);
                                        this.log((CommonBaseEvent)object4);
                                    } else {
                                        object2.setHexValueAsCharArray((char[])iDirectedGraph.getValue());
                                    }
                                    object = null;
                                    continue;
                                }
                                if (((String)object).equals("children")) {
                                    object4 = (String)list.get(++n5);
                                    string = object2.getChildren();
                                    if (string == null) {
                                        extendedDataElement = eventFactory.createExtendedDataElement();
                                        extendedDataElement.setName((String)object4);
                                        object2.addChild(extendedDataElement);
                                        object2 = extendedDataElement;
                                    } else {
                                        extendedDataElement = null;
                                        int n6 = 0;
                                        while (n6 < string.size()) {
                                            if (((ExtendedDataElement)string.get(n6)).getName().equals(object4)) {
                                                extendedDataElement = (ExtendedDataElement)string.get(n6);
                                            }
                                            ++n6;
                                        }
                                        if (extendedDataElement == null) {
                                            extendedDataElement = eventFactory.createExtendedDataElement();
                                            extendedDataElement.setName((String)object4);
                                            object2.addChild(extendedDataElement);
                                        }
                                        object2 = extendedDataElement;
                                    }
                                    object = (String)list.get(n5 += 2);
                                    continue;
                                }
                                object4 = this.getEventFactory().createCommonBaseEvent();
                                object4.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_ExtendedDataElement_WARN_");
                                object4.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), object});
                                object4.setSeverity((short)30);
                                this.log((CommonBaseEvent)object4);
                                object = null;
                            }
                            continue;
                        }
                        object3 = this.getEventFactory().createCommonBaseEvent();
                        object3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_CommmonBaseEvent_WARN_");
                        object3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(2)});
                        object3.setSeverity((short)30);
                        this.log((CommonBaseEvent)object3);
                        continue;
                    }
                    object3 = this.getEventFactory().createCommonBaseEvent();
                    object3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Property_WARN_");
                    object3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(0)});
                    object3.setSeverity((short)30);
                    this.log((CommonBaseEvent)object3);
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = this.getEventFactory().createCommonBaseEvent();
                    object2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Non_Numeric_Property_WARN_");
                    object2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(2)});
                    object2.setSeverity((short)30);
                    this.log((CommonBaseEvent)object2);
                }
                catch (Exception exception) {
                    object = this.getEventFactory().createCommonBaseEvent();
                    object.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Exception_WARN_");
                    object.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)list.get(2), exception.getMessage()});
                    object.setSeverity((short)30);
                    this.log((CommonBaseEvent)object);
                }
            }
            commonBaseEventArray[n] = commonBaseEvent;
            ++n;
        }
        return commonBaseEventArray;
    }

    public Object[] testProcessEventItems(Object[] objectArray) throws AdapterInvalidConfig {
        return this.testProcessDirectedGraphs(objectArray);
    }

    private CommonBaseEvent[] testProcessDirectedGraphs(Object[] objectArray) throws AdapterInvalidConfig {
        if (!(objectArray[0] instanceof List)) {
            throw new AdapterInvalidConfig("This formatter will only accept arrays of Lists");
        }
        CommonBaseEvent[] commonBaseEventArray = new CommonBaseEvent[]{eventFactory.createCommonBaseEvent()};
        return commonBaseEventArray;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
    }

    private void getLocalHostInfo() {
        block3: {
            try {
                this.localHostId = InetAddress.getLocalHost().getHostAddress();
                if (this.localHostId.indexOf(58) != -1) {
                    this.localHostIdFormat = HOST_ID_FORMAT_IPV6;
                    break block3;
                }
                this.localHostIdFormat = HOST_ID_FORMAT_IPV4;
            }
            catch (Exception exception) {
                this.localHostId = UNKNOWN_HOST;
                this.localHostIdFormat = NONE;
            }
        }
    }

    private String getLocalHostId() {
        if (this.localHostId == null) {
            this.getLocalHostInfo();
        }
        return this.localHostId;
    }

    private String getLocalHostIdFormat() {
        if (this.localHostIdFormat == null) {
            this.getLocalHostInfo();
        }
        return this.localHostIdFormat;
    }
}

