/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.impl.TemplateContentHandlerImpl;

public class RuntimeTemplateContentHandlerImpl
extends TemplateContentHandlerImpl {
    private static String localHostIP = null;

    public void completeEvent(CommonBaseEvent commonBaseEvent) throws CompletionException {
        if (commonBaseEvent != null && !commonBaseEvent.isComplete()) {
            MsgDataElement msgDataElement;
            ComponentIdentification componentIdentification;
            super.completeEvent(commonBaseEvent);
            if (commonBaseEvent.getGlobalInstanceId() == null) {
                commonBaseEvent.setGlobalInstanceId(Guid.generate());
            }
            if (!commonBaseEvent.isSetCreationTime()) {
                commonBaseEvent.setCreationTimeAsLong(System.currentTimeMillis());
            }
            if ((componentIdentification = commonBaseEvent.getSourceComponentId()) != null) {
                if (componentIdentification.getThreadId() == null) {
                    componentIdentification.setThreadId(Thread.currentThread().getName());
                }
                if (componentIdentification.getLocation() == null && componentIdentification.getLocationType() == null) {
                    componentIdentification.setLocation(localHostIP);
                    componentIdentification.setLocationType("IPV4");
                }
            }
            if ((msgDataElement = commonBaseEvent.getMsgDataElement()) != null && msgDataElement.getMsgLocale() == null) {
                Locale locale = Locale.getDefault();
                msgDataElement.setMsgLocale(locale.getLanguage().concat("-").concat(locale.getCountry()));
            }
        }
    }

    static {
        try {
            localHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            localHostIP = "127.0.0.1";
        }
    }
}

