/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.w3c.dom.Element;

public class CBELogOutputter
extends Outputter
implements IOutputter {
    private LoggingAgent cbelogger = null;
    private static String defaultAgentName = "GenericAdapterCBELogger";
    private String agentName = null;
    private long waitTime = 0L;

    public Object[] processEventItems(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return this.processCBEs((CommonBaseEvent[])objectArray);
    }

    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] commonBaseEventArray) {
        if (commonBaseEventArray.length > 0 && !this.cbelogger.isLogging() && this.getWaitTime() > 0L) {
            CommonBaseEvent commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
            commonBaseEvent.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Waiting_INFO_");
            commonBaseEvent.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName()});
            commonBaseEvent.setSeverity((short)10);
            this.log(commonBaseEvent);
            while (!this.cbelogger.waitUntilLogging(this.getWaitTime())) {
                commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
                commonBaseEvent.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Waiting_INFO_");
                commonBaseEvent.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName()});
                commonBaseEvent.setSeverity((short)10);
                this.log(commonBaseEvent);
            }
        }
        int n = 0;
        while (n < commonBaseEventArray.length) {
            if (commonBaseEventArray[n] != null) {
                try {
                    this.cbelogger.write(EventFormatter.toCanonicalXMLString((CommonBaseEvent)commonBaseEventArray[n], (boolean)false));
                }
                catch (Exception exception) {
                    CommonBaseEvent commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
                    commonBaseEvent.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Write_ERROR_");
                    commonBaseEvent.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName()});
                    commonBaseEvent.setSeverity((short)60);
                    this.log(commonBaseEvent);
                }
            }
            ++n;
        }
        return commonBaseEventArray;
    }

    public Object[] testProcessEventItems(Object[] objectArray) throws AdapterInvalidConfig {
        if (!(objectArray instanceof CommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of CommonBaseEvent");
        }
        return this.testProcessCBEs((CommonBaseEvent[])objectArray);
    }

    private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] commonBaseEventArray) {
        return commonBaseEventArray;
    }

    public void update() throws AdapterInvalidConfig {
        Object object;
        super.update();
        Element element = this.getConfiguration();
        Element element2 = null;
        String string = null;
        Object var5_4 = null;
        Hashtable hashtable = this.getProperties();
        if (hashtable != null && !hashtable.isEmpty()) {
            string = (String)hashtable.get(Messages.getString("HyadesGAwaitTimeAttributeName"));
            if (string != null && string.length() > 0) {
                this.setWaitTime(Long.valueOf(string));
            }
            this.setAgentName((String)hashtable.get(Messages.getString("HyadesGAagentNameAttributeName")));
        } else {
            object = element.getChildNodes();
            int n = 0;
            while (n < object.getLength()) {
                Element element3;
                if (object.item(n).getNodeType() == 1 && (element3 = (Element)object.item(n)).getTagName().equals(Messages.getString("HyadesGALogOutputterTypeTagName"))) {
                    String string2;
                    element2 = element3;
                    if (element2.hasAttribute(Messages.getString("HyadesGAwaitTimeAttributeName")) && (string2 = element2.getAttribute(Messages.getString("HyadesGAwaitTimeAttributeName"))) != null && !string2.equals("")) {
                        this.setWaitTime(Long.valueOf(string2));
                    }
                    if (element2.hasAttribute(Messages.getString("HyadesGAagentNameAttributeName"))) {
                        this.setAgentName(element2.getAttribute(Messages.getString("HyadesGAagentNameAttributeName")));
                    }
                }
                ++n;
            }
        }
        if (this.cbelogger == null) {
            object = this.getAgentName() == null ? defaultAgentName : this.getAgentName();
            this.cbelogger = new LoggingAgent((String)object);
        }
    }

    public void setAgentName(String string) {
        this.agentName = string;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setWaitTime(long l) {
        this.waitTime = l;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void stop() {
        this.cbelogger.deregister();
    }
}

