/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.IDirectedGraph;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.parsers.DirectedGraphImpl;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.Parser;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.parsers.SubstituteStatement;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttributeStatement
implements IStatement {
    private IParser parser;
    List substitutions;
    private String name;
    private String defaultValue;
    private boolean usePreviousMatchSubstitutionAsDefault = false;
    private IDirectedGraph previousMatch = null;

    public AttributeStatement() {
    }

    public AttributeStatement(IParser iParser) {
        this.parser = iParser;
    }

    public void prepare(Element element, String string) throws PreparationException {
        String string2;
        this.name = string == null ? element.getAttribute(Messages.getString("HyadesGANameAttributeName")) : string + "." + element.getAttribute(Messages.getString("HyadesGANameAttributeName"));
        String string3 = element.getAttribute(Messages.getString("HyadesGAIndexAttributeName"));
        if (string3 != null && !string3.equals("")) {
            this.name = this.name + "[" + string3 + "]";
        }
        this.defaultValue = element.getAttribute(Messages.getString("HyadesGAdefaultValueAttributeName"));
        if (this.defaultValue == null || this.defaultValue.equals("")) {
            this.defaultValue = null;
        }
        this.usePreviousMatchSubstitutionAsDefault = (string2 = element.getAttribute(Messages.getString("HyadesGAUsePreviousMatchSubstitutionAsDefault"))) != null && !string2.equals("") && !string2.equals("false");
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n > 0) {
            this.substitutions = new ArrayList();
            int n2 = 0;
            while (n2 < n) {
                block13: {
                    Element element2 = null;
                    try {
                        element2 = (Element)nodeList.item(n2);
                    }
                    catch (ClassCastException classCastException) {
                        break block13;
                    }
                    if (element2.getNodeName().endsWith(Messages.getString("HyadesGASubstitutionRuleTagName"))) {
                        SubstituteStatement substituteStatement = new SubstituteStatement();
                        try {
                            substituteStatement.prepare(element2, this.name);
                            this.substitutions.add(substituteStatement);
                        }
                        catch (PreparationException preparationException) {
                            if (this.parser != null && this.parser instanceof Parser) {
                                CommonBaseEvent commonBaseEvent = ((Parser)this.parser).getEventFactory().createCommonBaseEvent();
                                if (preparationException.getDetails() != null) {
                                    commonBaseEvent.setMsg(preparationException.getMessage() + " " + preparationException.getDetails());
                                } else {
                                    commonBaseEvent.setMsg(preparationException.getMessage());
                                }
                                commonBaseEvent.setSeverity((short)50);
                                ExtendedDataElement extendedDataElement = ((Parser)this.parser).getEventFactory().createExtendedDataElement();
                                extendedDataElement.setName("EXCEPTION DETAILS");
                                extendedDataElement.setType("string");
                                extendedDataElement.setValues(new String[]{preparationException.getLocalizedMessage()});
                                commonBaseEvent.addExtendedDataElement(extendedDataElement);
                                extendedDataElement = ((Parser)this.parser).getEventFactory().createExtendedDataElement();
                                extendedDataElement.setName("PATH");
                                extendedDataElement.setType("string");
                                extendedDataElement.setValues(new String[]{preparationException.getDigraph()});
                                commonBaseEvent.addExtendedDataElement(extendedDataElement);
                                this.parser.log(commonBaseEvent);
                            }
                            throw preparationException;
                        }
                    }
                }
                ++n2;
            }
            if (this.substitutions.isEmpty()) {
                this.substitutions = null;
            }
        }
    }

    public boolean run(String string, HashMap hashMap, List list) throws AdapterException {
        if (this.substitutions != null) {
            ListIterator listIterator = this.substitutions.listIterator();
            SubstituteStatement substituteStatement = null;
            while (listIterator.hasNext()) {
                substituteStatement = (SubstituteStatement)listIterator.next();
                if (!substituteStatement.run(string, hashMap, list)) continue;
                if (this.usePreviousMatchSubstitutionAsDefault) {
                    this.previousMatch = substituteStatement.getResultGraph();
                }
                return true;
            }
            if (this.usePreviousMatchSubstitutionAsDefault && this.previousMatch != null) {
                list.add(this.previousMatch);
                return true;
            }
            if (this.defaultValue != null) {
                list.add(substituteStatement.createResultGraph(this.defaultValue));
                return true;
            }
        } else if (this.defaultValue != null) {
            DirectedGraphImpl directedGraphImpl = new DirectedGraphImpl();
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(this.name, ".");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(91);
                if (n > 0) {
                    String string3 = string2.substring(n + 1, string2.length() - 1);
                    string2 = string2.substring(0, n);
                    arrayList.add(string2);
                    arrayList.add(string3);
                    continue;
                }
                arrayList.add(string2);
            }
            directedGraphImpl.setPath(arrayList);
            directedGraphImpl.setValue(this.defaultValue);
            list.add(directedGraphImpl);
            return true;
        }
        return false;
    }
}

