/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.parsers.AttributeStatement;
import org.eclipse.hyades.logging.adapter.parsers.GroupStatement;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Parser
extends ProcessUnit
implements IParser {
    protected List ruleSets;
    protected String separatorToken;
    protected Pattern separatorPattern;
    protected String designationToken;
    protected Pattern designationPattern;

    public void update() throws AdapterInvalidConfig {
        super.update();
        Element element = this.getConfiguration();
        if (!element.getNodeName().equals(Messages.getString("HyadesGAParserTagName"))) {
            throw new AdapterInvalidConfig("cc:Parser expected to contain parsing rules");
        }
        NodeList nodeList = element.getChildNodes();
        this.separatorToken = element.getAttribute(Messages.getString("HyadesGASeparatorTokenAttributeName"));
        this.designationToken = element.getAttribute(Messages.getString("HyadesGADesignationTokenName"));
        if (this.separatorToken != null && !this.separatorToken.equals("")) {
            this.compileSeparatorToken(this.separatorToken);
        }
        if (this.designationToken != null && !this.designationToken.equals("")) {
            this.compileDesignationToken(this.designationToken);
        }
        this.prepareRules(nodeList);
    }

    protected void compileSeparatorToken(String string) throws PreparationException {
        try {
            this.separatorPattern = Pattern.compile(string, 8);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new PreparationException(patternSyntaxException);
        }
    }

    protected void compileDesignationToken(String string) throws PreparationException {
        try {
            this.designationPattern = Pattern.compile(string, 8);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new PreparationException(patternSyntaxException);
        }
    }

    protected void prepareRules(NodeList nodeList) throws AdapterInvalidConfig {
        int n = nodeList.getLength();
        if (n > 0) {
            this.ruleSets = new ArrayList();
            int n2 = 0;
            while (n2 < n) {
                block13: {
                    Element element = null;
                    try {
                        element = (Element)nodeList.item(n2);
                    }
                    catch (ClassCastException classCastException) {
                        break block13;
                    }
                    if (element != null) {
                        IStatement iStatement = null;
                        if (element.getNodeName().endsWith(Messages.getString("HyadesGARuleElementTagName"))) {
                            iStatement = new GroupStatement(this);
                        } else if (element.getNodeName().endsWith(Messages.getString("HyadesRuleAttributeTagName"))) {
                            iStatement = new AttributeStatement(this);
                        } else {
                            throw new AdapterInvalidConfig();
                        }
                        try {
                            iStatement.prepare(element, null);
                            this.ruleSets.add(iStatement);
                        }
                        catch (PreparationException preparationException) {
                            CommonBaseEvent commonBaseEvent;
                            if (preparationException.getDetails() == null) {
                                commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
                                commonBaseEvent.setMsg(preparationException.getLocalizedMessage());
                                commonBaseEvent.setSeverity((short)50);
                                this.log(commonBaseEvent);
                            } else {
                                commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
                                commonBaseEvent.setMsg(preparationException.getLocalizedMessage() + " " + preparationException.getDetails() + ". ");
                                commonBaseEvent.setSeverity((short)50);
                                this.log(commonBaseEvent);
                            }
                            commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
                            commonBaseEvent.getMsgDataElement().setMsgCatalogId("HyadesGASubstitutionRuleIgnored_WARN_");
                            commonBaseEvent.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{preparationException.getDigraph()});
                            commonBaseEvent.setSeverity((short)50);
                            this.log(commonBaseEvent);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public Object[] processEventItems(Object[] objectArray) {
        if (this.ruleSets != null) {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    HashMap hashMap = this.prepareEnvData(((MessageString)objectArray[n]).getValue());
                    ListIterator listIterator = this.ruleSets.listIterator();
                    ArrayList arrayList2 = new ArrayList();
                    while (listIterator.hasNext()) {
                        IStatement iStatement = (IStatement)listIterator.next();
                        try {
                            iStatement.run(((MessageString)objectArray[n]).getValue(), hashMap, arrayList2);
                        }
                        catch (AdapterException adapterException) {
                            CommonBaseEvent commonBaseEvent = this.getEventFactory().createCommonBaseEvent();
                            commonBaseEvent.setMsg(adapterException.getLocalizedMessage());
                            commonBaseEvent.setSeverity((short)50);
                            this.log(commonBaseEvent);
                        }
                    }
                    arrayList.add(arrayList2);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return null;
    }

    public Object[] testProcessEventItems(Object[] objectArray) throws AdapterInvalidConfig {
        if (!(objectArray instanceof MessageString[])) {
            throw new AdapterInvalidConfig("This parser will only accept arrays of MessageString");
        }
        return objectArray;
    }

    protected HashMap prepareEnvData(String string) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        if (this.separatorToken == null || this.separatorToken.equals("")) {
            return hashMap;
        }
        String[] stringArray = this.separatorPattern.split(string);
        int n = 0;
        while (n < stringArray.length) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            String string3 = "";
            String string4 = stringArray[n];
            if (string4.length() > 0) {
                if (this.designationToken == null || this.designationToken.equals("")) {
                    hashMap.put(new Long(n), string4);
                } else {
                    Matcher matcher = this.designationPattern.matcher(string4);
                    if (matcher.find()) {
                        if (matcher.start() > 0) {
                            string2 = string4.substring(0, matcher.start());
                            if (matcher.end() < string4.length()) {
                                string3 = string4.substring(matcher.end());
                            }
                            hashMap.put(string2.trim(), string3.trim());
                        }
                    } else {
                        hashMap.put(new Long(n), string4);
                    }
                }
            }
            ++n;
        }
        return hashMap;
    }
}

