/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.io.IOException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.perfmon.PerfmonPlugin;

public class PerfmonCommandUtil {
    Agent agent;
    Process process;
    Node node;

    public PerfmonCommandUtil(Agent agent) throws InactiveProcessException {
        this.agent = agent;
        this.process = agent.getProcess();
        this.node = this.process.getNode();
    }

    public void setFrequency(int n) throws IOException {
        this.setNVPair("var_int", "DC_WAITTIME", "" + n);
    }

    public void getUpdatedTree() throws IOException {
        this.setNVPair("updatetree", "", "true");
    }

    public void getUpdatedTree(SDDescriptor sDDescriptor) throws IOException {
        if (sDDescriptor.getId() == null) {
            return;
        }
        PerfmonPlugin.DBG.info("Requesting tree update for descriptor " + sDDescriptor.getName() + " (" + sDDescriptor.getId() + ")");
        this.setNVPair("updatetree", sDDescriptor.getId(), "true");
    }

    public void stopTracing(SDDescriptor sDDescriptor) throws IOException, NullPointerException {
        this.applyDown(sDDescriptor, false);
        this.applyUp(sDDescriptor, false);
    }

    public void startTracing(SDDescriptor sDDescriptor) throws IOException, NullPointerException {
        this.applyDown(sDDescriptor, true);
        this.applyUp(sDDescriptor, true);
    }

    private void apply(SDDescriptor sDDescriptor, boolean bl) throws IOException {
        this.traceCounter(sDDescriptor, bl);
    }

    private void applyUp(SDDescriptor sDDescriptor, boolean bl) throws IOException {
        SDDescriptor sDDescriptor2 = sDDescriptor.getParent();
        if (sDDescriptor2 != null) {
            this.apply(sDDescriptor2, bl);
            this.applyUp(sDDescriptor2, bl);
        }
    }

    private void applyDown(SDDescriptor sDDescriptor, boolean bl) throws IOException {
        this.apply(sDDescriptor, bl);
        EList eList = sDDescriptor.getChildren();
        int n = 0;
        while (n < eList.size()) {
            this.applyDown((SDDescriptor)eList.get(n), bl);
            ++n;
        }
    }

    private void traceCounter(SDDescriptor sDDescriptor, boolean bl) throws IOException, NullPointerException {
        String string = sDDescriptor.getId();
        if (string == null) {
            throw new NullPointerException("descriptor ID not found");
        }
        this.setNVPair("filter", string, "" + bl);
    }

    public void setNVPair(String string, String string2, String string3) throws IOException {
        ControlMessage controlMessage = new ControlMessage();
        SetNVPairCommand setNVPairCommand = new SetNVPairCommand();
        try {
            setNVPairCommand.setProcessId(Long.parseLong(this.process.getProcessId()));
        }
        catch (InactiveProcessException inactiveProcessException) {
            throw new IOException("Inactive process - try again soon?");
        }
        setNVPairCommand.setAgentName(this.agent.getName());
        setNVPairCommand.setType(string);
        setNVPairCommand.setName(string2);
        setNVPairCommand.setValue(string3);
        controlMessage.appendCommand((CommandElement)setNVPairCommand);
        this.node.getConnection().sendMessage(controlMessage, null);
    }
}

