/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.util.HashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.PerfmonCommandUtil;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PerfmonCounterDialog
extends Dialog
implements MouseListener,
SelectionListener {
    TRCAgent trcagent;
    Agent agent;
    Shell thisshell;
    Shell parentshell;
    Composite buttonpanel;
    Button okbutton;
    Button refresh;
    Tree tree;
    Menu tree_menu;
    MenuItem get_children;
    MenuItem start_tracing;
    HashMap descriptor_to_item = new HashMap();
    HashMap item_to_descriptor = new HashMap();
    PerfmonCommandUtil command;
    ModelListener adapter = new ModelListener();
    SDDescriptor selected_descriptor;

    public PerfmonCounterDialog(Shell shell, TRCAgent tRCAgent, Agent agent) {
        super(shell, 0);
        this.parentshell = shell;
        this.trcagent = tRCAgent;
        this.agent = agent;
        try {
            this.command = new PerfmonCommandUtil(agent);
        }
        catch (Exception exception) {
            PerfmonPlugin.DBG.logVisibleError((Throwable)exception, PerfmonPlugin.getString("ERROR_COMMAND_UTIL"), true);
        }
        tRCAgent.eAdapters().add((Object)this.adapter);
        if (tRCAgent.getView() != null) {
            tRCAgent.getView().eAdapters().add((Object)this.adapter);
            EList eList = tRCAgent.getView().eContents();
            int n = 0;
            while (n < eList.size()) {
                SDSampleWindow sDSampleWindow = (SDSampleWindow)eList.get(n);
                sDSampleWindow.eAdapters().add((Object)this.adapter);
                ++n;
            }
        }
    }

    public Object open() {
        Shell shell = this.getParent();
        Shell shell2 = new Shell(shell, 67696);
        shell2.setText(PerfmonPlugin.getString("CONFIGURE_PERFMON"));
        shell2.setBounds(0, 0, 400, 400);
        shell2.setLayout((Layout)new FillLayout());
        this.thisshell = shell2;
        PerfmonPlugin.DBG.info("initialising graphics");
        this.init(shell2);
        Rectangle rectangle = this.parentshell.getBounds();
        Rectangle rectangle2 = shell2.getBounds();
        if (rectangle2.width < 400) {
            rectangle2.width = 400;
        }
        if (rectangle2.height < 400) {
            rectangle2.height = 400;
        }
        shell2.setBounds(rectangle.x + rectangle.width / 2 - rectangle2.width / 2, rectangle.y + rectangle.height / 2 - rectangle2.height / 2, rectangle2.width, rectangle2.height);
        PerfmonPlugin.DBG.info("opening dialog");
        shell2.open();
        Display display = shell.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return null;
    }

    public void init(Shell shell) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)gridLayout);
        this.tree = new Tree(composite, 2048);
        this.tree.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)true, (int)-1, (int)-1, (int)1, (int)1, (int)4, (int)4));
        this.tree_menu = new Menu((Control)this.tree);
        this.get_children = new MenuItem(this.tree_menu, 0);
        this.start_tracing = new MenuItem(this.tree_menu, 0);
        this.get_children.setText(PerfmonPlugin.getString("UPDATE_TREE"));
        this.get_children.setImage(PerfmonPlugin.img.getImage("update_tree.gif"));
        this.start_tracing.setText(PerfmonPlugin.getString("START_TRACING"));
        this.start_tracing.setImage(PerfmonPlugin.img.getImage("trace_start.gif"));
        try {
            this.rebuildTree();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.buttonpanel = new Composite(composite, 0);
        this.buttonpanel.setLayout((Layout)gridLayout);
        this.buttonpanel.setLayoutData((Object)GData.getGridData((boolean)true, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)2, (int)4));
        this.okbutton = new Button(this.buttonpanel, 0);
        this.okbutton.setText(" " + PerfmonPlugin.getString("OK") + " ");
        this.okbutton.setLayoutData((Object)GData.getGridData((boolean)false, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)2, (int)2));
        this.refresh = new Button(this.buttonpanel, 0);
        this.refresh.setText(PerfmonPlugin.getString("REFRESH"));
        this.refresh.setLayoutData((Object)GData.getGridData((boolean)false, (boolean)false, (int)-1, (int)-1, (int)1, (int)1, (int)2, (int)2));
        this.okbutton.addSelectionListener((SelectionListener)this);
        this.refresh.addSelectionListener((SelectionListener)this);
        this.get_children.addSelectionListener((SelectionListener)this);
        this.start_tracing.addSelectionListener((SelectionListener)this);
        this.tree.addMouseListener((MouseListener)this);
    }

    private void refreshTree() {
        EList eList = this.trcagent.getDescriptor();
        int n = 0;
        while (n < eList.size()) {
            SDDescriptor sDDescriptor = (SDDescriptor)eList.get(n);
            this.addToTree(sDDescriptor);
            ++n;
        }
    }

    private void rebuildTree() {
        this.tree.removeAll();
        EList eList = this.trcagent.getDescriptor();
        int n = 0;
        while (n < eList.size()) {
            SDDescriptor sDDescriptor = (SDDescriptor)eList.get(n);
            this.addToTree(sDDescriptor);
            ++n;
        }
    }

    private int findIndex(String string, TreeItem[] treeItemArray) {
        if (string != null) {
            int n = 0;
            while (n < treeItemArray.length) {
                if (treeItemArray[n] != null && string.compareTo(treeItemArray[n].getText()) < 0) {
                    return n;
                }
                ++n;
            }
        }
        return treeItemArray.length;
    }

    private void addToTree(SDDescriptor sDDescriptor) {
        SDMemberDescriptor sDMemberDescriptor;
        int n;
        TreeItem treeItem = null;
        if (sDDescriptor.getName() == null) {
            return;
        }
        treeItem = (TreeItem)this.descriptor_to_item.get(sDDescriptor);
        if (treeItem == null) {
            if (sDDescriptor.getParent() == null) {
                n = this.findIndex(sDDescriptor.getName(), this.tree.getItems());
                treeItem = new TreeItem(this.tree, 0, n);
            } else {
                TreeItem treeItem2 = (TreeItem)this.descriptor_to_item.get(sDDescriptor.getParent());
                int n2 = this.findIndex(sDDescriptor.getName(), treeItem2.getItems());
                treeItem = new TreeItem(treeItem2, 0, n2);
            }
            this.descriptor_to_item.put(sDDescriptor, treeItem);
            this.item_to_descriptor.put(treeItem, sDDescriptor);
        }
        if (sDDescriptor.getDescription() == null) {
            treeItem.setText(sDDescriptor.getName());
        } else {
            treeItem.setText(sDDescriptor.getName() + " - " + sDDescriptor.getDescription());
        }
        treeItem.setImage(EditorPlugin.img.getImage("smodel_descriptor2.gif"));
        if (sDDescriptor instanceof SDMemberDescriptor && (sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor).getSnapshotObservation().size() > 0) {
            treeItem.setImage(PerfmonPlugin.img.getImage("trace_start.gif"));
        }
        n = 0;
        while (n < sDDescriptor.getChildren().size()) {
            SDDescriptor sDDescriptor2 = (SDDescriptor)sDDescriptor.getChildren().get(n);
            this.addToTree(sDDescriptor2);
            ++n;
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        block5: {
            Object object;
            block7: {
                block6: {
                    block4: {
                        object = selectionEvent.getSource();
                        if (object != this.refresh) break block4;
                        this.refreshTree();
                        break block5;
                    }
                    if (object != this.okbutton) break block6;
                    this.thisshell.close();
                    break block5;
                }
                if (object != this.get_children) break block7;
                try {
                    this.command.getUpdatedTree(this.selected_descriptor);
                }
                catch (Exception exception) {
                    PerfmonPlugin.DBG.logVisibleError((Throwable)exception, PerfmonPlugin.getString("ERROR_UPDATE_TREE"), false);
                }
                break block5;
            }
            if (object != this.start_tracing) break block5;
            try {
                this.command.startTracing(this.selected_descriptor);
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)exception, PerfmonPlugin.getString("ERROR_ISSUE_COMMAND"), false);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.x, mouseEvent.y);
        TreeItem treeItem = this.tree.getItem(point);
        if (treeItem != null) {
            this.selected_descriptor = (SDDescriptor)this.item_to_descriptor.get(treeItem);
            if (this.selected_descriptor != null && mouseEvent.button > 1) {
                this.tree_menu.setVisible(true);
            }
        }
    }

    class ModelListener
    extends AdapterImpl
    implements Runnable {
        ModelListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 3) {
                Object object = notification.getNewValue();
                boolean bl = false;
                if (object instanceof SDDescriptor) {
                    bl = true;
                } else if (object instanceof SDSnapshotObservation) {
                    bl = true;
                }
                if (bl) {
                    Display display = Display.getCurrent();
                    if (display == null) {
                        display = Display.getDefault();
                    }
                    if (display == null) {
                        PerfmonCounterDialog.this.thisshell.getDisplay().syncExec((Runnable)this);
                    } else {
                        display.syncExec((Runnable)this);
                    }
                }
            }
        }

        public void run() {
            try {
                PerfmonCounterDialog.this.refreshTree();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (SWTException sWTException) {}
        }
    }
}

