/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.perfmon.PerfmonLoader;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.StatisticalLoaderListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.swt.widgets.Display;

public class PerfmonGenericLoader
extends PerfmonLoader
implements DataProcessor,
ProcessListener,
AgentListener {
    private static final boolean PRINTXML = false;
    StatisticalFactory factory = StatisticalFactory.eINSTANCE;
    long started;
    String tracename;
    Node node;
    Process process;
    Agent agent;
    TRCAgent trcagent;
    boolean running = false;
    XMLLoader xloader;
    ArrayList listeners = new ArrayList();
    ModelListener adapter = new ModelListener();
    IProgressMonitor pmonitor;
    boolean first = true;

    public PerfmonGenericLoader(IProgressMonitor iProgressMonitor, long l, TRCAgent tRCAgent, String string, String string2, int n, String string3, int n2) throws Exception {
        this.pmonitor = iProgressMonitor;
        this.started = l;
        this.init(string, tRCAgent, string2, n, string3, n2);
    }

    public PerfmonGenericLoader(long l, TRCAgent tRCAgent, String string, String string2, String string3, int n) throws Exception {
        this.started = l;
        this.init(string, tRCAgent, string2, 10002, string3, n);
    }

    public void processLaunched(Process process) {
    }

    public void processExited(Process process) {
        TRCProcessProxy tRCProcessProxy = this.trcagent.getAgentProxy().getProcessProxy();
        if (tRCProcessProxy == null) {
            return;
        }
        TRCAgentProxy tRCAgentProxy = this.trcagent.getAgentProxy();
        if (tRCAgentProxy == null) {
            return;
        }
        tRCAgentProxy.setActive(false);
        tRCAgentProxy.setAttached(false);
        tRCAgentProxy.setMonitored(false);
        tRCProcessProxy.setActive(false);
        final TRCAgentProxy tRCAgentProxy2 = tRCAgentProxy;
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                profileEvent.setSource((Object)tRCAgentProxy2);
                profileEvent.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            }
        });
    }

    public void agentActive(Agent agent) {
    }

    public void agentInactive(Agent agent) {
        this.processExited(this.process);
    }

    public void error(Agent agent, String string, String string2) {
    }

    public void handleCommand(Agent agent, CommandElement commandElement) {
    }

    public void killProcess() throws Exception {
        this.node.killProcess(this.process);
    }

    public void setFrequency(int n) throws IOException {
        this.setNVPair("var_int", "DC_WAITTIME", "" + n);
    }

    public void setRemoteHost(String string) throws IOException {
        if (string.length() == 0) {
            string = "NULL";
        }
        PerfmonPlugin.DBG.info("Setting remote host to " + string);
        this.setNVPair("var_string", "PERFMON_REG_HOST", string);
    }

    public void getUpdatedTree() throws IOException {
        this.setNVPair("updatetree", "", "true");
    }

    public void getUpdatedTree(SDDescriptor sDDescriptor) throws IOException {
        if (sDDescriptor.getId() == null) {
            return;
        }
        PerfmonPlugin.DBG.info("Requesting tree update for descriptor " + sDDescriptor.getName() + " (" + sDDescriptor.getId() + ")");
        this.setNVPair("updatetree", sDDescriptor.getId(), "true");
    }

    public void counterON(SDDescriptor sDDescriptor) throws IOException, NullPointerException {
        String string = sDDescriptor.getId();
        if (string == null) {
            throw new NullPointerException("descriptor ID not found");
        }
        this.setNVPair("filter", string, "true");
    }

    public void counterOFF(SDDescriptor sDDescriptor) throws IOException {
        String string = sDDescriptor.getId();
        if (string == null) {
            throw new IOException("descriptor ID not found");
        }
        this.setNVPair("filter", string, "false");
    }

    public SDDescriptor getModel() {
        EList eList = this.trcagent.getDescriptor();
        if (eList.size() > 0) {
            return (SDDescriptor)eList.get(0);
        }
        return null;
    }

    public void addLoaderListener(StatisticalLoaderListener statisticalLoaderListener) {
        this.listeners.add(statisticalLoaderListener);
    }

    public void removeLoaderListener(StatisticalLoaderListener statisticalLoaderListener) {
        this.listeners.add(statisticalLoaderListener);
    }

    private Agent findAgent(Node node) throws NotConnectedException {
        Agent agent = null;
        Enumeration enumeration = node.listProcesses();
        while (enumeration.hasMoreElements()) {
            Process process = (Process)enumeration.nextElement();
            PerfmonPlugin.DBG.info("checking RAC process " + process.getName());
            agent = this.findAgent(process);
            if (agent != null) break;
        }
        return agent;
    }

    private Agent findAgent(Process process) {
        if (process == null) {
            return null;
        }
        Enumeration enumeration = process.listAgents();
        Agent agent = null;
        if (!enumeration.hasMoreElements()) {
            PerfmonPlugin.DBG.info("found no agents in this process");
        }
        while (enumeration.hasMoreElements()) {
            Agent agent2 = (Agent)enumeration.nextElement();
            PerfmonPlugin.DBG.info("found RAC agent " + agent2.getName() + "/" + agent2.getType());
            if (!agent2.getName().startsWith("PerfmonAgent") && !agent2.getType().startsWith("PerfmonAgent")) continue;
            try {
                if (agent2.isAttached()) continue;
                this.process = process;
                agent = agent2;
                PerfmonPlugin.DBG.info("agent not attached - accepting");
                break;
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.warning("error checking agent " + exception);
            }
        }
        return agent;
    }

    private void init(String string, TRCAgent tRCAgent, String string2, int n, String string3, int n2) throws Exception {
        block21: {
            SDSampleWindow sDSampleWindow;
            SDSampleWindow sDSampleWindow2;
            this.trcagent = tRCAgent;
            SDView sDView = (SDView)tRCAgent.getView();
            if (sDView == null) {
                sDView = this.factory.createSDView();
                sDView.setAgent(tRCAgent);
                sDView.setName("view");
            }
            if (sDView.eContents().size() == 0) {
                sDSampleWindow2 = this.factory.createSDSampleWindow();
                sDSampleWindow2.setView(sDView);
            }
            tRCAgent.eAdapters().add((Object)this.adapter);
            tRCAgent.getView().eAdapters().add((Object)this.adapter);
            sDSampleWindow2 = sDView.eContents();
            int n3 = 0;
            while (n3 < sDSampleWindow2.size()) {
                sDSampleWindow = (SDSampleWindow)sDSampleWindow2.get(n3);
                sDSampleWindow.eAdapters().add((Object)this.adapter);
                ++n3;
            }
            this.tracename = string;
            this.xloader = new XMLLoader(tRCAgent);
            PerfmonPlugin.DBG.warning("asked to connect to " + string2 + ":" + n);
            try {
                this.node = NodeFactory.createNode((String)string2);
                PerfmonPlugin.DBG.info("connecting to RAC");
                if (this.pmonitor != null) {
                    this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONNECTING"));
                }
                this.node.connect(n);
                PerfmonPlugin.DBG.info("connected to RAC");
                if (this.pmonitor != null) {
                    this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CREATING"));
                }
                this.agent = this.findAgent(this.node);
                if (this.agent == null) {
                    PerfmonPlugin.DBG.info("Launching RAC PerfmonAgent");
                    sDSampleWindow = ProcessFactory.createProcess((Node)this.node, (String)"PerfmonAgent");
                    if (sDSampleWindow != null) {
                        ProcessAdapter processAdapter = new ProcessAdapter((Process)sDSampleWindow, null);
                        sDSampleWindow.addProcessListener(new ProcessListener((IProcess)processAdapter){
                            private final /* synthetic */ IProcess val$adapter;
                            {
                                this.val$adapter = iProcess;
                            }

                            public void processLaunched(Process process) {
                                UIPlugin.getDefault().registerLaunchProcess(this.val$adapter);
                            }

                            public void processExited(Process process) {
                                UIPlugin.getDefault().deregisterLaunchProcess(this.val$adapter);
                            }
                        });
                        ProcessLaunch processLaunch = new ProcessLaunch();
                        processLaunch.process = sDSampleWindow;
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        display.syncExec((Runnable)processLaunch);
                        long l = System.currentTimeMillis() + 8000L;
                        while (!sDSampleWindow.isActive() && System.currentTimeMillis() < l) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        l = System.currentTimeMillis() + 25000L;
                        this.agent = this.findAgent(this.node);
                        while (this.agent == null && System.currentTimeMillis() < l) {
                            Thread.sleep(1250L);
                            this.agent = this.findAgent(this.node);
                        }
                    }
                }
                if (this.agent != null) {
                    if (this.pmonitor != null) {
                        this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONFIGURING"));
                    }
                    this.agent.addAgentListener((AgentListener)this);
                    this.process.addProcessListener((ProcessListener)this);
                    PerfmonPlugin.DBG.info("attaching to perfmon agent " + this.agent.getName());
                    this.running = true;
                    try {
                        tRCAgent.getAgentProxy().getProcessProxy().setPid(Integer.parseInt(this.agent.getProcess().getProcessId()));
                    }
                    catch (Exception exception) {
                        PerfmonPlugin.DBG.error("could not set process proxy PID");
                    }
                    tRCAgent.getAgentProxy().setRuntimeId(this.process.getUUID());
                    LoadersUtils.registerAgentInstance((TRCAgentProxy)tRCAgent.getAgentProxy(), (Object)this.agent);
                    this.agent.attach();
                    this.agent.startMonitoring((DataProcessor)this);
                    tRCAgent.setRuntimeId(this.agent.getUUID());
                    PerfmonPlugin.DBG.info("attached To & Monitoring Perfmon Agent");
                    this.setRemoteHost(string3);
                    this.setFrequency(n2);
                    this.getUpdatedTree();
                    long l = System.currentTimeMillis();
                    while (this.getModel() == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - l <= 10000L) continue;
                        l = Long.MAX_VALUE;
                        PerfmonPlugin.DBG.info("been waiting 10 seconds and still no model...");
                    }
                    break block21;
                }
                PerfmonPlugin.DBG.warning("no perfmon agent found");
                throw new Exception("Could not create PerfmonAgent on RAC");
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.warning("problem initialising loader");
                throw exception;
            }
        }
    }

    public void setNVPair(String string, String string2, String string3) throws IOException {
        ControlMessage controlMessage = new ControlMessage();
        SetNVPairCommand setNVPairCommand = new SetNVPairCommand();
        try {
            setNVPairCommand.setProcessId(Long.parseLong(this.process.getProcessId()));
        }
        catch (InactiveProcessException inactiveProcessException) {
            throw new IOException("Inactive process - try again soon?");
        }
        setNVPairCommand.setAgentName(this.agent.getName());
        setNVPairCommand.setType(string);
        setNVPairCommand.setName(string2);
        setNVPairCommand.setValue(string3);
        controlMessage.appendCommand((CommandElement)setNVPairCommand);
        this.node.getConnection().sendMessage(controlMessage, null);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void shutdown() {
        block2: {
            this.running = false;
            PerfmonPlugin.DBG.info("shutdown");
            if (this.agent == null) break block2;
            try {
                PerfmonPlugin.DBG.info("detaching from agent");
                this.agent.stopMonitoring();
                this.agent.detach();
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.warning("failed to detach from agent", (Throwable)exception);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    public void incoming(String string) {
    }

    private byte[] stringToBytes(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < string.length()) {
            byteArrayOutputStream.write((byte)string.charAt(n));
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
        if ((n = (byArray = new String(byArray, 0, n).trim().getBytes()).length) == 0) {
            return;
        }
        if (this.first) {
            byte[] byArray2 = "<TRACE>".getBytes();
            this.xloader.loadEvent(byArray2, byArray2.length);
            this.first = false;
        }
        try {
            this.xloader.loadEvent(byArray, n);
        }
        catch (Throwable throwable) {
            PerfmonPlugin.DBG.error("unable to parse message " + new String(byArray, 0, 30) + "...", throwable);
        }
    }

    public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
    }

    public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
        PerfmonPlugin.DBG.warning("invalid datatype");
    }

    public void waitingForData() {
    }

    class ModelListener
    extends AdapterImpl {
        ModelListener() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 3) {
                Object object = notification.getNewValue();
                boolean bl = false;
                SDDescriptor sDDescriptor = null;
                if (object instanceof SDDescriptor) {
                    bl = true;
                    sDDescriptor = ((SDDescriptor)object).getParent();
                } else if (object instanceof SDSnapshotObservation) {
                    bl = true;
                    sDDescriptor = ((SDSnapshotObservation)object).getMemberDescriptor();
                }
                if (bl) {
                    int n = 0;
                    while (n < PerfmonGenericLoader.this.listeners.size()) {
                        StatisticalLoaderListener statisticalLoaderListener = (StatisticalLoaderListener)PerfmonGenericLoader.this.listeners.get(n);
                        statisticalLoaderListener.modelChanged(sDDescriptor);
                        ++n;
                    }
                }
            }
        }
    }

    class ProcessLaunch
    implements Runnable {
        Process process;

        ProcessLaunch() {
        }

        public void run() {
            try {
                this.process.launch();
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)exception, PerfmonPlugin.getString("ERROR_LAUNCH_PERFMON"), true);
            }
        }
    }
}

