/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonGenericLoader;
import org.eclipse.hyades.perfmon.PerfmonLoader;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.StatisticalLoaderListener;
import org.eclipse.hyades.statistical.ui.editor.internal.AgentChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableLoader;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableModifierProxy;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PerfmonModuleTrace
implements AgentChangeListener,
SDVariableModifierProxy {
    private static final boolean USE_CUSTOM_LOADER = false;
    ImageManager img = PerfmonPlugin.img;
    StatConInterface statcon;
    IProgressMonitor pmonitor;
    String PERFMON_NODE = "Perfmon Trace";
    String ACTION_FILTER_COUNTERS = "Set Counter Filters";
    String ACTION_STOP_TRACE = "Stop Trace";
    String ACTION_UPDATE_TREE = "Update Counter Tree";
    String ACTION_START_TRACING = "Start Tracing this Counter";
    String ACTION_STOP_TRACING = "Stop Tracing this Counter";
    String ACTION_SETSMODELPATH = "Set Statistical Model save path...";
    String tracename;
    SimpleDateFormat smodel_sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
    boolean new_monitor = true;
    TRCMonitor monitor;
    TRCAgent agent;
    PerfmonLoader loader;
    VariablePadder var_padder;
    SDModifiableVariableRepresentation freq_var;
    double frequency = 1.0;
    URI smodelpath;
    URI monitor_uri;
    String rachost;

    public void unloadTrace() {
        this.var_padder.die = true;
        try {
            this.loader.shutdown();
        }
        catch (Exception exception) {
            PerfmonPlugin.DBG.warning("failed to shut down Perfmon loader");
        }
        try {
            this.statcon.setConstantUpdate("PERFMON UPDATE " + this.loader.hashCode(), false, 1000L);
            this.statcon.setAgentImage(this.agent, this.img.getImage("trace_stop.gif"));
            this.statcon.removeAgentAction(this.agent, this.ACTION_FILTER_COUNTERS);
            this.statcon.removeAgentAction(this.agent, this.ACTION_STOP_TRACE);
            this.statcon.removeAgentAction(this.agent, this.ACTION_UPDATE_TREE);
        }
        catch (Exception exception) {
            PerfmonPlugin.DBG.warning("failed to remove stuff from statcon");
        }
        this.statcon.removeAgentChangeListener((AgentChangeListener)this);
    }

    public void agentAdded(TRCAgent tRCAgent) {
    }

    public void agentRemoved(TRCAgent tRCAgent) {
        if (this.agent == tRCAgent) {
            this.unloadTrace();
        }
    }

    public void requestValue(String string, int n) throws ClassCastException {
        this.requestValue(string, (double)n);
    }

    public void requestValue(String string, long l) throws ClassCastException {
        this.requestValue(string, (double)l);
    }

    public void requestValue(String string, float f) throws ClassCastException {
        this.requestValue(string, (double)f);
    }

    public void requestValue(String string, double d) throws ClassCastException {
        block3: {
            if (!string.equals("PERFMON#FREQUENCY")) break block3;
            if (d < 0.5) {
                d = 0.5;
            }
            int n = (int)(d * 1000.0);
            try {
                this.loader.setFrequency(n);
                this.frequency = d;
                this.freq_var.setMeasuredValue(System.currentTimeMillis(), d);
            }
            catch (IOException iOException) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)iOException, PerfmonPlugin.getString("ERROR_SETTING_FREQUENCY") + " " + n, false);
            }
        }
    }

    public void requestValue(String string, Object object) throws ClassCastException {
        this.requestValue(string, ((Number)object).doubleValue());
    }

    public PerfmonModuleTrace(IProgressMonitor iProgressMonitor, String string, String string2, URI uRI, URI uRI2) {
        this.pmonitor = iProgressMonitor;
        this.statcon = null;
        this.smodelpath = uRI;
        this.monitor_uri = uRI2;
        this.rachost = string;
        new Init(string, string2).run();
    }

    public PerfmonModuleTrace(StatConInterface statConInterface, String string, String string2, URI uRI) {
        this.statcon = statConInterface;
        this.smodelpath = uRI;
        this.rachost = string;
        new Init(string, string2).start();
    }

    private String getStatModelFileName() {
        return this.tracename;
    }

    private void removeRepresentations(SDDescriptor sDDescriptor) {
        SDMemberDescriptor sDMemberDescriptor;
        if (sDDescriptor == null) {
            return;
        }
        if (sDDescriptor instanceof SDMemberDescriptor) {
            sDMemberDescriptor = (SDMemberDescriptor)sDDescriptor;
            sDMemberDescriptor.setRepresentation(null);
            EList eList = sDMemberDescriptor.getSnapshotObservation();
            int n = 0;
            while (n < eList.size()) {
                SDSnapshotObservation sDSnapshotObservation = (SDSnapshotObservation)eList.get(n);
                if (sDSnapshotObservation.getWindow() == null) {
                    PerfmonPlugin.DBG.warning("NULL OBSERVATION WINDOW UNDER " + sDDescriptor.getName() + " (" + sDDescriptor.getDescription() + ")");
                }
                ++n;
            }
        }
        sDMemberDescriptor = sDDescriptor.getChildren();
        int n = 0;
        while (n < sDMemberDescriptor.size()) {
            this.removeRepresentations((SDDescriptor)sDMemberDescriptor.get(n));
            ++n;
        }
    }

    private void saveResources() throws IOException {
        URI uRI = this.smodelpath;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = null;
        URI uRI2 = null;
        if (this.monitor_uri == null) {
            path = new Path(uRI + "/" + this.getStatModelFileName() + ".trcmxmi");
            uRI2 = URI.createPlatformResourceURI((String)iWorkspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        } else {
            uRI2 = this.monitor_uri;
        }
        path = new Path(uRI + "/" + this.getStatModelFileName() + ".trcnxmi");
        URI uRI3 = URI.createPlatformResourceURI((String)iWorkspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        path = new Path(uRI + "/" + this.getStatModelFileName() + ".trcpxmi");
        URI uRI4 = URI.createPlatformResourceURI((String)iWorkspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        path = new Path(uRI + "/" + this.getStatModelFileName() + ".trcaxmi");
        URI uRI5 = URI.createPlatformResourceURI((String)iWorkspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        HierarchyResourceSetImpl hierarchyResourceSetImpl = HierarchyResourceSetImpl.getInstance();
        Resource resource = null;
        Resource resource2 = null;
        Resource resource3 = null;
        Resource resource4 = null;
        try {
            resource = hierarchyResourceSetImpl.getResource(uRI2, true);
            PerfmonPlugin.DBG.info("got TRCMonitor resource OK");
        }
        catch (Exception exception) {
            resource = hierarchyResourceSetImpl.createResource(uRI2);
            PerfmonPlugin.DBG.info("created TRCMonitor resource OK");
        }
        try {
            resource2 = hierarchyResourceSetImpl.getResource(uRI3, true);
            PerfmonPlugin.DBG.info("got TRCNode resource OK");
        }
        catch (Exception exception) {
            resource2 = hierarchyResourceSetImpl.createResource(uRI3);
            PerfmonPlugin.DBG.info("created TRCNode resource OK");
        }
        try {
            resource3 = hierarchyResourceSetImpl.getResource(uRI4, true);
            PerfmonPlugin.DBG.info("got TRCProcessProxy resource OK");
        }
        catch (Exception exception) {
            resource3 = hierarchyResourceSetImpl.createResource(uRI4);
            PerfmonPlugin.DBG.info("created TRCProcessProxy resource OK");
        }
        try {
            resource4 = hierarchyResourceSetImpl.getResource(uRI5, true);
            PerfmonPlugin.DBG.info("got TRCAgent resource OK");
        }
        catch (Exception exception) {
            resource4 = hierarchyResourceSetImpl.createResource(uRI5);
            PerfmonPlugin.DBG.info("created TRCAgent resource OK");
        }
        if (this.monitor_uri == null) {
            try {
                resource.getContents().add((Object)this.monitor);
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.error("problem adding to monitor resource");
            }
        }
        try {
            resource2.getContents().add((Object)this.agent.getAgentProxy().getProcessProxy().getNode());
        }
        catch (Exception exception) {
            PerfmonPlugin.DBG.error("problem adding to node resource");
        }
        try {
            resource3.getContents().add((Object)this.agent.getAgentProxy().getProcessProxy());
        }
        catch (Exception exception) {
            PerfmonPlugin.DBG.error("problem adding to process resource");
        }
        resource4.getContents().add((Object)this.agent);
    }

    private void saveStatisticalModel() throws IOException {
        EList eList = this.agent.getDescriptor();
        int n = 0;
        while (n < eList.size()) {
            this.removeRepresentations((SDDescriptor)eList.get(n));
            ++n;
        }
        URI uRI = this.smodelpath;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(uRI + "/" + this.getStatModelFileName() + ".trcaxmi");
        URI uRI2 = URI.createURI((String)iWorkspaceRoot.getFile((IPath)path).getProjectRelativePath().toString());
        if (this.statcon != null) {
            this.monitor.eResource().save(Collections.EMPTY_MAP);
            this.agent.getAgentProxy().getProcessProxy().getNode().eResource().save(Collections.EMPTY_MAP);
            this.agent.getAgentProxy().getProcessProxy().eResource().save(Collections.EMPTY_MAP);
            this.agent.eResource().save(Collections.EMPTY_MAP);
            this.statcon.setAgentFile(this.agent, uRI2);
        }
    }

    private void configureSliders() throws Exception {
        double d;
        TimeZoomSlider timeZoomSlider = this.statcon.getGraphWindow().getXSlider(0);
        double d2 = timeZoomSlider.getMinVisible();
        double d3 = timeZoomSlider.getMaxVisible();
        double d4 = timeZoomSlider.getMinLimit();
        double d5 = timeZoomSlider.getMaxLimit();
        d2 = d = (double)System.currentTimeMillis();
        d3 = d + 60000.0;
        d4 = Math.min(d4, d - 3600000.0);
        d5 = Math.max(d5, d + 8.64E7);
        timeZoomSlider.configure(d4, d5, d2, d3, timeZoomSlider.getResolution());
        ZoomSlider zoomSlider = this.statcon.getGraphWindow().getYSlider(0);
        d2 = zoomSlider.getMinVisible();
        d3 = Math.max(zoomSlider.getMaxVisible(), 100.0);
        d4 = zoomSlider.getMinLimit();
        d5 = Math.max(zoomSlider.getMaxLimit(), d3 * 10.0);
        zoomSlider.configure(d4, d5, d2, d3, zoomSlider.getResolution());
    }

    private void createTRCAgent(String string) {
        Object object;
        Object object2;
        Resource resource;
        HierarchyResourceSetImpl hierarchyResourceSetImpl;
        HierarchyFactory hierarchyFactory = HierarchyFactory.eINSTANCE;
        TRCMonitor tRCMonitor = null;
        if (this.monitor_uri != null) {
            PerfmonPlugin.DBG.info("TRCMonitor URI specified - fetching TRCMonitor");
            hierarchyResourceSetImpl = HierarchyResourceSetImpl.getInstance();
            resource = null;
            try {
                resource = hierarchyResourceSetImpl.getResource(this.monitor_uri, true);
                PerfmonPlugin.DBG.info("got TRCMonitor resource OK");
                this.new_monitor = false;
            }
            catch (Exception exception) {
                resource = hierarchyResourceSetImpl.createResource(this.monitor_uri);
                PerfmonPlugin.DBG.info("had to create new TRCMonitor resource");
                tRCMonitor = hierarchyFactory.createTRCMonitor();
                String string2 = this.monitor_uri.toString();
                string2 = string2.substring(string2.lastIndexOf("/") + 1);
                string2 = string2.substring(0, string2.length() - ".trcmxmi".length());
                tRCMonitor.setName(string2);
                try {
                    resource.getContents().add((Object)tRCMonitor);
                }
                catch (Exception exception2) {
                    PerfmonPlugin.DBG.error("problem adding to monitor resource", (Throwable)exception2);
                }
            }
            object2 = resource.getContents();
            int n = 0;
            while (n < object2.size()) {
                object = object2.get(n);
                if (object instanceof TRCMonitor) {
                    tRCMonitor = (TRCMonitor)object;
                    break;
                }
                ++n;
            }
        } else {
            PerfmonPlugin.DBG.info("TRCMonitor URI not specified - creating new TRCMonitor");
            tRCMonitor = hierarchyFactory.createTRCMonitor();
            tRCMonitor.setName(string);
        }
        TRCNode tRCNode = hierarchyFactory.createTRCNode();
        tRCNode.setMonitor(tRCMonitor);
        tRCNode.setName(this.rachost);
        tRCNode.setRuntimeId("unknown");
        tRCNode.setTimezone(0.0);
        TRCProcessProxy tRCProcessProxy = hierarchyFactory.createTRCProcessProxy();
        tRCProcessProxy.setNode(tRCNode);
        tRCNode.getProcessProxies().add((Object)tRCProcessProxy);
        tRCProcessProxy.setActive(true);
        tRCProcessProxy.setPid(-1);
        tRCProcessProxy.setName(PerfmonPlugin.getString("PERFMON_AGENT"));
        TRCAgentProxy tRCAgentProxy = hierarchyFactory.createTRCAgentProxy();
        tRCAgentProxy.setProcessProxy(tRCProcessProxy);
        tRCProcessProxy.getAgentProxies().add((Object)tRCAgentProxy);
        tRCAgentProxy.setActive(true);
        tRCAgentProxy.setAttached(true);
        tRCAgentProxy.setMonitored(true);
        tRCAgentProxy.setType("Profiler");
        tRCAgentProxy.setName(PerfmonPlugin.getString("PERFMON_AGENT"));
        TRCAgent tRCAgent = hierarchyFactory.createTRCAgent();
        tRCAgent.setAgentProxy(tRCAgentProxy);
        tRCAgent.setName(string);
        tRCAgent.setType("Profiler");
        hierarchyResourceSetImpl = HierarchyResourceSetImpl.getInstance();
        resource = this.smodelpath;
        object2 = resource.toString().replaceFirst("platform:/resource/", "");
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.agent = tRCAgent;
        this.monitor = tRCMonitor;
        object = new Path(((String)object2).toString().replaceFirst("platform:/resource/", ""));
        try {
            this.saveResources();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PerfmonPlugin.DBG.info("AGENT PROXY URI = " + this.agent.getAgentProxy().eResource().getURI());
        MonitorViewUpdate monitorViewUpdate = new MonitorViewUpdate();
        monitorViewUpdate.temp = object;
        Display.getDefault().syncExec((Runnable)monitorViewUpdate);
    }

    public static final IContainer createContainer(IPath iPath) {
        IFolder iFolder = null;
        IWorkspace iWorkspace = UIPlugin.getPluginWorkbench();
        int n = iPath.segmentCount();
        int n2 = 0;
        while (n2 < n) {
            IFolder iFolder2;
            String string = iPath.segment(n2);
            if (n2 == 0) {
                iFolder2 = iWorkspace.getRoot().getProject(iPath.uptoSegment(n2 + 1).toString());
                if (iFolder2 == null || !iFolder2.exists()) {
                    try {
                        iFolder2.create(null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    iFolder2.open(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iFolder = iFolder2;
            } else {
                iFolder2 = iWorkspace.getRoot().getFolder(iPath.uptoSegment(n2 + 1));
                if (iFolder2 == null || !iFolder2.exists()) {
                    try {
                        iFolder2.create(false, true, null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                iFolder = iFolder2;
            }
            ++n2;
        }
        try {
            iFolder.getProject().refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iFolder;
    }

    private void redoActions() {
    }

    class AgentUpdateThread
    extends Thread
    implements StatisticalLoaderListener {
        public boolean die;
        TRCAgent agent;
        Object list_lock = new Object();
        ArrayList descriptor_updates = new ArrayList();
        HashMap descriptor_map = new HashMap();
        ArrayList agent_updates = new ArrayList();

        public AgentUpdateThread(TRCAgent tRCAgent) {
            this.agent = tRCAgent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(SDDescriptor sDDescriptor) {
            SDDescriptor sDDescriptor2 = sDDescriptor;
            Object object = this.list_lock;
            synchronized (object) {
                if (sDDescriptor2 == null) {
                    if (this.agent_updates.size() == 0) {
                        this.agent_updates.add(this.agent);
                    }
                } else {
                    if (this.descriptor_map.get(sDDescriptor2) != null) {
                        return;
                    }
                    SDDescriptor sDDescriptor3 = sDDescriptor2.getParent();
                    while (sDDescriptor3 != null) {
                        if (this.descriptor_map.get(sDDescriptor3) != null) {
                            return;
                        }
                        sDDescriptor3 = sDDescriptor3.getParent();
                    }
                    this.descriptor_updates.add(sDDescriptor2);
                    this.descriptor_map.put(sDDescriptor2, sDDescriptor2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collapse() {
            Object object = this.list_lock;
            synchronized (object) {
                if (this.agent_updates.size() > 0) {
                    return;
                }
                if (this.descriptor_updates.size() > 350) {
                    this.agent_updates.add(this.agent);
                    return;
                }
                int n = 0;
                while (n < this.descriptor_updates.size()) {
                    SDDescriptor sDDescriptor = (SDDescriptor)this.descriptor_updates.get(n);
                    SDDescriptor sDDescriptor2 = sDDescriptor.getParent();
                    while (sDDescriptor2 != null) {
                        if (this.descriptor_map.get(sDDescriptor2) != null) {
                            this.descriptor_updates.remove(n--);
                            this.descriptor_map.remove(sDDescriptor2);
                            break;
                        }
                        sDDescriptor2 = sDDescriptor2.getParent();
                    }
                    ++n;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object = this.list_lock;
                synchronized (object) {
                    this.collapse();
                    if (this.agent_updates.size() > 0) {
                        PerfmonModuleTrace.this.statcon.getGraphWindow().getDisplay().syncExec((Runnable)new ListUpdate(this.agent_updates));
                    } else if (this.descriptor_updates.size() > 0) {
                        PerfmonModuleTrace.this.statcon.getGraphWindow().getDisplay().syncExec((Runnable)new ListUpdate(this.descriptor_updates));
                    }
                    this.descriptor_updates = new ArrayList();
                    this.descriptor_map = new HashMap();
                    this.agent_updates = new ArrayList();
                }
            }
        }
    }

    class ListUpdate
    extends Thread {
        ArrayList items;

        public ListUpdate(ArrayList arrayList) {
            this.items = arrayList;
        }

        public void run() {
            try {
                int n = 0;
                while (n < this.items.size()) {
                    Object e = this.items.get(n);
                    if (e instanceof SDDescriptor) {
                        PerfmonModuleTrace.this.statcon.updateModel((SDDescriptor)e);
                    } else if (e instanceof TRCAgent) {
                        PerfmonModuleTrace.this.statcon.updateAgent((TRCAgent)e);
                        return;
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.warning("couldnt update perfmon agent " + throwable);
            }
        }
    }

    class PerfmonSetPath
    implements Runnable {
        PerfmonSetPath() {
        }

        public void run() {
            PerfmonPlugin.DBG.info("set test model save path");
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path path = null;
            IFolder iFolder = null;
            try {
                path = new Path("" + PerfmonModuleTrace.this.smodelpath);
                iFolder = iWorkspaceRoot.getFolder((IPath)path);
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path");
            }
            PerfmonPlugin.DBG.info("showing container selection dialog");
            ContainerSelectionDialog containerSelectionDialog = null;
            containerSelectionDialog = new ContainerSelectionDialog(PerfmonModuleTrace.this.statcon.getGraphWindow().getShell(), (IContainer)iFolder, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
            containerSelectionDialog.open();
            Object[] objectArray = containerSelectionDialog.getResult();
            if (objectArray != null && objectArray.length > 0) {
                URI uRI;
                Path path2 = (Path)objectArray[0];
                PerfmonModuleTrace.this.smodelpath = uRI = URI.createPlatformResourceURI((String)path2.toString());
                PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
                PerfmonModuleTrace.this.redoActions();
                PerfmonModuleTrace.this.statcon.setDirty(true);
            }
        }
    }

    class CounterOFF
    implements Runnable {
        PerfmonLoader loader;

        public CounterOFF(PerfmonLoader perfmonLoader) {
            this.loader = perfmonLoader;
        }

        public void run() {
            try {
                this.apply(PerfmonModuleTrace.this.statcon.getSelectedDescriptor());
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.error("unable to set counter to ON", (Throwable)exception);
            }
        }

        void apply(SDDescriptor sDDescriptor) throws IOException {
            this.loader.counterOFF(sDDescriptor);
            PerfmonModuleTrace.this.statcon.setDescriptorImage(sDDescriptor, PerfmonModuleTrace.this.img.getImage("trace_stop.gif"));
            EList eList = sDDescriptor.getChildren();
            int n = 0;
            while (n < eList.size()) {
                this.apply((SDDescriptor)eList.get(n));
                ++n;
            }
        }
    }

    class CounterON
    implements Runnable {
        PerfmonLoader loader;

        public CounterON(PerfmonLoader perfmonLoader) {
            this.loader = perfmonLoader;
        }

        public void run() {
            try {
                this.applyDown(PerfmonModuleTrace.this.statcon.getSelectedDescriptor());
                this.applyUp(PerfmonModuleTrace.this.statcon.getSelectedDescriptor());
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.error("unable to set counter to ON", (Throwable)exception);
            }
        }

        void apply(SDDescriptor sDDescriptor) throws IOException {
            try {
                this.loader.counterON(sDDescriptor);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            PerfmonModuleTrace.this.statcon.setDescriptorImage(sDDescriptor, PerfmonModuleTrace.this.img.getImage("trace_start.gif"));
        }

        void applyUp(SDDescriptor sDDescriptor) throws IOException {
            SDDescriptor sDDescriptor2 = sDDescriptor.getParent();
            if (sDDescriptor2 != null) {
                this.apply(sDDescriptor2);
                this.applyUp(sDDescriptor2);
            }
        }

        void applyDown(SDDescriptor sDDescriptor) throws IOException {
            this.apply(sDDescriptor);
            EList eList = sDDescriptor.getChildren();
            int n = 0;
            while (n < eList.size()) {
                this.applyDown((SDDescriptor)eList.get(n));
                ++n;
            }
        }
    }

    class StopTraceAction
    implements Runnable {
        PerfmonLoader loader;
        TRCAgent agent;

        public StopTraceAction(PerfmonLoader perfmonLoader, TRCAgent tRCAgent) {
            this.loader = perfmonLoader;
            this.agent = tRCAgent;
        }

        public void run() {
            PerfmonModuleTrace.this.unloadTrace();
            try {
                PerfmonModuleTrace.this.saveStatisticalModel();
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.error("problem saving statistical model", (Throwable)exception);
            }
            try {
                this.loader.killProcess();
            }
            catch (Exception exception) {
                PerfmonPlugin.DBG.error("problem killing perfmon process", (Throwable)exception);
            }
        }
    }

    class UpdateTreeAction
    implements Runnable {
        PerfmonLoader loader;
        TRCAgent agent;

        public UpdateTreeAction(PerfmonLoader perfmonLoader, TRCAgent tRCAgent) {
            this.loader = perfmonLoader;
            this.agent = tRCAgent;
        }

        public void run() {
            try {
                SDDescriptor sDDescriptor = PerfmonModuleTrace.this.statcon.getSelectedDescriptor();
                this.loader.getUpdatedTree(sDDescriptor);
            }
            catch (IOException iOException) {
                PerfmonPlugin.DBG.logVisibleError((Throwable)iOException, PerfmonPlugin.getString("ERROR_UPDATE_TREE"), false);
            }
        }
    }

    class VariablePadder
    extends Thread {
        boolean die = false;

        VariablePadder() {
        }

        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(750L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    PerfmonModuleTrace.this.freq_var.padRequestedValue(System.currentTimeMillis());
                    PerfmonModuleTrace.this.freq_var.setMeasuredValue(System.currentTimeMillis(), PerfmonModuleTrace.this.freq_var.getLastMeasuredValue());
                }
                catch (Exception exception) {
                    PerfmonPlugin.DBG.warning("unable to pad variable requested and measured - " + exception);
                }
            }
        }
    }

    class Init
    extends Thread {
        String rac_host;
        String reg_host;

        public Init(String string, String string2) {
            this.rac_host = string;
            this.reg_host = string2;
        }

        public void run() {
            if (PerfmonModuleTrace.this.pmonitor != null) {
                PerfmonModuleTrace.this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_LAUNCHING"));
            }
            try {
                if (this.reg_host.equalsIgnoreCase(this.rac_host)) {
                    this.reg_host = "null";
                }
                HierarchyFactory hierarchyFactory = HierarchyFactory.eINSTANCE;
                long l = System.currentTimeMillis();
                String string = this.rac_host;
                int n = 10002;
                String string2 = this.reg_host;
                if (string2.equalsIgnoreCase("null")) {
                    string2 = string;
                } else if (!this.reg_host.startsWith("\\\\")) {
                    this.reg_host = "\\\\" + this.reg_host;
                }
                PerfmonModuleTrace.this.tracename = "Perfmon Trace - " + string2 + " (" + string + ") " + PerfmonModuleTrace.this.smodel_sdf.format(new Date(l));
                String string3 = "Perfmon Host Trace - " + PerfmonModuleTrace.this.smodel_sdf.format(new Date(l));
                PerfmonModuleTrace.this.createTRCAgent(PerfmonModuleTrace.this.tracename);
                PerfmonPlugin.DBG.info("Creating variable loader");
                SDVariableLoader sDVariableLoader = null;
                if (PerfmonModuleTrace.this.statcon != null) {
                    sDVariableLoader = new SDVariableLoader(PerfmonModuleTrace.this.agent, "Perfmon Controls");
                }
                AgentUpdateThread agentUpdateThread = null;
                if (PerfmonModuleTrace.this.statcon != null) {
                    agentUpdateThread = new AgentUpdateThread(PerfmonModuleTrace.this.agent);
                    agentUpdateThread.start();
                }
                PerfmonModuleTrace.this.loader = new PerfmonGenericLoader(PerfmonModuleTrace.this.pmonitor, l, PerfmonModuleTrace.this.agent, string3, string, n, this.reg_host, (int)(1000.0 * PerfmonModuleTrace.this.frequency));
                if (PerfmonModuleTrace.this.statcon != null) {
                    PerfmonModuleTrace.this.loader.addLoaderListener(agentUpdateThread);
                }
                if (PerfmonModuleTrace.this.pmonitor != null) {
                    PerfmonModuleTrace.this.pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONFIGURING"));
                }
                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                profileEvent.setSource((Object)PerfmonModuleTrace.this.agent.getAgentProxy());
                profileEvent.setType(1);
                ProfileUpdate profileUpdate = new ProfileUpdate();
                profileUpdate.event = profileEvent;
                Display.getDefault().syncExec((Runnable)profileUpdate);
                if (PerfmonModuleTrace.this.statcon != null) {
                    PerfmonPlugin.DBG.info("Creating frequency variable");
                    PerfmonModuleTrace.this.freq_var = sDVariableLoader.createSDModifiableVariable("PERFMON#FREQUENCY", "Frequency (sec)", "The period between data updates in seconds", null, false, 3, 3, "Frequency", "Perfmon Controls", (SDVariableModifierProxy)PerfmonModuleTrace.this, 0.5, Double.MAX_VALUE);
                    Display.getDefault().syncExec((Runnable)new StatconUpdate1());
                    Display.getDefault().syncExec((Runnable)new StatconUpdate2());
                }
                if (PerfmonModuleTrace.this.pmonitor != null) {
                    PerfmonModuleTrace.this.pmonitor.done();
                }
            }
            catch (Throwable throwable) {
                if (PerfmonModuleTrace.this.pmonitor != null) {
                    PerfmonModuleTrace.this.pmonitor.done();
                }
                PerfmonPlugin.DBG.logVisibleError(throwable, PerfmonPlugin.getString("ERROR_STARTING_TRACE"), true);
            }
        }
    }

    class StatconUpdate2
    implements Runnable {
        StatconUpdate2() {
        }

        public void run() {
            try {
                PerfmonPlugin.DBG.info("Setting requested frequency to " + PerfmonModuleTrace.this.frequency);
                PerfmonModuleTrace.this.freq_var.setRequestedValue(System.currentTimeMillis(), PerfmonModuleTrace.this.frequency);
                PerfmonPlugin.DBG.info("setting up trcagent + variable padder");
                PerfmonModuleTrace.this.statcon.addAgentChangeListener((AgentChangeListener)PerfmonModuleTrace.this);
                PerfmonModuleTrace.this.statcon.setAgentImage(PerfmonModuleTrace.this.agent, PerfmonModuleTrace.this.img.getImage("trace_start.gif"));
                PerfmonModuleTrace.this.var_padder = new VariablePadder();
                PerfmonModuleTrace.this.var_padder.start();
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.logVisibleError(throwable, PerfmonPlugin.getString("ERROR_STATCON_UPDATE") + " (2)", true);
            }
        }
    }

    class StatconUpdate1
    implements Runnable {
        StatconUpdate1() {
        }

        public void run() {
            try {
                PerfmonModuleTrace.this.statcon.setConstantUpdate("PERFMON UPDATE " + PerfmonModuleTrace.this.loader.hashCode(), true, 1000L);
                PerfmonModuleTrace.this.statcon.addAgent(PerfmonModuleTrace.this.agent);
                PerfmonModuleTrace.this.statcon.addAgentAction(PerfmonModuleTrace.this.agent, PerfmonModuleTrace.this.ACTION_STOP_TRACE, PerfmonPlugin.getString("STOP_TRACE"), PerfmonModuleTrace.this.img.getImage("trace_stop.gif"), (Runnable)new StopTraceAction(PerfmonModuleTrace.this.loader, PerfmonModuleTrace.this.agent));
                PerfmonModuleTrace.this.statcon.addModelAction(PerfmonModuleTrace.this.agent, PerfmonModuleTrace.this.ACTION_UPDATE_TREE, PerfmonPlugin.getString("UPDATE_TREE"), PerfmonModuleTrace.this.img.getImage("update_tree.gif"), (Runnable)new UpdateTreeAction(PerfmonModuleTrace.this.loader, PerfmonModuleTrace.this.agent));
                PerfmonModuleTrace.this.statcon.addModelAction(PerfmonModuleTrace.this.agent, PerfmonModuleTrace.this.ACTION_START_TRACING, PerfmonPlugin.getString("START_TRACING"), PerfmonModuleTrace.this.img.getImage("trace_start.gif"), (Runnable)new CounterON(PerfmonModuleTrace.this.loader));
                PerfmonModuleTrace.this.statcon.addModelAction(PerfmonModuleTrace.this.agent, PerfmonModuleTrace.this.ACTION_STOP_TRACING, PerfmonPlugin.getString("STOP_TRACING"), PerfmonModuleTrace.this.img.getImage("trace_stop.gif"), (Runnable)new CounterOFF(PerfmonModuleTrace.this.loader));
                PerfmonModuleTrace.this.configureSliders();
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.logVisibleError(throwable, PerfmonPlugin.getString("ERROR_STATCON_UPDATE") + " (1)", true);
            }
        }
    }

    class ProfileUpdate
    implements Runnable {
        ProfileEvent event;

        ProfileUpdate() {
        }

        public void run() {
            try {
                UIPlugin.getDefault().notifyProfileEventListener(this.event);
            }
            catch (Throwable throwable) {
                PerfmonPlugin.DBG.logVisibleError(throwable, PerfmonPlugin.getString("ERROR_SEND_PROFILING"), true);
            }
        }
    }

    class MonitorViewUpdate
    implements Runnable {
        IPath temp;

        MonitorViewUpdate() {
        }

        public void run() {
            block3: {
                try {
                    if (!PerfmonModuleTrace.this.new_monitor) {
                        PDContentProvider.resetMonitors();
                        break block3;
                    }
                    PDContentProvider.addMonitor((IResource)PerfmonModuleTrace.createContainer(this.temp), (TRCMonitor)PerfmonModuleTrace.this.monitor);
                }
                catch (Throwable throwable) {
                    PerfmonPlugin.DBG.logVisibleError(throwable, PerfmonPlugin.getString("ERROR_UPDATE_PROFMON"), true);
                }
            }
        }
    }
}

