/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;

public abstract class BaseMessage
extends GraphNode {
    protected Lifeline startLifeline = null;
    protected Lifeline endLifeline = null;
    private String prefId = "PREF_SYNC_MESS";
    protected int eventOccurrence = 0;
    protected boolean visible = true;

    public int getX() {
        return this.getX(false);
    }

    public int getY() {
        if (this.startLifeline != null && this.endLifeline != null) {
            return this.endLifeline.getY() + this.endLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.eventOccurrence;
        }
        if (this.startLifeline != null) {
            return this.startLifeline.getY() + this.startLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.eventOccurrence;
        }
        if (this.endLifeline != null) {
            return this.endLifeline.getY() + this.endLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.eventOccurrence;
        }
        return 0;
    }

    public int getWidth() {
        return this.getWidth(false);
    }

    public int getHeight() {
        return 0;
    }

    protected int getX(boolean bl) {
        int n = 0;
        int n2 = 4;
        if (this.startLifeline != null && this.endLifeline != null) {
            n = this.startLifeline.getX() + Metrics.getLifelineWidth() / 2;
        } else {
            if (this.startLifeline != null) {
                n = this.startLifeline.getX() + Metrics.getLifelineWidth() / 2;
            }
            if (this.endLifeline != null) {
                n = this.endLifeline.getX() - 22;
            }
        }
        if (bl) {
            return n;
        }
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline.getX() > this.endLifeline.getX()) {
            n2 = -n2;
        }
        if (this.isMessageStartInActivation(this.eventOccurrence)) {
            n += n2;
        }
        return n;
    }

    protected int getWidth(boolean bl) {
        int n = 0;
        int n2 = 4;
        if (this.startLifeline != null && this.endLifeline != null) {
            n = this.endLifeline.getX() + Metrics.getLifelineWidth() / 2 - this.getX(true);
        } else {
            if (this.startLifeline != null) {
                n = Metrics.swimmingLaneWidth() / 2;
            }
            if (this.endLifeline != null) {
                n = Metrics.swimmingLaneWidth() / 2;
            }
        }
        if (bl) {
            return n;
        }
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline.getX() > this.endLifeline.getX()) {
            n2 = -n2;
        }
        if (this.isMessageStartInActivation(this.eventOccurrence)) {
            n -= n2;
        }
        if (this.isMessageEndInActivation(this.eventOccurrence)) {
            n -= n2;
        }
        return n;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setStartLifeline(Lifeline lifeline) {
        this.startLifeline = lifeline;
    }

    public Lifeline getStartLifeline() {
        return this.startLifeline;
    }

    public Lifeline getEndLifeline() {
        return this.endLifeline;
    }

    public void setEndLifeline(Lifeline lifeline) {
        this.endLifeline = lifeline;
    }

    protected void setEventOccurrence(int n) {
        this.eventOccurrence = n;
    }

    public int getEventOccurrence() {
        return this.eventOccurrence;
    }

    protected boolean isMessageStartInActivation(int n) {
        boolean bl = false;
        if (this.startLifeline != null) {
            int n2 = this.getY();
            int n3 = 0;
            while (n3 < this.startLifeline.getExecutions().size()) {
                BasicExecutionOccurrence basicExecutionOccurrence = (BasicExecutionOccurrence)this.startLifeline.getExecutions().get(n3);
                if (n >= basicExecutionOccurrence.startOccurrence && n <= basicExecutionOccurrence.endOccurrence) {
                    bl = true;
                }
                if (basicExecutionOccurrence.getY() > n2) break;
                ++n3;
            }
        }
        return bl;
    }

    protected boolean isMessageEndInActivation(int n) {
        boolean bl = false;
        if (this.endLifeline != null) {
            int n2 = this.endLifeline.getExecOccurrenceDrawIndex();
            int n3 = 0;
            while (n3 < this.endLifeline.getExecutions().size()) {
                BasicExecutionOccurrence basicExecutionOccurrence = (BasicExecutionOccurrence)this.endLifeline.getExecutions().get(n3);
                if (n >= basicExecutionOccurrence.startOccurrence && n <= basicExecutionOccurrence.endOccurrence) {
                    bl = true;
                }
                if (basicExecutionOccurrence.getY() > this.getY()) break;
                ++n3;
            }
        }
        return bl;
    }

    public boolean contains(int n, int n2) {
        int n3 = this.getX();
        int n4 = this.getY();
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        int n7 = 10 + Metrics.getMessageFontHeigth();
        if (this.startLifeline == this.endLifeline) {
            if (this.getName().length() * Metrics.getAverageCharWidth() > Metrics.swimmingLaneWidth() - 4 + -20 ? Frame.contains(n3 + 20 + 10, n4, Metrics.swimmingLaneWidth() - 4 + -20, Metrics.getMessageFontHeigth(), n, n2) : Frame.contains(n3 + 20 + 10, n4, this.getName().length() * Metrics.getAverageCharWidth(), Metrics.getMessageFontHeigth(), n, n2)) {
                return true;
            }
            if (Frame.contains(n3, n4 - 5, 10, 10, n, n2)) {
                return true;
            }
            if (Frame.contains(n3 + 20 - 5, n4, 10, n6 + 10, n, n2)) {
                return true;
            }
            return Frame.contains(n3, n4 + n6 - 5 + 10, 10, 10, n, n2);
        }
        return Frame.contains(n3, n4 - n7, n5, n7 * 2, n - n7, n2);
    }

    private void drawMessage(IGC iGC) {
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (this.startLifeline == null && this.endLifeline != null) {
            IColor iColor;
            IColor iColor2 = iGC.getForeground();
            iGC.setForeground(Frame.getUserPref().getFontColor(this.prefId));
            iGC.drawTextTruncatedCentred(this.getName(), n, n2 - Metrics.getMessageFontHeigth() - 20, n3, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            iGC.setForeground(iColor2);
            iGC.drawLine(n, n2, n + n3, n2 + n4);
            Double d = new Double(Math.cos(0.75) * 7.0);
            Double d2 = new Double(Math.sin(0.75) * 7.0);
            if (iGC.getLineStyle() == iGC.getLineSolidStyle()) {
                iColor = iGC.getBackground();
                iGC.setBackground(iGC.getForeground());
                int[] nArray = new int[]{n + n3, n2 + n4, n + n3 - d.intValue(), n2 + n4 - d2.intValue(), n + n3 - d.intValue(), n2 + n4 + d2.intValue(), n + n3, n2 + n4};
                iGC.fillPolygon(nArray);
                iGC.drawPolygon(nArray);
                iGC.setBackground(iColor);
            } else {
                int n5 = iGC.getLineStyle();
                int n6 = iGC.getLineWidth();
                iGC.setLineWidth(n6 + 2);
                iGC.setLineStyle(iGC.getLineSolidStyle());
                iGC.drawLine(n + n3 - d.intValue(), n2 + n4 - d2.intValue(), n + n3, n2 + n4);
                iGC.drawLine(n + n3 - d.intValue(), n2 + n4 + d2.intValue(), n + n3, n2 + n4);
                iGC.setLineStyle(n5);
                iGC.setLineWidth(n6);
            }
            iColor = iGC.getBackground();
            iGC.setBackground(iGC.getForeground());
            int n7 = 5;
            if (iGC.getLineWidth() != 1) {
                n7 = n7 + 5 - 1;
            }
            iGC.fillOval(n - n7, n2 - n7, n7 * 2, n7 * 2);
            iGC.setBackground(iColor);
        } else if (this.endLifeline == null && this.startLifeline != null) {
            IColor iColor = iGC.getForeground();
            iGC.setForeground(Frame.getUserPref().getFontColor(this.prefId));
            iGC.drawTextTruncatedCentred(this.getName(), n, n2 - Metrics.getMessageFontHeigth() - 20, n3, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            iGC.setForeground(iColor);
            iGC.drawLine(n, n2, n + n3, n2 + n4);
            Double d = new Double(Math.cos(0.75) * 7.0);
            Double d3 = new Double(Math.sin(0.75) * 7.0);
            if (iGC.getLineStyle() == iGC.getLineSolidStyle()) {
                IColor iColor3 = iGC.getBackground();
                iGC.setBackground(iGC.getForeground());
                int[] nArray = new int[]{n + n3 - 5, n2 + n4, n + n3 - d.intValue() - 5, n2 + n4 - d3.intValue(), n + n3 - d.intValue() - 5, n2 + n4 + d3.intValue(), n + n3 - 5, n2 + n4};
                iGC.fillPolygon(nArray);
                iGC.drawPolygon(nArray);
                iGC.setBackground(iColor3);
            } else {
                int n8 = iGC.getLineStyle();
                int n9 = iGC.getLineWidth();
                iGC.setLineWidth(n9 + 2);
                iGC.setLineStyle(iGC.getLineSolidStyle());
                iGC.drawLine(n + n3 - d.intValue() - 5, n2 + n4 - d3.intValue(), n + n3 - 5, n2 + n4);
                iGC.drawLine(n + n3 - d.intValue() - 5, n2 + n4 + d3.intValue(), n + n3 - 5, n2 + n4);
                iGC.setLineStyle(n8);
                iGC.setLineWidth(n9);
            }
            IColor iColor4 = iGC.getBackground();
            iGC.setBackground(iGC.getForeground());
            int n10 = 5;
            if (iGC.getLineWidth() != 1) {
                n10 = n10 + 5 - 1;
            }
            iGC.fillOval(n + n3 - n10, n2 + n4 - n10, n10 * 2, n10 * 2);
            iGC.setBackground(iColor4);
        } else if (this.startLifeline != null && this.endLifeline != null && this.startLifeline == this.endLifeline) {
            int n11 = 10;
            n11 = 5;
            iGC.drawLine(n, n2, n + 10, n2);
            iGC.drawLine(n + 20, n2 + n11, n + 20, n2 + n4 + 10 - n11);
            iGC.drawLine(n, n2 + n4 + 10, n + 10, n2 + n4 + 10);
            Double d = new Double(Math.cos(0.75) * 7.0);
            Double d4 = new Double(Math.sin(0.75) * 7.0);
            if (iGC.getLineStyle() == iGC.getLineSolidStyle()) {
                IColor iColor = iGC.getBackground();
                iGC.setBackground(iGC.getForeground());
                int[] nArray = new int[]{n, n2 + n4 + 10, n + d.intValue(), n2 + n4 + 10 + d4.intValue(), n + d.intValue(), n2 + n4 + 10 - d4.intValue(), n, n2 + n4 + 10};
                iGC.fillPolygon(nArray);
                iGC.drawPolygon(nArray);
                iGC.setBackground(iColor);
            } else {
                int n12 = iGC.getLineStyle();
                int n13 = iGC.getLineWidth();
                iGC.setLineWidth(n13 + 2);
                iGC.setLineStyle(iGC.getLineSolidStyle());
                iGC.drawLine(n + d.intValue(), n2 + n4 + 10 + d4.intValue(), n, n2 + n4 + 10);
                iGC.drawLine(n + d.intValue(), n2 + n4 + 10 - d4.intValue(), n, n2 + n4 + 10);
                iGC.setLineStyle(n12);
                iGC.setLineWidth(n13);
            }
            iGC.drawArc(n, n2, 20, 2 * n11, 0, 90);
            iGC.drawArc(n, n2 + 10, 20, -2 * n11, 0, -90);
            iGC.setForeground(Frame.getUserPref().getFontColor(this.prefId));
            if (this.startLifeline.getIndex() == this.startLifeline.getFrame().getHorizontalIndex()) {
                iGC.drawTextTruncated(this.getName(), n + n3 + 20 + 20, n2, Metrics.swimmingLaneWidth() / 2 - 8 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
            } else {
                iGC.drawTextTruncated(this.getName(), n + n3 + 20 + 20, n2, Metrics.swimmingLaneWidth() - 8 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
            }
        } else if (this.startLifeline != null && this.endLifeline != null) {
            iGC.drawLine(n, n2, n + n3, n2 + n4);
            int n14 = this.endLifeline.getX() - this.startLifeline.getX();
            double d = n4;
            double d5 = n3;
            double d6 = Math.atan(d / d5);
            Double d7 = new Double(Math.cos(d6 - 0.75) * 7.0);
            Double d8 = new Double(Math.sin(d6 - 0.75) * 7.0);
            Double d9 = new Double(Math.cos(d6 + 0.75) * 7.0);
            Double d10 = new Double(Math.sin(d6 + 0.75) * 7.0);
            if (n14 > 0) {
                if (iGC.getLineStyle() == iGC.getLineSolidStyle()) {
                    IColor iColor = iGC.getBackground();
                    iGC.setBackground(iGC.getForeground());
                    int[] nArray = new int[]{n + n3 - d7.intValue(), n2 + n4 - d8.intValue(), n + n3, n2 + n4, n + n3 - d9.intValue(), n2 + n4 - d10.intValue(), n + n3 - d7.intValue(), n2 + n4 - d8.intValue()};
                    iGC.fillPolygon(nArray);
                    iGC.drawPolygon(nArray);
                    iGC.setBackground(iColor);
                } else {
                    int n15 = iGC.getLineStyle();
                    int n16 = iGC.getLineWidth();
                    iGC.setLineWidth(n16 + 2);
                    iGC.setLineStyle(iGC.getLineSolidStyle());
                    iGC.drawLine(n + n3 - d7.intValue(), n2 + n4 - d8.intValue(), n + n3, n2 + n4);
                    iGC.drawLine(n + n3 - d9.intValue(), n2 + n4 - d10.intValue(), n + n3, n2 + n4);
                    iGC.setLineStyle(n15);
                    iGC.setLineWidth(n16);
                }
                iGC.setForeground(Frame.getUserPref().getFontColor(this.prefId));
                iGC.drawTextTruncatedCentred(this.getName(), n, n2 - 20 - Metrics.getMessageFontHeigth(), n3, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            } else {
                if (iGC.getLineStyle() == iGC.getLineSolidStyle()) {
                    IColor iColor = iGC.getBackground();
                    iGC.setBackground(iGC.getForeground());
                    int[] nArray = new int[]{n + n3, n2 + n4, n + n3 + d7.intValue(), n2 + n4 + d8.intValue(), n + n3 + d9.intValue(), n2 + n4 + d10.intValue(), n + n3, n2 + n4};
                    iGC.fillPolygon(nArray);
                    iGC.drawPolygon(nArray);
                    iGC.setBackground(iColor);
                } else {
                    int n17 = iGC.getLineStyle();
                    int n18 = iGC.getLineWidth();
                    iGC.setLineWidth(n18 + 2);
                    iGC.setLineStyle(iGC.getLineSolidStyle());
                    iGC.drawLine(n + n3, n2 + n4, n + n3 + d7.intValue(), n2 + n4 + d8.intValue());
                    iGC.drawLine(n + n3, n2 + n4, n + n3 + d9.intValue(), n2 + n4 + d10.intValue());
                    iGC.setLineStyle(n17);
                    iGC.setLineWidth(n18);
                }
                iGC.setForeground(Frame.getUserPref().getFontColor(this.prefId));
                iGC.drawTextTruncatedCentred(this.getName(), n + n3, n2 - 20 - Metrics.getMessageFontHeigth(), -n3, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            }
        }
    }

    public void draw(IGC iGC) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isSelected()) {
            iGC.setForeground(Frame.getUserPref().getBackGroundColorSelection());
            iGC.setLineWidth(5);
            this.drawMessage(iGC);
            iGC.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            iGC.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        } else if (this instanceof SyncMessageReturn) {
            iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_SYNC_MESS_RET"));
            iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_SYNC_MESS_RET"));
            this.prefId = "PREF_SYNC_MESS_RET";
        } else if (this instanceof SyncMessage) {
            iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_SYNC_MESS"));
            iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_SYNC_MESS"));
            this.prefId = "PREF_SYNC_MESS";
        } else if (this instanceof AsyncMessageReturn) {
            iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_ASYNC_MESS_RET"));
            iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_ASYNC_MESS_RET"));
            this.prefId = "PREF_ASYNC_MESS_RET";
        } else if (this instanceof AsyncMessage) {
            iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_ASYNC_MESS"));
            iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_ASYNC_MESS"));
            this.prefId = "PREF_ASYNC_MESS";
        }
        iGC.setLineWidth(1);
        this.drawMessage(iGC);
    }
}

