/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.TimeEvent;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.ISDPreferences;
import org.eclipse.hyades.uml2sd.util.SortAsyncForBackward;
import org.eclipse.hyades.uml2sd.util.SortAsyncMessageComparator;
import org.eclipse.hyades.uml2sd.util.SortSyncMessageComparator;
import org.eclipse.hyades.uml2sd.util.TimeEventComparator;

public class Frame
extends GraphNode {
    protected double maxTime = -50.0;
    protected double minTime = -50.0;
    private boolean computeMinMax = true;
    protected List lifeLines = new ArrayList();
    protected List syncMessages = new ArrayList();
    protected List syncMessagesReturn = new ArrayList();
    protected List asyncMessages;
    protected List asyncMessagesReturn;
    protected List asyncMessagesRetForBackward;
    protected List asyncMessagesRetForForward;
    protected List asyncMessagesForBackward = new ArrayList();
    protected List asyncMessagesForForward = new ArrayList();
    protected int verticalIndex = 0;
    protected int horizontalIndex = 0;
    private int lifeLineDrawIndex = 0;
    private int messageDrawIndex = 0;
    private int messageReturnDrawIndex = 0;
    private int asyncMessageDrawIndex = 0;
    private int asyncMessageReturnDrawIndex = 0;
    protected LifelineCategories[] lifelineCategories = null;
    protected boolean sortSyncMessage = false;
    protected boolean sortSyncMessageReturn = false;
    protected boolean sortAsyncMessage = false;
    protected boolean sortAsyncMessageReturn = false;
    protected boolean sortBackwardAsyncList = false;
    protected boolean sortBackwardAsyncRetList = false;
    protected Lifeline highlightLifeline = null;
    protected int startEvent = 0;
    protected int nbEvent = 0;
    protected IColor highlightColor = null;
    protected boolean timeInfo = false;
    protected List executionOccurrencesWithTime;
    private int visibleAreaX;
    private int visibleAreaY;
    private int visibleAreaWidth;
    private int visibleAreaHeight;
    protected static ISDPreferences userPref = null;
    protected GraphNode focusNode = null;
    protected String unitName = null;
    protected int forceEventOccurrenceSpacing = -1;

    public Frame() {
        this.asyncMessages = this.asyncMessagesForForward;
        this.asyncMessagesRetForBackward = new ArrayList();
        this.asyncMessagesRetForForward = new ArrayList();
        this.asyncMessagesReturn = this.asyncMessagesRetForForward;
        Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing;
    }

    protected List getLifelines() {
        return this.lifeLines;
    }

    public Object[] getLifelinesArray() {
        return this.lifeLines.toArray();
    }

    public int lifeLinesCount() {
        if (this.lifeLines != null) {
            return this.lifeLines.size();
        }
        return 0;
    }

    public Lifeline getLifeline(int n) {
        if (this.lifeLines != null && n >= 0 && n < this.lifeLines.size()) {
            return (Lifeline)this.lifeLines.get(n);
        }
        return null;
    }

    protected List getSyncMessages() {
        return this.syncMessages;
    }

    public Object[] getSyncMessagesArray() {
        return this.syncMessages.toArray();
    }

    public int syncMessageCount() {
        if (this.syncMessages != null) {
            return this.syncMessages.size();
        }
        return 0;
    }

    public SyncMessage getSyncMessage(int n) {
        if (this.syncMessages != null && n >= 0 && n < this.syncMessages.size()) {
            return (SyncMessage)this.syncMessages.get(n);
        }
        return null;
    }

    public int asyncMessageCount() {
        if (this.asyncMessages != null) {
            return this.asyncMessages.size();
        }
        return 0;
    }

    public AsyncMessage getAsyncMessage(int n) {
        if (this.asyncMessages != null && n >= 0 && n < this.asyncMessages.size()) {
            return (AsyncMessage)this.asyncMessages.get(n);
        }
        return null;
    }

    public void resetIndex() {
        this.lifeLineDrawIndex = 0;
        this.messageDrawIndex = 0;
        this.messageReturnDrawIndex = 0;
    }

    public void setLifelineCategories(LifelineCategories[] lifelineCategoriesArray) {
        this.lifelineCategories = lifelineCategoriesArray;
    }

    public LifelineCategories[] getLifelineCategories() {
        return this.lifelineCategories;
    }

    protected List getSyncMessagesReturn() {
        return this.syncMessagesReturn;
    }

    public Object[] getSyncMessagesReturnArray() {
        return this.syncMessagesReturn.toArray();
    }

    public int syncMessageReturnCount() {
        if (this.syncMessagesReturn != null) {
            return this.syncMessagesReturn.size();
        }
        return 0;
    }

    public SyncMessageReturn getSyncMessageReturn(int n) {
        if (this.syncMessagesReturn != null && n >= 0 && n < this.syncMessagesReturn.size()) {
            return (SyncMessageReturn)this.syncMessagesReturn.get(n);
        }
        return null;
    }

    public int asyncMessageReturnCount() {
        if (this.asyncMessagesReturn != null) {
            return this.asyncMessagesReturn.size();
        }
        return 0;
    }

    public AsyncMessageReturn getAsyncMessageReturn(int n) {
        if (this.asyncMessagesReturn != null && n >= 0 && n < this.asyncMessagesReturn.size()) {
            return (AsyncMessageReturn)this.asyncMessagesReturn.get(n);
        }
        return null;
    }

    protected int getMaxEventOccurrence() {
        return this.verticalIndex;
    }

    protected void setMaxEventOccurrence(int n) {
        this.verticalIndex = n;
    }

    protected int getNewHorizontalIndex() {
        return ++this.horizontalIndex;
    }

    protected int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public void addLifeLine(Lifeline lifeline) {
        this.computeMinMax = true;
        if (lifeline == null) {
            return;
        }
        lifeline.setFrame(this);
        lifeline.setIndex(this.getNewHorizontalIndex());
        if (lifeline.hasTimeInfo()) {
            this.timeInfo = true;
        }
        this.lifeLines.add(lifeline);
    }

    public void addMessage(BaseMessage baseMessage) {
        this.computeMinMax = true;
        if (baseMessage == null) {
            return;
        }
        if (baseMessage instanceof SyncMessageReturn) {
            BaseMessage baseMessage2;
            if (this.syncMessagesReturn.size() > 0 && (baseMessage2 = (BaseMessage)this.syncMessagesReturn.get(this.syncMessagesReturn.size() - 1)).getEventOccurrence() > baseMessage.getEventOccurrence()) {
                this.sortSyncMessageReturn = true;
            }
            this.syncMessagesReturn.add(baseMessage);
        } else if (baseMessage instanceof SyncMessage) {
            BaseMessage baseMessage3;
            if (this.syncMessages.size() > 0 && (baseMessage3 = (BaseMessage)this.syncMessages.get(this.syncMessages.size() - 1)).getEventOccurrence() > baseMessage.getEventOccurrence()) {
                this.sortSyncMessage = true;
            }
            this.syncMessages.add(baseMessage);
        } else if (baseMessage instanceof AsyncMessageReturn) {
            if (this.asyncMessagesReturn.size() > 0) {
                AsyncMessage asyncMessage = (AsyncMessage)this.asyncMessagesReturn.get(this.asyncMessagesReturn.size() - 1);
                AsyncMessage asyncMessage2 = (AsyncMessage)baseMessage;
                SortAsyncMessageComparator sortAsyncMessageComparator = new SortAsyncMessageComparator();
                SortAsyncForBackward sortAsyncForBackward = new SortAsyncForBackward();
                if (sortAsyncMessageComparator.compare(asyncMessage, asyncMessage2) == 1) {
                    this.sortAsyncMessageReturn = true;
                }
                if (sortAsyncForBackward.compare(asyncMessage, asyncMessage2) == 1) {
                    this.sortBackwardAsyncRetList = true;
                }
            }
            this.asyncMessagesRetForForward.add(baseMessage);
            this.asyncMessagesRetForBackward.add(baseMessage);
            this.asyncMessagesReturn = this.asyncMessagesRetForForward;
        } else if (baseMessage instanceof AsyncMessage) {
            if (this.asyncMessages.size() > 0) {
                AsyncMessage asyncMessage = (AsyncMessage)this.asyncMessages.get(this.asyncMessages.size() - 1);
                AsyncMessage asyncMessage3 = (AsyncMessage)baseMessage;
                SortAsyncMessageComparator sortAsyncMessageComparator = new SortAsyncMessageComparator();
                SortAsyncForBackward sortAsyncForBackward = new SortAsyncForBackward();
                if (sortAsyncMessageComparator.compare(asyncMessage, asyncMessage3) == 1) {
                    this.sortAsyncMessage = true;
                }
                if (sortAsyncForBackward.compare(asyncMessage, asyncMessage3) == 1) {
                    this.sortBackwardAsyncList = true;
                }
            }
            this.asyncMessagesForForward.add(baseMessage);
            this.asyncMessagesForBackward.add(baseMessage);
            this.asyncMessages = this.asyncMessagesForForward;
        }
    }

    public void updateIndex(int n, int n2, int n3, int n4) {
        AsyncMessage asyncMessage;
        AsyncMessage asyncMessage2;
        int n5;
        BaseMessage baseMessage;
        GraphNode graphNode;
        int n6;
        this.visibleAreaX = n;
        this.visibleAreaY = n2;
        this.visibleAreaWidth = n3;
        this.visibleAreaHeight = n4;
        SortSyncMessageComparator sortSyncMessageComparator = new SortSyncMessageComparator();
        SortAsyncMessageComparator sortAsyncMessageComparator = new SortAsyncMessageComparator();
        SortAsyncForBackward sortAsyncForBackward = new SortAsyncForBackward();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        boolean bl = false;
        int n12 = 1;
        if (n == 0) {
            this.lifeLineDrawIndex = 0;
        }
        if (this.lifeLines == null || this.lifeLines.size() < 1) {
            return;
        }
        if (((Lifeline)this.lifeLines.get(this.lifeLineDrawIndex)).getX() > n) {
            n12 = -1;
        }
        int n13 = this.lifeLineDrawIndex;
        while (n13 < this.lifeLines.size() && n13 >= 0) {
            ++n7;
            this.lifeLineDrawIndex = n13;
            if (n12 == 1 ? ((Lifeline)this.lifeLines.get(n13)).getX() > n - Metrics.swimmingLaneWidth() : ((Lifeline)this.lifeLines.get(n13)).getX() < n) break;
            n13 += n12;
        }
        int n14 = 1;
        if (n2 == 0) {
            this.messageDrawIndex = 0;
            this.messageReturnDrawIndex = 0;
            this.asyncMessageDrawIndex = 0;
            this.asyncMessageReturnDrawIndex = 0;
        }
        if (this.syncMessages != null && this.syncMessages.size() > 0) {
            if (((BaseMessage)this.syncMessages.get(this.messageDrawIndex)).getY() > n2) {
                n14 = -1;
            }
            n6 = this.messageDrawIndex;
            while (n6 < this.syncMessages.size() && n6 >= 0) {
                ++n8;
                this.messageDrawIndex = n6;
                graphNode = (SyncMessage)this.syncMessages.get(n6);
                if (n6 < this.syncMessages.size() - 1 && sortSyncMessageComparator.compare(graphNode, baseMessage = (SyncMessage)this.syncMessages.get(n6 + 1)) == 1) {
                    this.sortSyncMessage = true;
                }
                if (n14 == 1 ? ((BaseMessage)this.syncMessages.get(n6)).getY() > n2 : ((BaseMessage)this.syncMessages.get(n6)).getY() < n2) break;
                n6 += n14;
            }
        }
        if (this.asyncMessagesReturn != null && this.asyncMessagesReturn.size() > 0) {
            n6 = ((BaseMessage)this.asyncMessagesReturn.get(this.asyncMessageReturnDrawIndex)).getY();
            int n15 = ((BaseMessage)this.asyncMessagesReturn.get(this.asyncMessageReturnDrawIndex)).getHeight();
            if (n6 > n2 || n6 + n15 > n2) {
                n14 = -1;
            }
            if (this.asyncMessageReturnDrawIndex == 0) {
                n14 = 1;
            }
            if (n14 == -1) {
                this.asyncMessageReturnDrawIndex = Arrays.binarySearch(this.asyncMessagesRetForBackward.toArray(), this.asyncMessagesReturn.get(this.asyncMessageReturnDrawIndex), new SortAsyncForBackward());
                this.asyncMessagesReturn = this.asyncMessagesRetForBackward;
            }
            baseMessage = null;
            n5 = this.asyncMessageReturnDrawIndex;
            while (n5 < this.asyncMessagesReturn.size() && n5 >= 0) {
                this.asyncMessageReturnDrawIndex = n5;
                ++n11;
                asyncMessage2 = (AsyncMessage)this.asyncMessagesReturn.get(n5);
                if (baseMessage == null) {
                    baseMessage = asyncMessage2;
                }
                if (n14 == 1) {
                    if (n5 < this.asyncMessagesReturn.size() - 1 && sortAsyncMessageComparator.compare(asyncMessage2, asyncMessage = (AsyncMessage)this.asyncMessagesReturn.get(n5 + 1)) == 1) {
                        this.sortAsyncMessageReturn = true;
                    }
                    if (asyncMessage2.getY() >= n2 || asyncMessage2.getY() + asyncMessage2.getHeight() >= n2) {
                        break;
                    }
                } else {
                    if (n5 < this.asyncMessagesReturn.size() - 1 && sortAsyncForBackward.compare(asyncMessage2, asyncMessage = (AsyncMessage)this.asyncMessagesReturn.get(n5 + 1)) == 1) {
                        this.sortBackwardAsyncRetList = true;
                    }
                    if (asyncMessage2.getY() <= n2 && asyncMessage2.getY() + asyncMessage2.getHeight() <= n2) {
                        if (sortAsyncMessageComparator.compare(asyncMessage2, baseMessage) <= 0) {
                            break;
                        }
                    } else if (sortAsyncMessageComparator.compare(asyncMessage2, baseMessage) <= 0) {
                        baseMessage = asyncMessage2;
                    }
                }
                n5 += n14;
            }
            this.asyncMessagesReturn = this.asyncMessagesRetForForward;
            if (n14 == -1 && this.asyncMessageReturnDrawIndex > 0) {
                this.asyncMessageReturnDrawIndex = Arrays.binarySearch(this.asyncMessagesReturn.toArray(), this.asyncMessagesRetForBackward.get(this.asyncMessageReturnDrawIndex), new SortAsyncMessageComparator());
            }
        }
        if (this.asyncMessages != null && this.asyncMessages.size() > 0) {
            n6 = ((BaseMessage)this.asyncMessages.get(this.asyncMessageDrawIndex)).getY();
            int n16 = ((BaseMessage)this.asyncMessages.get(this.asyncMessageDrawIndex)).getHeight();
            if (n6 > n2 || n6 + n16 > n2) {
                n14 = -1;
            }
            if (this.asyncMessageDrawIndex == 0) {
                n14 = 1;
            }
            if (n14 == -1) {
                this.asyncMessages = this.asyncMessagesForForward;
                this.asyncMessageDrawIndex = Arrays.binarySearch(this.asyncMessagesForBackward.toArray(), this.asyncMessagesForForward.get(this.asyncMessageDrawIndex), new SortAsyncForBackward());
                this.asyncMessages = this.asyncMessagesForBackward;
            }
            baseMessage = null;
            n5 = this.asyncMessageDrawIndex;
            while (n5 < this.asyncMessages.size() && n5 >= 0) {
                if (SDViewerPlugin.debugIndex()) {
                    System.out.print("Direction = " + n14 + "\n");
                }
                ++n9;
                this.asyncMessageDrawIndex = n5;
                asyncMessage2 = (AsyncMessage)this.asyncMessages.get(n5);
                if (baseMessage == null) {
                    baseMessage = asyncMessage2;
                }
                if (n14 == 1) {
                    asyncMessage = null;
                    if (n5 < this.asyncMessages.size() - 1 && sortAsyncMessageComparator.compare(asyncMessage2, asyncMessage = (AsyncMessage)this.asyncMessages.get(n5 + 1)) == 1) {
                        this.sortAsyncMessage = true;
                    }
                    if (asyncMessage2.getY() >= n2 || asyncMessage2.getY() + asyncMessage2.getHeight() >= n2) {
                        break;
                    }
                } else {
                    if (n5 < this.asyncMessages.size() - 1 && sortAsyncForBackward.compare(asyncMessage2, asyncMessage = (AsyncMessage)this.asyncMessages.get(n5 + 1)) == 1) {
                        this.sortBackwardAsyncList = true;
                    }
                    if (asyncMessage2.getY() <= n2 && asyncMessage2.getY() + asyncMessage2.getHeight() <= n2) {
                        if (sortAsyncMessageComparator.compare(asyncMessage2, baseMessage) <= 0) {
                            break;
                        }
                    } else if (sortAsyncMessageComparator.compare(asyncMessage2, baseMessage) <= 0) {
                        baseMessage = asyncMessage2;
                    }
                }
                n5 += n14;
            }
            this.asyncMessages = this.asyncMessagesForForward;
            if (n14 == -1 && this.asyncMessageDrawIndex > 0) {
                this.asyncMessageDrawIndex = Arrays.binarySearch(this.asyncMessages.toArray(), this.asyncMessagesForBackward.get(this.asyncMessageDrawIndex), new SortAsyncMessageComparator());
            }
        }
        if (this.syncMessagesReturn != null && this.syncMessagesReturn.size() > 0) {
            if (((BaseMessage)this.syncMessagesReturn.get(this.messageReturnDrawIndex)).getY() > n2) {
                n14 = -1;
            }
            n6 = this.messageReturnDrawIndex;
            while (n6 < this.syncMessagesReturn.size() && n6 >= 0) {
                ++n10;
                this.messageReturnDrawIndex = n6;
                graphNode = (SyncMessage)this.syncMessagesReturn.get(n6);
                if (n6 < this.syncMessagesReturn.size() - 1 && sortSyncMessageComparator.compare(graphNode, baseMessage = (SyncMessage)this.syncMessagesReturn.get(n6 + 1)) == 1) {
                    this.sortSyncMessageReturn = true;
                }
                if (n14 == 1 ? ((BaseMessage)this.syncMessagesReturn.get(n6)).getY() > n2 : ((BaseMessage)this.syncMessagesReturn.get(n6)).getY() < n2) break;
                n6 += n14;
            }
        }
        n6 = this.lifeLineDrawIndex;
        while (n6 < this.lifeLines.size()) {
            graphNode = (Lifeline)this.lifeLines.get(n6);
            graphNode.updateIndex(n, n2);
            if (graphNode.getX() > n + n3) break;
            ++n6;
        }
        if (SDViewerPlugin.debugIndex()) {
            System.out.print("*****************************\n");
            System.out.print("Visible area position in virtual screen (x,y)= " + n + " " + n2 + "\n\n");
            System.out.print("First drawn lifeline index = " + this.lifeLineDrawIndex + "\n");
            System.out.print("First drawn sync message index = " + this.messageDrawIndex + "\n");
            System.out.print("First drawn sync message return index = " + this.messageReturnDrawIndex + "\n");
            System.out.print("First drawn async message index = " + this.asyncMessageDrawIndex + "\n");
            System.out.print("First drawn async return message index = " + this.asyncMessageReturnDrawIndex + "\n\n");
            System.out.print("Lifeline index found in = " + n7 + " iterations\n");
            System.out.print("Sync Message index found in = " + n8 + " iterations\n");
            System.out.print("Sync Message Return index found in " + n10 + " iterations\n");
            System.out.print("Async Message found in " + n9 + " iterations\n");
            System.out.print("Async Message Return found in " + n11 + " iterations\n");
            System.out.print("*****************************\n");
        }
    }

    public int getFirstVisibleLifeline() {
        return this.lifeLineDrawIndex;
    }

    public int getFirstVisibleSyncMessage() {
        return this.messageDrawIndex;
    }

    public int getFirstVisibleSyncMessageReturn() {
        return this.messageReturnDrawIndex;
    }

    public int getFirstVisibleAsyncMessage() {
        return this.asyncMessageDrawIndex;
    }

    public int getFirstVisibleAsyncMessageReturn() {
        return this.asyncMessageReturnDrawIndex;
    }

    public int getX() {
        return 10;
    }

    public int getY() {
        return 10;
    }

    public int getWidth() {
        if (this.horizontalIndex == 0) {
            return Metrics.swimmingLaneWidth() + 46 - 10 - 22;
        }
        return this.horizontalIndex * Metrics.swimmingLaneWidth() + 46 - 45;
    }

    public int getHeight() {
        if (this.forceEventOccurrenceSpacing >= 0) {
            Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing;
        }
        return this.verticalIndex * (Metrics.getMessagesSpacing() + Metrics.getMessageFontHeigth()) + 14 + 4 + Metrics.getLifelineFontHeigth() + 30 + 20 + 14 + 4 + Metrics.getLifelineFontHeigth() * 2;
    }

    protected GraphNode getNodeFromListAt(int n, int n2, List list, int n3) {
        if (list == null) {
            return null;
        }
        int n4 = n3;
        while (n4 < list.size()) {
            GraphNode graphNode = (GraphNode)list.get(n4);
            if (graphNode instanceof Lifeline && graphNode.getX() > this.visibleAreaX + this.visibleAreaWidth || (graphNode.getHeight() >= 0 ? graphNode.getY() > this.visibleAreaY + this.visibleAreaHeight : graphNode.getY() + graphNode.getHeight() > this.visibleAreaY + this.visibleAreaHeight)) break;
            if (graphNode.contains(n, n2)) {
                return graphNode;
            }
            ++n4;
        }
        return null;
    }

    protected GraphNode getCloserLeavingMessage(Lifeline lifeline, BaseMessage baseMessage, List list, boolean bl) {
        if (list == null) {
            return null;
        }
        if (!bl) {
            int n = 0;
            if (baseMessage != null) {
                n = baseMessage.getEventOccurrence();
            }
            int n2 = 0;
            while (n2 < list.size()) {
                GraphNode graphNode = (GraphNode)list.get(n2);
                if (graphNode instanceof SyncMessage ? ((SyncMessage)graphNode).getEventOccurrence() >= n && ((SyncMessage)graphNode).getStartLifeline() == lifeline && graphNode != baseMessage : graphNode instanceof AsyncMessage && ((AsyncMessage)graphNode).getStartOccurrence() >= n && ((AsyncMessage)graphNode).getStartLifeline() == lifeline && graphNode != baseMessage) {
                    return graphNode;
                }
                ++n2;
            }
        } else {
            int n = this.getMaxEventOccurrence();
            if (baseMessage != null) {
                n = baseMessage.getEventOccurrence();
            }
            int n3 = list.size() - 1;
            while (n3 >= 0) {
                GraphNode graphNode = (GraphNode)list.get(n3);
                if (graphNode instanceof SyncMessage ? ((SyncMessage)graphNode).getEventOccurrence() < n && ((SyncMessage)graphNode).getStartLifeline() == lifeline && graphNode != baseMessage : graphNode instanceof AsyncMessage && ((AsyncMessage)graphNode).getStartOccurrence() < n && ((AsyncMessage)graphNode).getStartLifeline() == lifeline && graphNode != baseMessage) {
                    return graphNode;
                }
                --n3;
            }
        }
        return null;
    }

    protected GraphNode getCloserEnteringMessage(Lifeline lifeline, BaseMessage baseMessage, List list, boolean bl) {
        if (list == null) {
            return null;
        }
        if (!bl) {
            int n = 0;
            if (baseMessage != null) {
                n = baseMessage.getEventOccurrence();
            }
            int n2 = 0;
            while (n2 < list.size()) {
                GraphNode graphNode = (GraphNode)list.get(n2);
                if (graphNode instanceof SyncMessage ? ((SyncMessage)graphNode).getEventOccurrence() < n && ((SyncMessage)graphNode).getEndLifeline() == lifeline && graphNode != baseMessage : graphNode instanceof AsyncMessage && ((AsyncMessage)graphNode).getStartOccurrence() < n && ((AsyncMessage)graphNode).getEndLifeline() == lifeline && graphNode != baseMessage) {
                    return graphNode;
                }
                ++n2;
            }
        } else {
            int n = this.getMaxEventOccurrence();
            if (baseMessage != null) {
                n = baseMessage.getEventOccurrence();
            }
            int n3 = list.size() - 1;
            while (n3 >= 0) {
                GraphNode graphNode = (GraphNode)list.get(n3);
                if (graphNode instanceof SyncMessage ? ((SyncMessage)graphNode).getEventOccurrence() < n && ((SyncMessage)graphNode).getEndLifeline() == lifeline && graphNode != baseMessage : graphNode instanceof AsyncMessage && ((AsyncMessage)graphNode).getStartOccurrence() < n && ((AsyncMessage)graphNode).getEndLifeline() == lifeline && graphNode != baseMessage) {
                    return graphNode;
                }
                --n3;
            }
        }
        return null;
    }

    private int distanceFromEvent(GraphNode graphNode, int n) {
        int n2 = 0;
        if (graphNode instanceof SyncMessage) {
            n2 = ((SyncMessage)graphNode).getEventOccurrence() - n;
        } else if (graphNode instanceof AsyncMessage) {
            int n3;
            int n4 = ((AsyncMessage)graphNode).getStartOccurrence();
            n2 = n4 - n < (n3 = ((AsyncMessage)graphNode).getEndOccurrence()) - n ? n4 - n : n4 - n;
        }
        return Math.abs(n2);
    }

    private GraphNode getCloserToEvent(GraphNode graphNode, GraphNode graphNode2, int n) {
        if (graphNode != null && graphNode2 != null) {
            if (this.distanceFromEvent(graphNode, n) < this.distanceFromEvent(graphNode2, n)) {
                return graphNode;
            }
            return graphNode2;
        }
        if (graphNode != null) {
            return graphNode;
        }
        if (graphNode2 != null) {
            return graphNode2;
        }
        return null;
    }

    public GraphNode getCalledMessage(BaseMessage baseMessage) {
        int n = 0;
        GraphNode graphNode = null;
        Lifeline lifeline = null;
        if (baseMessage != null) {
            n = baseMessage.getEventOccurrence();
            lifeline = baseMessage.getEndLifeline();
            if (lifeline == null) {
                lifeline = baseMessage.getStartLifeline();
            }
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessages, false);
        GraphNode graphNode3 = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessagesReturn, false);
        graphNode = this.getCloserToEvent(graphNode2, graphNode3, n);
        graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessages, false);
        graphNode = this.getCloserToEvent(graphNode, graphNode2, n);
        graphNode3 = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessagesReturn, false);
        graphNode = this.getCloserToEvent(graphNode, graphNode3, n);
        return graphNode;
    }

    public GraphNode getCallerMessage(BaseMessage baseMessage) {
        int n = this.getMaxEventOccurrence();
        GraphNode graphNode = null;
        Lifeline lifeline = null;
        if (baseMessage != null) {
            n = baseMessage.getEventOccurrence();
            lifeline = baseMessage.getStartLifeline();
            if (lifeline == null) {
                lifeline = baseMessage.getEndLifeline();
            }
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode graphNode2 = this.getCloserEnteringMessage(lifeline, baseMessage, this.syncMessages, true);
        GraphNode graphNode3 = this.getCloserEnteringMessage(lifeline, baseMessage, this.syncMessagesReturn, true);
        graphNode = this.getCloserToEvent(graphNode2, graphNode3, n);
        graphNode2 = this.getCloserEnteringMessage(lifeline, baseMessage, this.asyncMessages, true);
        graphNode = this.getCloserToEvent(graphNode, graphNode2, n);
        graphNode3 = this.getCloserEnteringMessage(lifeline, baseMessage, this.asyncMessagesReturn, true);
        graphNode = this.getCloserToEvent(graphNode, graphNode3, n);
        return graphNode;
    }

    public GraphNode getNextLifelineMessage(Lifeline lifeline, BaseMessage baseMessage) {
        int n = 0;
        if (baseMessage != null) {
            n = baseMessage.getEventOccurrence();
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode graphNode = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessages, false);
        GraphNode graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessagesReturn, false);
        GraphNode graphNode3 = this.getCloserToEvent(graphNode, graphNode2, n);
        graphNode = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessages, false);
        graphNode3 = this.getCloserToEvent(graphNode3, graphNode, n);
        graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessagesReturn, false);
        graphNode3 = this.getCloserToEvent(graphNode3, graphNode2, n);
        return graphNode3;
    }

    public GraphNode getPrevLifelineMessage(Lifeline lifeline, BaseMessage baseMessage) {
        int n = this.getMaxEventOccurrence();
        if (baseMessage != null) {
            n = baseMessage.getEventOccurrence();
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode graphNode = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessages, true);
        GraphNode graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.syncMessagesReturn, true);
        GraphNode graphNode3 = this.getCloserToEvent(graphNode, graphNode2, n);
        graphNode = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessages, true);
        graphNode3 = this.getCloserToEvent(graphNode3, graphNode, n);
        graphNode2 = this.getCloserLeavingMessage(lifeline, baseMessage, this.asyncMessagesReturn, true);
        graphNode3 = this.getCloserToEvent(graphNode3, graphNode2, n);
        return graphNode3;
    }

    public GraphNode getNodeAt(int n, int n2) {
        GraphNode graphNode = this.getNodeFromListAt(n, n2, this.lifeLines, this.lifeLineDrawIndex);
        if (graphNode != null) {
            GraphNode graphNode2 = this.getNodeFromListAt(n, n2, ((Lifeline)graphNode).executionOccurrences, 0);
            if (graphNode2 != null) {
                return graphNode2;
            }
            return graphNode;
        }
        graphNode = this.getNodeFromListAt(n, n2, this.syncMessages, this.messageDrawIndex);
        if (graphNode != null) {
            return graphNode;
        }
        graphNode = this.getNodeFromListAt(n, n2, this.syncMessagesReturn, this.messageReturnDrawIndex);
        if (graphNode != null) {
            return graphNode;
        }
        graphNode = this.getNodeFromListAt(n, n2, this.asyncMessages, 0);
        if (graphNode != null) {
            return graphNode;
        }
        graphNode = this.getNodeFromListAt(n, n2, this.asyncMessagesReturn, 0);
        if (graphNode != null) {
            return graphNode;
        }
        return null;
    }

    public void draw(IGC iGC) {
        int n;
        GraphNode graphNode;
        int n2;
        int n3;
        Object[] objectArray;
        this.visibleAreaHeight = iGC.getVisibleHeight();
        this.visibleAreaWidth = iGC.getVisibleWidth();
        this.visibleAreaX = iGC.getContentsX();
        this.visibleAreaY = iGC.getContentsY();
        if (this.forceEventOccurrenceSpacing >= 0) {
            Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing;
        }
        if (userPref == null) {
            return;
        }
        if (this.sortSyncMessage) {
            objectArray = this.syncMessages.toArray();
            Arrays.sort(objectArray, new SortSyncMessageComparator());
            this.sortSyncMessage = false;
            this.syncMessages = Arrays.asList(objectArray);
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Syn messages array sorted\n");
            }
        }
        if (this.sortSyncMessageReturn) {
            objectArray = this.syncMessagesReturn.toArray();
            Arrays.sort(objectArray, new SortSyncMessageComparator());
            this.sortSyncMessageReturn = false;
            this.syncMessagesReturn = Arrays.asList(objectArray);
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Syn messages return array sorted\n");
            }
        }
        if (this.sortAsyncMessage) {
            objectArray = this.asyncMessagesForForward.toArray();
            Arrays.sort(objectArray, new SortAsyncMessageComparator());
            this.sortAsyncMessage = false;
            this.asyncMessagesForForward = Arrays.asList(objectArray);
            this.asyncMessages = this.asyncMessagesForForward;
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Asyn messages array sorted\n");
            }
        }
        if (this.sortBackwardAsyncList) {
            objectArray = this.asyncMessagesForBackward.toArray();
            Arrays.sort(objectArray, new SortAsyncForBackward());
            this.sortBackwardAsyncList = false;
            this.asyncMessagesForBackward = Arrays.asList(objectArray);
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Backward asyn messages array sorted\n");
            }
        }
        if (this.sortAsyncMessageReturn) {
            objectArray = this.asyncMessagesRetForForward.toArray();
            Arrays.sort(objectArray, new SortAsyncMessageComparator());
            this.sortAsyncMessageReturn = false;
            this.asyncMessagesRetForForward = Arrays.asList(objectArray);
            this.asyncMessagesReturn = this.asyncMessagesRetForForward;
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Asyn messages return array sorted\n");
            }
        }
        if (this.sortBackwardAsyncRetList) {
            objectArray = this.asyncMessagesRetForBackward.toArray();
            Arrays.sort(objectArray, new SortAsyncForBackward());
            this.sortBackwardAsyncRetList = false;
            this.asyncMessagesRetForBackward = Arrays.asList(objectArray);
            if (SDViewerPlugin.debugSorting()) {
                System.out.print("Backward asyn messages return array sorted\n");
            }
        }
        iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
        int n4 = this.getX();
        int n5 = this.getY();
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        iGC.fillRectangle(n4, n5, n6, n7);
        iGC.drawRectangle(n4, n5, n6, n7);
        iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME_NAME"));
        iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME_NAME"));
        iGC.setFont(Frame.getUserPref().getFont("PREF_FRAME_NAME"));
        int n8 = iGC.textExtent(this.getName()) + 16;
        int n9 = Metrics.getLifelineFontHeigth() + 8;
        if (n8 > n6) {
            n8 = n6;
        }
        int[] nArray = new int[]{n4, n5, n4 + n8, n5, n4 + n8, n5 - 11 + n9, n4 - 11 + n8, n5 + n9, n4, n5 + n9, n4, n5 + n9};
        iGC.fillPolygon(nArray);
        iGC.drawPolygon(nArray);
        iGC.drawLine(n4, n5, n4, n5 + n9);
        iGC.setForeground(Frame.getUserPref().getFontColor("PREF_FRAME_NAME"));
        iGC.drawTextTruncatedCentred(this.getName(), n4, n5, n8 - 11, n9, false);
        iGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        iGC.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
        int n10 = 0;
        int n11 = 1;
        int n12 = 1;
        if ((float)Metrics.swimmingLaneWidth() * iGC.getZoom() < 10.0f) {
            n11 = Math.round(10.0f / ((float)Metrics.swimmingLaneWidth() * iGC.getZoom()));
        }
        if ((float)(Metrics.getMessageFontHeigth() + 20) * iGC.getZoom() < 1.0f) {
            n12 = Math.round(1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * iGC.getZoom()));
        }
        if (this.lifeLines == null || this.lifeLines.size() < 1) {
            return;
        }
        if (this.highlightLifeline != null) {
            IColor iColor = iGC.getBackground();
            iGC.setBackground(Frame.getUserPref().getTimeCompressionSelectionColor());
            int n13 = this.highlightLifeline.getY() + this.highlightLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.startEvent;
            iGC.fillRectangle(11, n13, this.highlightLifeline.getX() + Metrics.getLifelineWidth() / 2 - 10, (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.nbEvent);
            iGC.setBackground(iColor);
        }
        iGC.setFont(Frame.getUserPref().getFont("PREF_LIFELINE"));
        int n14 = this.lifeLineDrawIndex;
        while (n14 < this.lifeLines.size()) {
            Lifeline lifeline = (Lifeline)this.lifeLines.get(n14);
            if (lifeline.getX() > iGC.getContentsX() + iGC.getVisibleWidth()) break;
            lifeline.draw(iGC);
            if (this.highlightLifeline != null) {
                if (lifeline == this.highlightLifeline) {
                    lifeline.highlightExecOccurrenceRegion(iGC, this.startEvent, this.nbEvent, this.highlightColor);
                } else if (lifeline.getIndex() < this.highlightLifeline.getIndex() || lifeline.getIndex() < this.highlightLifeline.getIndex()) {
                    n2 = n3 = lifeline.getExecOccurrenceDrawIndex();
                    while (n7 < lifeline.getExecutions().size()) {
                        graphNode = (BasicExecutionOccurrence)lifeline.getExecutions().get(n2);
                        int n15 = this.startEvent;
                        n = 0;
                        while (n < this.nbEvent) {
                            if (n15 >= ((BasicExecutionOccurrence)graphNode).startOccurrence && n15 <= ((BasicExecutionOccurrence)graphNode).endOccurrence && n15 + 1 >= ((BasicExecutionOccurrence)graphNode).startOccurrence && n15 + 1 <= ((BasicExecutionOccurrence)graphNode).endOccurrence) {
                                lifeline.highlightExecOccurrenceRegion(iGC, n15, 1, Frame.getUserPref().getTimeCompressionSelectionColor());
                            }
                            ++n15;
                            ++n;
                        }
                        if (((BasicExecutionOccurrence)graphNode).getY() > this.getY()) break;
                        ++n2;
                    }
                }
            }
            ++n10;
            n14 += n11;
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print("\n");
            System.out.print(n10 + " Lifeline drawn, starting from index " + this.lifeLineDrawIndex + "\n");
        }
        int n16 = 0;
        if (this.syncMessages != null && this.syncMessages.size() > 0) {
            SortSyncMessageComparator sortSyncMessageComparator = new SortSyncMessageComparator();
            iGC.setFont(Frame.getUserPref().getFont("PREF_SYNC_MESS"));
            n2 = this.messageDrawIndex;
            while (n2 < this.syncMessages.size()) {
                SyncMessage syncMessage;
                graphNode = (SyncMessage)this.syncMessages.get(n2);
                if (n2 < this.syncMessages.size() - 1 && sortSyncMessageComparator.compare(graphNode, syncMessage = (SyncMessage)this.syncMessages.get(n2 + 1)) == 1) {
                    this.sortSyncMessage = true;
                }
                if (((BaseMessage)graphNode).getY() > iGC.getContentsY() + iGC.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth()) break;
                if (((SyncMessage)graphNode).endLifeline == null && ((SyncMessage)graphNode).startLifeline != null) {
                    if (iGC.getContentsX() + iGC.getVisibleWidth() > ((BaseMessage)graphNode).getX() + ((BaseMessage)graphNode).getWidth() && iGC.getContentsX() < ((BaseMessage)graphNode).getX() + ((BaseMessage)graphNode).getWidth()) {
                        ((BaseMessage)graphNode).draw(iGC);
                        ++n16;
                    }
                } else if (((SyncMessage)graphNode).endLifeline != null && ((SyncMessage)graphNode).startLifeline == null && iGC.getContentsX() + iGC.getVisibleWidth() > ((BaseMessage)graphNode).getX() + ((BaseMessage)graphNode).getWidth() && iGC.getContentsX() < ((BaseMessage)graphNode).getX() + ((BaseMessage)graphNode).getWidth()) {
                    ((BaseMessage)graphNode).draw(iGC);
                    ++n16;
                }
                if (this.lifelineDependantDrawing(iGC, (BaseMessage)graphNode)) {
                    ++n16;
                }
                n2 += n12;
            }
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print(n16 + " Message drawn, starting from index " + this.messageDrawIndex + "\n");
        }
        n16 = 0;
        if (this.syncMessagesReturn != null && this.syncMessagesReturn.size() > 0) {
            SortSyncMessageComparator sortSyncMessageComparator = new SortSyncMessageComparator();
            iGC.setFont(Frame.getUserPref().getFont("PREF_SYNC_MESS_RET"));
            n2 = this.messageReturnDrawIndex;
            while (n2 < this.syncMessagesReturn.size()) {
                SyncMessage syncMessage;
                graphNode = (SyncMessage)this.syncMessagesReturn.get(n2);
                if (n2 < this.syncMessagesReturn.size() - 1 && sortSyncMessageComparator.compare(graphNode, syncMessage = (SyncMessage)this.syncMessagesReturn.get(n2 + 1)) == 1) {
                    this.sortSyncMessageReturn = true;
                }
                if (((BaseMessage)graphNode).getY() > iGC.getContentsY() + iGC.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth()) break;
                if (this.lifelineDependantDrawing(iGC, (BaseMessage)graphNode)) {
                    ++n16;
                }
                n2 += n12;
            }
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print(n16 + " Message return drawn, starting from index " + this.messageReturnDrawIndex + "\n");
        }
        n16 = 0;
        if (this.asyncMessages != null && this.asyncMessages.size() > 0) {
            SortAsyncMessageComparator sortAsyncMessageComparator = new SortAsyncMessageComparator();
            iGC.setFont(Frame.getUserPref().getFont("PREF_ASYNC_MESS"));
            n2 = this.asyncMessageDrawIndex;
            while (n2 < this.asyncMessages.size()) {
                AsyncMessage asyncMessage;
                graphNode = (AsyncMessage)this.asyncMessages.get(n2);
                if (n2 < this.asyncMessages.size() - 1 && sortAsyncMessageComparator.compare(graphNode, asyncMessage = (AsyncMessage)this.asyncMessages.get(n2 + 1)) == 1) {
                    this.sortAsyncMessage = true;
                }
                int n17 = ((AsyncMessage)graphNode).getY();
                n = ((AsyncMessage)graphNode).getHeight();
                if (n17 > iGC.getContentsY() + iGC.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth() && n17 + n > iGC.getContentsY() + iGC.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth()) break;
                if (this.lifelineDependantDrawing(iGC, (BaseMessage)graphNode)) {
                    ++n16;
                }
                n2 += n12;
            }
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print(n16 + " Async message drawn, starting from index " + this.asyncMessageDrawIndex + "\n");
        }
        n16 = 0;
        if (this.asyncMessagesReturn != null && this.asyncMessagesReturn.size() > 0) {
            SortAsyncMessageComparator sortAsyncMessageComparator = new SortAsyncMessageComparator();
            iGC.setFont(Frame.getUserPref().getFont("PREF_ASYNC_MESS_RET"));
            n2 = this.asyncMessageReturnDrawIndex;
            while (n2 < this.asyncMessagesReturn.size()) {
                AsyncMessage asyncMessage;
                graphNode = (AsyncMessage)this.asyncMessagesReturn.get(n2);
                if (n2 < this.asyncMessagesReturn.size() - 1 && sortAsyncMessageComparator.compare(graphNode, asyncMessage = (AsyncMessage)this.asyncMessagesReturn.get(n2 + 1)) == 1) {
                    this.sortAsyncMessageReturn = true;
                }
                int n18 = ((AsyncMessage)graphNode).getY();
                n = ((AsyncMessage)graphNode).getHeight();
                if (n18 > iGC.getContentsY() + iGC.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth() && n18 + n > iGC.getContentsY() + iGC.getVisibleHeight() + 10 + Metrics.getMessageFontHeigth()) break;
                if (this.lifelineDependantDrawing(iGC, (BaseMessage)graphNode)) {
                    ++n16;
                }
                n2 += n12;
            }
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print(n16 + " Async message return drawn, starting from index " + this.asyncMessageReturnDrawIndex + "\n\n");
        }
        n3 = this.lifeLineDrawIndex;
        while (n3 < this.lifeLines.size()) {
            Lifeline lifeline = (Lifeline)this.lifeLines.get(n3);
            if (lifeline.getX() - 22 > iGC.getContentsX() + iGC.getVisibleWidth()) break;
            lifeline.drawName(iGC);
            n3 += n11;
        }
    }

    public void setFocusNode(GraphNode graphNode) {
        this.focusNode = graphNode;
    }

    public GraphNode getFocusNode() {
        return this.focusNode;
    }

    private boolean lifelineDependantDrawing(IGC iGC, BaseMessage baseMessage) {
        if (baseMessage.endLifeline != null && baseMessage.endLifeline.isVisible(iGC.getContentsX(), 0, iGC.getVisibleWidth(), 0) || baseMessage.startLifeline != null && baseMessage.startLifeline.isVisible(iGC.getContentsX(), 0, iGC.getVisibleWidth(), 0)) {
            baseMessage.draw(iGC);
            return true;
        }
        if (baseMessage.endLifeline != null && !baseMessage.endLifeline.isVisible(iGC.getContentsX(), 0, iGC.getVisibleWidth(), 0) && baseMessage.startLifeline != null && !baseMessage.startLifeline.isVisible(iGC.getContentsX(), 0, iGC.getVisibleWidth(), 0)) {
            if (baseMessage.endLifeline.getX() > iGC.getContentsX() + iGC.getVisibleWidth() && baseMessage.startLifeline.getX() < iGC.getContentsX()) {
                baseMessage.draw(iGC);
                return true;
            }
            if (baseMessage.startLifeline.getX() > iGC.getContentsX() + iGC.getVisibleWidth() && baseMessage.endLifeline.getX() < iGC.getContentsX()) {
                baseMessage.draw(iGC);
                return true;
            }
        }
        return false;
    }

    public void highlightTimeCompression(Lifeline lifeline, int n, int n2, IColor iColor) {
        this.highlightLifeline = lifeline;
        this.startEvent = n;
        this.nbEvent = n2;
        this.highlightColor = iColor;
    }

    public void resetTimeCompression() {
        this.highlightLifeline = null;
        this.startEvent = 0;
        this.nbEvent = 0;
        this.highlightColor = null;
    }

    public double getMinTime() {
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.minTime;
    }

    public double getMaxTime() {
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.maxTime;
    }

    private List buildTimeArray() {
        Object object;
        Object object2;
        Object object3;
        int n;
        List<Object> list = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < this.syncMessages.size()) {
            if (((ITimeRange)this.syncMessages.get(n2)).hasTimeInfo()) {
                n = ((BaseMessage)this.syncMessages.get(n2)).getEventOccurrence();
                double d = ((ITimeRange)this.syncMessages.get(n2)).getFirstTime();
                TimeEvent timeEvent = new TimeEvent(d, n, (ITimeRange)this.syncMessages.get(n2));
                list.add(timeEvent);
            }
            ++n2;
        }
        n = 0;
        while (n < this.syncMessagesReturn.size()) {
            if (((ITimeRange)this.syncMessagesReturn.get(n)).hasTimeInfo()) {
                int n3 = ((BaseMessage)this.syncMessagesReturn.get(n)).getEventOccurrence();
                double d = ((ITimeRange)this.syncMessagesReturn.get(n)).getFirstTime();
                object3 = new TimeEvent(d, n3, (ITimeRange)this.syncMessagesReturn.get(n));
                list.add(object3);
            }
            ++n;
        }
        int n4 = 0;
        while (n4 < this.asyncMessages.size()) {
            if (((ITimeRange)this.asyncMessages.get(n4)).hasTimeInfo()) {
                int n5 = ((AsyncMessage)this.asyncMessages.get(n4)).getStartOccurrence();
                double d = ((ITimeRange)this.asyncMessages.get(n4)).getFirstTime();
                object2 = new TimeEvent(d, n5, (ITimeRange)this.asyncMessages.get(n4));
                list.add(object2);
                n5 = ((AsyncMessage)this.asyncMessages.get(n4)).getEndOccurrence();
                d = ((ITimeRange)this.asyncMessages.get(n4)).getLastTime();
                object2 = new TimeEvent(d, n5, (ITimeRange)this.asyncMessages.get(n4));
                list.add(object2);
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 < this.asyncMessagesReturn.size()) {
            if (((ITimeRange)this.asyncMessagesReturn.get(n6)).hasTimeInfo()) {
                int n7 = ((AsyncMessage)this.asyncMessagesReturn.get(n6)).getStartOccurrence();
                double d = ((ITimeRange)this.asyncMessagesReturn.get(n6)).getFirstTime();
                object = new TimeEvent(d, n7, (ITimeRange)this.asyncMessagesReturn.get(n6));
                list.add(object);
                n7 = ((AsyncMessage)this.asyncMessagesReturn.get(n6)).getEndOccurrence();
                d = ((ITimeRange)this.asyncMessagesReturn.get(n6)).getLastTime();
                object = new TimeEvent(d, n7, (ITimeRange)this.asyncMessagesReturn.get(n6));
                list.add(object);
            }
            ++n6;
        }
        this.executionOccurrencesWithTime = null;
        int n8 = 0;
        while (n8 < this.lifeLines.size()) {
            object3 = this.getLifeline(n8);
            if (object3.hasTimeInfo()) {
                object2 = object3.executionOccurrences.iterator();
                while (object2.hasNext()) {
                    ExecutionOccurrence executionOccurrence;
                    object = object2.next();
                    if (!(object instanceof ExecutionOccurrence) || !(executionOccurrence = (ExecutionOccurrence)object).hasTimeInfo()) continue;
                    int n9 = executionOccurrence.getStartOccurrence();
                    double d = executionOccurrence.getFirstTime();
                    TimeEvent timeEvent = new TimeEvent(d, n9, executionOccurrence);
                    list.add(timeEvent);
                    if (this.executionOccurrencesWithTime == null) {
                        this.executionOccurrencesWithTime = new ArrayList();
                    }
                    this.executionOccurrencesWithTime.add(timeEvent);
                    n9 = executionOccurrence.getEndOccurrence();
                    d = executionOccurrence.getLastTime();
                    timeEvent = new TimeEvent(d, n9, executionOccurrence);
                    list.add(timeEvent);
                    this.executionOccurrencesWithTime.add(timeEvent);
                }
            }
            ++n8;
        }
        if (this.executionOccurrencesWithTime != null) {
            object3 = this.executionOccurrencesWithTime.toArray();
            Arrays.sort(object3, new TimeEventComparator());
            this.executionOccurrencesWithTime = Arrays.asList(object3);
        }
        object3 = list.toArray();
        Arrays.sort(object3, new TimeEventComparator());
        list = Arrays.asList(object3);
        return list;
    }

    private void computeMinMax() {
        List list = this.buildTimeArray();
        int n = 0;
        while (n < list.size() - 1) {
            TimeEvent timeEvent = (TimeEvent)list.get(n);
            TimeEvent timeEvent2 = (TimeEvent)list.get(n + 1);
            if (this.computeMinMax) {
                this.minTime = timeEvent2.getTime() - timeEvent.getTime();
                this.computeMinMax = false;
            }
            if (timeEvent2.getTime() - timeEvent.getTime() < this.minTime) {
                this.minTime = timeEvent2.getTime() - timeEvent.getTime();
            }
            if (timeEvent2.getTime() - timeEvent.getTime() > this.maxTime) {
                this.maxTime = timeEvent2.getTime() - timeEvent.getTime();
            }
            ++n;
        }
    }

    public boolean findDateBounds(double d, ITimeRange[] iTimeRangeArray) {
        if (this.hasTimeInfo()) {
            List list = this.buildTimeArray();
            iTimeRangeArray[0] = null;
            iTimeRangeArray[1] = null;
            int n = 0;
            while (n < list.size()) {
                TimeEvent timeEvent = (TimeEvent)list.get(n);
                if (timeEvent.getTime() > d) {
                    iTimeRangeArray[1] = timeEvent.getGraphNode();
                    if (n > 0) {
                        iTimeRangeArray[0] = ((TimeEvent)list.get(n - 1)).getGraphNode();
                        return true;
                    }
                    return false;
                }
                ++n;
            }
            iTimeRangeArray[0] = ((TimeEvent)list.get(list.size() - 1)).getGraphNode();
        }
        return false;
    }

    public List getExecutionOccurrencesWithTime() {
        return this.executionOccurrencesWithTime;
    }

    protected void setHasTimeInfo(boolean bl) {
        this.timeInfo = bl;
    }

    public boolean hasTimeInfo() {
        return this.timeInfo;
    }

    public static boolean contains(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        if (n3 < 0) {
            n7 += n3;
            n9 = -n9;
        }
        if (n4 < 0) {
            n8 += n4;
            n10 = -n10;
        }
        return n5 >= n7 && n6 >= n8 && n5 - n7 < n9 && n6 - n8 < n10;
    }

    public static void setUserPref(ISDPreferences iSDPreferences) {
        userPref = iSDPreferences;
    }

    public static ISDPreferences getUserPref() {
        return userPref;
    }

    public void setTimeUnitName(String string) {
        this.unitName = string;
    }

    public String getTimeUnitName() {
        return this.unitName;
    }

    public void forceEventOccurrenceSpacing(int n) {
        this.forceEventOccurrenceSpacing = n;
    }

    protected int getVisibleAreaX() {
        return this.visibleAreaX;
    }

    protected int getVisibleAreaY() {
        return this.visibleAreaY;
    }
}

