/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.load;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.ui.IWorkbenchPage;

public class LoadersManager {
    private static IUml2SDLoader currentLoader;
    private static LoadersManager loadersManager;

    private LoadersManager() {
    }

    public static LoadersManager getLoadersManager() {
        if (loadersManager == null) {
            loadersManager = new LoadersManager();
        }
        return loadersManager;
    }

    public IUml2SDLoader createLoader(String string, ClassLoader classLoader, SDView sDView) {
        IUml2SDLoader iUml2SDLoader = null;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            Class<?> clazz = classLoader.loadClass(string);
            iUml2SDLoader = (IUml2SDLoader)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        this.setCurrentLoader(iUml2SDLoader);
        if (iUml2SDLoader != null) {
            iUml2SDLoader.setViewer(sDView);
        }
        return iUml2SDLoader;
    }

    public void setCurrentLoader(IUml2SDLoader iUml2SDLoader) {
        if (currentLoader != null) {
            IWorkbenchPage iWorkbenchPage;
            SDView sDView;
            if (iUml2SDLoader != null && (sDView = (SDView)(iWorkbenchPage = UIPlugin.getActivePage()).findView("org.eclipse.hyades.uml2sd.ui.view.SDView")) != null) {
                sDView.resetProviders();
            }
            currentLoader.aboutToBeReplaced();
        }
        if ((currentLoader = iUml2SDLoader) != null) {
            SDViewerPlugin.getDefault().setLastLoader(currentLoader.getClass().getName());
        }
    }

    public IUml2SDLoader getCurrentLoader() {
        if (currentLoader == null) {
            SDViewerPlugin.getDefault().createLastLoaderIfAny();
        }
        return currentLoader;
    }
}

