/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.preferences.SDViewPref;
import org.eclipse.hyades.uml2sd.ui.view.DiagramToolTip;
import org.eclipse.hyades.uml2sd.ui.view.ITimeCompressionListener;
import org.eclipse.hyades.uml2sd.ui.view.NGC;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidgetSelectionProvider;
import org.eclipse.hyades.uml2sd.ui.view.ScrollView;
import org.eclipse.hyades.uml2sd.ui.view.TimeCompressionBar;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.ViewPart;

public class SDWidget
extends ScrollView
implements SelectionListener,
IPropertyChangeListener,
DisposeListener,
ITimeCompressionListener {
    private Frame frame;
    private Image overView = null;
    private static Color foreGroundColor = null;
    private static Color backGroundColor = null;
    private static Display display = null;
    private Menu menu = null;
    protected MenuItem zoomIn = null;
    protected MenuItem zoomOut = null;
    protected SDWidgetSelectionProvider selProvider = null;
    protected float zoomValue = 1.0f;
    protected boolean zoomInMode = false;
    protected boolean zoomOutMode = false;
    protected List selectedNodeList = null;
    protected boolean multiSelection = false;
    private ViewPart site = null;
    public GraphNode currentGraphNode = null;
    private TimeCompressionBar timeBar = null;
    private DiagramToolTip toolTip = null;

    public SDWidget(Composite composite, int n) {
        super(composite, n | 0x40000);
        display = this.getDisplay();
        this.setOverviewEnabled(true);
        this.selectedNodeList = new ArrayList();
        this.selProvider = new SDWidgetSelectionProvider();
        SDViewPref.getInstance().addPropertyChangeListener(this);
        this.toolTip = new DiagramToolTip(this.getViewControl());
        super.addDisposeListener((DisposeListener)this);
    }

    public void setTimeBar(TimeCompressionBar timeCompressionBar) {
        if (timeCompressionBar != null) {
            this.timeBar = timeCompressionBar;
            this.timeBar.addTimeCompressionListener(this);
        }
    }

    protected void keyPressedEvent(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 262144) {
            this.multiSelection = true;
        }
        super.keyPressedEvent(keyEvent);
    }

    protected void keyReleasedEvent(KeyEvent keyEvent) {
        this.multiSelection = false;
        super.keyReleasedEvent(keyEvent);
    }

    public void resizeContents(Frame frame) {
        int n = Math.round((float)(frame.getWidth() + 20) * this.zoomValue);
        int n2 = Math.round((float)(frame.getHeight() + 20) * this.zoomValue);
        this.resizeContents(n, n2);
    }

    protected void setFrame(Frame frame, boolean bl) {
        this.selectedNodeList.clear();
        this.selProvider.setSelection((ISelection)new StructuredSelection());
        this.frame = frame;
        if (bl) {
            this.setContentsPos(0, 0);
            this.resizeContents(this.frame);
            this.redraw();
        }
        if (this.overView != null) {
            this.overView.dispose();
        }
        this.overView = null;
        this.resizeContents(this.frame);
    }

    protected Frame getFrame() {
        return this.frame;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selProvider;
    }

    public boolean setContentsPos(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.frame == null) {
            return false;
        }
        if (n + this.getVisibleWidth() > this.getContentsWidth()) {
            n = this.getContentsWidth() - this.getVisibleWidth();
        }
        if (n2 + this.getVisibleHeight() > this.getContentsHeight()) {
            n2 = this.getContentsHeight() - this.getVisibleHeight();
        }
        int n3 = Math.round((float)n / this.zoomValue);
        int n4 = Math.round((float)n2 / this.zoomValue);
        int n5 = Math.round((float)this.getVisibleWidth() / this.zoomValue);
        int n6 = Math.round((float)this.getVisibleHeight() / this.zoomValue);
        this.frame.updateIndex(n3, n4, n5, n6);
        return super.setContentsPos(n, n2);
    }

    protected void contentsMouseHover(MouseEvent mouseEvent) {
        GraphNode graphNode = null;
        if (this.frame != null) {
            int n;
            int n2 = Math.round((float)mouseEvent.x / this.zoomValue);
            graphNode = this.frame.getNodeAt(n2, n = Math.round((float)mouseEvent.y / this.zoomValue));
            if (graphNode != null) {
                if (graphNode instanceof Lifeline) {
                    Lifeline lifeline = (Lifeline)graphNode;
                    this.toolTip.showToolTip(lifeline.getToolTipText());
                } else {
                    this.toolTip.showToolTip(graphNode.getName());
                }
            } else {
                this.toolTip.hideToolTip();
            }
        }
    }

    protected void contentsMouseMoveEvent(MouseEvent mouseEvent) {
        this.toolTip.hideToolTip();
        super.contentsMouseMoveEvent(mouseEvent);
    }

    protected void contentsMouseUpEvent(MouseEvent mouseEvent) {
        if (this.frame == null) {
            return;
        }
        this.frame.resetTimeCompression();
        this.multiSelection = (mouseEvent.stateMask & 0x40000) != 0;
        if ((this.zoomInMode || this.zoomOutMode) && mouseEvent.button == 1) {
            int n = Math.round((float)mouseEvent.x / this.zoomValue);
            int n2 = Math.round((float)mouseEvent.y / this.zoomValue);
            if (this.zoomInMode) {
                if (this.zoomValue < 64.0f) {
                    this.zoomValue *= 1.25f;
                }
            } else {
                this.zoomValue /= 1.25f;
            }
            int n3 = Math.round((float)n * this.zoomValue - (float)(this.getVisibleWidth() / 2));
            int n4 = Math.round((float)n2 * this.zoomValue - (float)(this.getVisibleHeight() / 2));
            this.setContentsPos(n3, n4);
            if (this.timeBar != null) {
                this.timeBar.setZoom(this.zoomValue);
            }
            this.redraw();
        } else {
            GraphNode graphNode = null;
            if (this.frame != null) {
                int n = Math.round((float)mouseEvent.x / this.zoomValue);
                int n5 = Math.round((float)mouseEvent.y / this.zoomValue);
                graphNode = this.frame.getNodeAt(n, n5);
                if (mouseEvent.button == 1 || graphNode != null && !graphNode.isSelected() && !this.multiSelection) {
                    this.performSelection(graphNode);
                    this.currentGraphNode = graphNode;
                }
                this.redraw();
            }
        }
        super.contentsMouseUpEvent(mouseEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performSelection(GraphNode graphNode) {
        if (this.multiSelection) {
            if (graphNode == null) return;
            if (this.selectedNodeList.contains(graphNode)) {
                this.removeSelection(graphNode);
                return;
            } else {
                this.addSelection(graphNode);
            }
            return;
        } else {
            this.clearSelection();
            if (graphNode == null) return;
            this.addSelection(graphNode);
        }
    }

    public List getSelection() {
        return this.selectedNodeList;
    }

    public void addSelection(GraphNode graphNode) {
        if (graphNode == null) {
            return;
        }
        this.selectedNodeList.add(graphNode);
        graphNode.setSelected(true);
        this.currentGraphNode = graphNode;
        StructuredSelection structuredSelection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)structuredSelection);
    }

    public void addSelection(List list) {
        this.selectedNodeList.addAll(list);
        int n = 0;
        while (n < list.size()) {
            ((GraphNode)list.get(n)).setSelected(true);
            ++n;
        }
        StructuredSelection structuredSelection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)structuredSelection);
    }

    public void removeSelection(GraphNode graphNode) {
        this.selectedNodeList.remove(graphNode);
        graphNode.setSelected(false);
        StructuredSelection structuredSelection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)structuredSelection);
    }

    public void removeSelection(List list) {
        this.selectedNodeList.removeAll(list);
        int n = 0;
        while (n < list.size()) {
            ((GraphNode)list.get(n)).setSelected(false);
            ++n;
        }
        StructuredSelection structuredSelection = new StructuredSelection(this.selectedNodeList);
        this.selProvider.setSelection((ISelection)structuredSelection);
    }

    public void clearSelection() {
        int n = 0;
        while (n < this.selectedNodeList.size()) {
            ((GraphNode)this.selectedNodeList.get(n)).setSelected(false);
            ++n;
        }
        this.selectedNodeList.clear();
        this.selProvider.setSelection((ISelection)new StructuredSelection());
    }

    public void setSite(ViewPart viewPart) {
        this.site = viewPart;
        this.site.getSite().setSelectionProvider((ISelectionProvider)this.selProvider);
        String[] stringArray = new String[]{"org.eclipse.ui.UML2SDScope", "org.eclipse.ui.globalScope"};
        this.site.getSite().getKeyBindingService().setScopes(stringArray);
    }

    protected void drawContents(GC gC, int n, int n2, int n3, int n4) {
        if (this.frame == null) {
            gC.setBackground(this.getDisplay().getSystemColor(1));
            gC.fillRectangle(0, 0, this.getVisibleWidth(), this.getVisibleHeight());
            gC.dispose();
            return;
        }
        Frame.setUserPref(SDViewPref.getInstance());
        this.update();
        Rectangle rectangle = this.getClientArea();
        Image image = null;
        GC gC2 = null;
        if (!SDViewerPlugin.debugDoubleBuffer()) {
            try {
                image = new Image((Device)this.getDisplay(), rectangle.width, rectangle.height);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            gC2 = new GC((Drawable)image);
        } else {
            gC2 = gC;
        }
        NGC nGC = new NGC(this, gC2);
        Metrics.setLifelineFontHeight(nGC.getFontHeight(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineFontWidth(nGC.getFontWidth(SDViewPref.getInstance().getFont("PREF_LIFELINE")));
        Metrics.setLifelineWidth(SDViewPref.getInstance().getLifelineWidth());
        int n5 = nGC.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS"));
        int n6 = nGC.getFontHeight(SDViewPref.getInstance().getFont("PREF_SYNC_MESS_RET"));
        int n7 = nGC.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS"));
        int n8 = nGC.getFontHeight(SDViewPref.getInstance().getFont("PREF_ASYNC_MESS_RET"));
        int n9 = 0;
        n9 = n5 > n6 ? n5 : n6;
        if (n9 < n7) {
            n9 = n7;
        }
        if (n9 < n8) {
            n9 = n8;
        }
        Metrics.setMessageFontHeight(n9);
        nGC.setFont(SDViewPref.getInstance().getFont("PREF_LIFELINE"));
        int n10 = Math.round((float)(this.frame.getWidth() + 20) * this.zoomValue);
        int n11 = Math.round((float)(this.frame.getHeight() + 20) * this.zoomValue);
        this.resizeContents(n10, n11);
        nGC.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        nGC.fillRectangle(0, 0, this.getContentsWidth(), 10);
        nGC.fillRectangle(0, 0, this.frame.getX(), this.getContentsHeight());
        nGC.fillRectangle(this.frame.getX() + this.frame.getWidth() + 1, 0, this.getContentsWidth() - (this.frame.getX() + this.frame.getWidth() + 1), this.getContentsHeight());
        nGC.fillRectangle(0, this.frame.getY() + this.frame.getHeight() + 1, this.getContentsWidth(), this.getContentsHeight() - (this.frame.getY() + this.frame.getHeight() + 1));
        gC2.setLineWidth(1);
        this.frame.draw(nGC);
        if (!SDViewerPlugin.debugDoubleBuffer()) {
            try {
                gC.drawImage(image, 0, 0, rectangle.width, rectangle.height, 0, 0, rectangle.width, rectangle.height);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            gC2.dispose();
            image.dispose();
        }
        gC.dispose();
        nGC.dispose();
        this.setHScrollBarIncrement(Math.round((float)(SDViewPref.getInstance().getLifelineWidth() / 2) * this.zoomValue));
        this.setVScrollBarIncrement(Math.round((float)Metrics.getMessagesSpacing() * this.zoomValue));
        if (this.timeBar != null && this.frame.hasTimeInfo()) {
            this.timeBar.resizeContents(9, n11 + this.getHorizontalBarHeight());
            this.timeBar.setContentsPos(this.getContentsX(), this.getContentsY());
            this.timeBar.redraw();
            this.timeBar.update();
        }
        float f = this.getContentsWidth() / this.getVisibleWidth();
        float f2 = this.getContentsHeight() / this.getVisibleHeight();
        if (f2 > f) {
            this.setOverviewSize((int)((double)this.getVisibleHeight() * 0.75));
        } else {
            this.setOverviewSize((int)((double)this.getVisibleWidth() * 0.75));
        }
    }

    public GraphNode getMouseOverNode() {
        return this.currentGraphNode;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.zoomIn) {
            this.zoomValue *= 2.0f;
        } else if (selectionEvent.widget == this.zoomOut) {
            this.zoomValue /= 2.0f;
        }
        this.redraw();
    }

    public void setZoomInMode(boolean bl) {
        if (bl) {
            this.setZoomOutMode(false);
        }
        this.zoomInMode = bl;
    }

    public void setZoomOutMode(boolean bl) {
        if (bl) {
            this.setZoomInMode(false);
        }
        this.zoomOutMode = bl;
    }

    public void moveTo(GraphNode graphNode) {
        if (graphNode == null) {
            return;
        }
        this.clearSelection();
        graphNode.setSelected(true);
        this.selectedNodeList.add(graphNode);
        this.ensureVisible(graphNode);
    }

    public void ensureVisible(GraphNode graphNode) {
        if (graphNode == null) {
            return;
        }
        int n = Math.round((float)graphNode.getX() * this.zoomValue);
        int n2 = Math.round((float)graphNode.getY() * this.zoomValue);
        int n3 = graphNode.getWidth();
        int n4 = graphNode.getHeight();
        if (graphNode instanceof SyncMessage) {
            n4 = Metrics.getMessagesSpacing();
        }
        this.ensureVisible(n, n2 - 30, n3, n4 + 30, 0x1000000);
        this.redraw();
    }

    public float getZoomFactor() {
        return this.zoomValue;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("PREFOK")) {
            if (this.overView != null) {
                this.overView.dispose();
            }
            this.overView = null;
            this.redraw();
        }
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.overView != null) {
            this.overView.dispose();
        }
        super.removeDisposeListener((DisposeListener)this);
        SDViewPref.getInstance().removePropertyChangeListener(this);
        LoadersManager loadersManager = LoadersManager.getLoadersManager();
        if (loadersManager != null) {
            loadersManager.setCurrentLoader(null);
        }
        if (this.site != null && this.site instanceof SDView) {
            ((SDView)this.site).resetProviders();
        }
    }

    protected void drawOverview(GC gC, Rectangle rectangle) {
        float f = this.zoomValue;
        this.zoomValue = this.getContentsWidth() > this.getContentsHeight() ? (float)rectangle.width / (float)this.getContentsWidth() * f : (float)rectangle.height / (float)this.getContentsHeight() * f;
        if (this.overView != null && (rectangle.width != this.overView.getBounds().width || rectangle.height != this.overView.getBounds().height)) {
            this.overView.dispose();
            this.overView = null;
        }
        if (this.overView == null) {
            int n = this.getContentsX();
            int n2 = this.getContentsY();
            this.setContentsPos(0, 0);
            this.overView = new Image((Device)this.getDisplay(), rectangle.width, rectangle.height);
            GC gC2 = new GC((Drawable)this.overView);
            NGC nGC = new NGC(this, gC2);
            nGC.setBackground(SDViewPref.getInstance().getBackGroundColor("PREF_FRAME"));
            this.frame.draw(nGC);
            this.setContentsPos(n, n2);
            gC2.dispose();
            nGC.dispose();
        }
        if (this.overView != null && rectangle.width == this.overView.getBounds().width && rectangle.height == this.overView.getBounds().height) {
            gC.drawImage(this.overView, 0, 0, rectangle.width, rectangle.height, 0, 0, rectangle.width, rectangle.height);
        }
        this.zoomValue = f;
        super.drawOverview(gC, rectangle);
    }

    public void deltaSelected(Lifeline lifeline, int n, int n2, IColor iColor) {
        this.frame.highlightTimeCompression(lifeline, n, n2, iColor);
        this.redraw();
    }

    public void resetZoomFactor() {
        int n = Math.round((float)this.getContentsX() / this.zoomValue);
        int n2 = Math.round((float)this.getContentsY() / this.zoomValue);
        this.zoomValue = 1.0f;
        if (this.timeBar != null && !this.timeBar.isDisposed()) {
            this.timeBar.setZoom(this.zoomValue);
        }
        this.redraw();
        this.update();
        this.setContentsPos(n, n2);
    }
}

