/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.hyades.loaders.util.IXMLLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class SAXFragmentHandler
extends DefaultHandler
implements XMLFragmentHandler {
    protected InputSource inputSource = null;
    protected ParserPipedInputStream xmlStream = null;
    protected SAXParser parser;
    protected Thread parseThread;
    protected IXMLLoader handler;
    protected int depth;
    protected static final int WAIT_TIME = 500;
    protected byte[] rootTag;
    protected volatile boolean rootTagRequired;
    protected boolean restart;

    SAXFragmentHandler() {
    }

    public void setXMLLoader(IXMLLoader iXMLLoader) {
        this.handler = iXMLLoader;
        this.init();
    }

    public void init() {
        try {
            this.initRestart();
            this.depth = -1;
            this.rootTagRequired = false;
            this.parser = this.makeParser();
            this.xmlStream = new ParserPipedInputStream(this);
            this.parseThread = new Thread(Thread.currentThread().getThreadGroup(), "xmlParserThread"){

                public void run() {
                    do {
                        if (SAXFragmentHandler.this.xmlStream == null) {
                            return;
                        }
                        SAXFragmentHandler.this.parse();
                    } while (SAXFragmentHandler.this.restart);
                    SAXFragmentHandler.this.xmlStream = null;
                }
            };
            this.parseThread.start();
        }
        catch (Exception exception) {
            LoadersUtils.log(exception);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.handler.characters(cArray, n, n2);
    }

    public void endDocument() throws SAXException {
        this.restart = false;
        if (this.depth == 0 && this.xmlStream != null) {
            this.xmlStream.makeClosed();
            this.xmlStream = null;
        }
        this.depth = -1;
        this.handler.endDocument(null, 0);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.handler.endElement(string3, 0);
        --this.depth;
        if (this.depth == 0) {
            if (this.xmlStream != null) {
                this.xmlStream.makeClosed();
                this.xmlStream = null;
            }
            this.restart = false;
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        SAXFragmentHandler sAXFragmentHandler = this;
        synchronized (sAXFragmentHandler) {
            if (this.restart && this.depth == 1) {
                this.depth = -1;
                this.rootTagRequired = true;
                try {
                    this.parser = this.makeParser();
                    if (this.xmlStream == null) {
                        this.xmlStream = new ParserPipedInputStream(this);
                    }
                    this.xmlStream.makeOpened();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    LoadersUtils.log(parserConfigurationException);
                    throw new InvalidXMLException(parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    LoadersUtils.log(sAXException);
                    throw new InvalidXMLException(sAXException);
                }
                return;
            }
        }
        throw sAXParseException;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return null;
    }

    public void scanContent(byte[] byArray, int n, int n2) throws InvalidXMLException {
        if (this.xmlStream != null) {
            if (this.restart && this.rootTagRequired && this.rootTag != null) {
                this.xmlStream.writeBuf(this.rootTag, 0, this.rootTag.length);
                this.rootTagRequired = false;
            }
            this.xmlStream.writeBuf(byArray, n, n2);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.depth = 0;
        this.handler.startDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.depth;
        if (this.restart && this.depth == 1 && this.rootTag == null) {
            this.rootTag = ("<" + string3 + ">").getBytes();
        }
        this.handler.startElement(string3, false, attributes.getLength() == 0);
        int n = 0;
        while (n < attributes.getLength()) {
            this.handler.attributeName(attributes.getQName(n));
            this.handler.attributeValueCharacters(attributes.getValue(n));
            ++n;
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateParser() {
        this.restart = false;
        this.depth = -1;
        if (this.xmlStream != null) {
            this.xmlStream.makeClosed();
            this.xmlStream = null;
        }
        SAXFragmentHandler sAXFragmentHandler = this;
        synchronized (sAXFragmentHandler) {
            this.notifyAll();
            this.parseThread.interrupt();
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setFeature("http://xml.org/sax/features/string-interning", true);
        sAXParserFactory.setValidating(false);
        return sAXParserFactory.newSAXParser();
    }

    protected synchronized void parse() throws InvalidXMLException {
        try {
            this.inputSource = new InputSource(this.xmlStream);
            this.parser.parse(this.inputSource, (DefaultHandler)this);
        }
        catch (Exception exception) {
            if (this.restart) {
                return;
            }
            this.handler.error(new InvalidXMLException(exception));
        }
    }

    private void initRestart() {
        this.restart = false;
        try {
            this.parser = this.makeParser();
            if (this.parser.getClass().getName().equals("org.apache.crimson.jaxp.SAXParserImpl")) {
                this.restart = true;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {}
    }

    public static class ParserPipedInputStream
    extends InputStream {
        private byte[] inBuf;
        private boolean closed = false;
        private int inCount;
        private long inTotalLength;
        private long inPartLength;
        private int inPos;
        private SAXFragmentHandler handler;

        public ParserPipedInputStream(SAXFragmentHandler sAXFragmentHandler) {
            this.handler = sAXFragmentHandler;
            this.inTotalLength = 0L;
            this.inPartLength = 0L;
            this.inCount = 0;
            this.inPos = 0;
        }

        protected synchronized void makeOpened() {
            this.inPartLength = 0L;
            this.inBuf = null;
            this.inCount = 0;
            this.inPos = 0;
            this.closed = false;
            this.notifyAll();
        }

        public int available() throws IOException {
            this.waitForNewData();
            return this.inCount;
        }

        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public boolean hasEmptyBuffer() {
            return this.inCount == 0;
        }

        public synchronized void mark(int n) {
            super.mark(n);
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            --this.inCount;
            return this.inBuf[this.inPos++];
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            int n3 = Math.min(this.inCount, n2);
            System.arraycopy(this.inBuf, this.inPos, byArray, n, n3);
            this.inPos += n3;
            this.inCount -= n3;
            return n3;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public synchronized void reset() throws IOException {
            super.reset();
        }

        public long skip(long l) throws IOException {
            if ((l += (long)this.inPos) < this.inTotalLength) {
                this.inPos = (int)l;
                return l;
            }
            return -1L;
        }

        public synchronized void writeBuf(byte[] byArray, int n, int n2) {
            if (byArray == null || n2 == 0) {
                return;
            }
            this.inBuf = byArray;
            this.inPos = n;
            this.inTotalLength += (long)n2;
            this.inPartLength += (long)n2;
            this.inCount = n2;
            this.notifyAll();
            this.waitForEmptyBuffer();
        }

        protected synchronized void makeClosed() {
            this.inPartLength = 0L;
            this.inBuf = null;
            this.inCount = 0;
            this.inPos = 0;
            this.closed = true;
            this.notifyAll();
        }

        private void waitForEmptyBuffer() {
            while (!this.hasEmptyBuffer() && !this.closed) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    if (!this.hasEmptyBuffer() && !this.closed) continue;
                    return;
                }
            }
        }

        private synchronized void waitForNewData() {
            boolean bl = true;
            while (this.hasEmptyBuffer()) {
                if (bl) {
                    this.notifyAll();
                    bl = false;
                }
                if (this.closed) {
                    return;
                }
                try {
                    this.wait(500L);
                    if (!this.handler.restart || !this.hasEmptyBuffer() || this.inPartLength <= 0L) continue;
                    try {
                        if (this.handler.depth == 0) {
                            this.makeClosed();
                            this.handler.rootTagRequired = true;
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    if (!this.closed) continue;
                    return;
                }
            }
        }
    }
}

