/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logc.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logc.extensions.ILogRecordFilter;
import org.eclipse.hyades.logc.internal.extensions.ProgressMonitorAdapter;
import org.eclipse.hyades.logs.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;

public class CorrelationHelper {
    private static CorrelationHelper instance;
    private List agentsList = new ArrayList();

    protected CorrelationHelper() {
    }

    public static CorrelationHelper getInstance() {
        if (instance == null) {
            instance = new CorrelationHelper();
        }
        return instance;
    }

    public IExtension[] getCorrelationExtensions() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView");
        IExtension[] iExtensionArray = null;
        if (iExtensionPoint != null) {
            iExtensionArray = iExtensionPoint.getExtensions();
        }
        return iExtensionArray;
    }

    public IConfigurationElement getCorrelationByName(String string) {
        IExtension[] iExtensionArray = this.getCorrelationExtensions();
        if (iExtensionArray != null) {
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    if ("view".equals(iConfigurationElementArray[n2].getName()) && iConfigurationElementArray[n2].getAttribute("name").equals(string)) {
                        return iConfigurationElement;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return null;
    }

    public CorrelationContainerProxy createCorrelationContainer(IConfigurationElement iConfigurationElement, Object object, String string) {
        this.agentsList.clear();
        if (iConfigurationElement == null) {
            return null;
        }
        this.loadLogAgents(object);
        BasicEList basicEList = new BasicEList();
        String string2 = null;
        CorrelationContainerProxy correlationContainerProxy = null;
        ILogRecordCorrelationEngine iLogRecordCorrelationEngine = null;
        IConfigurationElement[] iConfigurationElementArray = this.addNodes(iConfigurationElement, basicEList);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equals("LogRecordCorrelationEngine")) {
                try {
                    iLogRecordCorrelationEngine = (ILogRecordCorrelationEngine)iConfigurationElementArray[n].createExecutableExtension("class");
                    string2 = iConfigurationElement.getAttribute("name");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        if (iLogRecordCorrelationEngine != null && this.agentsList.size() > 0) {
            correlationContainerProxy = LoadersUtils.getCorrelationContainerProxy((TRCAgentProxy)((TRCAgentProxy)this.agentsList.get(0)), string2, (String)string);
            correlationContainerProxy.setName(string);
            CorrelationEngine correlationEngine = HierarchyFactory.eINSTANCE.createCorrelationEngine();
            correlationEngine.setId(string2);
            correlationEngine.setType(iConfigurationElement.getAttribute("log_types"));
            correlationEngine.setName(iConfigurationElement.getAttribute("name"));
            correlationContainerProxy.setCorrelationEngine(correlationEngine);
            int n2 = 1;
            while (n2 < this.agentsList.size()) {
                if (this.agentsList.get(n2) != null) {
                    correlationContainerProxy.getCorrelatedAgents().add(this.agentsList.get(n2));
                }
                ++n2;
            }
            CorrelationJob correlationJob = new CorrelationJob(LogCorrelatorPlugin.getResourceString("STR_JOB_LBL"), iLogRecordCorrelationEngine, correlationContainerProxy, (EList)basicEList);
            correlationJob.schedule();
        }
        return correlationContainerProxy;
    }

    private IConfigurationElement[] addNodes(IConfigurationElement iConfigurationElement, BasicEList basicEList) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        ILogRecordFilter iLogRecordFilter = null;
        boolean bl = true;
        int n = 0;
        while (n < this.agentsList.size()) {
            if (this.agentsList.get(n) != null) {
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    if (iConfigurationElementArray[n2].getName().equals("LogRecordFilter") && ((TRCAgentProxy)this.agentsList.get(n)).getName().equals(iConfigurationElementArray[n2].getAttribute("log_type"))) {
                        try {
                            iLogRecordFilter = (ILogRecordFilter)iConfigurationElementArray[n2].createExecutableExtension("class");
                            basicEList.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(n), iLogRecordFilter));
                            bl = false;
                        }
                        catch (Exception exception) {
                            basicEList.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(n), null));
                            bl = false;
                        }
                    } else if (((TRCAgentProxy)this.agentsList.get(n)).getName().equals(iConfigurationElementArray[n2].getAttribute("log_type"))) {
                        basicEList.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(n), null));
                        bl = false;
                    }
                    ++n2;
                }
                if (bl) {
                    basicEList.add((Object)this.loadLog((TRCAgentProxy)this.agentsList.get(n), null));
                }
            }
            bl = true;
            ++n;
        }
        return iConfigurationElementArray;
    }

    private RecordList loadLog(TRCAgentProxy tRCAgentProxy, ILogRecordFilter iLogRecordFilter) {
        RecordList recordList = null;
        recordList = iLogRecordFilter != null ? new RecordList(this.cbeEventFilter(iLogRecordFilter.filter(tRCAgentProxy.getAgent().getDefaultEvents())), tRCAgentProxy.getName()) : new RecordList(this.cbeEventFilter(tRCAgentProxy.getAgent().getDefaultEvents()), tRCAgentProxy.getName());
        return recordList;
    }

    private EList cbeEventFilter(EList eList) {
        BasicEList basicEList = new BasicEList();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CBECommonBaseEvent)) continue;
            basicEList.add(e);
        }
        return basicEList;
    }

    private void loadLogAgents(Object object) {
        if (object instanceof List) {
            Object e = null;
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof TRCAgentProxy) || !((TRCAgentProxy)e).getType().equals("Logging")) continue;
                this.agentsList.add(e);
            }
        } else if (object instanceof CorrelationContainerProxy) {
            TRCAgentProxy tRCAgentProxy;
            Iterator iterator = ((CorrelationContainerProxy)object).getCorrelatedAgents().iterator();
            while (iterator.hasNext()) {
                tRCAgentProxy = (TRCAgentProxy)iterator.next();
                if (tRCAgentProxy == null || tRCAgentProxy.eIsProxy()) continue;
                this.agentsList.add(tRCAgentProxy);
            }
            tRCAgentProxy = this.getCorrelation(((CorrelationContainerProxy)object).getCorrelationEngine());
            if (tRCAgentProxy != null) {
                this.addNodes((IConfigurationElement)tRCAgentProxy, new BasicEList());
            } else if (this.isInternalCorrelation((CorrelationContainerProxy)object)) {
                this.addAllNodes();
            }
        } else if (object instanceof TRCMonitor) {
            this.loadAllAgents((TRCMonitor)object);
        } else if (object instanceof TRCNode) {
            this.loadAllAgents((TRCNode)object);
        } else if (object instanceof TRCProcessProxy) {
            this.loadAllAgents((TRCProcessProxy)object);
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Logging")) {
            this.agentsList.add((TRCAgentProxy)object);
        }
    }

    private boolean isInternalCorrelation(CorrelationContainerProxy correlationContainerProxy) {
        Iterator iterator = correlationContainerProxy.getCorrelatedAgents().iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (!tRCAgentProxy.getInternalCorrelations().contains((Object)correlationContainerProxy)) continue;
            return true;
        }
        return false;
    }

    private void addAllNodes() {
        int n = 0;
        while (n < this.agentsList.size()) {
            if (this.agentsList.get(n) != null) {
                this.loadLog((TRCAgentProxy)this.agentsList.get(n), null);
            }
            ++n;
        }
    }

    public IConfigurationElement getCorrelation(CorrelationEngine correlationEngine) {
        String string = correlationEngine.getName();
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint("org.eclipse.hyades.logc.logInteractionView");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    if ("view".equals(iConfigurationElementArray[n2].getName()) && iConfigurationElementArray[n2].getAttribute("name").equals(string)) {
                        return iConfigurationElement;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return null;
    }

    private void loadAllAgents(TRCMonitor tRCMonitor) {
        if (tRCMonitor != null) {
            Iterator iterator = tRCMonitor.getNodes().iterator();
            while (iterator.hasNext()) {
                TRCNode tRCNode = (TRCNode)iterator.next();
                if (tRCNode == null) continue;
                this.loadAllAgents(tRCNode);
            }
        }
    }

    private void loadAllAgents(TRCNode tRCNode) {
        Iterator iterator = tRCNode.getProcessProxies().iterator();
        while (iterator.hasNext()) {
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)iterator.next();
            if (tRCProcessProxy == null) continue;
            this.loadAllAgents(tRCProcessProxy);
        }
    }

    private void loadAllAgents(TRCProcessProxy tRCProcessProxy) {
        Iterator iterator = tRCProcessProxy.getAgentProxies().iterator();
        while (iterator.hasNext()) {
            TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (tRCAgentProxy == null || tRCAgentProxy.eIsProxy() || !tRCAgentProxy.getType().equals("Logging")) continue;
            this.agentsList.add(tRCAgentProxy);
        }
    }

    class CorrelationJob
    extends Job {
        private ILogRecordCorrelationEngine recordCorrelator;
        private EList recordListToCorrelate;
        private CorrelationContainerProxy container;

        CorrelationJob(String string, ILogRecordCorrelationEngine iLogRecordCorrelationEngine, CorrelationContainerProxy correlationContainerProxy, EList eList) {
            super(string);
            this.recordCorrelator = iLogRecordCorrelationEngine;
            this.container = correlationContainerProxy;
            this.recordListToCorrelate = eList;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            ProgressMonitorAdapter progressMonitorAdapter = new ProgressMonitorAdapter(iProgressMonitor);
            this.recordCorrelator.correlate(this.container, this.recordListToCorrelate, progressMonitorAdapter);
            return new Status(0, LogCorrelatorPlugin.getPluginId(), 0, "", null);
        }
    }
}

