/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.editor.EditorSynchronizer;
import org.eclipse.hyades.ui.internal.editor.PageContainerEditorPart;
import org.eclipse.hyades.ui.internal.editor.action.ActionHandlerListener;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.util.IRefreshable;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public abstract class HyadesEditorPart
extends PageContainerEditorPart
implements IRefreshable,
ISelectionListener {
    private int defaultTabHeight;
    private Object editorObject;
    private IAssociationDescriptor editorDescriptor;
    private IEditorExtension editorExtension;
    private ListenerList selectionChangedListeners = new ListenerList();
    private EditorSynchronizer editorSynchronizer;

    public void dispose() {
        if (this.editorSynchronizer != null) {
            this.editorSynchronizer.dispose();
            this.editorSynchronizer = null;
        }
        this.getSite().setSelectionProvider(null);
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        this.selectionChangedListeners.clear();
        if (this.editorExtension != null) {
            this.editorExtension.dispose();
            this.editorExtension = null;
        }
        this.editorDescriptor = null;
        this.editorObject = null;
        super.dispose();
    }

    public final IAssociationDescriptor getEditorDescriptor() {
        return this.editorDescriptor;
    }

    protected final IEditorExtension getEditorExtension() {
        return this.editorExtension;
    }

    public void setEditorObject(Object object) {
        this.editorObject = object;
        this.firePropertyChange(517);
    }

    public Object getEditorObject() {
        return this.editorObject;
    }

    public int addPage(Control control) {
        int n = super.addPage(control);
        this.adjustContainer();
        return n;
    }

    public int addPage(IEditorPart iEditorPart, IEditorInput iEditorInput) throws PartInitException {
        int n = super.addPage(iEditorPart, iEditorInput);
        this.adjustContainer();
        return n;
    }

    protected void pageChange(int n) {
        super.pageChange(n);
        this.notifyPageChange(n);
    }

    public void setActivePage(int n) {
        boolean bl = this.getActivePage() != n;
        super.setActivePage(n);
        if (bl) {
            this.notifyPageChange(n);
        }
    }

    protected void notifyPageChange(int n) {
        if (this.editorExtension == null) {
            return;
        }
        if (this.editorExtension.pageActivated(n)) {
            this.fileSelection(this.getSelection());
        }
    }

    public void removePage(int n) {
        super.removePage(n);
        this.adjustContainer();
    }

    protected void adjustContainer() {
        if (this.getContainer() instanceof CTabFolder) {
            int n = ((CTabFolder)this.getContainer()).getTabHeight();
            if (n > 0) {
                this.defaultTabHeight = n;
            }
            ((CTabFolder)this.getContainer()).setTabHeight(this.getPageCount() == 1 ? 0 : this.defaultTabHeight);
        }
    }

    protected final void createPages() {
        if (this.editorSynchronizer == null) {
            this.setTitle(HyadesUIPlugin.getString("EDT_HYADES_TTL"));
            String string = "";
            FileEditorInput fileEditorInput = EditorSynchronizer.getEditorFile(this.getEditorInput());
            if (fileEditorInput != null) {
                string = fileEditorInput.getPath().toString();
                try {
                    fileEditorInput.getFile().refreshLocal(0, null);
                }
                catch (CoreException coreException) {
                    HyadesUIPlugin.logError(coreException);
                }
            }
            String string2 = HyadesUIPlugin.getString("RES_NOT_EXIST", string);
            HyadesUIPlugin.logError(string2);
            Label label = new Label(this.getContainer(), 0);
            label.setText(string2);
            this.addPage((Control)label);
            return;
        }
        if (this.editorExtension != null) {
            this.editorExtension.createPages();
        } else {
            this.setTitle(HyadesUIPlugin.getString("EDT_HYADES_TTL"));
            String string = HyadesUIPlugin.getString("EDT_HYADES_TXT");
            HyadesUIPlugin.logError(string);
            Label label = new Label(this.getContainer(), 0);
            label.setText(string);
            label.setBackground(Display.getCurrent().getSystemColor(3));
            this.addPage((Control)label);
        }
        if (this.getTitle() == null && this.editorDescriptor != null && this.editorDescriptor.getName() != null) {
            this.setTitle(this.editorDescriptor.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.editorExtension != null) {
            this.editorSynchronizer.setResourceChangeListenerEnabled(false);
            try {
                this.editorSynchronizer.validateEdit();
                this.editorExtension.doSave(iProgressMonitor);
                this.editorSynchronizer.editorSaved();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                iProgressMonitor.setCanceled(this.isDirty());
                this.editorSynchronizer.setResourceChangeListenerEnabled(true);
                this.firePropertyChange(257);
                throw throwable;
            }
            iProgressMonitor.setCanceled(this.isDirty());
            this.editorSynchronizer.setResourceChangeListenerEnabled(true);
            this.firePropertyChange(257);
            {
            }
        }
    }

    public void doSaveAs() {
        if (this.editorExtension != null) {
            this.editorExtension.doSaveAs();
        }
    }

    public void gotoMarker(IMarker iMarker) {
        if (this.editorExtension != null) {
            this.editorExtension.gotoMarker(iMarker);
        }
    }

    public boolean isSaveAsAllowed() {
        if (this.editorExtension != null) {
            this.editorExtension.isSaveAsAllowed();
        }
        return false;
    }

    public boolean isDirty() {
        if (this.editorExtension != null) {
            if (this.editorExtension.isDirty()) {
                return true;
            }
            if (this.editorExtension.checkPagesDirtyState()) {
                return super.isDirty();
            }
        }
        return false;
    }

    public void refreshContent(Object object) {
        if (this.editorExtension != null) {
            this.editorExtension.refreshContent(object);
            if (this.editorExtension.refreshPages()) {
                int n = 0;
                while (n < this.getPageCount()) {
                    IEditorPart iEditorPart = this.getEditor(n);
                    if (iEditorPart == null) {
                        iEditorPart = this.getControl(n);
                    }
                    if (iEditorPart instanceof IRefreshable) {
                        ((IRefreshable)iEditorPart).refreshContent(object);
                    }
                    ++n;
                }
            }
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        if (iEditorSite != null && iEditorSite.getRegisteredName() != null) {
            this.setTitle(iEditorSite.getRegisteredName());
        } else {
            this.setTitle("");
        }
        if (!EditorSynchronizer.exists(EditorSynchronizer.getEditorFile(iEditorInput))) {
            return;
        }
        iEditorSite.setSelectionProvider((ISelectionProvider)this);
        iEditorSite.getPage().addPostSelectionListener((ISelectionListener)this);
        this.editorDescriptor = this.identifyEditorDescriptor(iEditorInput);
        if (this.editorDescriptor != null) {
            if (this.cloneExtensionDefinitions()) {
                this.editorDescriptor = this.editorDescriptor.copy();
            }
            this.editorExtension = (IEditorExtension)this.editorDescriptor.createImplementationClassInstance();
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        if (this.editorExtension != null) {
            this.editorExtension.init(this);
        }
        this.enableEditActions();
        this.enableFileSynchronization();
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }

    protected void enableFileSynchronization() {
        this.editorSynchronizer = new EditorSynchronizer((IEditorPart)this);
    }

    protected boolean cloneExtensionDefinitions() {
        return true;
    }

    protected abstract IAssociationDescriptor identifyEditorDescriptor(IEditorInput var1) throws PartInitException;

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add((Object)iSelectionChangedListener);
    }

    public ISelection getSelection() {
        if (this.getEditorExtension() != null) {
            return this.getEditorExtension().getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove((Object)iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        if (!UIUtil.areEquals(this.getSelection(), iSelection) && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            if (this.getEditorExtension() != null) {
                this.getEditorExtension().setSelection(iStructuredSelection);
            }
            this.updateStatusLine(iStructuredSelection);
        }
        this.fileSelection(iSelection);
    }

    protected void fileSelection(ISelection iSelection) {
        Object[] objectArray = this.selectionChangedListeners.getListeners();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            iSelectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, iSelection));
            ++n;
        }
    }

    protected void updateStatusLine(IStructuredSelection iStructuredSelection) {
        String string = this.getStatusLineMessage(iStructuredSelection);
        this.getEditorSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    protected String getStatusLineMessage(IStructuredSelection iStructuredSelection) {
        if (this.getEditorExtension() != null) {
            return this.getEditorExtension().getStatusLineMessage(iStructuredSelection);
        }
        return null;
    }

    public IEditorPart getEditorPart() {
        return this;
    }

    public Object getAdapter(Class clazz) {
        Object object;
        if (this.editorExtension != null && (object = this.editorExtension.getAdapter(clazz)) != null) {
            return object;
        }
        return super.getAdapter(clazz);
    }

    public boolean isReadOnly() {
        if (this.editorSynchronizer == null) {
            return false;
        }
        return EditorSynchronizer.isReadOnly(this.editorSynchronizer.getEditorFile());
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart != this && this.editorExtension != null) {
            this.editorExtension.selectionChanged(iWorkbenchPart, iSelection);
        }
    }
}

