/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.hyades.ui.internal.util.RuntimeExceptionDecorator;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class CoreUtil {
    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        String string = byteArrayOutputStream.toString();
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {}
        return string;
    }

    public static boolean dispose(Map map) {
        if (map == null) {
            return true;
        }
        boolean bl = CoreUtil.dispose(map.values());
        map.clear();
        return bl;
    }

    public static boolean dispose(Collection collection) {
        if (collection == null) {
            return true;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IDisposable) {
                ((IDisposable)e).dispose();
                continue;
            }
            if (e instanceof Collection) {
                CoreUtil.dispose((Collection)e);
                continue;
            }
            if (!(e instanceof Map)) continue;
            CoreUtil.dispose((Map)e);
        }
        try {
            collection.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
        return true;
    }

    public static Object getObjectFieldValue(Object object, String string, boolean bl) throws RuntimeException {
        if (object == null || string == null) {
            return null;
        }
        RuntimeExceptionDecorator runtimeExceptionDecorator = null;
        Field field = null;
        Class<?> clazz = object.getClass();
        while (field == null && clazz != null) {
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (Exception exception) {
                if (bl && runtimeExceptionDecorator == null) {
                    runtimeExceptionDecorator = new RuntimeExceptionDecorator(exception);
                }
                clazz = clazz.getSuperclass();
            }
        }
        if (field == null) {
            if (runtimeExceptionDecorator != null) {
                throw runtimeExceptionDecorator;
            }
            return null;
        }
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            if (bl) {
                throw new RuntimeExceptionDecorator(exception);
            }
            return null;
        }
    }

    public static Object invokeObjectMethod(Object object, String string, Object[] objectArray, boolean bl) throws RuntimeException {
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                classArray[n] = objectArray[n].getClass();
                ++n;
            }
        }
        return CoreUtil.invokeObjectMethod(object, string, classArray, objectArray, bl);
    }

    public static Object invokeObjectMethod(Object object, String string, Class[] classArray, Object[] objectArray, boolean bl) throws RuntimeException {
        if (object == null || string == null) {
            return null;
        }
        if (classArray == null) {
            classArray = new Class[]{};
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        RuntimeExceptionDecorator runtimeExceptionDecorator = null;
        Method method = null;
        Class<?> clazz = object.getClass();
        while (method == null && clazz != null) {
            try {
                method = clazz.getDeclaredMethod(string, classArray);
            }
            catch (Exception exception) {
                if (bl && runtimeExceptionDecorator == null) {
                    runtimeExceptionDecorator = new RuntimeExceptionDecorator(exception);
                }
                clazz = clazz.getSuperclass();
            }
        }
        if (method == null) {
            if (runtimeExceptionDecorator != null) {
                throw runtimeExceptionDecorator;
            }
            return null;
        }
        try {
            method.setAccessible(true);
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            if (bl) {
                throw new RuntimeExceptionDecorator(exception);
            }
            return null;
        }
    }

    public static int removeBitFlag(int n, int n2) {
        return ~(~n | n2);
    }

    public static int fromBynaryString(String string) {
        int n;
        int n2 = 0;
        int n3 = n = string.length();
        while (n3 > 0) {
            if (string.charAt(n3 - 1) == '1') {
                n2 = (int)((double)n2 + Math.pow(2.0, n - n3));
            }
            --n3;
        }
        return n2;
    }

    public static IElementFactory getElementFactory(String string) {
        return WorkbenchPlugin.getDefault().getElementFactory(string);
    }

    public static void moveUp(List list, List list2) {
        if (list == null || list.isEmpty() || list2 == null || list2.isEmpty()) {
            return;
        }
        int n = 0;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n2 = list.indexOf(e);
            if (n2 < 0) continue;
            if (n2 > n) {
                CoreUtil.swap(list, n2, n2 - 1);
                continue;
            }
            ++n;
        }
    }

    public static void moveDown(List list, List list2) {
        if (list == null || list.isEmpty() || list2 == null || list2.isEmpty()) {
            return;
        }
        int n = list.size() - 1;
        ListIterator listIterator = list2.listIterator(list2.size());
        while (listIterator.hasPrevious()) {
            Object e = listIterator.previous();
            int n2 = list.indexOf(e);
            if (n2 < 0) continue;
            if (n2 < n) {
                CoreUtil.swap(list, n2, n2 + 1);
                continue;
            }
            --n;
        }
    }

    public static void swap(List list, int n, int n2) {
        if (list == null || n == n2) {
            return;
        }
        int n3 = list.size() - 1;
        if (n > n3 || n2 > n3 || n < 0 || n2 < 0) {
            return;
        }
        if (n > n2) {
            int n4 = n2;
            n2 = n;
            n = n4;
        }
        Object e = list.get(n);
        Object e2 = list.get(n2);
        list.remove(e);
        list.remove(e2);
        list.add(n, e2);
        list.add(n2, e);
    }
}

