/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PartInitException;

public abstract class HyadesNewWizard
extends HyadesWizard
implements INewWizard,
Listener {
    protected static final String SET_LAST_SELECTION = "LAST_SELECTION";
    private LocationPage locationPage;
    private AttributeWizardPage attributeWizardPage;
    private boolean firstNameDescriptionPageActivation = true;
    private IFile newFile;

    public void dispose() {
        this.attributeWizardPage.removeActivationListener(this);
        super.dispose();
    }

    protected void initPages() {
        IStructuredSelection iStructuredSelection = this.adjustSeletion();
        this.locationPage = new LocationPage("location", iStructuredSelection);
        String string = this.getFileExtension();
        if (string != null) {
            this.locationPage.setFileExtension(string);
            this.locationPage.setFileName("");
        }
        this.attributeWizardPage = new AttributeWizardPage("nameDescription");
        this.attributeWizardPage.addActivationListener(this);
    }

    protected IStructuredSelection adjustSeletion() {
        IResource iResource;
        String string;
        IStructuredSelection iStructuredSelection = this.getSelection();
        if (this.getDialogSettings() != null && (iStructuredSelection == null || iStructuredSelection.isEmpty()) && (string = this.getDialogSettings().get(SET_LAST_SELECTION)) != null && (iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string)) != null && iResource.exists()) {
            iStructuredSelection = new StructuredSelection((Object)iResource);
        }
        return iStructuredSelection;
    }

    protected LocationPage getLocationPage() {
        return this.locationPage;
    }

    protected AttributeWizardPage getAttributeWizardPage() {
        return this.attributeWizardPage;
    }

    public void handleEvent(Event event) {
        if (event.type == 3 && event.data == this.getAttributeWizardPage() && this.firstNameDescriptionPageActivation) {
            this.firstNameDescriptionPageActivation = false;
            this.adjustAttributePage();
        }
    }

    protected void adjustAttributePage() {
        if (this.getAttributeWizardPage() == null || this.getLocationPage() == null) {
            return;
        }
        if (this.getAttributeWizardPage().getItemName() == null || "".equals(this.getAttributeWizardPage().getItemName())) {
            String string = this.getLocationPage().getFileName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            this.getAttributeWizardPage().setItemName(string);
        }
    }

    public boolean performFinish() {
        this.adjustAttributePage();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath iPath = this.getLocationPage().getContainerFullPath();
        if (iWorkspaceRoot.findMember(iPath) == null) {
            try {
                ResourceUtil.createContainer((IContainer)iWorkspaceRoot.getFolder(iPath), null);
            }
            catch (CoreException coreException) {
                this.handleException(iPath.toString(), (Exception)((Object)coreException));
                return false;
            }
        }
        String string = this.getLocationPage().getFileName();
        String string2 = this.getLocationPage().getFileExtension();
        if (!string.endsWith("." + string2)) {
            string = string + "." + string2;
        }
        iPath = iPath.append(string);
        IFile iFile = iWorkspaceRoot.getFile(iPath);
        try {
            if (!this.createObject(iFile)) {
                return false;
            }
        }
        catch (Exception exception) {
            this.handleException(iFile.getFullPath().toString(), exception);
            return false;
        }
        this.newFile = iFile;
        this.selectAndReveal((IResource)iFile);
        try {
            this.openEditor(iFile);
        }
        catch (PartInitException partInitException) {
            this.handleException(iFile.getFullPath().toString(), (Exception)((Object)partInitException));
        }
        return true;
    }

    protected void selectAndReveal(IResource iResource) {
        ResourceUtil.selectAndReveal(iResource, this.getWorkbench().getActiveWorkbenchWindow());
    }

    protected String getFileExtension() {
        return null;
    }

    protected void openEditor(IFile iFile) throws PartInitException {
        UIUtil.openEditor(iFile, null, false);
    }

    protected void handleException(String string, Exception exception) {
        HyadesUIPlugin.logError(exception);
        UIUtil.openSaveFileErrorDialog(this.getShell(), string, exception);
    }

    protected abstract boolean createObject(IFile var1) throws Exception;

    public IFile getNewFile() {
        return this.newFile;
    }
}

