/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard.exampleproject;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.FileSystemStructureProvider;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.IProjectAdjuster;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class CreationOperation
implements IRunnableWithProgress {
    private Map editorIdByResourceToOpen;
    private CreationWizard creationWizard;
    private IOverwriteQuery overwriteQuery;
    private IProjectAdjuster adjuster;

    public CreationOperation(CreationWizard creationWizard, IOverwriteQuery iOverwriteQuery) {
        this.creationWizard = creationWizard;
        this.overwriteQuery = iOverwriteQuery;
        this.editorIdByResourceToOpen = new HashMap();
    }

    public void dispose() {
        this.editorIdByResourceToOpen.clear();
        this.creationWizard = null;
        this.overwriteQuery = null;
        this.adjuster = null;
    }

    public IProjectAdjuster getAdjuster() {
        return this.adjuster;
    }

    public void setAdjuster(IProjectAdjuster iProjectAdjuster) {
        this.adjuster = iProjectAdjuster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            CreationWizardPage[] creationWizardPageArray = this.creationWizard.getCreationWizardPages();
            iProgressMonitor.beginTask(HyadesUIPlugin.getString("OP_CREATE_PRJS"), creationWizardPageArray.length);
            int n = 0;
            while (n < creationWizardPageArray.length) {
                this.createProject(creationWizardPageArray[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                ++n;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
    }

    public IResource[] getResourcesToOpen() {
        return this.editorIdByResourceToOpen.keySet().toArray(new IResource[this.editorIdByResourceToOpen.keySet().size()]);
    }

    public String getEditorId(IResource iResource) {
        return (String)this.editorIdByResourceToOpen.get(iResource);
    }

    private void createProject(CreationWizardPage creationWizardPage, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        IConfigurationElement iConfigurationElement = creationWizardPage.getConfigurationElement();
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("import");
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren("nature");
        IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElement.getChildren("references");
        int n = iConfigurationElementArray == null ? 0 : iConfigurationElementArray.length;
        int n2 = iConfigurationElementArray2 == null ? 0 : iConfigurationElementArray2.length;
        int n3 = iConfigurationElementArray3 == null ? 0 : iConfigurationElementArray3.length;
        iProgressMonitor.beginTask(HyadesUIPlugin.getString("OP_CREATE_PRJ"), n + 1);
        String[] stringArray = new String[n2];
        int n4 = 0;
        while (n4 < n2) {
            stringArray[n4] = iConfigurationElementArray2[n4].getAttribute("id");
            ++n4;
        }
        IProject[] iProjectArray = new IProject[n3];
        int n5 = 0;
        while (n5 < n3) {
            iProjectArray[n5] = ResourcesPlugin.getWorkspace().getRoot().getProject(iConfigurationElementArray3[n5].getAttribute("id"));
            ++n5;
        }
        IProject iProject = this.configNewProject(creationWizardPage, stringArray, iProjectArray, iProgressMonitor);
        int n6 = 0;
        while (n6 < n) {
            this.doImports(creationWizardPage, iProject, iConfigurationElementArray[n6], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            ++n6;
        }
        IConfigurationElement[] iConfigurationElementArray4 = iConfigurationElement.getChildren("open");
        String string = Locale.getDefault().getLanguage();
        String string2 = Locale.getDefault().getCountry();
        int n7 = 0;
        while (n7 < iConfigurationElementArray4.length) {
            String string3 = iConfigurationElementArray4[n7].getAttribute("file");
            if (string3 != null && string3.length() > 0) {
                String string4 = string3.substring(string3.lastIndexOf("."));
                String string5 = (string3 = string3.substring(0, string3.lastIndexOf("."))) + "_" + string + "_" + string2 + string4;
                IResource iResource = iProject.findMember((IPath)new Path(string5));
                if (iResource == null) {
                    string5 = string5.substring(0, string5.lastIndexOf("_")) + string4;
                    iResource = iProject.findMember((IPath)new Path(string5));
                }
                if (iResource == null) {
                    string5 = string3 + string4;
                    iResource = iProject.findMember((IPath)new Path(string5));
                }
                if (iResource != null) {
                    String string6 = iConfigurationElementArray4[n7].getAttribute("editorId");
                    if (string6 == null) {
                        string6 = "";
                    }
                    this.editorIdByResourceToOpen.put(iResource, string6);
                }
            }
            ++n7;
        }
    }

    private IProject configNewProject(CreationWizardPage creationWizardPage, String[] stringArray, IProject[] iProjectArray, IProgressMonitor iProgressMonitor) throws InvocationTargetException {
        try {
            IProject iProject = creationWizardPage.getProjectHandle();
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
            if (Platform.getLocation().equals((Object)creationWizardPage.getLocationPath())) {
                iProjectDescription.setLocation(null);
            } else {
                iProjectDescription.setLocation(creationWizardPage.getLocationPath());
            }
            IConfigurationElement[] iConfigurationElementArray = creationWizardPage.getConfigurationElement().getChildren("buildCommand");
            if (iConfigurationElementArray.length > 0) {
                ICommand[] iCommandArray = new ICommand[iConfigurationElementArray.length];
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    String string = iConfigurationElementArray[n].getAttribute("name");
                    iCommandArray[n] = iProjectDescription.newCommand();
                    iCommandArray[n].setBuilderName(string);
                    ++n;
                }
                iProjectDescription.setBuildSpec(iCommandArray);
            }
            iProjectDescription.setNatureIds(stringArray);
            iProjectDescription.setReferencedProjects(iProjectArray);
            if (!iProject.exists()) {
                iProject.create(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            if (!iProject.isOpen()) {
                iProject.open((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                iProject.setDescription(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            return iProject;
        }
        catch (CoreException coreException) {
            throw new InvocationTargetException(coreException);
        }
    }

    private void doImports(CreationWizardPage creationWizardPage, IProject iProject, IConfigurationElement iConfigurationElement, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        block10: {
            try {
                Object object;
                Object object2;
                IPath iPath;
                String string = iConfigurationElement.getAttribute("dest");
                if (string == null || string.length() == 0) {
                    iPath = iProject.getFullPath();
                } else {
                    object2 = iProject.getFolder(string);
                    if (!object2.exists()) {
                        object2.create(true, true, null);
                    }
                    iPath = object2.getFullPath();
                }
                object2 = iConfigurationElement.getAttribute("src");
                if (object2 == null) {
                    object2 = "";
                    HyadesUIPlugin.logError(HyadesUIPlugin.getString("_ERROR_IMPORT_PATH_NULL"));
                    return;
                }
                File file = null;
                try {
                    object = new URL(iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL(), (String)object2);
                    file = new File(Platform.asLocalURL((URL)object).getFile());
                }
                catch (Exception exception) {
                    String string2 = (String)object2 + ":" + exception.getMessage();
                    Status status = new Status(4, this.creationWizard.getPluginId(), 4, string2, (Throwable)exception);
                    throw new CoreException((IStatus)status);
                }
                object = File.separator.equals("/") ? "\\" : "/";
                object2 = StringUtil.replace((String)object2, (String)object, File.separator) + File.separator;
                if (file.isFile()) {
                    this.importFilesFromZip(creationWizardPage, file, iPath, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    break block10;
                }
                if (file.isDirectory()) {
                    this.importFilesFromDir(creationWizardPage, file, iPath, (String)object2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    break block10;
                }
                FileNotFoundException fileNotFoundException = new FileNotFoundException(file.getAbsolutePath());
                String string3 = (String)object2 + ":" + fileNotFoundException.getMessage();
                Status status = new Status(4, this.creationWizard.getPluginId(), 4, string3, (Throwable)fileNotFoundException);
                throw new CoreException((IStatus)status);
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFilesFromDir(CreationWizardPage creationWizardPage, File file, IPath iPath, String string, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        File file2;
        if (this.adjuster != null && (file2 = this.adjuster.adjust(this.creationWizard.getCreationWizardPages(), creationWizardPage, file)) != null && !file.equals(file2)) {
            file = file2;
            string = file.getAbsolutePath();
            String string2 = File.separator.equals("/") ? "\\" : "/";
            string = StringUtil.replace(string, string2, File.separator) + File.separator;
        }
        try {
            file2 = new ImportOperation(iPath, (Object)file, (IImportStructureProvider)new FileSystemStructureProvider(string), this.overwriteQuery);
            file2.run(iProgressMonitor);
            Object var9_8 = null;
            if (this.adjuster != null) {
                this.adjuster.finished(creationWizardPage, file);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (this.adjuster != null) {
                this.adjuster.finished(creationWizardPage, file);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFilesFromZip(CreationWizardPage creationWizardPage, File file, IPath iPath, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException, CoreException {
        Object object;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            Status status = new Status(4, this.creationWizard.getPluginId(), 4, string, (Throwable)exception);
            throw new CoreException((IStatus)status);
        }
        if (this.adjuster != null && (object = this.adjuster.adjust(this.creationWizard.getCreationWizardPages(), creationWizardPage, zipFile)) != null) {
            zipFile = object;
        }
        try {
            object = new ZipFileStructureProvider(zipFile);
            ImportOperation importOperation = new ImportOperation(iPath, (Object)object.getRoot(), (IImportStructureProvider)object, this.overwriteQuery);
            importOperation.run(iProgressMonitor);
            Object var10_11 = null;
            if (this.adjuster != null) {
                this.adjuster.finished(creationWizardPage, zipFile);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (this.adjuster != null) {
                this.adjuster.finished(creationWizardPage, zipFile);
            }
            throw throwable;
        }
    }
}

