/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.java.runner;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import junit.extensions.RepeatedTest;
import junit.framework.Test;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.MessageEvent;
import org.eclipse.hyades.test.common.junit.DefaultTestArbiter;
import org.eclipse.hyades.test.common.junit.HyadesTestRunner;
import org.eclipse.hyades.test.common.junit.HyadesTestSuite;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.common.junit.IHyadesTestArbiter;
import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.java.runner.JUnitResourceBundle;

public class HyadesJUnitRunner
extends HyadesTestRunner {
    public static final String LOADTESTSUITEPREFIX = "_@USERGROUP_";
    private AgentConsoleStream stdout = null;
    private AgentConsoleStream stderr = null;
    private static final String UTF8 = "UTF-8";
    static /* synthetic */ Class class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner;

    public static void main(String[] stringArray) {
        HyadesJUnitRunner hyadesJUnitRunner = new HyadesJUnitRunner(stringArray);
        try {
            Class<?> clazz = Class.forName(stringArray[0], true, (class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner == null ? (class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner = HyadesJUnitRunner.class$("org.eclipse.hyades.test.java.runner.HyadesJUnitRunner")) : class$org$eclipse$hyades$test$java$runner$HyadesJUnitRunner).getClassLoader());
            Method method = clazz.getMethod("suite", null);
            Test test = (Test)method.invoke(null, null);
            HyadesTestSuite hyadesTestSuite = (HyadesTestSuite)test;
            String string = HyadesTestUtil.appendToHierarchyId((String)HyadesTestUtil.getHierarchyIds((Test)hyadesTestSuite), null, (int)1);
            hyadesJUnitRunner.stdout = new AgentConsoleStream(hyadesJUnitRunner.agent, 0, string);
            hyadesJUnitRunner.stderr = new AgentConsoleStream(hyadesJUnitRunner.agent, 1, string);
            System.setOut(new PrintStream((OutputStream)hyadesJUnitRunner.stdout, false, UTF8));
            System.setErr(new PrintStream((OutputStream)hyadesJUnitRunner.stderr, false, UTF8));
            int n = 1;
            String string2 = System.getProperty("hyades.loadtest.nusers");
            if (string2 != null) {
                try {
                    n = Integer.valueOf(string2);
                }
                catch (Exception exception) {
                    n = 1;
                }
            }
            if (n <= 1) {
                hyadesJUnitRunner.run(test);
            } else {
                hyadesJUnitRunner.agent.sendMessageToAttachedClient("Running a " + n + " instance test", 0L);
                HyadesTestSuite hyadesTestSuite2 = HyadesJUnitRunner.createLoadTestSuite(hyadesTestSuite, n);
                hyadesJUnitRunner.run((Test)hyadesTestSuite2);
            }
            hyadesJUnitRunner.agent.sendMessageToAttachedClient("Testcase completed successfuly", 0L);
        }
        catch (Throwable throwable) {
            MessageEvent messageEvent = new MessageEvent();
            messageEvent.setText(BaseString.getStackTrace((Throwable)throwable));
            messageEvent.setSeverity(1);
            messageEvent.setOwnerId(stringArray[1]);
            messageEvent.setId("ROOT");
            hyadesJUnitRunner.agent.logMessageUTF8(messageEvent.toString());
        }
    }

    public void handleCustomCommand(CustomCommand customCommand) {
    }

    protected void flushConsoles() {
        if (this.stdout != null) {
            this.stdout.flush();
        }
        if (this.stderr != null) {
            this.stderr.flush();
        }
    }

    public HyadesJUnitRunner(RemoteComponentSkeleton remoteComponentSkeleton) {
    }

    public HyadesJUnitRunner(String[] stringArray) {
        super(stringArray);
    }

    protected void runnerStarted() {
        this.writeExecEvent("<EXECUTION>");
        super.runnerStarted();
    }

    protected void runnerExit(boolean bl, long l) {
        super.runnerExit(bl, l);
        this.writeExecEvent("</EXECUTION>");
    }

    public void writeEvent(ExecutionEvent executionEvent) {
        this.flushConsoles();
        this.writeExecEvent(executionEvent);
    }

    protected String getLastEventText(boolean bl, long l) {
        String[] stringArray = new String[]{new Integer(this.getSucceedTests().size() + this.getFailureTests().size() + this.getErrorTests().size()).toString(), new Integer(this.getFailureTests().size()).toString(), new Integer(this.getErrorTests().size()).toString(), new Long(l).toString()};
        if (bl) {
            return JUnitResourceBundle.getInstance().getString("execution.TestStoped", stringArray);
        }
        return JUnitResourceBundle.getInstance().getString("execution.TestsFinished", stringArray);
    }

    protected static HyadesTestSuite createLoadTestSuite(HyadesTestSuite hyadesTestSuite, int n) {
        String string = hyadesTestSuite.getId();
        HyadesTestSuite hyadesTestSuite2 = new HyadesTestSuite("root");
        hyadesTestSuite2.setArbiter((IHyadesTestArbiter)DefaultTestArbiter.INSTANCE).setId(string + "HTTP_ROOTID");
        HyadesTestSuite hyadesTestSuite3 = new HyadesTestSuite(LOADTESTSUITEPREFIX + n);
        hyadesTestSuite2.addTest((Test)new RepeatedTest((Test)hyadesTestSuite3, n));
        hyadesTestSuite3.setId(string + "_HTTP_USERGROUP").setSynchronous(false);
        hyadesTestSuite3.addTest((Test)hyadesTestSuite);
        return hyadesTestSuite2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AgentConsoleStream
    extends OutputStream {
        public static final int OUT = 0;
        public static final int ERR = 1;
        private int mode;
        private RemoteComponentSkeleton agent;
        private String hierarchyId;
        private StringBuffer buffer = new StringBuffer();

        public AgentConsoleStream(RemoteComponentSkeleton remoteComponentSkeleton, int n, String string) {
            this.mode = n;
            this.agent = remoteComponentSkeleton;
            this.hierarchyId = string;
        }

        public void write(int n) {
            this.buffer.append((char)n);
            if (n == 10) {
                this.flush();
            }
        }

        public void flush() {
            if (this.buffer.length() > 0) {
                MessageEvent messageEvent = new MessageEvent();
                messageEvent.setText(this.buffer.toString());
                messageEvent.setSeverity(0);
                String string = HyadesTestRunner.peekParentEventID();
                messageEvent.setParentId(string);
                if (this.mode == 0) {
                    messageEvent.setText("System.out:\n" + this.buffer.toString());
                } else if (this.mode == 1) {
                    messageEvent.setText("System.err:\n" + this.buffer.toString());
                }
                this.agent.logMessageUTF8(messageEvent.toString());
                this.buffer = new StringBuffer();
            }
        }
    }
}

