/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.harness.IExecutionDeploymentAdapter;
import org.eclipse.hyades.execution.local.NodeImpl;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

public class JavaExecutionDeploymentAdapter
implements IExecutionDeploymentAdapter {
    private HashMap hostFileManagerMap = new HashMap();

    public void deployTestAssets(INode iNode, TPFDeployment tPFDeployment, boolean bl) {
        if (iNode == null || tPFDeployment == null) {
            return;
        }
        CFGArtifactLocationPair[] cFGArtifactLocationPairArray = this.collectPairsByNode(tPFDeployment, iNode);
        if (cFGArtifactLocationPairArray == null || cFGArtifactLocationPairArray.length == 0) {
            return;
        }
        HashMap hashMap = this.collectDeployableFiles(cFGArtifactLocationPairArray, bl);
        StringBuffer stringBuffer = new StringBuffer();
        HashMap hashMap2 = this.deployToNode(iNode, hashMap, stringBuffer);
    }

    public void cleanUpTestAssets(INode iNode, TPFDeployment tPFDeployment, boolean bl) {
        if (iNode == null || tPFDeployment == null) {
            return;
        }
        CFGArtifactLocationPair[] cFGArtifactLocationPairArray = this.collectPairsByNode(tPFDeployment, iNode);
        if (cFGArtifactLocationPairArray == null || cFGArtifactLocationPairArray.length == 0) {
            return;
        }
        HashMap hashMap = this.collectDeployableFiles(cFGArtifactLocationPairArray, bl);
        if (hashMap != null && hashMap.size() > 0) {
            String[] stringArray = (String[])hashMap.values().toArray();
            StringBuffer stringBuffer = new StringBuffer();
            this.cleanFromNode(iNode, stringArray, stringBuffer);
        }
    }

    protected CFGArtifactLocationPair[] collectPairsByNode(TPFDeployment tPFDeployment, INode iNode) {
        CFGArtifactLocationPair[] cFGArtifactLocationPairArray = new CFGArtifactLocationPair[]{};
        String string = iNode.getName();
        if (string == null || string.length() < 1) {
            return cFGArtifactLocationPairArray;
        }
        EList eList = tPFDeployment.getArtifactLocations();
        if (eList == null || eList.isEmpty()) {
            return cFGArtifactLocationPairArray;
        }
        CFGArtifactLocationPair cFGArtifactLocationPair = null;
        String string2 = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CFGLocation cFGLocation;
            cFGArtifactLocationPair = (CFGArtifactLocationPair)iterator.next();
            if (!this.isValidPair(cFGArtifactLocationPair) || (string2 = (cFGLocation = cFGArtifactLocationPair.getLocation()) instanceof CFGMachineConstraint ? ((CFGMachineConstraint)cFGArtifactLocationPair.getLocation()).getHostname() : cFGArtifactLocationPair.getLocation().getName()) == null || string2.length() < 1 || !string.equals(string2)) continue;
            if (cFGArtifactLocationPairArray.length == 0) {
                cFGArtifactLocationPairArray = new CFGArtifactLocationPair[]{cFGArtifactLocationPair};
                continue;
            }
            CFGArtifactLocationPair[] cFGArtifactLocationPairArray2 = cFGArtifactLocationPairArray;
            cFGArtifactLocationPairArray = new CFGArtifactLocationPair[cFGArtifactLocationPairArray2.length + 1];
            System.arraycopy(cFGArtifactLocationPairArray2, 0, cFGArtifactLocationPairArray, 0, cFGArtifactLocationPairArray2.length);
            cFGArtifactLocationPairArray[cFGArtifactLocationPairArray2.length] = cFGArtifactLocationPair;
        }
        return cFGArtifactLocationPairArray;
    }

    protected boolean isValidPair(CFGArtifactLocationPair cFGArtifactLocationPair) {
        CFGLocation cFGLocation = cFGArtifactLocationPair.getLocation();
        CFGArtifact cFGArtifact = cFGArtifactLocationPair.getArtifact();
        return cFGLocation != null && cFGArtifact != null;
    }

    protected HashMap collectDeployableFiles(CFGArtifactLocationPair[] cFGArtifactLocationPairArray, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        CFGArtifactLocationPair cFGArtifactLocationPair = null;
        CFGArtifact cFGArtifact = null;
        CFGLocation cFGLocation = null;
        String string = null;
        CFGClass cFGClass = null;
        Object var9_9 = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < cFGArtifactLocationPairArray.length) {
            cFGArtifactLocationPair = cFGArtifactLocationPairArray[n];
            cFGLocation = cFGArtifactLocationPair.getLocation();
            cFGArtifact = cFGArtifactLocationPair.getArtifact();
            if (cFGArtifact != null && cFGLocation != null && cFGLocation instanceof CFGMachineConstraint) {
                BVRProperty[] bVRPropertyArray;
                Object object;
                string = this.getDeployRootDir(cFGLocation, null);
                CFGPropertyGroup cFGPropertyGroup = ConfigurationUtil.searchPropertyGroupById((List)cFGArtifact.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.artifact.attributes");
                if (cFGPropertyGroup != null) {
                    object = new Vector();
                    bVRPropertyArray = ConfigurationUtil.searchPropertiesByName((List)cFGPropertyGroup.getProperties(), (String)"CLASSPATH", (boolean)false);
                    int n2 = 0;
                    while (n2 < bVRPropertyArray.length) {
                        StringTokenizer stringTokenizer = new StringTokenizer(bVRPropertyArray[n2].getValue(), File.pathSeparator);
                        while (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                            string3 = this.getDeployFilePath(string2, string, bl);
                            ((Vector)object).add(string3);
                            if (this.isSourceDestinationSame((CFGMachineConstraint)cFGLocation, string2, string3)) continue;
                            File file = new File(string2);
                            if (file != null && file.isDirectory()) {
                                String[] stringArray = this.getClasspathFiles(file);
                                int n3 = 0;
                                while (n3 < stringArray.length) {
                                    string2 = stringArray[n3];
                                    string3 = this.getDeployFilePath(string2, string, bl);
                                    hashMap.put(string2, string3);
                                    ++n3;
                                }
                                continue;
                            }
                            hashMap.put(string2, string3);
                        }
                        ++n2;
                    }
                    this.setLocationClasspath(cFGLocation, (Vector)object);
                }
                object = cFGArtifact.getDeployableInstances();
                bVRPropertyArray = object.iterator();
                while (bVRPropertyArray.hasNext()) {
                    cFGClass = (CFGClass)bVRPropertyArray.next();
                    if (cFGClass instanceof TPFTestSuite || (string2 = this.getDeployableFilePath(cFGClass, bl)) == null || this.isSourceDestinationSame((CFGMachineConstraint)cFGLocation, string2, string3 = this.getDeployFilePath(string2, string, bl))) continue;
                    hashMap.put(string2, string3);
                }
            }
            ++n;
        }
        return hashMap;
    }

    protected String getDeployFilePath(String string, String string2, boolean bl) {
        String string3 = this.getSourceRootDir(new File(string), bl);
        string2 = string2 == null || string2.length() < 1 ? string3 : string2;
        String string4 = string2 + string.substring(string3.length() - 1, string.length());
        return string4;
    }

    protected String getDeployableFilePath(CFGClass cFGClass, boolean bl) {
        Resource resource = cFGClass.eResource();
        if (resource == null) {
            return null;
        }
        URI uRI = resource.getURI();
        if (bl) {
            return uRI.toFileString();
        }
        String string = uRI.toString();
        if (string.startsWith("platform:/resource/")) {
            string = this.getWorkspaceRoot() + string.substring("platform:/resource/".length());
        }
        return string;
    }

    protected boolean isSourceDestinationSame(CFGMachineConstraint cFGMachineConstraint, String string, String string2) {
        String string3 = cFGMachineConstraint.getHostname();
        try {
            if (!InetAddress.getLocalHost().equals(InetAddress.getByName(string3)) && !InetAddress.getByName(string3).isLoopbackAddress()) {
                return false;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        File file = new File(string);
        File file2 = new File(string2);
        return file.compareTo(file2) == 0;
    }

    protected String[] getClasspathFiles(File file) {
        Vector vector = new Vector();
        this.collectClassFiles(file, vector);
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.get(n);
            ++n;
        }
        return stringArray;
    }

    protected void collectClassFiles(File file, Vector vector) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile()) {
                if (fileArray[n].getName().endsWith(".class")) {
                    vector.add(fileArray[n].getAbsolutePath());
                }
            } else {
                this.collectClassFiles(fileArray[n], vector);
            }
            ++n;
        }
    }

    protected HashMap deployToNode(INode iNode, HashMap hashMap, StringBuffer stringBuffer) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        if (!(iNode instanceof NodeImpl)) {
            return hashMap2;
        }
        IFileManager iFileManager = ((NodeImpl)iNode).getFileManager();
        if (iFileManager == null) {
            return hashMap2;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            if (!this.deployFile(iFileManager, string2, string = (String)hashMap.get(string2), stringBuffer)) continue;
            hashMap2.put(string2, string);
        }
        return hashMap2;
    }

    protected boolean deployFile(IFileManager iFileManager, String string, String string2, StringBuffer stringBuffer) {
        try {
            iFileManager.putFile(string, string2);
            return true;
        }
        catch (IOException iOException) {
            stringBuffer.append(iOException.getMessage());
            return false;
        }
    }

    protected void cleanFromNode(INode iNode, String[] stringArray, StringBuffer stringBuffer) {
        if (!(iNode instanceof NodeImpl)) {
            return;
        }
        IFileManager iFileManager = ((NodeImpl)iNode).getFileManager();
        if (iFileManager == null) {
            return;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            try {
                iFileManager.deleteFile(stringArray[n]);
            }
            catch (IOException iOException) {
                stringBuffer.append(iOException.getMessage());
            }
            ++n;
        }
    }

    protected String getSourceRootDir(File file, boolean bl) {
        String string;
        if (!bl && (string = this.getWorkspaceRoot()) != null && file.getAbsolutePath().indexOf(string) > -1) {
            return string;
        }
        return URI.createFileURI((String)file.getAbsolutePath()).device() + File.separator;
    }

    protected String getWorkspaceRoot() {
        if (ResourcesPlugin.getWorkspace() != null) {
            String string = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
            File file = new File(string);
            if (!(string = file.getAbsolutePath()).endsWith(File.separator)) {
                string = string + File.separator;
            }
            return string;
        }
        return "";
    }

    protected String getDeployRootDir(CFGLocation cFGLocation, String string) {
        BVRProperty[] bVRPropertyArray;
        String string2 = null;
        CFGPropertyGroup cFGPropertyGroup = ConfigurationUtil.searchPropertyGroupById((List)cFGLocation.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.location.attributes");
        if (cFGPropertyGroup == null) {
            cFGPropertyGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            cFGPropertyGroup.setPropertyGroupID("org.eclipse.hyades.test.configuration.location.attributes");
            cFGLocation.getPropertyGroups().add((Object)cFGPropertyGroup);
        }
        if ((bVRPropertyArray = ConfigurationUtil.searchPropertiesByName((List)cFGPropertyGroup.getProperties(), (String)"ROOTDIR", (boolean)false)) == null || bVRPropertyArray.length == 0) {
            string2 = string;
            CFGComparableProperty cFGComparableProperty = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
            cFGComparableProperty.setName("ROOTDIR");
            cFGComparableProperty.setOperator("=");
            cFGComparableProperty.setValue(string2);
            cFGPropertyGroup.getProperties().add((Object)cFGComparableProperty);
        } else {
            string2 = bVRPropertyArray[0].getValue();
        }
        if (string2 != null) {
            // empty if block
        }
        return string2;
    }

    protected void setLocationClasspath(CFGLocation cFGLocation, Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        String string = "";
        int n = 0;
        while (n < vector.size()) {
            if (n > 0) {
                string = string + File.pathSeparator;
            }
            string = string + (String)vector.get(n);
            ++n;
        }
        CFGPropertyGroup cFGPropertyGroup = ConfigurationUtil.searchPropertyGroupById((List)cFGLocation.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.location.attributes");
        if (cFGPropertyGroup == null) {
            cFGPropertyGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            cFGPropertyGroup.setPropertyGroupID("org.eclipse.hyades.test.configuration.location.attributes");
            cFGLocation.getPropertyGroups().add((Object)cFGPropertyGroup);
        }
        BVRProperty[] bVRPropertyArray = ConfigurationUtil.searchPropertiesByName((List)cFGPropertyGroup.getProperties(), (String)"CLASSPATH", (boolean)false);
        boolean bl = false;
        int n2 = 0;
        while (n2 < bVRPropertyArray.length) {
            if (string.equals(bVRPropertyArray[n2].getValue())) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            CFGComparableProperty cFGComparableProperty = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
            cFGComparableProperty.setName("CLASSPATH");
            cFGComparableProperty.setOperator("=");
            cFGComparableProperty.setValue(string);
            cFGPropertyGroup.getProperties().add((Object)cFGComparableProperty);
        }
    }
}

