/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXEventHandler
extends DefaultHandler {
    private static final String SITUATION_TYPE_CLASS = EventPackage.eINSTANCE.getSituationType().getName();
    private static final String COMMON_BASE_EVENT_CLASS = EventPackage.eINSTANCE.getCommonBaseEvent().getName();
    private static final String ASSOCIATION_ENGINE_CLASS = EventPackage.eINSTANCE.getAssociationEngine().getName();
    private HashMap elementMap = new HashMap();
    private HashMap featureMap = new HashMap();
    private int column = 0;
    private int line = 0;
    private int parsingAny = -1;
    private boolean nextElementIsAnAny = false;
    private int anyStartCharacter = -1;
    private int startCharacterCopy = -1;
    private int lengthCharacterCopy = -1;
    private ArrayList events = null;
    private ArrayList associationEngines = null;
    private List stack = null;

    public SAXEventHandler() {
        this.init();
    }

    public void init() {
        this.reset();
        this.associationEngines = new ArrayList();
        this.events = new ArrayList();
    }

    private void reset() {
        this.column = 0;
        this.line = 0;
        this.parsingAny = -1;
        this.nextElementIsAnAny = false;
        this.anyStartCharacter = -1;
        this.startCharacterCopy = -1;
        this.lengthCharacterCopy = -1;
        this.stack = new ArrayList();
        EList eList = EventPackage.eINSTANCE.eContents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            EClass eClass = (EClass)iterator.next();
            this.elementMap.put(eClass.getName(), eClass);
            EList eList2 = eClass.getEAllStructuralFeatures();
            int n = 0;
            while (n < eList2.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)eList2.get(n);
                HashMap<String, EStructuralFeature> hashMap = (HashMap<String, EStructuralFeature>)this.featureMap.get(eClass.getName());
                if (hashMap == null) {
                    hashMap = new HashMap<String, EStructuralFeature>();
                    this.featureMap.put(eClass.getName(), hashMap);
                }
                hashMap.put(eStructuralFeature.getName(), eStructuralFeature);
                ++n;
            }
        }
    }

    public CommonBaseEvent[] getCommonBaseEvents() {
        if (this.events != null && this.events.size() > 0) {
            return this.events.toArray(new CommonBaseEvent[this.events.size()]);
        }
        return null;
    }

    public AssociationEngine[] getAssociationEngines() {
        if (this.associationEngines != null && this.associationEngines.size() > 0) {
            return this.associationEngines.toArray(new AssociationEngine[this.associationEngines.size()]);
        }
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        this.column = locator.getColumnNumber();
        this.line = locator.getLineNumber();
        super.setDocumentLocator(locator);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string;
        CommonBaseEvent commonBaseEvent;
        this.startCharacterCopy = n;
        this.lengthCharacterCopy = n2;
        if (this.nextElementIsAnAny) {
            this.nextElementIsAnAny = false;
            commonBaseEvent = (CommonBaseEvent)this.stack.get(this.stack.size() - 1);
            string = new String(cArray, this.anyStartCharacter, n - this.anyStartCharacter);
            commonBaseEvent.addAny(string.trim());
        }
        if (this.stack.size() > 2) {
            List list;
            commonBaseEvent = this.stack.get(this.stack.size() - 1);
            if (commonBaseEvent instanceof List) {
                string = new String(cArray, n, n2);
                list = (List)((Object)commonBaseEvent);
                list.add(string);
            }
            if (commonBaseEvent instanceof EStructuralFeature) {
                string = new String(cArray, n, n2);
                list = (EObject)this.stack.get(this.stack.size() - 2);
                EStructuralFeature eStructuralFeature = (EStructuralFeature)this.stack.get(this.stack.size() - 1);
                list.eSet(eStructuralFeature, string);
            }
        }
        super.characters(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        if (this.parsingAny >= 0) {
            --this.parsingAny;
            if (this.parsingAny < 0) {
                this.nextElementIsAnAny = true;
            }
        } else {
            Object e;
            String string4 = string2;
            if (string4 == null || string4.trim().length() == 0) {
                int n = -1;
                string4 = string3 != null && (n = string3.lastIndexOf(58)) != -1 ? string3.substring(n + 1) : string3;
            }
            if (!string4.equals(ASSOCIATION_ENGINE_CLASS) && !string4.equalsIgnoreCase("CommonBaseEvents") && !string4.equalsIgnoreCase("TemplateEvent") && (e = this.stack.remove(this.stack.size() - 1)) instanceof CommonBaseEvent) {
                this.events.add((CommonBaseEvent)e);
                this.reset();
            }
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        super.error(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        super.fatalError(sAXParseException);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        super.ignorableWhitespace(cArray, n, n2);
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        super.notationDecl(string, string2, string3);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        super.processingInstruction(string, string2);
    }

    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        return super.resolveEntity(string, string2);
    }

    public void skippedEntity(String string) throws SAXException {
        super.skippedEntity(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        super.startElement(string, string2, string3, attributes);
        String string4 = string2;
        if (string4 == null || string4.trim().length() == 0) {
            int n = -1;
            string4 = string3 != null && (n = string3.lastIndexOf(58)) != -1 ? string3.substring(n + 1) : string3;
        }
        if (string4.equalsIgnoreCase("CommonBaseEvents") || string4.equalsIgnoreCase("TemplateEvent")) return;
        if (this.parsingAny >= 0) {
            ++this.parsingAny;
        }
        EObject eObject = null;
        EClass eClass = null;
        if (this.stack.isEmpty()) {
            if (string4.equals(ASSOCIATION_ENGINE_CLASS)) {
                AssociationEngine associationEngine = EventFactory.eINSTANCE.createAssociationEngine();
                associationEngine.setId(Guid.generate());
                String string5 = null;
                int n = 0;
                while (n < attributes.getLength()) {
                    string5 = attributes.getLocalName(n);
                    if (string5 == null || string5.trim().length() == 0) {
                        int n2 = -1;
                        String string6 = attributes.getQName(n);
                        string5 = string6 != null && (n2 = string6.lastIndexOf(58)) != -1 ? string6.substring(n2 + 1) : string6;
                    }
                    if (string5.equals("id")) {
                        associationEngine.setId(attributes.getValue(n));
                    } else if (string5.equals("name")) {
                        associationEngine.setName(attributes.getValue(n));
                    } else if (string5.equals("type")) {
                        associationEngine.setType(attributes.getValue(n));
                    }
                    ++n;
                }
                this.associationEngines.add(associationEngine);
                return;
            }
            if (!string4.equals(COMMON_BASE_EVENT_CLASS)) {
                throw new SAXException("Expected a '" + COMMON_BASE_EVENT_CLASS + "' element, but found '" + string4 + "' at line " + this.line + ", column " + this.column);
            }
            eClass = (EClass)this.elementMap.get(string4);
            eObject = EventFactory.eINSTANCE.create(eClass);
            this.stack.add(eObject);
        } else {
            EObject eObject2 = (EObject)this.stack.get(this.stack.size() - 1);
            HashMap hashMap = (HashMap)this.featureMap.get(eObject2.eClass().getName());
            object3 = (EStructuralFeature)hashMap.get(string4);
            if (object3 == null) {
                if (!eObject2.eClass().getName().equals(COMMON_BASE_EVENT_CLASS)) throw new SAXException("Unexpected element: '" + string4 + "' at line " + this.line + ", column " + this.column);
                this.parsingAny = 0;
                this.anyStartCharacter = this.startCharacterCopy + this.lengthCharacterCopy;
            } else {
                object2 = object3.getEType().getName();
                if (((String)object2).equals(SITUATION_TYPE_CLASS)) {
                    object = (Situation)eObject2;
                    object2 = object.getCategoryName();
                }
                if (((String)object2).equals("EString")) {
                    if (object3.isMany()) {
                        object = (List)eObject2.eGet((EStructuralFeature)object3);
                        this.stack.add(object);
                    } else {
                        this.stack.add(object3);
                    }
                } else {
                    eClass = (EClass)this.elementMap.get(object2);
                    eObject = EventFactory.eINSTANCE.create(eClass);
                    if (object3.isMany()) {
                        object = (List)eObject2.eGet((EStructuralFeature)object3);
                        object.add(eObject);
                    } else {
                        eObject2.eSet((EStructuralFeature)object3, (Object)eObject);
                    }
                    this.stack.add(eObject);
                }
            }
        }
        if (eObject == null) return;
        int n = attributes.getLength();
        int n3 = 0;
        while (n3 < n) {
            object3 = attributes.getLocalName(n3);
            if (object3 == null || ((String)object3).trim().length() == 0) {
                int n4 = -1;
                object = attributes.getQName(n3);
                object3 = object != null && (n4 = ((String)object).lastIndexOf(58)) != -1 ? ((String)object).substring(n4 + 1) : object;
            }
            if ((object = (EAttribute)((HashMap)(object2 = (HashMap)this.featureMap.get(eClass.getName()))).get(object3)) != null) {
                String string7 = attributes.getValue(n3);
                String string8 = object.getEAttributeType().getName();
                if (string8.equals("ELong")) {
                    Long l = Long.valueOf(string7);
                    eObject.eSet((EStructuralFeature)object, (Object)l);
                } else if (string8.equals("EShort")) {
                    Short s = Short.valueOf(string7);
                    eObject.eSet((EStructuralFeature)object, (Object)s);
                } else {
                    eObject.eSet((EStructuralFeature)object, (Object)string7);
                }
            }
            ++n3;
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        super.unparsedEntityDecl(string, string2, string3, string4);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        super.warning(sAXParseException);
    }
}

