/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.StringSorter;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CList {
    protected Label _label;
    protected org.eclipse.swt.widgets.List _list;
    protected Button _order;
    protected Composite groupWidget;
    private ArrayList listeners = new ArrayList();

    public CList(Composite composite, String string) {
        this(composite, string, null);
    }

    public CList(Composite composite, String string, List list) {
        this.groupWidget = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.groupWidget.setLayout((Layout)gridLayout);
        this.groupWidget.setLayoutData((Object)GridUtil.createFill());
        if (string != null && !string.equals("")) {
            this._label = new Label(this.groupWidget, 0);
            this._label.setText(string);
        }
        this._list = new org.eclipse.swt.widgets.List(this.groupWidget, 2818);
        this._list.setLayoutData((Object)GridUtil.createFill());
        this._order = new Button(this.groupWidget, 8);
        this._order.setText(LogUIPlugin.getResourceString("SORT_BUTTON"));
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                this._list.add(list.get(n).toString(), n);
                ++n;
            }
        }
        this._order.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CList.this.sortList();
                selectionEvent.data = CList.this;
                CList.this.fireSelectionNotification(selectionEvent);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    public void add(Object object) {
        this._list.add(object.toString());
    }

    public void add(Object object, int n) {
        this._list.add(object.toString(), n);
    }

    public void clearSelection() {
        this._list.deselectAll();
    }

    public boolean contains(Object object) {
        return this._list.indexOf(object.toString()) != -1;
    }

    public void deselect(int n) {
        this._list.deselect(n);
    }

    public void disableCList() {
        this._order.setEnabled(false);
    }

    public void enable(boolean bl) {
        this._list.setEnabled(bl);
        this._order.setEnabled(bl);
        if (this._label != null) {
            this._label.setEnabled(bl);
        }
    }

    public Object getItem(int n) {
        return this._list.getItem(n);
    }

    public int getItemCount() {
        return this._list.getItemCount();
    }

    public org.eclipse.swt.widgets.List getList() {
        return this._list;
    }

    public int getSelectedIndex() {
        return this._list.getSelectionIndex();
    }

    public int[] getSelectedIndices() {
        return this._list.getSelectionIndices();
    }

    public Object getSelectedItem() {
        String[] stringArray = this._list.getSelection();
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getSelectedItems() {
        return this._list.getSelection();
    }

    public Composite getWidget() {
        return this.groupWidget;
    }

    public boolean isSelectedIndex(int n) {
        return this._list.isSelected(n);
    }

    public void refreshList(Vector vector) {
        this._list.removeAll();
        int n = 0;
        while (n < vector.size()) {
            this.add(vector.elementAt(n));
            ++n;
        }
    }

    public void remove(int n) {
        this._list.remove(n);
    }

    public void remove(Object object) {
        this._list.remove(object.toString());
    }

    public void select(Object object) {
        int n = this._list.indexOf(object.toString());
        if (n != -1) {
            this._list.select(n);
        }
    }

    public void selectAll(int[] nArray) {
        this._list.select(nArray);
    }

    public void setFocus() {
        this._list.setFocus();
    }

    public void setSelectedIndex(int n) {
        this._list.setSelection(n);
    }

    public void setSelectionInterval(int n, int n2) {
        this._list.setSelection(n, n2);
    }

    public void setToolTipText(String string) {
    }

    public void setVisible(boolean bl) {
        this.groupWidget.setVisible(bl);
    }

    public synchronized void sortList() {
        int n;
        String[] stringArray = this._list.getItems();
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = this._list.getSelection();
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            vector.addElement(stringArray[n2]);
            ++n2;
        }
        new StringSorter().qsortNoCaseStringVector(vector);
        this.refreshList(vector);
        Vector<String> vector2 = new Vector<String>();
        int n3 = 0;
        while (n3 < this._list.getItemCount()) {
            boolean bl = false;
            n = 0;
            while (!bl && n < stringArray2.length) {
                if (stringArray2[n].equals(this.getItem(n3))) {
                    bl = true;
                    vector2.addElement(String.valueOf(n3));
                    continue;
                }
                ++n;
            }
            ++n3;
        }
        int[] nArray = new int[vector2.size()];
        n = 0;
        while (n < vector2.size()) {
            nArray[n] = Integer.parseInt(vector2.elementAt(n).toString());
            ++n;
        }
        this._list.setSelection(nArray);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (!this.listeners.contains(selectionListener)) {
            this.listeners.add(selectionListener);
            this._list.addSelectionListener(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.listeners.remove(selectionListener);
        this._list.removeSelectionListener(selectionListener);
    }

    public void fireSelectionNotification(SelectionEvent selectionEvent) {
        int n = 0;
        while (n < this.listeners.size()) {
            ((SelectionListener)this.listeners.get(n)).widgetSelected(selectionEvent);
            ++n;
        }
    }
}

