/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.Locale;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFindProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.LogFindCriteria;
import org.eclipse.hyades.log.ui.internal.util.CBEAdvFilterUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchRecordDialog
extends Dialog
implements SelectionListener {
    private CBEAdvFilterUI _filters;
    private Button btnFind;
    private Button btnCancel;
    private Button btnUp;
    private Button btnDown;
    private Label lblMessage;
    private Tree tree;
    private String _title;
    private ILogFindProvider logFindProvider = null;
    private LogFindCriteria criteria = null;

    public SearchRecordDialog(Shell shell, String string, Image image, ILogFindProvider iLogFindProvider) {
        super(shell);
        this._title = string;
        Window.setDefaultImage((Image)image);
        this.logFindProvider = iLogFindProvider;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 500;
        composite2.setLayoutData((Object)gridData);
        this._filters = new CBEAdvFilterUI(2);
        this._filters.createControl(composite2, LogUIPlugin.getResourceString("STR_FIND_CONTENT_LABEL"));
        Label label = new Label(composite2, 258);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        composite3.setLayoutData((Object)gridData);
        this.createOptionsGroup(composite3);
        this.createButtonsGroup(composite3);
        this.createFooter(composite2);
        this.initializeFiltersAndButtons();
        this.btnFind.addSelectionListener((SelectionListener)this);
        this.btnCancel.addSelectionListener((SelectionListener)this);
        this._filters.getAddBtn().addSelectionListener((SelectionListener)this);
        this._filters.getRemoveBtn().addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)composite2, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH);
        WorkbenchHelp.setHelp((Control)this.btnUp, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH_UP);
        WorkbenchHelp.setHelp((Control)this.btnDown, (String)ContextIds.ACTLOG_VIEW_DIALOG_SEARCH_DOWN);
        return composite2;
    }

    private void initializeFiltersAndButtons() {
        if (this.logFindProvider != null) {
            String string = this.logFindProvider.loadFindPreferenceString();
            this._filters.initializeFilters(string);
            if (this.logFindProvider.loadFindDirection()) {
                this.btnDown.setSelection(true);
            } else {
                this.btnUp.setSelection(true);
            }
            this.btnFind.setEnabled(this._filters.getFilterList().getFilters().size() > 0);
        }
    }

    private void createOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridUtil.createHorizontalFill());
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setText(LogUIPlugin.getResourceString("STR_DIRECTION_LABEL"));
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.widthHint = 300;
        group.setLayoutData((Object)gridData);
        this.btnUp = new Button((Composite)group, 16);
        this.btnUp.setText(LogUIPlugin.getResourceString("STR_DIR_UP_LABEL"));
        this.btnDown = new Button((Composite)group, 16);
        this.btnDown.setText(LogUIPlugin.getResourceString("STR_DIR_DOWN_LABEL"));
    }

    private void createButtonsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalAlignment = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.btnFind = new Button(composite2, 8);
        this.btnFind.setText(LogUIPlugin.getResourceString("STR_FINDNEXT_LABEL"));
        gridData = new GridData();
        gridData.widthHint = Locale.getDefault().toString().equals("en_US") ? 75 : 100;
        this.btnFind.setLayoutData((Object)gridData);
        this.btnCancel = new Button(composite2, 8);
        this.btnCancel.setText(LogUIPlugin.getResourceString("STR_CANCEL_LABEL"));
        gridData = new GridData();
        gridData.widthHint = Locale.getDefault().toString().equals("en_US") ? 75 : 100;
        this.btnCancel.setLayoutData((Object)gridData);
        Shell shell = composite.getShell();
        if (shell != null) {
            shell.setDefaultButton(this.btnFind);
        }
    }

    private void createFooter(Composite composite) {
        this.lblMessage = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.lblMessage.setLayoutData((Object)gridData);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.btnCancel) {
            if (this.logFindProvider != null) {
                this.criteria = new LogFindCriteria();
                this.criteria.setFilters(this._filters.getFilterList().getFilters());
                this.criteria.setForwardDirection(this.btnDown.getSelection());
                this.logFindProvider.storeFindOptions(this.criteria);
            }
            this.close();
        }
        if (selectionEvent.widget == this.btnFind) {
            this.lblMessage.setText("");
            this.criteria = new LogFindCriteria();
            this.criteria.setFilters(this._filters.getFilterList().getFilters());
            this.criteria.setForwardDirection(this.btnDown.getSelection());
            this.criteria.setFindMessage(this.lblMessage);
            if (this.logFindProvider != null) {
                this.logFindProvider.findRecord(this.criteria);
            }
        }
        if (selectionEvent.widget == this._filters.getAddBtn() || selectionEvent.widget == this._filters.getRemoveBtn()) {
            this.btnFind.setEnabled(this._filters.getFilterList().getSize() > 0);
        }
    }
}

