/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.IRecordPaneViewerListener;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.log.ui.internal.views.LogAnalysisPageBook;
import org.eclipse.hyades.log.ui.internal.views.LogRecordPaneViewer;
import org.eclipse.hyades.log.ui.internal.views.PCDataPane;
import org.eclipse.hyades.log.ui.internal.views.RecordPaneContentProvider;
import org.eclipse.hyades.log.ui.internal.views.RecordPaneLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.PageBook;

public class LogRecordPageBook
extends PageBook
implements ISelectionChangedListener,
ISelectionProvider,
IRecordPaneViewerListener {
    private LogRecordPaneViewer fTableViewer;
    private PCDataPane aPCDataPane;
    private LogAnalysisPageBook page;
    private ISelection selection;
    private int selIndex;

    public LogRecordPageBook(Composite composite, int n) {
        super(composite, n);
        this.populateUI();
    }

    private void createColumns() {
        Table table = (Table)this.fTableViewer.getControl();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        String[] stringArray = new String[]{LogUIPlugin.getResourceString("RecordPaneHeader1"), LogUIPlugin.getResourceString("RecordPaneHeader2")};
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnPixelData(150, true), new ColumnPixelData(300, true)};
        TableColumn[] tableColumnArray = new TableColumn[stringArray.length];
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            tableLayout.addColumnData(columnLayoutDataArray[n]);
            TableColumn tableColumn = new TableColumn(table, 0, n);
            tableColumn.setResizable(columnLayoutDataArray[n].resizable);
            tableColumn.setText(stringArray[n]);
            tableColumnArray[n] = tableColumn;
            ++n;
        }
    }

    public TableViewer getTableControl() {
        return this.fTableViewer;
    }

    protected void populateUI() {
        this.fTableViewer = new LogRecordPaneViewer((Composite)this);
        this.fTableViewer.setContentProvider((IContentProvider)new RecordPaneContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new RecordPaneLabelProvider());
        this.createColumns();
        LogUIPlugin.getDefault().addRecordPaneViewerListener(this);
        this.aPCDataPane = new PCDataPane((Composite)this, 0);
        this.showPage(this.fTableViewer.getControl());
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        try {
            Object object = null;
            ISelection iSelection = selectionChangedEvent.getSelection();
            if (!(iSelection instanceof IStructuredSelection)) {
                return;
            }
            object = ((IStructuredSelection)iSelection).getFirstElement();
            this.selIndex = ((Table)this.fTableViewer.getControl()).getSelectionIndex();
            this.fTableViewer.setInput(object);
            this.showPage(this.fTableViewer.getControl());
            this.setSelection();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setSelection() {
        Object[] objectArray = ((RecordPaneContentProvider)this.fTableViewer.getContentProvider()).getElements(this.fTableViewer.getInput());
        Object object = null;
        if (objectArray.length > 0) {
            if (this.selIndex > -1 && this.selIndex < objectArray.length) {
                object = objectArray[this.selIndex];
            } else {
                this.selIndex = 0;
                object = objectArray[0];
            }
        } else {
            this.selIndex = -1;
            object = new Object[]{null};
        }
        if (this.selIndex > -1) {
            ((Table)this.fTableViewer.getControl()).setSelection(this.selIndex);
        }
        this.selection = new StructuredSelection(object);
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.selection);
        this.page.selectionChanged(selectionChangedEvent);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void handleRecordChangeEvent(RecordChangeEvent recordChangeEvent) {
        if (recordChangeEvent.getType() == 1 || recordChangeEvent.getType() == 3) {
            this.fTableViewer.getControl().setRedraw(false);
            this.fTableViewer.refresh();
            this.fTableViewer.getControl().setRedraw(true);
            this.setSelection();
        }
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fTableViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fTableViewer.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public void setAnalysisPageBook(LogAnalysisPageBook logAnalysisPageBook) {
        this.page = logAnalysisPageBook;
    }

    public void dispose() {
        LogUIPlugin.getDefault().removeRecordPaneViewerListener(this);
        super.dispose();
    }
}

